# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_cell_locator import AbstractCellLocator


class CellTreeLocator(AbstractCellLocator):
    r"""
    CellTreeLocator - This class implements the data structures,
    construction algorithms for fast cell location.
    
    Superclass: AbstractCellLocator
    
    Cell Tree is a bounding interval hierarchy based data structure,
    where child boxes do not form an exact split of the parent boxes
    along a dimension.  Therefore two axis- aligned bounding planes (left
    max and right min) are stored for each node along a dimension. This
    class implements the data structure (Cell Tree Node) and its build
    and traversal algorithms described in the paper. Some methods in
    building and traversing the cell tree in this class were derived from
    avtcell_locator_bih class in the vis_it Visualization Tool.
    
    CellTreeLocator utilizes the following parent class parameters:
    - number_of_cells_per_node        (default 8)
    - cache_cell_bounds             (default true)
    - use_existing_search_structure  (default false)
    
    CellTreeLocator does NOT utilize the following parameters:
    - Automatic
    - Level
    - max_level
    - Tolerance
    - retain_cell_lists
    
    @warning
    This class is templated. It may run slower than serial execution if
    the code is not optimized during compilation. Build in Release or
    release_with_debug_info.
    
    From the article: "Fast, Memory-Efficient Cell location in Unstructured Grids for
    Visualization" by Christoph Garth and Kenneth I. Joy in vis_week,
    2011.
    
    @sa
    AbstractCellLocator CellLocator StaticCellLocator
    ModifiedBSPTree OBBTree
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellTreeLocator, obj, update, **traits)
    
    number_of_buckets = traits.Int(6, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of buckets.
        
        Default is 6.
        """
    )

    def _number_of_buckets_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBuckets,
                        self.number_of_buckets)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        r"""
        Inform the user as to whether large ids are being used. This flag
        only has meaning after the locator has been built. Large ids are
        used when the number of binned points, or the number of bins, is
        >= the maximum number of buckets (specified by the user). Note
        that large_ids are only available on 64-bit architectures.
        """
    )

    def build_locator_if_needed(self):
        """
        build_locator_if_needed(self) -> None
        C++: virtual void build_locator_if_needed()"""
        ret = self._vtk_obj.BuildLocatorIfNeeded()
        return ret
        

    _updateable_traits_ = \
    (('cache_cell_bounds', 'GetCacheCellBounds'), ('lazy_evaluation',
    'GetLazyEvaluation'), ('retain_cell_lists', 'GetRetainCellLists'),
    ('automatic', 'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_buckets', 'GetNumberOfBuckets'),
    ('number_of_cells_per_node', 'GetNumberOfCellsPerNode'), ('max_level',
    'GetMaxLevel'), ('tolerance', 'GetTolerance'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'cache_cell_bounds', 'debug', 'global_warning_display',
    'lazy_evaluation', 'retain_cell_lists',
    'use_existing_search_structure', 'max_level', 'number_of_buckets',
    'number_of_cells_per_node', 'object_name', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellTreeLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellTreeLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'cache_cell_bounds', 'lazy_evaluation',
            'retain_cell_lists', 'use_existing_search_structure'], [],
            ['max_level', 'number_of_buckets', 'number_of_cells_per_node',
            'object_name', 'tolerance']),
            title='Edit CellTreeLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellTreeLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

