# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class PolyDataPlaneClipper(PolyDataAlgorithm):
    r"""
    PolyDataPlaneClipper - clip a PolyData with a plane and
    optionally cap it
    
    Superclass: PolyDataAlgorithm
    
    PolyDataPlaneClipper clips an input PolyData with a plane to
    produce an output PolyData. (Here clipping means extracting cells,
    or portions of cells, that are on one side of a specified plane.) The
    input PolyData must consist of convex polygons forming one or more
    manifold shells (use TriangleFilter to triangulate the input if
    necessary. Note that if the input cells are non-convex, then the
    clipping operation will likely produce erroneous results.)
    
    An optional, second PolyData output may also be generated if
    either clipping_loops or Capping is enabled. The clipping loops are a
    set of lines representing the curve(s) of intersection between the
    plane and the one or more shells of the input PolyData. If Capping
    is enabled, then the clipping loops are tessellated to produce a
    "cap" across the clipped output. The capping option is only available
    if the input consists of one or more manifold shells. If not, the
    loop generation will fail and no cap(s) will be generated.
    
    @warning
    The method can_fully_process_data_object() is available to see whether
    the input data can be successully processed by this filter. Use this
    method sparingly because it can be slow.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    ClipPolyData ClipClosedSurface PolyDataPlaneCutter
    PlaneCutter TriangleFilter Cutter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyDataPlaneClipper, obj, update, **traits)
    
    capping = tvtk_base.true_bool_trait(desc=\
        r"""
        Specify whether to cap the clipped output PolyData. If
        enabled, a second PolyData output will be produced that
        contains the capping polygons (in PolyData:Polys). Note that
        the capping operation assumes that the input to this filter is a
        manifold shell. If not, no output will be generated. Note that
        point data or cell data is not produced on this second output
        (because the results of interpolation across the cap(s) are
        generally nonsensical).
        """
    )

    def _capping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCapping,
                        self.capping_)

    clipping_loops = tvtk_base.true_bool_trait(desc=\
        r"""
        Specify whether to generate clipping loops, i.e., the
        intersection of the plane with the input polydata. The generation
        of clipping loops will function correctly even if the input
        PolyData consists of non-closed shells; however if the shells
        are not closed, the loops will not be either. If enabled, a
        second PolyData output will be produced that contains the
        clipping loops (in PolyData::Lines)
        """
    )

    def _clipping_loops_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetClippingLoops,
                        self.clipping_loops_)

    pass_cap_point_data = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify whether to pass point data through to the second (Cap)
        output. By default this is disabled. This feature is useful in
        certain situations when trying to combine the cap with clipped
        polydata.
        """
    )

    def _pass_cap_point_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCapPointData,
                        self.pass_cap_point_data_)

    batch_size = traits.Trait(10000, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the number of input triangles in a batch, where a batch
        defines a subset of the input triangles operated on during
        threaded execution. Generally this is only used for debugging or
        performance studies (since batch size affects the thread
        workload).
        """
    )

    def _batch_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBatchSize,
                        self.batch_size)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points type. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        output_points_precision is DEFAULT_PRECISION by default.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        r"""
        
        """
    )

    def _get_cap(self):
        return wrap_vtk(self._vtk_obj.GetCap())
    cap = traits.Property(_get_cap, desc=\
        r"""
        Get the output dataset representing the clipping loops and
        capping polygons.  This output is empty if both clipping_loops and
        Capping is off. Otherwise, if there is an intersection with the
        clipping plane, then polyline loops are available from the
        PolyData::Lines, and the capping polygons are available from
        the PolyData::Polys data arrays.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def can_fully_process_data_object(self, *args):
        """
        can_fully_process_data_object(object:DataObject) -> bool
        C++: static bool can_fully_process_data_object(DataObject *object)
        This helper method can be used to determine the if the input
        PolyData contains convex polygonal cells, and therefore is
        suitable for processing by this filter. (The name of the method
        is consistent with other filters that perform similar
        operations.) This method returns true when the input contains
        only polygons (i.e., no verts, lines, or triangle strips); and
        each polygon is convex. It returns false otherwise.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanFullyProcessDataObject, *my_args)
        return ret

    _updateable_traits_ = \
    (('capping', 'GetCapping'), ('clipping_loops', 'GetClippingLoops'),
    ('pass_cap_point_data', 'GetPassCapPointData'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('batch_size', 'GetBatchSize'),
    ('output_points_precision', 'GetOutputPointsPrecision'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'capping', 'clipping_loops', 'debug',
    'global_warning_display', 'pass_cap_point_data', 'release_data_flag',
    'batch_size', 'object_name', 'output_points_precision',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyDataPlaneClipper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyDataPlaneClipper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['capping', 'clipping_loops', 'pass_cap_point_data'], [],
            ['batch_size', 'object_name', 'output_points_precision']),
            title='Edit PolyDataPlaneClipper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyDataPlaneClipper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

