/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <string>
using std::string;


#include "LanguageHelper.h" 
#include "PlainTextHelper.h" 
#include "Highlighter.h"



// -----------------------------------------------------------------------
// ------------------- Syntax highlighter code ---------------------------
//        this class is used by the PlainTextHelper object, defined below
// -----------------------------------------------------------------------


class PlainTextHighlighter : public Highlighter
{
public:
     PlainTextHighlighter(QTextDocument *parent = 0);
    ~PlainTextHighlighter(){}

     virtual void highlightBlock(const QString &text);

};


PlainTextHighlighter::PlainTextHighlighter(QTextDocument *parent)
     : Highlighter(parent)
{
}



void PlainTextHighlighter::highlightBlock(const QString &text)
{
    foreach (HighlightingRule rule, highlightingRules) 
    {
        QRegExp expression(rule.pattern);
        int index = text.indexOf(expression);
        while (index >= 0) 
        {
            int length = expression.matchedLength();
            setFormat(index, length, rule.format);
            index = text.indexOf(expression, index + length);
        }
    }
}





// -----------------------------------------------------------------------
// -------------------------- PlainTextHelper code ---------------------------
// -----------------------------------------------------------------------


// ---------------------------------------------------------------------------
// PlainTextHelper::PlainTextHelper
// constructor
// ---------------------------------------------------------------------------

PlainTextHelper::PlainTextHelper()
{
    languageName_ = "Plain Text";
    className_    = "NOTE";
    serviceName_  = "none";
}


// ---------------------------------------------------------------------------
// PlainTextHelper::~PlainTextHelper
// destructor
// ---------------------------------------------------------------------------

PlainTextHelper::~PlainTextHelper()
{
}


// ---------------------------------------------------------------------------
// PlainTextHelper::createHighlighter
// creates a new syntax highlighter object
// ---------------------------------------------------------------------------

Highlighter *PlainTextHelper::createHighlighter(QTextDocument *parent)
{
    return new PlainTextHighlighter(parent);
}










