#!/bin/bash

# a line will take the format: ./drivers/pinctrl/tegra/pinctrl-tegra234.ko

# example use:
# 1. Build modules on ARM64 device
# 2. At repository root, run $ find . -name "*.ko" > r36-modlist.txt
# 3. Run $ ./gen-dkms-conf-mod-entries.sh r36-modlist.txt
# 4. Insert output into dkms.conf, replacing existing module entries.

INPUT_FILE=$1
if [[ ! -f $INPUT_FILE ]]; then
	echo "Usage: $0 <input-file>"
	exit 1
fi

i=0
while read line; do
	line=${line#./}
	base=$(basename $line)
	built_module_name=${base%.*}
	built_module_location=$(dirname $line)
	dest_module_location="/extra"
	echo "BUILT_MODULE_NAME[$i]=\"$built_module_name\""
	echo "BUILT_MODULE_LOCATION[$i]=\"$built_module_location\""
	echo "DEST_MODULE_LOCATION[$i]=\"$dest_module_location\""
	echo
	i=$((i+1))
done <<<$(cat "$INPUT_FILE" | sort)
