/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.spi.MetricValue;
import org.apache.hadoop.metrics.spi.MetricsRecordImpl;
import org.apache.hadoop.metrics.spi.OutputRecord;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractMetricsContext
implements MetricsContext {
    private int period = 5;
    private Timer timer = null;
    private Set<Updater> updaters = new HashSet<Updater>(1);
    private volatile boolean isMonitoring = false;
    private ContextFactory factory = null;
    private String contextName = null;
    private Map<String, RecordMap> bufferedData = new HashMap<String, RecordMap>();

    protected AbstractMetricsContext() {
    }

    @Override
    public void init(String contextName, ContextFactory factory) {
        this.contextName = contextName;
        this.factory = factory;
    }

    protected String getAttribute(String attributeName) {
        String factoryAttribute = this.contextName + "." + attributeName;
        return (String)this.factory.getAttribute(factoryAttribute);
    }

    protected Map<String, String> getAttributeTable(String tableName) {
        String prefix = this.contextName + "." + tableName + ".";
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attributeName : this.factory.getAttributeNames()) {
            if (!attributeName.startsWith(prefix)) continue;
            String name = attributeName.substring(prefix.length());
            String value = (String)this.factory.getAttribute(attributeName);
            result.put(name, value);
        }
        return result;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    public ContextFactory getContextFactory() {
        return this.factory;
    }

    @Override
    public synchronized void startMonitoring() throws IOException {
        if (!this.isMonitoring) {
            this.startTimer();
            this.isMonitoring = true;
        }
    }

    @Override
    public synchronized void stopMonitoring() {
        if (this.isMonitoring) {
            this.stopTimer();
            this.isMonitoring = false;
        }
    }

    @Override
    public boolean isMonitoring() {
        return this.isMonitoring;
    }

    @Override
    public synchronized void close() {
        this.stopMonitoring();
        this.clearUpdaters();
    }

    @Override
    public final synchronized MetricsRecord createRecord(String recordName) {
        if (this.bufferedData.get(recordName) == null) {
            this.bufferedData.put(recordName, new RecordMap());
        }
        return this.newRecord(recordName);
    }

    protected MetricsRecord newRecord(String recordName) {
        return new MetricsRecordImpl(recordName, this);
    }

    @Override
    public synchronized void registerUpdater(Updater updater) {
        if (!this.updaters.contains(updater)) {
            this.updaters.add(updater);
        }
    }

    @Override
    public synchronized void unregisterUpdater(Updater updater) {
        this.updaters.remove(updater);
    }

    private synchronized void clearUpdaters() {
        this.updaters.clear();
    }

    private synchronized void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer("Timer thread for monitoring " + this.getContextName(), true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        AbstractMetricsContext.this.timerEvent();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            };
            long millis = this.period * 1000;
            this.timer.scheduleAtFixedRate(task, millis, millis);
        }
    }

    private synchronized void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerEvent() throws IOException {
        if (this.isMonitoring) {
            ArrayList<Updater> myUpdaters;
            AbstractMetricsContext abstractMetricsContext = this;
            synchronized (abstractMetricsContext) {
                myUpdaters = new ArrayList<Updater>(this.updaters);
            }
            for (Updater updater : myUpdaters) {
                try {
                    updater.doUpdates(this);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.emitRecords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void emitRecords() throws IOException {
        for (String recordName : this.bufferedData.keySet()) {
            RecordMap recordMap;
            RecordMap recordMap2 = recordMap = this.bufferedData.get(recordName);
            synchronized (recordMap2) {
                Set entrySet = recordMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    OutputRecord outRec = new OutputRecord((TagMap)entry.getKey(), (MetricMap)entry.getValue());
                    this.emitRecord(this.contextName, recordName, outRec);
                }
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, Collection<OutputRecord>> getAllRecords() {
        TreeMap<String, Collection<OutputRecord>> out = new TreeMap<String, Collection<OutputRecord>>();
        for (String recordName : this.bufferedData.keySet()) {
            RecordMap recordMap;
            RecordMap recordMap2 = recordMap = this.bufferedData.get(recordName);
            synchronized (recordMap2) {
                ArrayList<OutputRecord> records = new ArrayList<OutputRecord>();
                Set entrySet = recordMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    OutputRecord outRec = new OutputRecord((TagMap)entry.getKey(), (MetricMap)entry.getValue());
                    records.add(outRec);
                }
                out.put(recordName, records);
            }
        }
        return out;
    }

    protected abstract void emitRecord(String var1, String var2, OutputRecord var3) throws IOException;

    protected void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(MetricsRecordImpl record) {
        RecordMap recordMap;
        String recordName = record.getRecordName();
        TagMap tagTable = record.getTagTable();
        Map<String, MetricValue> metricUpdates = record.getMetricTable();
        RecordMap recordMap2 = recordMap = this.getRecordMap(recordName);
        synchronized (recordMap2) {
            MetricMap metricMap = (MetricMap)recordMap.get(tagTable);
            if (metricMap == null) {
                metricMap = new MetricMap();
                TagMap tagMap = new TagMap(tagTable);
                recordMap.put(tagMap, metricMap);
            }
            Set<Map.Entry<String, MetricValue>> entrySet = metricUpdates.entrySet();
            for (Map.Entry<String, MetricValue> entry : entrySet) {
                String metricName = entry.getKey();
                MetricValue updateValue = entry.getValue();
                Number updateNumber = updateValue.getNumber();
                Number currentNumber = (Number)metricMap.get(metricName);
                if (currentNumber == null || updateValue.isAbsolute()) {
                    metricMap.put(metricName, updateNumber);
                    continue;
                }
                Number newNumber = this.sum(updateNumber, currentNumber);
                metricMap.put(metricName, newNumber);
            }
        }
    }

    private synchronized RecordMap getRecordMap(String recordName) {
        return this.bufferedData.get(recordName);
    }

    private Number sum(Number a, Number b) {
        if (a instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Float) {
            return new Float(a.floatValue() + b.floatValue());
        }
        if (a instanceof Short) {
            return (short)(a.shortValue() + b.shortValue());
        }
        if (a instanceof Byte) {
            return (byte)(a.byteValue() + b.byteValue());
        }
        if (a instanceof Long) {
            return a.longValue() + b.longValue();
        }
        throw new MetricsException("Invalid number type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(MetricsRecordImpl record) {
        RecordMap recordMap;
        String recordName = record.getRecordName();
        TagMap tagTable = record.getTagTable();
        RecordMap recordMap2 = recordMap = this.getRecordMap(recordName);
        synchronized (recordMap2) {
            Iterator it = recordMap.keySet().iterator();
            while (it.hasNext()) {
                TagMap rowTags = (TagMap)it.next();
                if (!rowTags.containsAll(tagTable)) continue;
                it.remove();
            }
        }
    }

    @Override
    public int getPeriod() {
        return this.period;
    }

    protected void setPeriod(int period) {
        this.period = period;
    }

    protected void parseAndSetPeriod(String attributeName) {
        String periodStr = this.getAttribute(attributeName);
        if (periodStr != null) {
            int period = 0;
            try {
                period = Integer.parseInt(periodStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (period <= 0) {
                throw new MetricsException("Invalid period: " + periodStr);
            }
            this.setPeriod(period);
        }
    }

    static class RecordMap
    extends HashMap<TagMap, MetricMap> {
        private static final long serialVersionUID = 259835619700264611L;

        RecordMap() {
        }
    }

    @InterfaceAudience.Private
    public static class MetricMap
    extends TreeMap<String, Number> {
        private static final long serialVersionUID = -7495051861141631609L;

        MetricMap() {
        }

        MetricMap(MetricMap orig) {
            super(orig);
        }
    }

    @InterfaceAudience.Private
    public static class TagMap
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 3546309335061952993L;

        TagMap() {
        }

        TagMap(TagMap orig) {
            super(orig);
        }

        public boolean containsAll(TagMap other) {
            for (Map.Entry entry : other.entrySet()) {
                Object value = this.get(entry.getKey());
                if (value != null && value.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
    }
}

