/* $Id: GCClient_GetAssemblyReques.hpp 459043 2015-02-12 17:31:59Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_GetAssemblyReques.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GCClient_GetAssemblyReques_.hpp


#ifndef OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYREQUES_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYREQUES_HPP


// generated includes
#include <objects/genomecoll/GCClient_GetAssemblyReques_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class CGCClient_GetAssemblyRequest : public CGCClient_GetAssemblyRequest_Base
{
    typedef CGCClient_GetAssemblyRequest_Base Tparent;
public:
    // constructor
    CGCClient_GetAssemblyRequest(void);
    // destructor
    ~CGCClient_GetAssemblyRequest(void);

    enum EAssemblyMode {
        eAssemblyMode_assembly_only          = 1,  ///<- use for minimal, assembly level retrieval
        eAssemblyMode_eukaryotic_annotation  = 2,  ///<- use to retrive eukaryotic assemblies for annotation
        eAssemblyMode_prokaryotic_annotation = 3,  ///<- use to retrive prokaryotic assemblies for annotation
        eAssemblyMode_entrez_indexing        = 4,  ///<- used when building the Entrez index for assembly and gencoll
        eAssemblyMode_assembly_backend       = 5,  ///<- used in the CGI to provide data to the Entrez Assembly detail page.
        eAssemblyMode_sequence_names         = 6,  ///<- used in retrieving sequences synonyms
        eAssemblyMode_ftp_export             = 7   ///<- used in export to public FTP site
    };

    struct SRequestParam
    {
        int level;
        int assembly_flags;
        int chromosome_flags;
        int scaffold_flags;
        int component_flags;

        SRequestParam();

        bool SetMode(EAssemblyMode mode);
    };

private:
    // Prohibit copy constructor and assignment operator
    CGCClient_GetAssemblyRequest(const CGCClient_GetAssemblyRequest& value);
    CGCClient_GetAssemblyRequest& operator=(const CGCClient_GetAssemblyRequest& value);

};

/////////////////// CGCClient_GetAssemblyRequest inline methods

// constructor
inline
CGCClient_GetAssemblyRequest::CGCClient_GetAssemblyRequest(void)
{
}


/////////////////// end of CGCClient_GetAssemblyRequest inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYREQUES_HPP
/* Original file checksum: lines: 86, chars: 2751, CRC32: c1b54f29 */
