#line 9 "putget.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 11
/*
 *	Copyright 1996, University Corporation for Atmospheric Research
 *      See netcdf/COPYRIGHT file for copying and redistribution conditions.
 */
/* $Id: putget.m4 2783 2014-10-26 05:19:35Z wkliao $ */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "netcdf.h"
#include "nc3dispatch.h"
#include "nc3internal.h"
#include "ncx.h"
#include "fbits.h"
#include "onstack.h"
#ifdef LOCKNUMREC
#  include <mpp/shmem.h>	/* for SGI/Cray SHMEM routines */
#  ifdef LN_TEST
#    include <stdio.h>
#  endif
#endif


#undef MIN  /* system may define MIN somewhere and complain */
#define MIN(mm,nn) (((mm) < (nn)) ? (mm) : (nn))

static int
readNCv(const NC3_INFO* ncp, const NC_var* varp, const size_t* start,
        const size_t nelems, void* value, const nc_type memtype);
static int
writeNCv(NC3_INFO* ncp, const NC_var* varp, const size_t* start,
         const size_t nelems, const void* value, const nc_type memtype);


/* #define ODEBUG 1 */

#if ODEBUG
#include <stdio.h>
/*
 * Print the values of an array of size_t
 */
void
arrayp(const char *label, size_t count, const size_t *array)
{
	(void) fprintf(stderr, "%s", label);
	(void) fputc('\t',stderr);
	for(; count > 0; count--, array++)
		(void) fprintf(stderr," %lu", (unsigned long)*array);
	(void) fputc('\n',stderr);
}
#endif /* ODEBUG */


/* Begin fill */
/*
 * This is tunable parameter.
 * It essentially controls the tradeoff between the number of times
 * memcpy() gets called to copy the external data to fill
 * a large buffer vs the number of times its called to
 * prepare the external data.
 */
#if	_SX
/* NEC SX specific optimization */
#define	NFILL	2048
#else
#define	NFILL	16
#endif


#line 110

/*
 * Next 6 type specific functions
 * Fill a some memory with the default special value.
 * Formerly
NC_arrayfill()
 */
static int
#line 117
NC_fill_schar(
#line 117
	void **xpp,
#line 117
	size_t nelems)	/* how many */
#line 117
{
#line 117
	schar fillp[NFILL * sizeof(double)/X_SIZEOF_CHAR];
#line 117

#line 117
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 117

#line 117
	{
#line 117
		schar *vp = fillp;	/* lower bound of area to be filled */
#line 117
		const schar *const end = vp + nelems;
#line 117
		while(vp < end)
#line 117
		{
#line 117
			*vp++ = NC_FILL_BYTE;
#line 117
		}
#line 117
	}
#line 117
	return ncx_putn_schar_schar(xpp, nelems, fillp ,NULL);
#line 117
}
#line 117

static int
#line 118
NC_fill_char(
#line 118
	void **xpp,
#line 118
	size_t nelems)	/* how many */
#line 118
{
#line 118
	char fillp[NFILL * sizeof(double)/X_SIZEOF_CHAR];
#line 118

#line 118
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 118

#line 118
	{
#line 118
		char *vp = fillp;	/* lower bound of area to be filled */
#line 118
		const char *const end = vp + nelems;
#line 118
		while(vp < end)
#line 118
		{
#line 118
			*vp++ = NC_FILL_CHAR;
#line 118
		}
#line 118
	}
#line 118
	return ncx_putn_char_char(xpp, nelems, fillp );
#line 118
}
#line 118

static int
#line 119
NC_fill_short(
#line 119
	void **xpp,
#line 119
	size_t nelems)	/* how many */
#line 119
{
#line 119
	short fillp[NFILL * sizeof(double)/X_SIZEOF_SHORT];
#line 119

#line 119
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 119

#line 119
	{
#line 119
		short *vp = fillp;	/* lower bound of area to be filled */
#line 119
		const short *const end = vp + nelems;
#line 119
		while(vp < end)
#line 119
		{
#line 119
			*vp++ = NC_FILL_SHORT;
#line 119
		}
#line 119
	}
#line 119
	return ncx_putn_short_short(xpp, nelems, fillp ,NULL);
#line 119
}
#line 119


#if (SIZEOF_INT >= X_SIZEOF_INT)
static int
#line 122
NC_fill_int(
#line 122
	void **xpp,
#line 122
	size_t nelems)	/* how many */
#line 122
{
#line 122
	int fillp[NFILL * sizeof(double)/X_SIZEOF_INT];
#line 122

#line 122
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 122

#line 122
	{
#line 122
		int *vp = fillp;	/* lower bound of area to be filled */
#line 122
		const int *const end = vp + nelems;
#line 122
		while(vp < end)
#line 122
		{
#line 122
			*vp++ = NC_FILL_INT;
#line 122
		}
#line 122
	}
#line 122
	return ncx_putn_int_int(xpp, nelems, fillp ,NULL);
#line 122
}
#line 122

#elif SIZEOF_LONG == X_SIZEOF_INT
static int
#line 124
NC_fill_int(
#line 124
	void **xpp,
#line 124
	size_t nelems)	/* how many */
#line 124
{
#line 124
	long fillp[NFILL * sizeof(double)/X_SIZEOF_INT];
#line 124

#line 124
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 124

#line 124
	{
#line 124
		long *vp = fillp;	/* lower bound of area to be filled */
#line 124
		const long *const end = vp + nelems;
#line 124
		while(vp < end)
#line 124
		{
#line 124
			*vp++ = NC_FILL_INT;
#line 124
		}
#line 124
	}
#line 124
	return ncx_putn_int_long(xpp, nelems, fillp ,NULL);
#line 124
}
#line 124

#else
#error "NC_fill_int implementation"
#endif

static int
#line 129
NC_fill_float(
#line 129
	void **xpp,
#line 129
	size_t nelems)	/* how many */
#line 129
{
#line 129
	float fillp[NFILL * sizeof(double)/X_SIZEOF_FLOAT];
#line 129

#line 129
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 129

#line 129
	{
#line 129
		float *vp = fillp;	/* lower bound of area to be filled */
#line 129
		const float *const end = vp + nelems;
#line 129
		while(vp < end)
#line 129
		{
#line 129
			*vp++ = NC_FILL_FLOAT;
#line 129
		}
#line 129
	}
#line 129
	return ncx_putn_float_float(xpp, nelems, fillp ,NULL);
#line 129
}
#line 129

static int
#line 130
NC_fill_double(
#line 130
	void **xpp,
#line 130
	size_t nelems)	/* how many */
#line 130
{
#line 130
	double fillp[NFILL * sizeof(double)/X_SIZEOF_DOUBLE];
#line 130

#line 130
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 130

#line 130
	{
#line 130
		double *vp = fillp;	/* lower bound of area to be filled */
#line 130
		const double *const end = vp + nelems;
#line 130
		while(vp < end)
#line 130
		{
#line 130
			*vp++ = NC_FILL_DOUBLE;
#line 130
		}
#line 130
	}
#line 130
	return ncx_putn_double_double(xpp, nelems, fillp ,NULL);
#line 130
}
#line 130


static int
#line 132
NC_fill_uchar(
#line 132
	void **xpp,
#line 132
	size_t nelems)	/* how many */
#line 132
{
#line 132
	uchar fillp[NFILL * sizeof(double)/X_SIZEOF_UBYTE];
#line 132

#line 132
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 132

#line 132
	{
#line 132
		uchar *vp = fillp;	/* lower bound of area to be filled */
#line 132
		const uchar *const end = vp + nelems;
#line 132
		while(vp < end)
#line 132
		{
#line 132
			*vp++ = NC_FILL_UBYTE;
#line 132
		}
#line 132
	}
#line 132
	return ncx_putn_uchar_uchar(xpp, nelems, fillp ,NULL);
#line 132
}
#line 132

static int
#line 133
NC_fill_ushort(
#line 133
	void **xpp,
#line 133
	size_t nelems)	/* how many */
#line 133
{
#line 133
	ushort fillp[NFILL * sizeof(double)/X_SIZEOF_USHORT];
#line 133

#line 133
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 133

#line 133
	{
#line 133
		ushort *vp = fillp;	/* lower bound of area to be filled */
#line 133
		const ushort *const end = vp + nelems;
#line 133
		while(vp < end)
#line 133
		{
#line 133
			*vp++ = NC_FILL_USHORT;
#line 133
		}
#line 133
	}
#line 133
	return ncx_putn_ushort_ushort(xpp, nelems, fillp ,NULL);
#line 133
}
#line 133

static int
#line 134
NC_fill_uint(
#line 134
	void **xpp,
#line 134
	size_t nelems)	/* how many */
#line 134
{
#line 134
	uint fillp[NFILL * sizeof(double)/X_SIZEOF_UINT];
#line 134

#line 134
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 134

#line 134
	{
#line 134
		uint *vp = fillp;	/* lower bound of area to be filled */
#line 134
		const uint *const end = vp + nelems;
#line 134
		while(vp < end)
#line 134
		{
#line 134
			*vp++ = NC_FILL_UINT;
#line 134
		}
#line 134
	}
#line 134
	return ncx_putn_uint_uint(xpp, nelems, fillp ,NULL);
#line 134
}
#line 134

static int
#line 135
NC_fill_longlong(
#line 135
	void **xpp,
#line 135
	size_t nelems)	/* how many */
#line 135
{
#line 135
	longlong fillp[NFILL * sizeof(double)/X_SIZEOF_LONGLONG];
#line 135

#line 135
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 135

#line 135
	{
#line 135
		longlong *vp = fillp;	/* lower bound of area to be filled */
#line 135
		const longlong *const end = vp + nelems;
#line 135
		while(vp < end)
#line 135
		{
#line 135
			*vp++ = NC_FILL_INT64;
#line 135
		}
#line 135
	}
#line 135
	return ncx_putn_longlong_longlong(xpp, nelems, fillp ,NULL);
#line 135
}
#line 135

static int
#line 136
NC_fill_ulonglong(
#line 136
	void **xpp,
#line 136
	size_t nelems)	/* how many */
#line 136
{
#line 136
	ulonglong fillp[NFILL * sizeof(double)/X_SIZEOF_ULONGLONG];
#line 136

#line 136
	assert(nelems <= sizeof(fillp)/sizeof(fillp[0]));
#line 136

#line 136
	{
#line 136
		ulonglong *vp = fillp;	/* lower bound of area to be filled */
#line 136
		const ulonglong *const end = vp + nelems;
#line 136
		while(vp < end)
#line 136
		{
#line 136
			*vp++ = NC_FILL_UINT64;
#line 136
		}
#line 136
	}
#line 136
	return ncx_putn_ulonglong_ulonglong(xpp, nelems, fillp ,NULL);
#line 136
}
#line 136




/*
 * Fill the external space for variable 'varp' values at 'recno' with
 * the appropriate value. If 'varp' is not a record variable, fill the
 * whole thing.  For the special case when 'varp' is the only record
 * variable and it is of type byte, char, or short, varsize should be
 * ncp->recsize, otherwise it should be varp->len.
 * Formerly
xdr_NC_fill()
 */
int
fill_NC_var(NC3_INFO* ncp, const NC_var *varp, size_t varsize, size_t recno)
{
	char xfillp[NFILL * X_SIZEOF_DOUBLE];
	const size_t step = varp->xsz;
	const size_t nelems = sizeof(xfillp)/step;
	const size_t xsz = varp->xsz * nelems;
	NC_attr **attrpp = NULL;
	off_t offset;
	size_t remaining = varsize;

	void *xp;
	int status = NC_NOERR;

	/*
	 * Set up fill value
	 */
	attrpp = NC_findattr(&varp->attrs, _FillValue);
	if( attrpp != NULL )
	{
		/* User defined fill value */
		if( (*attrpp)->type != varp->type || (*attrpp)->nelems != 1 )
		{
			return NC_EBADTYPE;
		}
		else
		{
			/* Use the user defined value */
			char *cp = xfillp;
			const char *const end = &xfillp[sizeof(xfillp)];

			assert(step <= (*attrpp)->xsz);

			for( /*NADA*/; cp < end; cp += step)
			{
				(void) memcpy(cp, (*attrpp)->xvalue, step);
			}
		}
	}
	else
	{
		/* use the default */

		assert(xsz % X_ALIGN == 0);
		assert(xsz <= sizeof(xfillp));

		xp = xfillp;

		switch(varp->type){
		case NC_BYTE :
			status = NC_fill_schar(&xp, nelems);
			break;
		case NC_CHAR :
			status = NC_fill_char(&xp, nelems);
			break;
		case NC_SHORT :
			status = NC_fill_short(&xp, nelems);
			break;
		case NC_INT :
			status = NC_fill_int(&xp, nelems);
			break;
		case NC_FLOAT :
			status = NC_fill_float(&xp, nelems);
			break;
		case NC_DOUBLE :
			status = NC_fill_double(&xp, nelems);
			break;
                case NC_UBYTE :
                        status = NC_fill_uchar(&xp, nelems);
                        break;
                case NC_USHORT :
                        status = NC_fill_ushort(&xp, nelems);
                        break;
                case NC_UINT :
                        status = NC_fill_uint(&xp, nelems);
                        break;
                case NC_INT64 :
                        status = NC_fill_longlong(&xp, nelems);
                        break;
                case NC_UINT64 :
                        status = NC_fill_ulonglong(&xp, nelems);
                        break;
		default :
			assert("fill_NC_var invalid type" == 0);
			status = NC_EBADTYPE;
			break;
		}
		if(status != NC_NOERR)
			return status;

		assert(xp == xfillp + xsz);
	}

	/*
	 * copyout:
	 * xfillp now contains 'nelems' elements of the fill value
	 * in external representation.
	 */

	/*
	 * Copy it out.
	 */

	offset = varp->begin;
	if(IS_RECVAR(varp))
	{
		offset += (off_t)ncp->recsize * recno;
	}

	assert(remaining > 0);
	for(;;)
	{
		const size_t chunksz = MIN(remaining, ncp->chunk);
		size_t ii;

		status = ncio_get(ncp->nciop, offset, chunksz,
				 RGN_WRITE, &xp);
		if(status != NC_NOERR)
		{
			return status;
		}

		/*
		 * fill the chunksz buffer in units  of xsz
		 */
		for(ii = 0; ii < chunksz/xsz; ii++)
		{
			(void) memcpy(xp, xfillp, xsz);
			xp = (char *)xp + xsz;
		}
		/*
		 * Deal with any remainder
		 */
		{
			const size_t rem = chunksz % xsz;
			if(rem != 0)
			{
				(void) memcpy(xp, xfillp, rem);
				/* xp = (char *)xp + xsz; */
			}

		}

		status = ncio_rel(ncp->nciop, offset, RGN_MODIFIED);

		if(status != NC_NOERR)
		{
			break;
		}

		remaining -= chunksz;
		if(remaining == 0)
			break;	/* normal loop exit */
		offset += chunksz;

	}

	return status;
}
/* End fill */


/*
 * Add a record containing the fill values.
 */
static int
NCfillrecord(NC3_INFO* ncp, const NC_var *const *varpp, size_t recno)
{
	size_t ii = 0;
	for(; ii < ncp->vars.nelems; ii++, varpp++)
	{
		if( !IS_RECVAR(*varpp) )
		{
			continue;	/* skip non-record variables */
		}
		{
		const int status = fill_NC_var(ncp, *varpp, (*varpp)->len, recno);
		if(status != NC_NOERR)
			return status;
		}
	}
	return NC_NOERR;
}


/*
 * Add a record containing the fill values in the special case when
 * there is exactly one record variable, where we don't require each
 * record to be four-byte aligned (no record padding).
 */
static int
NCfillspecialrecord(NC3_INFO* ncp, const NC_var *varp, size_t recno)
{
    int status;
    assert(IS_RECVAR(varp));
    status = fill_NC_var(ncp, varp, ncp->recsize, recno);
    if(status != NC_NOERR)
	return status;
    return NC_NOERR;
}


/*
 * It is advantageous to
 * #define TOUCH_LAST
 * when using memory mapped io.
 */
#if TOUCH_LAST
/*
 * Grow the file to a size which can contain recno
 */
static int
NCtouchlast(NC3_INFO* ncp, const NC_var *const *varpp, size_t recno)
{
	int status = NC_NOERR;
	const NC_var *varp = NULL;

	{
	size_t ii = 0;
	for(; ii < ncp->vars.nelems; ii++, varpp++)
	{
		if( !IS_RECVAR(*varpp) )
		{
			continue;	/* skip non-record variables */
		}
		varp = *varpp;
	}
	}
	assert(varp != NULL);
	assert( IS_RECVAR(varp) );
	{
		const off_t offset = varp->begin
				+ (off_t)(recno-1) * (off_t)ncp->recsize
				+ (off_t)(varp->len - varp->xsz);
		void *xp;


		status = ncio_get(ncp->nciop, offset, varp->xsz,
				 RGN_WRITE, &xp);
		if(status != NC_NOERR)
			return status;
		(void)memset(xp, 0, varp->xsz);
		status = ncio_rel(ncp->nciop, offset, RGN_MODIFIED);
	}
	return status;
}
#endif /* TOUCH_LAST */


/*
 * Ensure that the netcdf file has 'numrecs' records,
 * add records and fill as necessary.
 */
static int
NCvnrecs(NC3_INFO* ncp, size_t numrecs)
{
	int status = NC_NOERR;
#ifdef LOCKNUMREC
	ushmem_t myticket = 0, nowserving = 0;
	ushmem_t numpe = (ushmem_t) _num_pes();

	/* get ticket and wait */
	myticket = shmem_short_finc((shmem_t *) ncp->lock + LOCKNUMREC_LOCK,
		ncp->lock[LOCKNUMREC_BASEPE]);
#ifdef LN_TEST
		fprintf(stderr,"%d of %d : ticket = %hu\n",
			_my_pe(), _num_pes(), myticket);
#endif
	do {
		shmem_short_get((shmem_t *) &nowserving,
			(shmem_t *) ncp->lock + LOCKNUMREC_SERVING, 1,
			ncp->lock[LOCKNUMREC_BASEPE]);
#ifdef LN_TEST
		fprintf(stderr,"%d of %d : serving = %hu\n",
			_my_pe(), _num_pes(), nowserving);
#endif
		/* work-around for non-unique tickets */
		if (nowserving > myticket && nowserving < myticket + numpe ) {
			/* get a new ticket ... you've been bypassed */
			/* and handle the unlikely wrap-around effect */
			myticket = shmem_short_finc(
				(shmem_t *) ncp->lock + LOCKNUMREC_LOCK,
				ncp->lock[LOCKNUMREC_BASEPE]);
#ifdef LN_TEST
				fprintf(stderr,"%d of %d : new ticket = %hu\n",
					_my_pe(), _num_pes(), myticket);
#endif
		}
	} while(nowserving != myticket);
	/* now our turn to check & update value */
#endif

	if(numrecs > NC_get_numrecs(ncp))
	{


#if TOUCH_LAST
		status = NCtouchlast(ncp,
			(const NC_var *const*)ncp->vars.value,
			numrecs);
		if(status != NC_NOERR)
			goto common_return;
#endif /* TOUCH_LAST */

		set_NC_ndirty(ncp);

		if(!NC_dofill(ncp))
		{
			/* Simply set the new numrecs value */
			NC_set_numrecs(ncp, numrecs);
		}
		else
		{
		    /* Treat two cases differently:
		        - exactly one record variable (no padding)
                        - multiple record variables (each record padded
                          to 4-byte alignment)
		    */
		    NC_var **vpp = (NC_var **)ncp->vars.value;
		    NC_var *const *const end = &vpp[ncp->vars.nelems];
		    NC_var *recvarp = NULL;	/* last record var */
		    int numrecvars = 0;
		    size_t cur_nrecs;

		    /* determine how many record variables */
		    for( /*NADA*/; vpp < end; vpp++) {
			if(IS_RECVAR(*vpp)) {
			    recvarp = *vpp;
			    numrecvars++;
			}
		    }

		    if (numrecvars != 1) { /* usual case */
			/* Fill each record out to numrecs */
			while((cur_nrecs = NC_get_numrecs(ncp)) < numrecs)
			    {
				status = NCfillrecord(ncp,
					(const NC_var *const*)ncp->vars.value,
					cur_nrecs);
				if(status != NC_NOERR)
				{
					break;
				}
				NC_increase_numrecs(ncp, cur_nrecs +1);
			}
			if(status != NC_NOERR)
				goto common_return;
		    } else {	/* special case */
			/* Fill each record out to numrecs */
			while((cur_nrecs = NC_get_numrecs(ncp)) < numrecs)
			    {
				status = NCfillspecialrecord(ncp,
					recvarp,
					cur_nrecs);
				if(status != NC_NOERR)
				{
					break;
				}
				NC_increase_numrecs(ncp, cur_nrecs +1);
			}
			if(status != NC_NOERR)
				goto common_return;

		    }
		}

		if(NC_doNsync(ncp))
		{
			status = write_numrecs(ncp);
		}

	}
common_return:
#ifdef LOCKNUMREC
	/* finished with our lock - increment serving number */
	(void) shmem_short_finc((shmem_t *) ncp->lock + LOCKNUMREC_SERVING,
		ncp->lock[LOCKNUMREC_BASEPE]);
#endif
	return status;
}


/*
 * Check whether 'coord' values are valid for the variable.
 */
static int
NCcoordck(NC3_INFO* ncp, const NC_var *varp, const size_t *coord)
{
	const size_t *ip;
	size_t *up;

	if(varp->ndims == 0)
		return NC_NOERR;	/* 'scalar' variable */

	if(IS_RECVAR(varp))
	{
		if(*coord > X_UINT_MAX) /* rkr: bug fix from previous X_INT_MAX */
			return NC_EINVALCOORDS; /* sanity check */
#ifdef RELAX_COORD_BOUND
		if(NC_readonly(ncp) && *coord > NC_get_numrecs(ncp))
#else
		if(NC_readonly(ncp) && *coord >= NC_get_numrecs(ncp))
#endif
		{
			if(!NC_doNsync(ncp))
				return NC_EINVALCOORDS;
			/* else */
			{
				/* Update from disk and check again */
				const int status = read_numrecs(ncp);
				if(status != NC_NOERR)
					return status;
#ifdef RELAX_COORD_BOUND
				if(*coord > NC_get_numrecs(ncp))
#else
				if(*coord >= NC_get_numrecs(ncp))
#endif
					return NC_EINVALCOORDS;
			}
		}
		ip = coord + 1;
		up = varp->shape + 1;
	}
	else
	{
		ip = coord;
		up = varp->shape;
	}

#ifdef CDEBUG
fprintf(stderr,"	NCcoordck: coord %ld, count %d, ip %ld\n",
		coord, varp->ndims, ip );
#endif /* CDEBUG */

	for(; ip < coord + varp->ndims; ip++, up++)
	{

#ifdef CDEBUG
fprintf(stderr,"	NCcoordck: ip %p, *ip %ld, up %p, *up %lu\n",
			ip, *ip, up, *up );
#endif /* CDEBUG */

		/* cast needed for braindead systems with signed size_t */
#ifdef RELAX_COORD_BOUND
		if((unsigned long) *ip > (unsigned long) *up )
#else
		if((unsigned long) *ip >= (unsigned long) *up )
#endif
			return NC_EINVALCOORDS;
	}

	return NC_NOERR;
}


/*
 * Check whether 'edges' are valid for the variable and 'start'
 */
/*ARGSUSED*/
static int
NCedgeck(const NC3_INFO* ncp, const NC_var *varp,
	 const size_t *start, const size_t *edges)
{
	const size_t *const end = start + varp->ndims;
	const size_t *shp = varp->shape;

	if(varp->ndims == 0)
		return NC_NOERR;	/* 'scalar' variable */

	if(IS_RECVAR(varp))
	{
#ifdef RELAX_COORD_BOUND
		if (NC_readonly(ncp) &&
                    (start[0] == NC_get_numrecs(ncp) && edges[0] > 0))
			return(NC_EINVALCOORDS);
#endif
		start++;
		edges++;
		shp++;
	}

	for(; start < end; start++, edges++, shp++)
	{
#ifdef RELAX_COORD_BOUND
		if ((unsigned long) *start == *shp && *edges > 0)
			return(NC_EINVALCOORDS);
#endif
		/* cast needed for braindead systems with signed size_t */
		if((unsigned long) *edges > *shp ||
			(unsigned long) *start + (unsigned long) *edges > *shp)
		{
			return(NC_EEDGE);
		}
	}
	return NC_NOERR;
}


/*
 * Translate the (variable, coord) pair into a seek index
 */
static off_t
NC_varoffset(const NC3_INFO* ncp, const NC_var *varp, const size_t *coord)
{
	if(varp->ndims == 0) /* 'scalar' variable */
		return varp->begin;

	if(varp->ndims == 1)
	{
		if(IS_RECVAR(varp))
			return varp->begin +
				 (off_t)(*coord) * (off_t)ncp->recsize;
		/* else */
		return varp->begin + (off_t)(*coord) * (off_t)varp->xsz;
	}
	/* else */
	{
		off_t lcoord = (off_t)coord[varp->ndims -1];

		off_t *up = varp->dsizes +1;
		const size_t *ip = coord;
		const off_t *const end = varp->dsizes + varp->ndims;

		if(IS_RECVAR(varp))
			up++, ip++;

		for(; up < end; up++, ip++)
			lcoord += (off_t)(*up) * (off_t)(*ip);

		lcoord *= varp->xsz;

		if(IS_RECVAR(varp))
			lcoord += (off_t)(*coord) * ncp->recsize;

		lcoord += varp->begin;
		return lcoord;
	}
}


#line 753

static int
#line 754
putNCvx_char_char(NC3_INFO* ncp, const NC_var *varp,
#line 754
		 const size_t *start, size_t nelems, const char *value)
#line 754
{
#line 754
	off_t offset = NC_varoffset(ncp, varp, start);
#line 754
	size_t remaining = varp->xsz * nelems;
#line 754
	int status = NC_NOERR;
#line 754
	void *xp;
#line 754
        void *fillp=NULL;
#line 754

#line 754
	if(nelems == 0)
#line 754
		return NC_NOERR;
#line 754

#line 754
	assert(value != NULL);
#line 754

#line 754
#ifdef ERANGE_FILL
#line 754
        fillp = malloc(varp->xsz);
#line 754
        status = NC3_inq_var_fill(varp, fillp);
#line 754
#endif
#line 754

#line 754
	for(;;)
#line 754
	{
#line 754
		size_t extent = MIN(remaining, ncp->chunk);
#line 754
		size_t nput = ncx_howmany(varp->type, extent);
#line 754

#line 754
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 754
				 RGN_WRITE, &xp);
#line 754
		if(lstatus != NC_NOERR)
#line 754
			return lstatus;
#line 754

#line 754
		lstatus = ncx_putn_char_char(&xp, nput, value );
#line 754
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 754
		{
#line 754
			/* not fatal to the loop */
#line 754
			status = lstatus;
#line 754
		}
#line 754

#line 754
		(void) ncio_rel(ncp->nciop, offset,
#line 754
				 RGN_MODIFIED);
#line 754

#line 754
		remaining -= extent;
#line 754
		if(remaining == 0)
#line 754
			break; /* normal loop exit */
#line 754
		offset += (off_t)extent;
#line 754
		value += nput;
#line 754

#line 754
	}
#line 754
#ifdef ERANGE_FILL
#line 754
        free(fillp);
#line 754
#endif
#line 754

#line 754
	return status;
#line 754
}
#line 754


static int
#line 756
putNCvx_schar_schar(NC3_INFO* ncp, const NC_var *varp,
#line 756
		 const size_t *start, size_t nelems, const schar *value)
#line 756
{
#line 756
	off_t offset = NC_varoffset(ncp, varp, start);
#line 756
	size_t remaining = varp->xsz * nelems;
#line 756
	int status = NC_NOERR;
#line 756
	void *xp;
#line 756
        void *fillp=NULL;
#line 756

#line 756
	if(nelems == 0)
#line 756
		return NC_NOERR;
#line 756

#line 756
	assert(value != NULL);
#line 756

#line 756
#ifdef ERANGE_FILL
#line 756
        fillp = malloc(varp->xsz);
#line 756
        status = NC3_inq_var_fill(varp, fillp);
#line 756
#endif
#line 756

#line 756
	for(;;)
#line 756
	{
#line 756
		size_t extent = MIN(remaining, ncp->chunk);
#line 756
		size_t nput = ncx_howmany(varp->type, extent);
#line 756

#line 756
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 756
				 RGN_WRITE, &xp);
#line 756
		if(lstatus != NC_NOERR)
#line 756
			return lstatus;
#line 756

#line 756
		lstatus = ncx_putn_schar_schar(&xp, nput, value ,fillp);
#line 756
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 756
		{
#line 756
			/* not fatal to the loop */
#line 756
			status = lstatus;
#line 756
		}
#line 756

#line 756
		(void) ncio_rel(ncp->nciop, offset,
#line 756
				 RGN_MODIFIED);
#line 756

#line 756
		remaining -= extent;
#line 756
		if(remaining == 0)
#line 756
			break; /* normal loop exit */
#line 756
		offset += (off_t)extent;
#line 756
		value += nput;
#line 756

#line 756
	}
#line 756
#ifdef ERANGE_FILL
#line 756
        free(fillp);
#line 756
#endif
#line 756

#line 756
	return status;
#line 756
}
#line 756

static int
#line 757
putNCvx_schar_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 757
		 const size_t *start, size_t nelems, const uchar *value)
#line 757
{
#line 757
	off_t offset = NC_varoffset(ncp, varp, start);
#line 757
	size_t remaining = varp->xsz * nelems;
#line 757
	int status = NC_NOERR;
#line 757
	void *xp;
#line 757
        void *fillp=NULL;
#line 757

#line 757
	if(nelems == 0)
#line 757
		return NC_NOERR;
#line 757

#line 757
	assert(value != NULL);
#line 757

#line 757
#ifdef ERANGE_FILL
#line 757
        fillp = malloc(varp->xsz);
#line 757
        status = NC3_inq_var_fill(varp, fillp);
#line 757
#endif
#line 757

#line 757
	for(;;)
#line 757
	{
#line 757
		size_t extent = MIN(remaining, ncp->chunk);
#line 757
		size_t nput = ncx_howmany(varp->type, extent);
#line 757

#line 757
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 757
				 RGN_WRITE, &xp);
#line 757
		if(lstatus != NC_NOERR)
#line 757
			return lstatus;
#line 757

#line 757
		lstatus = ncx_putn_schar_uchar(&xp, nput, value ,fillp);
#line 757
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 757
		{
#line 757
			/* not fatal to the loop */
#line 757
			status = lstatus;
#line 757
		}
#line 757

#line 757
		(void) ncio_rel(ncp->nciop, offset,
#line 757
				 RGN_MODIFIED);
#line 757

#line 757
		remaining -= extent;
#line 757
		if(remaining == 0)
#line 757
			break; /* normal loop exit */
#line 757
		offset += (off_t)extent;
#line 757
		value += nput;
#line 757

#line 757
	}
#line 757
#ifdef ERANGE_FILL
#line 757
        free(fillp);
#line 757
#endif
#line 757

#line 757
	return status;
#line 757
}
#line 757

static int
#line 758
putNCvx_schar_short(NC3_INFO* ncp, const NC_var *varp,
#line 758
		 const size_t *start, size_t nelems, const short *value)
#line 758
{
#line 758
	off_t offset = NC_varoffset(ncp, varp, start);
#line 758
	size_t remaining = varp->xsz * nelems;
#line 758
	int status = NC_NOERR;
#line 758
	void *xp;
#line 758
        void *fillp=NULL;
#line 758

#line 758
	if(nelems == 0)
#line 758
		return NC_NOERR;
#line 758

#line 758
	assert(value != NULL);
#line 758

#line 758
#ifdef ERANGE_FILL
#line 758
        fillp = malloc(varp->xsz);
#line 758
        status = NC3_inq_var_fill(varp, fillp);
#line 758
#endif
#line 758

#line 758
	for(;;)
#line 758
	{
#line 758
		size_t extent = MIN(remaining, ncp->chunk);
#line 758
		size_t nput = ncx_howmany(varp->type, extent);
#line 758

#line 758
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 758
				 RGN_WRITE, &xp);
#line 758
		if(lstatus != NC_NOERR)
#line 758
			return lstatus;
#line 758

#line 758
		lstatus = ncx_putn_schar_short(&xp, nput, value ,fillp);
#line 758
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 758
		{
#line 758
			/* not fatal to the loop */
#line 758
			status = lstatus;
#line 758
		}
#line 758

#line 758
		(void) ncio_rel(ncp->nciop, offset,
#line 758
				 RGN_MODIFIED);
#line 758

#line 758
		remaining -= extent;
#line 758
		if(remaining == 0)
#line 758
			break; /* normal loop exit */
#line 758
		offset += (off_t)extent;
#line 758
		value += nput;
#line 758

#line 758
	}
#line 758
#ifdef ERANGE_FILL
#line 758
        free(fillp);
#line 758
#endif
#line 758

#line 758
	return status;
#line 758
}
#line 758

static int
#line 759
putNCvx_schar_int(NC3_INFO* ncp, const NC_var *varp,
#line 759
		 const size_t *start, size_t nelems, const int *value)
#line 759
{
#line 759
	off_t offset = NC_varoffset(ncp, varp, start);
#line 759
	size_t remaining = varp->xsz * nelems;
#line 759
	int status = NC_NOERR;
#line 759
	void *xp;
#line 759
        void *fillp=NULL;
#line 759

#line 759
	if(nelems == 0)
#line 759
		return NC_NOERR;
#line 759

#line 759
	assert(value != NULL);
#line 759

#line 759
#ifdef ERANGE_FILL
#line 759
        fillp = malloc(varp->xsz);
#line 759
        status = NC3_inq_var_fill(varp, fillp);
#line 759
#endif
#line 759

#line 759
	for(;;)
#line 759
	{
#line 759
		size_t extent = MIN(remaining, ncp->chunk);
#line 759
		size_t nput = ncx_howmany(varp->type, extent);
#line 759

#line 759
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 759
				 RGN_WRITE, &xp);
#line 759
		if(lstatus != NC_NOERR)
#line 759
			return lstatus;
#line 759

#line 759
		lstatus = ncx_putn_schar_int(&xp, nput, value ,fillp);
#line 759
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 759
		{
#line 759
			/* not fatal to the loop */
#line 759
			status = lstatus;
#line 759
		}
#line 759

#line 759
		(void) ncio_rel(ncp->nciop, offset,
#line 759
				 RGN_MODIFIED);
#line 759

#line 759
		remaining -= extent;
#line 759
		if(remaining == 0)
#line 759
			break; /* normal loop exit */
#line 759
		offset += (off_t)extent;
#line 759
		value += nput;
#line 759

#line 759
	}
#line 759
#ifdef ERANGE_FILL
#line 759
        free(fillp);
#line 759
#endif
#line 759

#line 759
	return status;
#line 759
}
#line 759

static int
#line 760
putNCvx_schar_float(NC3_INFO* ncp, const NC_var *varp,
#line 760
		 const size_t *start, size_t nelems, const float *value)
#line 760
{
#line 760
	off_t offset = NC_varoffset(ncp, varp, start);
#line 760
	size_t remaining = varp->xsz * nelems;
#line 760
	int status = NC_NOERR;
#line 760
	void *xp;
#line 760
        void *fillp=NULL;
#line 760

#line 760
	if(nelems == 0)
#line 760
		return NC_NOERR;
#line 760

#line 760
	assert(value != NULL);
#line 760

#line 760
#ifdef ERANGE_FILL
#line 760
        fillp = malloc(varp->xsz);
#line 760
        status = NC3_inq_var_fill(varp, fillp);
#line 760
#endif
#line 760

#line 760
	for(;;)
#line 760
	{
#line 760
		size_t extent = MIN(remaining, ncp->chunk);
#line 760
		size_t nput = ncx_howmany(varp->type, extent);
#line 760

#line 760
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 760
				 RGN_WRITE, &xp);
#line 760
		if(lstatus != NC_NOERR)
#line 760
			return lstatus;
#line 760

#line 760
		lstatus = ncx_putn_schar_float(&xp, nput, value ,fillp);
#line 760
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 760
		{
#line 760
			/* not fatal to the loop */
#line 760
			status = lstatus;
#line 760
		}
#line 760

#line 760
		(void) ncio_rel(ncp->nciop, offset,
#line 760
				 RGN_MODIFIED);
#line 760

#line 760
		remaining -= extent;
#line 760
		if(remaining == 0)
#line 760
			break; /* normal loop exit */
#line 760
		offset += (off_t)extent;
#line 760
		value += nput;
#line 760

#line 760
	}
#line 760
#ifdef ERANGE_FILL
#line 760
        free(fillp);
#line 760
#endif
#line 760

#line 760
	return status;
#line 760
}
#line 760

static int
#line 761
putNCvx_schar_double(NC3_INFO* ncp, const NC_var *varp,
#line 761
		 const size_t *start, size_t nelems, const double *value)
#line 761
{
#line 761
	off_t offset = NC_varoffset(ncp, varp, start);
#line 761
	size_t remaining = varp->xsz * nelems;
#line 761
	int status = NC_NOERR;
#line 761
	void *xp;
#line 761
        void *fillp=NULL;
#line 761

#line 761
	if(nelems == 0)
#line 761
		return NC_NOERR;
#line 761

#line 761
	assert(value != NULL);
#line 761

#line 761
#ifdef ERANGE_FILL
#line 761
        fillp = malloc(varp->xsz);
#line 761
        status = NC3_inq_var_fill(varp, fillp);
#line 761
#endif
#line 761

#line 761
	for(;;)
#line 761
	{
#line 761
		size_t extent = MIN(remaining, ncp->chunk);
#line 761
		size_t nput = ncx_howmany(varp->type, extent);
#line 761

#line 761
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 761
				 RGN_WRITE, &xp);
#line 761
		if(lstatus != NC_NOERR)
#line 761
			return lstatus;
#line 761

#line 761
		lstatus = ncx_putn_schar_double(&xp, nput, value ,fillp);
#line 761
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 761
		{
#line 761
			/* not fatal to the loop */
#line 761
			status = lstatus;
#line 761
		}
#line 761

#line 761
		(void) ncio_rel(ncp->nciop, offset,
#line 761
				 RGN_MODIFIED);
#line 761

#line 761
		remaining -= extent;
#line 761
		if(remaining == 0)
#line 761
			break; /* normal loop exit */
#line 761
		offset += (off_t)extent;
#line 761
		value += nput;
#line 761

#line 761
	}
#line 761
#ifdef ERANGE_FILL
#line 761
        free(fillp);
#line 761
#endif
#line 761

#line 761
	return status;
#line 761
}
#line 761

static int
#line 762
putNCvx_schar_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 762
		 const size_t *start, size_t nelems, const longlong *value)
#line 762
{
#line 762
	off_t offset = NC_varoffset(ncp, varp, start);
#line 762
	size_t remaining = varp->xsz * nelems;
#line 762
	int status = NC_NOERR;
#line 762
	void *xp;
#line 762
        void *fillp=NULL;
#line 762

#line 762
	if(nelems == 0)
#line 762
		return NC_NOERR;
#line 762

#line 762
	assert(value != NULL);
#line 762

#line 762
#ifdef ERANGE_FILL
#line 762
        fillp = malloc(varp->xsz);
#line 762
        status = NC3_inq_var_fill(varp, fillp);
#line 762
#endif
#line 762

#line 762
	for(;;)
#line 762
	{
#line 762
		size_t extent = MIN(remaining, ncp->chunk);
#line 762
		size_t nput = ncx_howmany(varp->type, extent);
#line 762

#line 762
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 762
				 RGN_WRITE, &xp);
#line 762
		if(lstatus != NC_NOERR)
#line 762
			return lstatus;
#line 762

#line 762
		lstatus = ncx_putn_schar_longlong(&xp, nput, value ,fillp);
#line 762
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 762
		{
#line 762
			/* not fatal to the loop */
#line 762
			status = lstatus;
#line 762
		}
#line 762

#line 762
		(void) ncio_rel(ncp->nciop, offset,
#line 762
				 RGN_MODIFIED);
#line 762

#line 762
		remaining -= extent;
#line 762
		if(remaining == 0)
#line 762
			break; /* normal loop exit */
#line 762
		offset += (off_t)extent;
#line 762
		value += nput;
#line 762

#line 762
	}
#line 762
#ifdef ERANGE_FILL
#line 762
        free(fillp);
#line 762
#endif
#line 762

#line 762
	return status;
#line 762
}
#line 762

static int
#line 763
putNCvx_schar_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 763
		 const size_t *start, size_t nelems, const ushort *value)
#line 763
{
#line 763
	off_t offset = NC_varoffset(ncp, varp, start);
#line 763
	size_t remaining = varp->xsz * nelems;
#line 763
	int status = NC_NOERR;
#line 763
	void *xp;
#line 763
        void *fillp=NULL;
#line 763

#line 763
	if(nelems == 0)
#line 763
		return NC_NOERR;
#line 763

#line 763
	assert(value != NULL);
#line 763

#line 763
#ifdef ERANGE_FILL
#line 763
        fillp = malloc(varp->xsz);
#line 763
        status = NC3_inq_var_fill(varp, fillp);
#line 763
#endif
#line 763

#line 763
	for(;;)
#line 763
	{
#line 763
		size_t extent = MIN(remaining, ncp->chunk);
#line 763
		size_t nput = ncx_howmany(varp->type, extent);
#line 763

#line 763
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 763
				 RGN_WRITE, &xp);
#line 763
		if(lstatus != NC_NOERR)
#line 763
			return lstatus;
#line 763

#line 763
		lstatus = ncx_putn_schar_ushort(&xp, nput, value ,fillp);
#line 763
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 763
		{
#line 763
			/* not fatal to the loop */
#line 763
			status = lstatus;
#line 763
		}
#line 763

#line 763
		(void) ncio_rel(ncp->nciop, offset,
#line 763
				 RGN_MODIFIED);
#line 763

#line 763
		remaining -= extent;
#line 763
		if(remaining == 0)
#line 763
			break; /* normal loop exit */
#line 763
		offset += (off_t)extent;
#line 763
		value += nput;
#line 763

#line 763
	}
#line 763
#ifdef ERANGE_FILL
#line 763
        free(fillp);
#line 763
#endif
#line 763

#line 763
	return status;
#line 763
}
#line 763

static int
#line 764
putNCvx_schar_uint(NC3_INFO* ncp, const NC_var *varp,
#line 764
		 const size_t *start, size_t nelems, const uint *value)
#line 764
{
#line 764
	off_t offset = NC_varoffset(ncp, varp, start);
#line 764
	size_t remaining = varp->xsz * nelems;
#line 764
	int status = NC_NOERR;
#line 764
	void *xp;
#line 764
        void *fillp=NULL;
#line 764

#line 764
	if(nelems == 0)
#line 764
		return NC_NOERR;
#line 764

#line 764
	assert(value != NULL);
#line 764

#line 764
#ifdef ERANGE_FILL
#line 764
        fillp = malloc(varp->xsz);
#line 764
        status = NC3_inq_var_fill(varp, fillp);
#line 764
#endif
#line 764

#line 764
	for(;;)
#line 764
	{
#line 764
		size_t extent = MIN(remaining, ncp->chunk);
#line 764
		size_t nput = ncx_howmany(varp->type, extent);
#line 764

#line 764
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 764
				 RGN_WRITE, &xp);
#line 764
		if(lstatus != NC_NOERR)
#line 764
			return lstatus;
#line 764

#line 764
		lstatus = ncx_putn_schar_uint(&xp, nput, value ,fillp);
#line 764
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 764
		{
#line 764
			/* not fatal to the loop */
#line 764
			status = lstatus;
#line 764
		}
#line 764

#line 764
		(void) ncio_rel(ncp->nciop, offset,
#line 764
				 RGN_MODIFIED);
#line 764

#line 764
		remaining -= extent;
#line 764
		if(remaining == 0)
#line 764
			break; /* normal loop exit */
#line 764
		offset += (off_t)extent;
#line 764
		value += nput;
#line 764

#line 764
	}
#line 764
#ifdef ERANGE_FILL
#line 764
        free(fillp);
#line 764
#endif
#line 764

#line 764
	return status;
#line 764
}
#line 764

static int
#line 765
putNCvx_schar_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 765
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 765
{
#line 765
	off_t offset = NC_varoffset(ncp, varp, start);
#line 765
	size_t remaining = varp->xsz * nelems;
#line 765
	int status = NC_NOERR;
#line 765
	void *xp;
#line 765
        void *fillp=NULL;
#line 765

#line 765
	if(nelems == 0)
#line 765
		return NC_NOERR;
#line 765

#line 765
	assert(value != NULL);
#line 765

#line 765
#ifdef ERANGE_FILL
#line 765
        fillp = malloc(varp->xsz);
#line 765
        status = NC3_inq_var_fill(varp, fillp);
#line 765
#endif
#line 765

#line 765
	for(;;)
#line 765
	{
#line 765
		size_t extent = MIN(remaining, ncp->chunk);
#line 765
		size_t nput = ncx_howmany(varp->type, extent);
#line 765

#line 765
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 765
				 RGN_WRITE, &xp);
#line 765
		if(lstatus != NC_NOERR)
#line 765
			return lstatus;
#line 765

#line 765
		lstatus = ncx_putn_schar_ulonglong(&xp, nput, value ,fillp);
#line 765
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 765
		{
#line 765
			/* not fatal to the loop */
#line 765
			status = lstatus;
#line 765
		}
#line 765

#line 765
		(void) ncio_rel(ncp->nciop, offset,
#line 765
				 RGN_MODIFIED);
#line 765

#line 765
		remaining -= extent;
#line 765
		if(remaining == 0)
#line 765
			break; /* normal loop exit */
#line 765
		offset += (off_t)extent;
#line 765
		value += nput;
#line 765

#line 765
	}
#line 765
#ifdef ERANGE_FILL
#line 765
        free(fillp);
#line 765
#endif
#line 765

#line 765
	return status;
#line 765
}
#line 765


static int
#line 767
putNCvx_short_schar(NC3_INFO* ncp, const NC_var *varp,
#line 767
		 const size_t *start, size_t nelems, const schar *value)
#line 767
{
#line 767
	off_t offset = NC_varoffset(ncp, varp, start);
#line 767
	size_t remaining = varp->xsz * nelems;
#line 767
	int status = NC_NOERR;
#line 767
	void *xp;
#line 767
        void *fillp=NULL;
#line 767

#line 767
	if(nelems == 0)
#line 767
		return NC_NOERR;
#line 767

#line 767
	assert(value != NULL);
#line 767

#line 767
#ifdef ERANGE_FILL
#line 767
        fillp = malloc(varp->xsz);
#line 767
        status = NC3_inq_var_fill(varp, fillp);
#line 767
#endif
#line 767

#line 767
	for(;;)
#line 767
	{
#line 767
		size_t extent = MIN(remaining, ncp->chunk);
#line 767
		size_t nput = ncx_howmany(varp->type, extent);
#line 767

#line 767
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 767
				 RGN_WRITE, &xp);
#line 767
		if(lstatus != NC_NOERR)
#line 767
			return lstatus;
#line 767

#line 767
		lstatus = ncx_putn_short_schar(&xp, nput, value ,fillp);
#line 767
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 767
		{
#line 767
			/* not fatal to the loop */
#line 767
			status = lstatus;
#line 767
		}
#line 767

#line 767
		(void) ncio_rel(ncp->nciop, offset,
#line 767
				 RGN_MODIFIED);
#line 767

#line 767
		remaining -= extent;
#line 767
		if(remaining == 0)
#line 767
			break; /* normal loop exit */
#line 767
		offset += (off_t)extent;
#line 767
		value += nput;
#line 767

#line 767
	}
#line 767
#ifdef ERANGE_FILL
#line 767
        free(fillp);
#line 767
#endif
#line 767

#line 767
	return status;
#line 767
}
#line 767

static int
#line 768
putNCvx_short_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 768
		 const size_t *start, size_t nelems, const uchar *value)
#line 768
{
#line 768
	off_t offset = NC_varoffset(ncp, varp, start);
#line 768
	size_t remaining = varp->xsz * nelems;
#line 768
	int status = NC_NOERR;
#line 768
	void *xp;
#line 768
        void *fillp=NULL;
#line 768

#line 768
	if(nelems == 0)
#line 768
		return NC_NOERR;
#line 768

#line 768
	assert(value != NULL);
#line 768

#line 768
#ifdef ERANGE_FILL
#line 768
        fillp = malloc(varp->xsz);
#line 768
        status = NC3_inq_var_fill(varp, fillp);
#line 768
#endif
#line 768

#line 768
	for(;;)
#line 768
	{
#line 768
		size_t extent = MIN(remaining, ncp->chunk);
#line 768
		size_t nput = ncx_howmany(varp->type, extent);
#line 768

#line 768
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 768
				 RGN_WRITE, &xp);
#line 768
		if(lstatus != NC_NOERR)
#line 768
			return lstatus;
#line 768

#line 768
		lstatus = ncx_putn_short_uchar(&xp, nput, value ,fillp);
#line 768
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 768
		{
#line 768
			/* not fatal to the loop */
#line 768
			status = lstatus;
#line 768
		}
#line 768

#line 768
		(void) ncio_rel(ncp->nciop, offset,
#line 768
				 RGN_MODIFIED);
#line 768

#line 768
		remaining -= extent;
#line 768
		if(remaining == 0)
#line 768
			break; /* normal loop exit */
#line 768
		offset += (off_t)extent;
#line 768
		value += nput;
#line 768

#line 768
	}
#line 768
#ifdef ERANGE_FILL
#line 768
        free(fillp);
#line 768
#endif
#line 768

#line 768
	return status;
#line 768
}
#line 768

static int
#line 769
putNCvx_short_short(NC3_INFO* ncp, const NC_var *varp,
#line 769
		 const size_t *start, size_t nelems, const short *value)
#line 769
{
#line 769
	off_t offset = NC_varoffset(ncp, varp, start);
#line 769
	size_t remaining = varp->xsz * nelems;
#line 769
	int status = NC_NOERR;
#line 769
	void *xp;
#line 769
        void *fillp=NULL;
#line 769

#line 769
	if(nelems == 0)
#line 769
		return NC_NOERR;
#line 769

#line 769
	assert(value != NULL);
#line 769

#line 769
#ifdef ERANGE_FILL
#line 769
        fillp = malloc(varp->xsz);
#line 769
        status = NC3_inq_var_fill(varp, fillp);
#line 769
#endif
#line 769

#line 769
	for(;;)
#line 769
	{
#line 769
		size_t extent = MIN(remaining, ncp->chunk);
#line 769
		size_t nput = ncx_howmany(varp->type, extent);
#line 769

#line 769
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 769
				 RGN_WRITE, &xp);
#line 769
		if(lstatus != NC_NOERR)
#line 769
			return lstatus;
#line 769

#line 769
		lstatus = ncx_putn_short_short(&xp, nput, value ,fillp);
#line 769
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 769
		{
#line 769
			/* not fatal to the loop */
#line 769
			status = lstatus;
#line 769
		}
#line 769

#line 769
		(void) ncio_rel(ncp->nciop, offset,
#line 769
				 RGN_MODIFIED);
#line 769

#line 769
		remaining -= extent;
#line 769
		if(remaining == 0)
#line 769
			break; /* normal loop exit */
#line 769
		offset += (off_t)extent;
#line 769
		value += nput;
#line 769

#line 769
	}
#line 769
#ifdef ERANGE_FILL
#line 769
        free(fillp);
#line 769
#endif
#line 769

#line 769
	return status;
#line 769
}
#line 769

static int
#line 770
putNCvx_short_int(NC3_INFO* ncp, const NC_var *varp,
#line 770
		 const size_t *start, size_t nelems, const int *value)
#line 770
{
#line 770
	off_t offset = NC_varoffset(ncp, varp, start);
#line 770
	size_t remaining = varp->xsz * nelems;
#line 770
	int status = NC_NOERR;
#line 770
	void *xp;
#line 770
        void *fillp=NULL;
#line 770

#line 770
	if(nelems == 0)
#line 770
		return NC_NOERR;
#line 770

#line 770
	assert(value != NULL);
#line 770

#line 770
#ifdef ERANGE_FILL
#line 770
        fillp = malloc(varp->xsz);
#line 770
        status = NC3_inq_var_fill(varp, fillp);
#line 770
#endif
#line 770

#line 770
	for(;;)
#line 770
	{
#line 770
		size_t extent = MIN(remaining, ncp->chunk);
#line 770
		size_t nput = ncx_howmany(varp->type, extent);
#line 770

#line 770
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 770
				 RGN_WRITE, &xp);
#line 770
		if(lstatus != NC_NOERR)
#line 770
			return lstatus;
#line 770

#line 770
		lstatus = ncx_putn_short_int(&xp, nput, value ,fillp);
#line 770
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 770
		{
#line 770
			/* not fatal to the loop */
#line 770
			status = lstatus;
#line 770
		}
#line 770

#line 770
		(void) ncio_rel(ncp->nciop, offset,
#line 770
				 RGN_MODIFIED);
#line 770

#line 770
		remaining -= extent;
#line 770
		if(remaining == 0)
#line 770
			break; /* normal loop exit */
#line 770
		offset += (off_t)extent;
#line 770
		value += nput;
#line 770

#line 770
	}
#line 770
#ifdef ERANGE_FILL
#line 770
        free(fillp);
#line 770
#endif
#line 770

#line 770
	return status;
#line 770
}
#line 770

static int
#line 771
putNCvx_short_float(NC3_INFO* ncp, const NC_var *varp,
#line 771
		 const size_t *start, size_t nelems, const float *value)
#line 771
{
#line 771
	off_t offset = NC_varoffset(ncp, varp, start);
#line 771
	size_t remaining = varp->xsz * nelems;
#line 771
	int status = NC_NOERR;
#line 771
	void *xp;
#line 771
        void *fillp=NULL;
#line 771

#line 771
	if(nelems == 0)
#line 771
		return NC_NOERR;
#line 771

#line 771
	assert(value != NULL);
#line 771

#line 771
#ifdef ERANGE_FILL
#line 771
        fillp = malloc(varp->xsz);
#line 771
        status = NC3_inq_var_fill(varp, fillp);
#line 771
#endif
#line 771

#line 771
	for(;;)
#line 771
	{
#line 771
		size_t extent = MIN(remaining, ncp->chunk);
#line 771
		size_t nput = ncx_howmany(varp->type, extent);
#line 771

#line 771
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 771
				 RGN_WRITE, &xp);
#line 771
		if(lstatus != NC_NOERR)
#line 771
			return lstatus;
#line 771

#line 771
		lstatus = ncx_putn_short_float(&xp, nput, value ,fillp);
#line 771
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 771
		{
#line 771
			/* not fatal to the loop */
#line 771
			status = lstatus;
#line 771
		}
#line 771

#line 771
		(void) ncio_rel(ncp->nciop, offset,
#line 771
				 RGN_MODIFIED);
#line 771

#line 771
		remaining -= extent;
#line 771
		if(remaining == 0)
#line 771
			break; /* normal loop exit */
#line 771
		offset += (off_t)extent;
#line 771
		value += nput;
#line 771

#line 771
	}
#line 771
#ifdef ERANGE_FILL
#line 771
        free(fillp);
#line 771
#endif
#line 771

#line 771
	return status;
#line 771
}
#line 771

static int
#line 772
putNCvx_short_double(NC3_INFO* ncp, const NC_var *varp,
#line 772
		 const size_t *start, size_t nelems, const double *value)
#line 772
{
#line 772
	off_t offset = NC_varoffset(ncp, varp, start);
#line 772
	size_t remaining = varp->xsz * nelems;
#line 772
	int status = NC_NOERR;
#line 772
	void *xp;
#line 772
        void *fillp=NULL;
#line 772

#line 772
	if(nelems == 0)
#line 772
		return NC_NOERR;
#line 772

#line 772
	assert(value != NULL);
#line 772

#line 772
#ifdef ERANGE_FILL
#line 772
        fillp = malloc(varp->xsz);
#line 772
        status = NC3_inq_var_fill(varp, fillp);
#line 772
#endif
#line 772

#line 772
	for(;;)
#line 772
	{
#line 772
		size_t extent = MIN(remaining, ncp->chunk);
#line 772
		size_t nput = ncx_howmany(varp->type, extent);
#line 772

#line 772
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 772
				 RGN_WRITE, &xp);
#line 772
		if(lstatus != NC_NOERR)
#line 772
			return lstatus;
#line 772

#line 772
		lstatus = ncx_putn_short_double(&xp, nput, value ,fillp);
#line 772
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 772
		{
#line 772
			/* not fatal to the loop */
#line 772
			status = lstatus;
#line 772
		}
#line 772

#line 772
		(void) ncio_rel(ncp->nciop, offset,
#line 772
				 RGN_MODIFIED);
#line 772

#line 772
		remaining -= extent;
#line 772
		if(remaining == 0)
#line 772
			break; /* normal loop exit */
#line 772
		offset += (off_t)extent;
#line 772
		value += nput;
#line 772

#line 772
	}
#line 772
#ifdef ERANGE_FILL
#line 772
        free(fillp);
#line 772
#endif
#line 772

#line 772
	return status;
#line 772
}
#line 772

static int
#line 773
putNCvx_short_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 773
		 const size_t *start, size_t nelems, const longlong *value)
#line 773
{
#line 773
	off_t offset = NC_varoffset(ncp, varp, start);
#line 773
	size_t remaining = varp->xsz * nelems;
#line 773
	int status = NC_NOERR;
#line 773
	void *xp;
#line 773
        void *fillp=NULL;
#line 773

#line 773
	if(nelems == 0)
#line 773
		return NC_NOERR;
#line 773

#line 773
	assert(value != NULL);
#line 773

#line 773
#ifdef ERANGE_FILL
#line 773
        fillp = malloc(varp->xsz);
#line 773
        status = NC3_inq_var_fill(varp, fillp);
#line 773
#endif
#line 773

#line 773
	for(;;)
#line 773
	{
#line 773
		size_t extent = MIN(remaining, ncp->chunk);
#line 773
		size_t nput = ncx_howmany(varp->type, extent);
#line 773

#line 773
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 773
				 RGN_WRITE, &xp);
#line 773
		if(lstatus != NC_NOERR)
#line 773
			return lstatus;
#line 773

#line 773
		lstatus = ncx_putn_short_longlong(&xp, nput, value ,fillp);
#line 773
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 773
		{
#line 773
			/* not fatal to the loop */
#line 773
			status = lstatus;
#line 773
		}
#line 773

#line 773
		(void) ncio_rel(ncp->nciop, offset,
#line 773
				 RGN_MODIFIED);
#line 773

#line 773
		remaining -= extent;
#line 773
		if(remaining == 0)
#line 773
			break; /* normal loop exit */
#line 773
		offset += (off_t)extent;
#line 773
		value += nput;
#line 773

#line 773
	}
#line 773
#ifdef ERANGE_FILL
#line 773
        free(fillp);
#line 773
#endif
#line 773

#line 773
	return status;
#line 773
}
#line 773

static int
#line 774
putNCvx_short_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 774
		 const size_t *start, size_t nelems, const ushort *value)
#line 774
{
#line 774
	off_t offset = NC_varoffset(ncp, varp, start);
#line 774
	size_t remaining = varp->xsz * nelems;
#line 774
	int status = NC_NOERR;
#line 774
	void *xp;
#line 774
        void *fillp=NULL;
#line 774

#line 774
	if(nelems == 0)
#line 774
		return NC_NOERR;
#line 774

#line 774
	assert(value != NULL);
#line 774

#line 774
#ifdef ERANGE_FILL
#line 774
        fillp = malloc(varp->xsz);
#line 774
        status = NC3_inq_var_fill(varp, fillp);
#line 774
#endif
#line 774

#line 774
	for(;;)
#line 774
	{
#line 774
		size_t extent = MIN(remaining, ncp->chunk);
#line 774
		size_t nput = ncx_howmany(varp->type, extent);
#line 774

#line 774
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 774
				 RGN_WRITE, &xp);
#line 774
		if(lstatus != NC_NOERR)
#line 774
			return lstatus;
#line 774

#line 774
		lstatus = ncx_putn_short_ushort(&xp, nput, value ,fillp);
#line 774
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 774
		{
#line 774
			/* not fatal to the loop */
#line 774
			status = lstatus;
#line 774
		}
#line 774

#line 774
		(void) ncio_rel(ncp->nciop, offset,
#line 774
				 RGN_MODIFIED);
#line 774

#line 774
		remaining -= extent;
#line 774
		if(remaining == 0)
#line 774
			break; /* normal loop exit */
#line 774
		offset += (off_t)extent;
#line 774
		value += nput;
#line 774

#line 774
	}
#line 774
#ifdef ERANGE_FILL
#line 774
        free(fillp);
#line 774
#endif
#line 774

#line 774
	return status;
#line 774
}
#line 774

static int
#line 775
putNCvx_short_uint(NC3_INFO* ncp, const NC_var *varp,
#line 775
		 const size_t *start, size_t nelems, const uint *value)
#line 775
{
#line 775
	off_t offset = NC_varoffset(ncp, varp, start);
#line 775
	size_t remaining = varp->xsz * nelems;
#line 775
	int status = NC_NOERR;
#line 775
	void *xp;
#line 775
        void *fillp=NULL;
#line 775

#line 775
	if(nelems == 0)
#line 775
		return NC_NOERR;
#line 775

#line 775
	assert(value != NULL);
#line 775

#line 775
#ifdef ERANGE_FILL
#line 775
        fillp = malloc(varp->xsz);
#line 775
        status = NC3_inq_var_fill(varp, fillp);
#line 775
#endif
#line 775

#line 775
	for(;;)
#line 775
	{
#line 775
		size_t extent = MIN(remaining, ncp->chunk);
#line 775
		size_t nput = ncx_howmany(varp->type, extent);
#line 775

#line 775
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 775
				 RGN_WRITE, &xp);
#line 775
		if(lstatus != NC_NOERR)
#line 775
			return lstatus;
#line 775

#line 775
		lstatus = ncx_putn_short_uint(&xp, nput, value ,fillp);
#line 775
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 775
		{
#line 775
			/* not fatal to the loop */
#line 775
			status = lstatus;
#line 775
		}
#line 775

#line 775
		(void) ncio_rel(ncp->nciop, offset,
#line 775
				 RGN_MODIFIED);
#line 775

#line 775
		remaining -= extent;
#line 775
		if(remaining == 0)
#line 775
			break; /* normal loop exit */
#line 775
		offset += (off_t)extent;
#line 775
		value += nput;
#line 775

#line 775
	}
#line 775
#ifdef ERANGE_FILL
#line 775
        free(fillp);
#line 775
#endif
#line 775

#line 775
	return status;
#line 775
}
#line 775

static int
#line 776
putNCvx_short_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 776
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 776
{
#line 776
	off_t offset = NC_varoffset(ncp, varp, start);
#line 776
	size_t remaining = varp->xsz * nelems;
#line 776
	int status = NC_NOERR;
#line 776
	void *xp;
#line 776
        void *fillp=NULL;
#line 776

#line 776
	if(nelems == 0)
#line 776
		return NC_NOERR;
#line 776

#line 776
	assert(value != NULL);
#line 776

#line 776
#ifdef ERANGE_FILL
#line 776
        fillp = malloc(varp->xsz);
#line 776
        status = NC3_inq_var_fill(varp, fillp);
#line 776
#endif
#line 776

#line 776
	for(;;)
#line 776
	{
#line 776
		size_t extent = MIN(remaining, ncp->chunk);
#line 776
		size_t nput = ncx_howmany(varp->type, extent);
#line 776

#line 776
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 776
				 RGN_WRITE, &xp);
#line 776
		if(lstatus != NC_NOERR)
#line 776
			return lstatus;
#line 776

#line 776
		lstatus = ncx_putn_short_ulonglong(&xp, nput, value ,fillp);
#line 776
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 776
		{
#line 776
			/* not fatal to the loop */
#line 776
			status = lstatus;
#line 776
		}
#line 776

#line 776
		(void) ncio_rel(ncp->nciop, offset,
#line 776
				 RGN_MODIFIED);
#line 776

#line 776
		remaining -= extent;
#line 776
		if(remaining == 0)
#line 776
			break; /* normal loop exit */
#line 776
		offset += (off_t)extent;
#line 776
		value += nput;
#line 776

#line 776
	}
#line 776
#ifdef ERANGE_FILL
#line 776
        free(fillp);
#line 776
#endif
#line 776

#line 776
	return status;
#line 776
}
#line 776


static int
#line 778
putNCvx_int_schar(NC3_INFO* ncp, const NC_var *varp,
#line 778
		 const size_t *start, size_t nelems, const schar *value)
#line 778
{
#line 778
	off_t offset = NC_varoffset(ncp, varp, start);
#line 778
	size_t remaining = varp->xsz * nelems;
#line 778
	int status = NC_NOERR;
#line 778
	void *xp;
#line 778
        void *fillp=NULL;
#line 778

#line 778
	if(nelems == 0)
#line 778
		return NC_NOERR;
#line 778

#line 778
	assert(value != NULL);
#line 778

#line 778
#ifdef ERANGE_FILL
#line 778
        fillp = malloc(varp->xsz);
#line 778
        status = NC3_inq_var_fill(varp, fillp);
#line 778
#endif
#line 778

#line 778
	for(;;)
#line 778
	{
#line 778
		size_t extent = MIN(remaining, ncp->chunk);
#line 778
		size_t nput = ncx_howmany(varp->type, extent);
#line 778

#line 778
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 778
				 RGN_WRITE, &xp);
#line 778
		if(lstatus != NC_NOERR)
#line 778
			return lstatus;
#line 778

#line 778
		lstatus = ncx_putn_int_schar(&xp, nput, value ,fillp);
#line 778
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 778
		{
#line 778
			/* not fatal to the loop */
#line 778
			status = lstatus;
#line 778
		}
#line 778

#line 778
		(void) ncio_rel(ncp->nciop, offset,
#line 778
				 RGN_MODIFIED);
#line 778

#line 778
		remaining -= extent;
#line 778
		if(remaining == 0)
#line 778
			break; /* normal loop exit */
#line 778
		offset += (off_t)extent;
#line 778
		value += nput;
#line 778

#line 778
	}
#line 778
#ifdef ERANGE_FILL
#line 778
        free(fillp);
#line 778
#endif
#line 778

#line 778
	return status;
#line 778
}
#line 778

static int
#line 779
putNCvx_int_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 779
		 const size_t *start, size_t nelems, const uchar *value)
#line 779
{
#line 779
	off_t offset = NC_varoffset(ncp, varp, start);
#line 779
	size_t remaining = varp->xsz * nelems;
#line 779
	int status = NC_NOERR;
#line 779
	void *xp;
#line 779
        void *fillp=NULL;
#line 779

#line 779
	if(nelems == 0)
#line 779
		return NC_NOERR;
#line 779

#line 779
	assert(value != NULL);
#line 779

#line 779
#ifdef ERANGE_FILL
#line 779
        fillp = malloc(varp->xsz);
#line 779
        status = NC3_inq_var_fill(varp, fillp);
#line 779
#endif
#line 779

#line 779
	for(;;)
#line 779
	{
#line 779
		size_t extent = MIN(remaining, ncp->chunk);
#line 779
		size_t nput = ncx_howmany(varp->type, extent);
#line 779

#line 779
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 779
				 RGN_WRITE, &xp);
#line 779
		if(lstatus != NC_NOERR)
#line 779
			return lstatus;
#line 779

#line 779
		lstatus = ncx_putn_int_uchar(&xp, nput, value ,fillp);
#line 779
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 779
		{
#line 779
			/* not fatal to the loop */
#line 779
			status = lstatus;
#line 779
		}
#line 779

#line 779
		(void) ncio_rel(ncp->nciop, offset,
#line 779
				 RGN_MODIFIED);
#line 779

#line 779
		remaining -= extent;
#line 779
		if(remaining == 0)
#line 779
			break; /* normal loop exit */
#line 779
		offset += (off_t)extent;
#line 779
		value += nput;
#line 779

#line 779
	}
#line 779
#ifdef ERANGE_FILL
#line 779
        free(fillp);
#line 779
#endif
#line 779

#line 779
	return status;
#line 779
}
#line 779

static int
#line 780
putNCvx_int_short(NC3_INFO* ncp, const NC_var *varp,
#line 780
		 const size_t *start, size_t nelems, const short *value)
#line 780
{
#line 780
	off_t offset = NC_varoffset(ncp, varp, start);
#line 780
	size_t remaining = varp->xsz * nelems;
#line 780
	int status = NC_NOERR;
#line 780
	void *xp;
#line 780
        void *fillp=NULL;
#line 780

#line 780
	if(nelems == 0)
#line 780
		return NC_NOERR;
#line 780

#line 780
	assert(value != NULL);
#line 780

#line 780
#ifdef ERANGE_FILL
#line 780
        fillp = malloc(varp->xsz);
#line 780
        status = NC3_inq_var_fill(varp, fillp);
#line 780
#endif
#line 780

#line 780
	for(;;)
#line 780
	{
#line 780
		size_t extent = MIN(remaining, ncp->chunk);
#line 780
		size_t nput = ncx_howmany(varp->type, extent);
#line 780

#line 780
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 780
				 RGN_WRITE, &xp);
#line 780
		if(lstatus != NC_NOERR)
#line 780
			return lstatus;
#line 780

#line 780
		lstatus = ncx_putn_int_short(&xp, nput, value ,fillp);
#line 780
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 780
		{
#line 780
			/* not fatal to the loop */
#line 780
			status = lstatus;
#line 780
		}
#line 780

#line 780
		(void) ncio_rel(ncp->nciop, offset,
#line 780
				 RGN_MODIFIED);
#line 780

#line 780
		remaining -= extent;
#line 780
		if(remaining == 0)
#line 780
			break; /* normal loop exit */
#line 780
		offset += (off_t)extent;
#line 780
		value += nput;
#line 780

#line 780
	}
#line 780
#ifdef ERANGE_FILL
#line 780
        free(fillp);
#line 780
#endif
#line 780

#line 780
	return status;
#line 780
}
#line 780

static int
#line 781
putNCvx_int_int(NC3_INFO* ncp, const NC_var *varp,
#line 781
		 const size_t *start, size_t nelems, const int *value)
#line 781
{
#line 781
	off_t offset = NC_varoffset(ncp, varp, start);
#line 781
	size_t remaining = varp->xsz * nelems;
#line 781
	int status = NC_NOERR;
#line 781
	void *xp;
#line 781
        void *fillp=NULL;
#line 781

#line 781
	if(nelems == 0)
#line 781
		return NC_NOERR;
#line 781

#line 781
	assert(value != NULL);
#line 781

#line 781
#ifdef ERANGE_FILL
#line 781
        fillp = malloc(varp->xsz);
#line 781
        status = NC3_inq_var_fill(varp, fillp);
#line 781
#endif
#line 781

#line 781
	for(;;)
#line 781
	{
#line 781
		size_t extent = MIN(remaining, ncp->chunk);
#line 781
		size_t nput = ncx_howmany(varp->type, extent);
#line 781

#line 781
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 781
				 RGN_WRITE, &xp);
#line 781
		if(lstatus != NC_NOERR)
#line 781
			return lstatus;
#line 781

#line 781
		lstatus = ncx_putn_int_int(&xp, nput, value ,fillp);
#line 781
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 781
		{
#line 781
			/* not fatal to the loop */
#line 781
			status = lstatus;
#line 781
		}
#line 781

#line 781
		(void) ncio_rel(ncp->nciop, offset,
#line 781
				 RGN_MODIFIED);
#line 781

#line 781
		remaining -= extent;
#line 781
		if(remaining == 0)
#line 781
			break; /* normal loop exit */
#line 781
		offset += (off_t)extent;
#line 781
		value += nput;
#line 781

#line 781
	}
#line 781
#ifdef ERANGE_FILL
#line 781
        free(fillp);
#line 781
#endif
#line 781

#line 781
	return status;
#line 781
}
#line 781

static int
#line 782
putNCvx_int_float(NC3_INFO* ncp, const NC_var *varp,
#line 782
		 const size_t *start, size_t nelems, const float *value)
#line 782
{
#line 782
	off_t offset = NC_varoffset(ncp, varp, start);
#line 782
	size_t remaining = varp->xsz * nelems;
#line 782
	int status = NC_NOERR;
#line 782
	void *xp;
#line 782
        void *fillp=NULL;
#line 782

#line 782
	if(nelems == 0)
#line 782
		return NC_NOERR;
#line 782

#line 782
	assert(value != NULL);
#line 782

#line 782
#ifdef ERANGE_FILL
#line 782
        fillp = malloc(varp->xsz);
#line 782
        status = NC3_inq_var_fill(varp, fillp);
#line 782
#endif
#line 782

#line 782
	for(;;)
#line 782
	{
#line 782
		size_t extent = MIN(remaining, ncp->chunk);
#line 782
		size_t nput = ncx_howmany(varp->type, extent);
#line 782

#line 782
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 782
				 RGN_WRITE, &xp);
#line 782
		if(lstatus != NC_NOERR)
#line 782
			return lstatus;
#line 782

#line 782
		lstatus = ncx_putn_int_float(&xp, nput, value ,fillp);
#line 782
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 782
		{
#line 782
			/* not fatal to the loop */
#line 782
			status = lstatus;
#line 782
		}
#line 782

#line 782
		(void) ncio_rel(ncp->nciop, offset,
#line 782
				 RGN_MODIFIED);
#line 782

#line 782
		remaining -= extent;
#line 782
		if(remaining == 0)
#line 782
			break; /* normal loop exit */
#line 782
		offset += (off_t)extent;
#line 782
		value += nput;
#line 782

#line 782
	}
#line 782
#ifdef ERANGE_FILL
#line 782
        free(fillp);
#line 782
#endif
#line 782

#line 782
	return status;
#line 782
}
#line 782

static int
#line 783
putNCvx_int_double(NC3_INFO* ncp, const NC_var *varp,
#line 783
		 const size_t *start, size_t nelems, const double *value)
#line 783
{
#line 783
	off_t offset = NC_varoffset(ncp, varp, start);
#line 783
	size_t remaining = varp->xsz * nelems;
#line 783
	int status = NC_NOERR;
#line 783
	void *xp;
#line 783
        void *fillp=NULL;
#line 783

#line 783
	if(nelems == 0)
#line 783
		return NC_NOERR;
#line 783

#line 783
	assert(value != NULL);
#line 783

#line 783
#ifdef ERANGE_FILL
#line 783
        fillp = malloc(varp->xsz);
#line 783
        status = NC3_inq_var_fill(varp, fillp);
#line 783
#endif
#line 783

#line 783
	for(;;)
#line 783
	{
#line 783
		size_t extent = MIN(remaining, ncp->chunk);
#line 783
		size_t nput = ncx_howmany(varp->type, extent);
#line 783

#line 783
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 783
				 RGN_WRITE, &xp);
#line 783
		if(lstatus != NC_NOERR)
#line 783
			return lstatus;
#line 783

#line 783
		lstatus = ncx_putn_int_double(&xp, nput, value ,fillp);
#line 783
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 783
		{
#line 783
			/* not fatal to the loop */
#line 783
			status = lstatus;
#line 783
		}
#line 783

#line 783
		(void) ncio_rel(ncp->nciop, offset,
#line 783
				 RGN_MODIFIED);
#line 783

#line 783
		remaining -= extent;
#line 783
		if(remaining == 0)
#line 783
			break; /* normal loop exit */
#line 783
		offset += (off_t)extent;
#line 783
		value += nput;
#line 783

#line 783
	}
#line 783
#ifdef ERANGE_FILL
#line 783
        free(fillp);
#line 783
#endif
#line 783

#line 783
	return status;
#line 783
}
#line 783

static int
#line 784
putNCvx_int_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 784
		 const size_t *start, size_t nelems, const longlong *value)
#line 784
{
#line 784
	off_t offset = NC_varoffset(ncp, varp, start);
#line 784
	size_t remaining = varp->xsz * nelems;
#line 784
	int status = NC_NOERR;
#line 784
	void *xp;
#line 784
        void *fillp=NULL;
#line 784

#line 784
	if(nelems == 0)
#line 784
		return NC_NOERR;
#line 784

#line 784
	assert(value != NULL);
#line 784

#line 784
#ifdef ERANGE_FILL
#line 784
        fillp = malloc(varp->xsz);
#line 784
        status = NC3_inq_var_fill(varp, fillp);
#line 784
#endif
#line 784

#line 784
	for(;;)
#line 784
	{
#line 784
		size_t extent = MIN(remaining, ncp->chunk);
#line 784
		size_t nput = ncx_howmany(varp->type, extent);
#line 784

#line 784
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 784
				 RGN_WRITE, &xp);
#line 784
		if(lstatus != NC_NOERR)
#line 784
			return lstatus;
#line 784

#line 784
		lstatus = ncx_putn_int_longlong(&xp, nput, value ,fillp);
#line 784
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 784
		{
#line 784
			/* not fatal to the loop */
#line 784
			status = lstatus;
#line 784
		}
#line 784

#line 784
		(void) ncio_rel(ncp->nciop, offset,
#line 784
				 RGN_MODIFIED);
#line 784

#line 784
		remaining -= extent;
#line 784
		if(remaining == 0)
#line 784
			break; /* normal loop exit */
#line 784
		offset += (off_t)extent;
#line 784
		value += nput;
#line 784

#line 784
	}
#line 784
#ifdef ERANGE_FILL
#line 784
        free(fillp);
#line 784
#endif
#line 784

#line 784
	return status;
#line 784
}
#line 784

static int
#line 785
putNCvx_int_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 785
		 const size_t *start, size_t nelems, const ushort *value)
#line 785
{
#line 785
	off_t offset = NC_varoffset(ncp, varp, start);
#line 785
	size_t remaining = varp->xsz * nelems;
#line 785
	int status = NC_NOERR;
#line 785
	void *xp;
#line 785
        void *fillp=NULL;
#line 785

#line 785
	if(nelems == 0)
#line 785
		return NC_NOERR;
#line 785

#line 785
	assert(value != NULL);
#line 785

#line 785
#ifdef ERANGE_FILL
#line 785
        fillp = malloc(varp->xsz);
#line 785
        status = NC3_inq_var_fill(varp, fillp);
#line 785
#endif
#line 785

#line 785
	for(;;)
#line 785
	{
#line 785
		size_t extent = MIN(remaining, ncp->chunk);
#line 785
		size_t nput = ncx_howmany(varp->type, extent);
#line 785

#line 785
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 785
				 RGN_WRITE, &xp);
#line 785
		if(lstatus != NC_NOERR)
#line 785
			return lstatus;
#line 785

#line 785
		lstatus = ncx_putn_int_ushort(&xp, nput, value ,fillp);
#line 785
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 785
		{
#line 785
			/* not fatal to the loop */
#line 785
			status = lstatus;
#line 785
		}
#line 785

#line 785
		(void) ncio_rel(ncp->nciop, offset,
#line 785
				 RGN_MODIFIED);
#line 785

#line 785
		remaining -= extent;
#line 785
		if(remaining == 0)
#line 785
			break; /* normal loop exit */
#line 785
		offset += (off_t)extent;
#line 785
		value += nput;
#line 785

#line 785
	}
#line 785
#ifdef ERANGE_FILL
#line 785
        free(fillp);
#line 785
#endif
#line 785

#line 785
	return status;
#line 785
}
#line 785

static int
#line 786
putNCvx_int_uint(NC3_INFO* ncp, const NC_var *varp,
#line 786
		 const size_t *start, size_t nelems, const uint *value)
#line 786
{
#line 786
	off_t offset = NC_varoffset(ncp, varp, start);
#line 786
	size_t remaining = varp->xsz * nelems;
#line 786
	int status = NC_NOERR;
#line 786
	void *xp;
#line 786
        void *fillp=NULL;
#line 786

#line 786
	if(nelems == 0)
#line 786
		return NC_NOERR;
#line 786

#line 786
	assert(value != NULL);
#line 786

#line 786
#ifdef ERANGE_FILL
#line 786
        fillp = malloc(varp->xsz);
#line 786
        status = NC3_inq_var_fill(varp, fillp);
#line 786
#endif
#line 786

#line 786
	for(;;)
#line 786
	{
#line 786
		size_t extent = MIN(remaining, ncp->chunk);
#line 786
		size_t nput = ncx_howmany(varp->type, extent);
#line 786

#line 786
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 786
				 RGN_WRITE, &xp);
#line 786
		if(lstatus != NC_NOERR)
#line 786
			return lstatus;
#line 786

#line 786
		lstatus = ncx_putn_int_uint(&xp, nput, value ,fillp);
#line 786
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 786
		{
#line 786
			/* not fatal to the loop */
#line 786
			status = lstatus;
#line 786
		}
#line 786

#line 786
		(void) ncio_rel(ncp->nciop, offset,
#line 786
				 RGN_MODIFIED);
#line 786

#line 786
		remaining -= extent;
#line 786
		if(remaining == 0)
#line 786
			break; /* normal loop exit */
#line 786
		offset += (off_t)extent;
#line 786
		value += nput;
#line 786

#line 786
	}
#line 786
#ifdef ERANGE_FILL
#line 786
        free(fillp);
#line 786
#endif
#line 786

#line 786
	return status;
#line 786
}
#line 786

static int
#line 787
putNCvx_int_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 787
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 787
{
#line 787
	off_t offset = NC_varoffset(ncp, varp, start);
#line 787
	size_t remaining = varp->xsz * nelems;
#line 787
	int status = NC_NOERR;
#line 787
	void *xp;
#line 787
        void *fillp=NULL;
#line 787

#line 787
	if(nelems == 0)
#line 787
		return NC_NOERR;
#line 787

#line 787
	assert(value != NULL);
#line 787

#line 787
#ifdef ERANGE_FILL
#line 787
        fillp = malloc(varp->xsz);
#line 787
        status = NC3_inq_var_fill(varp, fillp);
#line 787
#endif
#line 787

#line 787
	for(;;)
#line 787
	{
#line 787
		size_t extent = MIN(remaining, ncp->chunk);
#line 787
		size_t nput = ncx_howmany(varp->type, extent);
#line 787

#line 787
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 787
				 RGN_WRITE, &xp);
#line 787
		if(lstatus != NC_NOERR)
#line 787
			return lstatus;
#line 787

#line 787
		lstatus = ncx_putn_int_ulonglong(&xp, nput, value ,fillp);
#line 787
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 787
		{
#line 787
			/* not fatal to the loop */
#line 787
			status = lstatus;
#line 787
		}
#line 787

#line 787
		(void) ncio_rel(ncp->nciop, offset,
#line 787
				 RGN_MODIFIED);
#line 787

#line 787
		remaining -= extent;
#line 787
		if(remaining == 0)
#line 787
			break; /* normal loop exit */
#line 787
		offset += (off_t)extent;
#line 787
		value += nput;
#line 787

#line 787
	}
#line 787
#ifdef ERANGE_FILL
#line 787
        free(fillp);
#line 787
#endif
#line 787

#line 787
	return status;
#line 787
}
#line 787


static int
#line 789
putNCvx_float_schar(NC3_INFO* ncp, const NC_var *varp,
#line 789
		 const size_t *start, size_t nelems, const schar *value)
#line 789
{
#line 789
	off_t offset = NC_varoffset(ncp, varp, start);
#line 789
	size_t remaining = varp->xsz * nelems;
#line 789
	int status = NC_NOERR;
#line 789
	void *xp;
#line 789
        void *fillp=NULL;
#line 789

#line 789
	if(nelems == 0)
#line 789
		return NC_NOERR;
#line 789

#line 789
	assert(value != NULL);
#line 789

#line 789
#ifdef ERANGE_FILL
#line 789
        fillp = malloc(varp->xsz);
#line 789
        status = NC3_inq_var_fill(varp, fillp);
#line 789
#endif
#line 789

#line 789
	for(;;)
#line 789
	{
#line 789
		size_t extent = MIN(remaining, ncp->chunk);
#line 789
		size_t nput = ncx_howmany(varp->type, extent);
#line 789

#line 789
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 789
				 RGN_WRITE, &xp);
#line 789
		if(lstatus != NC_NOERR)
#line 789
			return lstatus;
#line 789

#line 789
		lstatus = ncx_putn_float_schar(&xp, nput, value ,fillp);
#line 789
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 789
		{
#line 789
			/* not fatal to the loop */
#line 789
			status = lstatus;
#line 789
		}
#line 789

#line 789
		(void) ncio_rel(ncp->nciop, offset,
#line 789
				 RGN_MODIFIED);
#line 789

#line 789
		remaining -= extent;
#line 789
		if(remaining == 0)
#line 789
			break; /* normal loop exit */
#line 789
		offset += (off_t)extent;
#line 789
		value += nput;
#line 789

#line 789
	}
#line 789
#ifdef ERANGE_FILL
#line 789
        free(fillp);
#line 789
#endif
#line 789

#line 789
	return status;
#line 789
}
#line 789

static int
#line 790
putNCvx_float_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 790
		 const size_t *start, size_t nelems, const uchar *value)
#line 790
{
#line 790
	off_t offset = NC_varoffset(ncp, varp, start);
#line 790
	size_t remaining = varp->xsz * nelems;
#line 790
	int status = NC_NOERR;
#line 790
	void *xp;
#line 790
        void *fillp=NULL;
#line 790

#line 790
	if(nelems == 0)
#line 790
		return NC_NOERR;
#line 790

#line 790
	assert(value != NULL);
#line 790

#line 790
#ifdef ERANGE_FILL
#line 790
        fillp = malloc(varp->xsz);
#line 790
        status = NC3_inq_var_fill(varp, fillp);
#line 790
#endif
#line 790

#line 790
	for(;;)
#line 790
	{
#line 790
		size_t extent = MIN(remaining, ncp->chunk);
#line 790
		size_t nput = ncx_howmany(varp->type, extent);
#line 790

#line 790
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 790
				 RGN_WRITE, &xp);
#line 790
		if(lstatus != NC_NOERR)
#line 790
			return lstatus;
#line 790

#line 790
		lstatus = ncx_putn_float_uchar(&xp, nput, value ,fillp);
#line 790
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 790
		{
#line 790
			/* not fatal to the loop */
#line 790
			status = lstatus;
#line 790
		}
#line 790

#line 790
		(void) ncio_rel(ncp->nciop, offset,
#line 790
				 RGN_MODIFIED);
#line 790

#line 790
		remaining -= extent;
#line 790
		if(remaining == 0)
#line 790
			break; /* normal loop exit */
#line 790
		offset += (off_t)extent;
#line 790
		value += nput;
#line 790

#line 790
	}
#line 790
#ifdef ERANGE_FILL
#line 790
        free(fillp);
#line 790
#endif
#line 790

#line 790
	return status;
#line 790
}
#line 790

static int
#line 791
putNCvx_float_short(NC3_INFO* ncp, const NC_var *varp,
#line 791
		 const size_t *start, size_t nelems, const short *value)
#line 791
{
#line 791
	off_t offset = NC_varoffset(ncp, varp, start);
#line 791
	size_t remaining = varp->xsz * nelems;
#line 791
	int status = NC_NOERR;
#line 791
	void *xp;
#line 791
        void *fillp=NULL;
#line 791

#line 791
	if(nelems == 0)
#line 791
		return NC_NOERR;
#line 791

#line 791
	assert(value != NULL);
#line 791

#line 791
#ifdef ERANGE_FILL
#line 791
        fillp = malloc(varp->xsz);
#line 791
        status = NC3_inq_var_fill(varp, fillp);
#line 791
#endif
#line 791

#line 791
	for(;;)
#line 791
	{
#line 791
		size_t extent = MIN(remaining, ncp->chunk);
#line 791
		size_t nput = ncx_howmany(varp->type, extent);
#line 791

#line 791
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 791
				 RGN_WRITE, &xp);
#line 791
		if(lstatus != NC_NOERR)
#line 791
			return lstatus;
#line 791

#line 791
		lstatus = ncx_putn_float_short(&xp, nput, value ,fillp);
#line 791
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 791
		{
#line 791
			/* not fatal to the loop */
#line 791
			status = lstatus;
#line 791
		}
#line 791

#line 791
		(void) ncio_rel(ncp->nciop, offset,
#line 791
				 RGN_MODIFIED);
#line 791

#line 791
		remaining -= extent;
#line 791
		if(remaining == 0)
#line 791
			break; /* normal loop exit */
#line 791
		offset += (off_t)extent;
#line 791
		value += nput;
#line 791

#line 791
	}
#line 791
#ifdef ERANGE_FILL
#line 791
        free(fillp);
#line 791
#endif
#line 791

#line 791
	return status;
#line 791
}
#line 791

static int
#line 792
putNCvx_float_int(NC3_INFO* ncp, const NC_var *varp,
#line 792
		 const size_t *start, size_t nelems, const int *value)
#line 792
{
#line 792
	off_t offset = NC_varoffset(ncp, varp, start);
#line 792
	size_t remaining = varp->xsz * nelems;
#line 792
	int status = NC_NOERR;
#line 792
	void *xp;
#line 792
        void *fillp=NULL;
#line 792

#line 792
	if(nelems == 0)
#line 792
		return NC_NOERR;
#line 792

#line 792
	assert(value != NULL);
#line 792

#line 792
#ifdef ERANGE_FILL
#line 792
        fillp = malloc(varp->xsz);
#line 792
        status = NC3_inq_var_fill(varp, fillp);
#line 792
#endif
#line 792

#line 792
	for(;;)
#line 792
	{
#line 792
		size_t extent = MIN(remaining, ncp->chunk);
#line 792
		size_t nput = ncx_howmany(varp->type, extent);
#line 792

#line 792
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 792
				 RGN_WRITE, &xp);
#line 792
		if(lstatus != NC_NOERR)
#line 792
			return lstatus;
#line 792

#line 792
		lstatus = ncx_putn_float_int(&xp, nput, value ,fillp);
#line 792
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 792
		{
#line 792
			/* not fatal to the loop */
#line 792
			status = lstatus;
#line 792
		}
#line 792

#line 792
		(void) ncio_rel(ncp->nciop, offset,
#line 792
				 RGN_MODIFIED);
#line 792

#line 792
		remaining -= extent;
#line 792
		if(remaining == 0)
#line 792
			break; /* normal loop exit */
#line 792
		offset += (off_t)extent;
#line 792
		value += nput;
#line 792

#line 792
	}
#line 792
#ifdef ERANGE_FILL
#line 792
        free(fillp);
#line 792
#endif
#line 792

#line 792
	return status;
#line 792
}
#line 792

static int
#line 793
putNCvx_float_float(NC3_INFO* ncp, const NC_var *varp,
#line 793
		 const size_t *start, size_t nelems, const float *value)
#line 793
{
#line 793
	off_t offset = NC_varoffset(ncp, varp, start);
#line 793
	size_t remaining = varp->xsz * nelems;
#line 793
	int status = NC_NOERR;
#line 793
	void *xp;
#line 793
        void *fillp=NULL;
#line 793

#line 793
	if(nelems == 0)
#line 793
		return NC_NOERR;
#line 793

#line 793
	assert(value != NULL);
#line 793

#line 793
#ifdef ERANGE_FILL
#line 793
        fillp = malloc(varp->xsz);
#line 793
        status = NC3_inq_var_fill(varp, fillp);
#line 793
#endif
#line 793

#line 793
	for(;;)
#line 793
	{
#line 793
		size_t extent = MIN(remaining, ncp->chunk);
#line 793
		size_t nput = ncx_howmany(varp->type, extent);
#line 793

#line 793
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 793
				 RGN_WRITE, &xp);
#line 793
		if(lstatus != NC_NOERR)
#line 793
			return lstatus;
#line 793

#line 793
		lstatus = ncx_putn_float_float(&xp, nput, value ,fillp);
#line 793
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 793
		{
#line 793
			/* not fatal to the loop */
#line 793
			status = lstatus;
#line 793
		}
#line 793

#line 793
		(void) ncio_rel(ncp->nciop, offset,
#line 793
				 RGN_MODIFIED);
#line 793

#line 793
		remaining -= extent;
#line 793
		if(remaining == 0)
#line 793
			break; /* normal loop exit */
#line 793
		offset += (off_t)extent;
#line 793
		value += nput;
#line 793

#line 793
	}
#line 793
#ifdef ERANGE_FILL
#line 793
        free(fillp);
#line 793
#endif
#line 793

#line 793
	return status;
#line 793
}
#line 793

static int
#line 794
putNCvx_float_double(NC3_INFO* ncp, const NC_var *varp,
#line 794
		 const size_t *start, size_t nelems, const double *value)
#line 794
{
#line 794
	off_t offset = NC_varoffset(ncp, varp, start);
#line 794
	size_t remaining = varp->xsz * nelems;
#line 794
	int status = NC_NOERR;
#line 794
	void *xp;
#line 794
        void *fillp=NULL;
#line 794

#line 794
	if(nelems == 0)
#line 794
		return NC_NOERR;
#line 794

#line 794
	assert(value != NULL);
#line 794

#line 794
#ifdef ERANGE_FILL
#line 794
        fillp = malloc(varp->xsz);
#line 794
        status = NC3_inq_var_fill(varp, fillp);
#line 794
#endif
#line 794

#line 794
	for(;;)
#line 794
	{
#line 794
		size_t extent = MIN(remaining, ncp->chunk);
#line 794
		size_t nput = ncx_howmany(varp->type, extent);
#line 794

#line 794
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 794
				 RGN_WRITE, &xp);
#line 794
		if(lstatus != NC_NOERR)
#line 794
			return lstatus;
#line 794

#line 794
		lstatus = ncx_putn_float_double(&xp, nput, value ,fillp);
#line 794
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 794
		{
#line 794
			/* not fatal to the loop */
#line 794
			status = lstatus;
#line 794
		}
#line 794

#line 794
		(void) ncio_rel(ncp->nciop, offset,
#line 794
				 RGN_MODIFIED);
#line 794

#line 794
		remaining -= extent;
#line 794
		if(remaining == 0)
#line 794
			break; /* normal loop exit */
#line 794
		offset += (off_t)extent;
#line 794
		value += nput;
#line 794

#line 794
	}
#line 794
#ifdef ERANGE_FILL
#line 794
        free(fillp);
#line 794
#endif
#line 794

#line 794
	return status;
#line 794
}
#line 794

static int
#line 795
putNCvx_float_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 795
		 const size_t *start, size_t nelems, const longlong *value)
#line 795
{
#line 795
	off_t offset = NC_varoffset(ncp, varp, start);
#line 795
	size_t remaining = varp->xsz * nelems;
#line 795
	int status = NC_NOERR;
#line 795
	void *xp;
#line 795
        void *fillp=NULL;
#line 795

#line 795
	if(nelems == 0)
#line 795
		return NC_NOERR;
#line 795

#line 795
	assert(value != NULL);
#line 795

#line 795
#ifdef ERANGE_FILL
#line 795
        fillp = malloc(varp->xsz);
#line 795
        status = NC3_inq_var_fill(varp, fillp);
#line 795
#endif
#line 795

#line 795
	for(;;)
#line 795
	{
#line 795
		size_t extent = MIN(remaining, ncp->chunk);
#line 795
		size_t nput = ncx_howmany(varp->type, extent);
#line 795

#line 795
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 795
				 RGN_WRITE, &xp);
#line 795
		if(lstatus != NC_NOERR)
#line 795
			return lstatus;
#line 795

#line 795
		lstatus = ncx_putn_float_longlong(&xp, nput, value ,fillp);
#line 795
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 795
		{
#line 795
			/* not fatal to the loop */
#line 795
			status = lstatus;
#line 795
		}
#line 795

#line 795
		(void) ncio_rel(ncp->nciop, offset,
#line 795
				 RGN_MODIFIED);
#line 795

#line 795
		remaining -= extent;
#line 795
		if(remaining == 0)
#line 795
			break; /* normal loop exit */
#line 795
		offset += (off_t)extent;
#line 795
		value += nput;
#line 795

#line 795
	}
#line 795
#ifdef ERANGE_FILL
#line 795
        free(fillp);
#line 795
#endif
#line 795

#line 795
	return status;
#line 795
}
#line 795

static int
#line 796
putNCvx_float_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 796
		 const size_t *start, size_t nelems, const ushort *value)
#line 796
{
#line 796
	off_t offset = NC_varoffset(ncp, varp, start);
#line 796
	size_t remaining = varp->xsz * nelems;
#line 796
	int status = NC_NOERR;
#line 796
	void *xp;
#line 796
        void *fillp=NULL;
#line 796

#line 796
	if(nelems == 0)
#line 796
		return NC_NOERR;
#line 796

#line 796
	assert(value != NULL);
#line 796

#line 796
#ifdef ERANGE_FILL
#line 796
        fillp = malloc(varp->xsz);
#line 796
        status = NC3_inq_var_fill(varp, fillp);
#line 796
#endif
#line 796

#line 796
	for(;;)
#line 796
	{
#line 796
		size_t extent = MIN(remaining, ncp->chunk);
#line 796
		size_t nput = ncx_howmany(varp->type, extent);
#line 796

#line 796
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 796
				 RGN_WRITE, &xp);
#line 796
		if(lstatus != NC_NOERR)
#line 796
			return lstatus;
#line 796

#line 796
		lstatus = ncx_putn_float_ushort(&xp, nput, value ,fillp);
#line 796
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 796
		{
#line 796
			/* not fatal to the loop */
#line 796
			status = lstatus;
#line 796
		}
#line 796

#line 796
		(void) ncio_rel(ncp->nciop, offset,
#line 796
				 RGN_MODIFIED);
#line 796

#line 796
		remaining -= extent;
#line 796
		if(remaining == 0)
#line 796
			break; /* normal loop exit */
#line 796
		offset += (off_t)extent;
#line 796
		value += nput;
#line 796

#line 796
	}
#line 796
#ifdef ERANGE_FILL
#line 796
        free(fillp);
#line 796
#endif
#line 796

#line 796
	return status;
#line 796
}
#line 796

static int
#line 797
putNCvx_float_uint(NC3_INFO* ncp, const NC_var *varp,
#line 797
		 const size_t *start, size_t nelems, const uint *value)
#line 797
{
#line 797
	off_t offset = NC_varoffset(ncp, varp, start);
#line 797
	size_t remaining = varp->xsz * nelems;
#line 797
	int status = NC_NOERR;
#line 797
	void *xp;
#line 797
        void *fillp=NULL;
#line 797

#line 797
	if(nelems == 0)
#line 797
		return NC_NOERR;
#line 797

#line 797
	assert(value != NULL);
#line 797

#line 797
#ifdef ERANGE_FILL
#line 797
        fillp = malloc(varp->xsz);
#line 797
        status = NC3_inq_var_fill(varp, fillp);
#line 797
#endif
#line 797

#line 797
	for(;;)
#line 797
	{
#line 797
		size_t extent = MIN(remaining, ncp->chunk);
#line 797
		size_t nput = ncx_howmany(varp->type, extent);
#line 797

#line 797
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 797
				 RGN_WRITE, &xp);
#line 797
		if(lstatus != NC_NOERR)
#line 797
			return lstatus;
#line 797

#line 797
		lstatus = ncx_putn_float_uint(&xp, nput, value ,fillp);
#line 797
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 797
		{
#line 797
			/* not fatal to the loop */
#line 797
			status = lstatus;
#line 797
		}
#line 797

#line 797
		(void) ncio_rel(ncp->nciop, offset,
#line 797
				 RGN_MODIFIED);
#line 797

#line 797
		remaining -= extent;
#line 797
		if(remaining == 0)
#line 797
			break; /* normal loop exit */
#line 797
		offset += (off_t)extent;
#line 797
		value += nput;
#line 797

#line 797
	}
#line 797
#ifdef ERANGE_FILL
#line 797
        free(fillp);
#line 797
#endif
#line 797

#line 797
	return status;
#line 797
}
#line 797

static int
#line 798
putNCvx_float_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 798
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 798
{
#line 798
	off_t offset = NC_varoffset(ncp, varp, start);
#line 798
	size_t remaining = varp->xsz * nelems;
#line 798
	int status = NC_NOERR;
#line 798
	void *xp;
#line 798
        void *fillp=NULL;
#line 798

#line 798
	if(nelems == 0)
#line 798
		return NC_NOERR;
#line 798

#line 798
	assert(value != NULL);
#line 798

#line 798
#ifdef ERANGE_FILL
#line 798
        fillp = malloc(varp->xsz);
#line 798
        status = NC3_inq_var_fill(varp, fillp);
#line 798
#endif
#line 798

#line 798
	for(;;)
#line 798
	{
#line 798
		size_t extent = MIN(remaining, ncp->chunk);
#line 798
		size_t nput = ncx_howmany(varp->type, extent);
#line 798

#line 798
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 798
				 RGN_WRITE, &xp);
#line 798
		if(lstatus != NC_NOERR)
#line 798
			return lstatus;
#line 798

#line 798
		lstatus = ncx_putn_float_ulonglong(&xp, nput, value ,fillp);
#line 798
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 798
		{
#line 798
			/* not fatal to the loop */
#line 798
			status = lstatus;
#line 798
		}
#line 798

#line 798
		(void) ncio_rel(ncp->nciop, offset,
#line 798
				 RGN_MODIFIED);
#line 798

#line 798
		remaining -= extent;
#line 798
		if(remaining == 0)
#line 798
			break; /* normal loop exit */
#line 798
		offset += (off_t)extent;
#line 798
		value += nput;
#line 798

#line 798
	}
#line 798
#ifdef ERANGE_FILL
#line 798
        free(fillp);
#line 798
#endif
#line 798

#line 798
	return status;
#line 798
}
#line 798


static int
#line 800
putNCvx_double_schar(NC3_INFO* ncp, const NC_var *varp,
#line 800
		 const size_t *start, size_t nelems, const schar *value)
#line 800
{
#line 800
	off_t offset = NC_varoffset(ncp, varp, start);
#line 800
	size_t remaining = varp->xsz * nelems;
#line 800
	int status = NC_NOERR;
#line 800
	void *xp;
#line 800
        void *fillp=NULL;
#line 800

#line 800
	if(nelems == 0)
#line 800
		return NC_NOERR;
#line 800

#line 800
	assert(value != NULL);
#line 800

#line 800
#ifdef ERANGE_FILL
#line 800
        fillp = malloc(varp->xsz);
#line 800
        status = NC3_inq_var_fill(varp, fillp);
#line 800
#endif
#line 800

#line 800
	for(;;)
#line 800
	{
#line 800
		size_t extent = MIN(remaining, ncp->chunk);
#line 800
		size_t nput = ncx_howmany(varp->type, extent);
#line 800

#line 800
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 800
				 RGN_WRITE, &xp);
#line 800
		if(lstatus != NC_NOERR)
#line 800
			return lstatus;
#line 800

#line 800
		lstatus = ncx_putn_double_schar(&xp, nput, value ,fillp);
#line 800
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 800
		{
#line 800
			/* not fatal to the loop */
#line 800
			status = lstatus;
#line 800
		}
#line 800

#line 800
		(void) ncio_rel(ncp->nciop, offset,
#line 800
				 RGN_MODIFIED);
#line 800

#line 800
		remaining -= extent;
#line 800
		if(remaining == 0)
#line 800
			break; /* normal loop exit */
#line 800
		offset += (off_t)extent;
#line 800
		value += nput;
#line 800

#line 800
	}
#line 800
#ifdef ERANGE_FILL
#line 800
        free(fillp);
#line 800
#endif
#line 800

#line 800
	return status;
#line 800
}
#line 800

static int
#line 801
putNCvx_double_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 801
		 const size_t *start, size_t nelems, const uchar *value)
#line 801
{
#line 801
	off_t offset = NC_varoffset(ncp, varp, start);
#line 801
	size_t remaining = varp->xsz * nelems;
#line 801
	int status = NC_NOERR;
#line 801
	void *xp;
#line 801
        void *fillp=NULL;
#line 801

#line 801
	if(nelems == 0)
#line 801
		return NC_NOERR;
#line 801

#line 801
	assert(value != NULL);
#line 801

#line 801
#ifdef ERANGE_FILL
#line 801
        fillp = malloc(varp->xsz);
#line 801
        status = NC3_inq_var_fill(varp, fillp);
#line 801
#endif
#line 801

#line 801
	for(;;)
#line 801
	{
#line 801
		size_t extent = MIN(remaining, ncp->chunk);
#line 801
		size_t nput = ncx_howmany(varp->type, extent);
#line 801

#line 801
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 801
				 RGN_WRITE, &xp);
#line 801
		if(lstatus != NC_NOERR)
#line 801
			return lstatus;
#line 801

#line 801
		lstatus = ncx_putn_double_uchar(&xp, nput, value ,fillp);
#line 801
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 801
		{
#line 801
			/* not fatal to the loop */
#line 801
			status = lstatus;
#line 801
		}
#line 801

#line 801
		(void) ncio_rel(ncp->nciop, offset,
#line 801
				 RGN_MODIFIED);
#line 801

#line 801
		remaining -= extent;
#line 801
		if(remaining == 0)
#line 801
			break; /* normal loop exit */
#line 801
		offset += (off_t)extent;
#line 801
		value += nput;
#line 801

#line 801
	}
#line 801
#ifdef ERANGE_FILL
#line 801
        free(fillp);
#line 801
#endif
#line 801

#line 801
	return status;
#line 801
}
#line 801

static int
#line 802
putNCvx_double_short(NC3_INFO* ncp, const NC_var *varp,
#line 802
		 const size_t *start, size_t nelems, const short *value)
#line 802
{
#line 802
	off_t offset = NC_varoffset(ncp, varp, start);
#line 802
	size_t remaining = varp->xsz * nelems;
#line 802
	int status = NC_NOERR;
#line 802
	void *xp;
#line 802
        void *fillp=NULL;
#line 802

#line 802
	if(nelems == 0)
#line 802
		return NC_NOERR;
#line 802

#line 802
	assert(value != NULL);
#line 802

#line 802
#ifdef ERANGE_FILL
#line 802
        fillp = malloc(varp->xsz);
#line 802
        status = NC3_inq_var_fill(varp, fillp);
#line 802
#endif
#line 802

#line 802
	for(;;)
#line 802
	{
#line 802
		size_t extent = MIN(remaining, ncp->chunk);
#line 802
		size_t nput = ncx_howmany(varp->type, extent);
#line 802

#line 802
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 802
				 RGN_WRITE, &xp);
#line 802
		if(lstatus != NC_NOERR)
#line 802
			return lstatus;
#line 802

#line 802
		lstatus = ncx_putn_double_short(&xp, nput, value ,fillp);
#line 802
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 802
		{
#line 802
			/* not fatal to the loop */
#line 802
			status = lstatus;
#line 802
		}
#line 802

#line 802
		(void) ncio_rel(ncp->nciop, offset,
#line 802
				 RGN_MODIFIED);
#line 802

#line 802
		remaining -= extent;
#line 802
		if(remaining == 0)
#line 802
			break; /* normal loop exit */
#line 802
		offset += (off_t)extent;
#line 802
		value += nput;
#line 802

#line 802
	}
#line 802
#ifdef ERANGE_FILL
#line 802
        free(fillp);
#line 802
#endif
#line 802

#line 802
	return status;
#line 802
}
#line 802

static int
#line 803
putNCvx_double_int(NC3_INFO* ncp, const NC_var *varp,
#line 803
		 const size_t *start, size_t nelems, const int *value)
#line 803
{
#line 803
	off_t offset = NC_varoffset(ncp, varp, start);
#line 803
	size_t remaining = varp->xsz * nelems;
#line 803
	int status = NC_NOERR;
#line 803
	void *xp;
#line 803
        void *fillp=NULL;
#line 803

#line 803
	if(nelems == 0)
#line 803
		return NC_NOERR;
#line 803

#line 803
	assert(value != NULL);
#line 803

#line 803
#ifdef ERANGE_FILL
#line 803
        fillp = malloc(varp->xsz);
#line 803
        status = NC3_inq_var_fill(varp, fillp);
#line 803
#endif
#line 803

#line 803
	for(;;)
#line 803
	{
#line 803
		size_t extent = MIN(remaining, ncp->chunk);
#line 803
		size_t nput = ncx_howmany(varp->type, extent);
#line 803

#line 803
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 803
				 RGN_WRITE, &xp);
#line 803
		if(lstatus != NC_NOERR)
#line 803
			return lstatus;
#line 803

#line 803
		lstatus = ncx_putn_double_int(&xp, nput, value ,fillp);
#line 803
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 803
		{
#line 803
			/* not fatal to the loop */
#line 803
			status = lstatus;
#line 803
		}
#line 803

#line 803
		(void) ncio_rel(ncp->nciop, offset,
#line 803
				 RGN_MODIFIED);
#line 803

#line 803
		remaining -= extent;
#line 803
		if(remaining == 0)
#line 803
			break; /* normal loop exit */
#line 803
		offset += (off_t)extent;
#line 803
		value += nput;
#line 803

#line 803
	}
#line 803
#ifdef ERANGE_FILL
#line 803
        free(fillp);
#line 803
#endif
#line 803

#line 803
	return status;
#line 803
}
#line 803

static int
#line 804
putNCvx_double_float(NC3_INFO* ncp, const NC_var *varp,
#line 804
		 const size_t *start, size_t nelems, const float *value)
#line 804
{
#line 804
	off_t offset = NC_varoffset(ncp, varp, start);
#line 804
	size_t remaining = varp->xsz * nelems;
#line 804
	int status = NC_NOERR;
#line 804
	void *xp;
#line 804
        void *fillp=NULL;
#line 804

#line 804
	if(nelems == 0)
#line 804
		return NC_NOERR;
#line 804

#line 804
	assert(value != NULL);
#line 804

#line 804
#ifdef ERANGE_FILL
#line 804
        fillp = malloc(varp->xsz);
#line 804
        status = NC3_inq_var_fill(varp, fillp);
#line 804
#endif
#line 804

#line 804
	for(;;)
#line 804
	{
#line 804
		size_t extent = MIN(remaining, ncp->chunk);
#line 804
		size_t nput = ncx_howmany(varp->type, extent);
#line 804

#line 804
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 804
				 RGN_WRITE, &xp);
#line 804
		if(lstatus != NC_NOERR)
#line 804
			return lstatus;
#line 804

#line 804
		lstatus = ncx_putn_double_float(&xp, nput, value ,fillp);
#line 804
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 804
		{
#line 804
			/* not fatal to the loop */
#line 804
			status = lstatus;
#line 804
		}
#line 804

#line 804
		(void) ncio_rel(ncp->nciop, offset,
#line 804
				 RGN_MODIFIED);
#line 804

#line 804
		remaining -= extent;
#line 804
		if(remaining == 0)
#line 804
			break; /* normal loop exit */
#line 804
		offset += (off_t)extent;
#line 804
		value += nput;
#line 804

#line 804
	}
#line 804
#ifdef ERANGE_FILL
#line 804
        free(fillp);
#line 804
#endif
#line 804

#line 804
	return status;
#line 804
}
#line 804

static int
#line 805
putNCvx_double_double(NC3_INFO* ncp, const NC_var *varp,
#line 805
		 const size_t *start, size_t nelems, const double *value)
#line 805
{
#line 805
	off_t offset = NC_varoffset(ncp, varp, start);
#line 805
	size_t remaining = varp->xsz * nelems;
#line 805
	int status = NC_NOERR;
#line 805
	void *xp;
#line 805
        void *fillp=NULL;
#line 805

#line 805
	if(nelems == 0)
#line 805
		return NC_NOERR;
#line 805

#line 805
	assert(value != NULL);
#line 805

#line 805
#ifdef ERANGE_FILL
#line 805
        fillp = malloc(varp->xsz);
#line 805
        status = NC3_inq_var_fill(varp, fillp);
#line 805
#endif
#line 805

#line 805
	for(;;)
#line 805
	{
#line 805
		size_t extent = MIN(remaining, ncp->chunk);
#line 805
		size_t nput = ncx_howmany(varp->type, extent);
#line 805

#line 805
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 805
				 RGN_WRITE, &xp);
#line 805
		if(lstatus != NC_NOERR)
#line 805
			return lstatus;
#line 805

#line 805
		lstatus = ncx_putn_double_double(&xp, nput, value ,fillp);
#line 805
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 805
		{
#line 805
			/* not fatal to the loop */
#line 805
			status = lstatus;
#line 805
		}
#line 805

#line 805
		(void) ncio_rel(ncp->nciop, offset,
#line 805
				 RGN_MODIFIED);
#line 805

#line 805
		remaining -= extent;
#line 805
		if(remaining == 0)
#line 805
			break; /* normal loop exit */
#line 805
		offset += (off_t)extent;
#line 805
		value += nput;
#line 805

#line 805
	}
#line 805
#ifdef ERANGE_FILL
#line 805
        free(fillp);
#line 805
#endif
#line 805

#line 805
	return status;
#line 805
}
#line 805

static int
#line 806
putNCvx_double_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 806
		 const size_t *start, size_t nelems, const longlong *value)
#line 806
{
#line 806
	off_t offset = NC_varoffset(ncp, varp, start);
#line 806
	size_t remaining = varp->xsz * nelems;
#line 806
	int status = NC_NOERR;
#line 806
	void *xp;
#line 806
        void *fillp=NULL;
#line 806

#line 806
	if(nelems == 0)
#line 806
		return NC_NOERR;
#line 806

#line 806
	assert(value != NULL);
#line 806

#line 806
#ifdef ERANGE_FILL
#line 806
        fillp = malloc(varp->xsz);
#line 806
        status = NC3_inq_var_fill(varp, fillp);
#line 806
#endif
#line 806

#line 806
	for(;;)
#line 806
	{
#line 806
		size_t extent = MIN(remaining, ncp->chunk);
#line 806
		size_t nput = ncx_howmany(varp->type, extent);
#line 806

#line 806
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 806
				 RGN_WRITE, &xp);
#line 806
		if(lstatus != NC_NOERR)
#line 806
			return lstatus;
#line 806

#line 806
		lstatus = ncx_putn_double_longlong(&xp, nput, value ,fillp);
#line 806
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 806
		{
#line 806
			/* not fatal to the loop */
#line 806
			status = lstatus;
#line 806
		}
#line 806

#line 806
		(void) ncio_rel(ncp->nciop, offset,
#line 806
				 RGN_MODIFIED);
#line 806

#line 806
		remaining -= extent;
#line 806
		if(remaining == 0)
#line 806
			break; /* normal loop exit */
#line 806
		offset += (off_t)extent;
#line 806
		value += nput;
#line 806

#line 806
	}
#line 806
#ifdef ERANGE_FILL
#line 806
        free(fillp);
#line 806
#endif
#line 806

#line 806
	return status;
#line 806
}
#line 806

static int
#line 807
putNCvx_double_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 807
		 const size_t *start, size_t nelems, const ushort *value)
#line 807
{
#line 807
	off_t offset = NC_varoffset(ncp, varp, start);
#line 807
	size_t remaining = varp->xsz * nelems;
#line 807
	int status = NC_NOERR;
#line 807
	void *xp;
#line 807
        void *fillp=NULL;
#line 807

#line 807
	if(nelems == 0)
#line 807
		return NC_NOERR;
#line 807

#line 807
	assert(value != NULL);
#line 807

#line 807
#ifdef ERANGE_FILL
#line 807
        fillp = malloc(varp->xsz);
#line 807
        status = NC3_inq_var_fill(varp, fillp);
#line 807
#endif
#line 807

#line 807
	for(;;)
#line 807
	{
#line 807
		size_t extent = MIN(remaining, ncp->chunk);
#line 807
		size_t nput = ncx_howmany(varp->type, extent);
#line 807

#line 807
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 807
				 RGN_WRITE, &xp);
#line 807
		if(lstatus != NC_NOERR)
#line 807
			return lstatus;
#line 807

#line 807
		lstatus = ncx_putn_double_ushort(&xp, nput, value ,fillp);
#line 807
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 807
		{
#line 807
			/* not fatal to the loop */
#line 807
			status = lstatus;
#line 807
		}
#line 807

#line 807
		(void) ncio_rel(ncp->nciop, offset,
#line 807
				 RGN_MODIFIED);
#line 807

#line 807
		remaining -= extent;
#line 807
		if(remaining == 0)
#line 807
			break; /* normal loop exit */
#line 807
		offset += (off_t)extent;
#line 807
		value += nput;
#line 807

#line 807
	}
#line 807
#ifdef ERANGE_FILL
#line 807
        free(fillp);
#line 807
#endif
#line 807

#line 807
	return status;
#line 807
}
#line 807

static int
#line 808
putNCvx_double_uint(NC3_INFO* ncp, const NC_var *varp,
#line 808
		 const size_t *start, size_t nelems, const uint *value)
#line 808
{
#line 808
	off_t offset = NC_varoffset(ncp, varp, start);
#line 808
	size_t remaining = varp->xsz * nelems;
#line 808
	int status = NC_NOERR;
#line 808
	void *xp;
#line 808
        void *fillp=NULL;
#line 808

#line 808
	if(nelems == 0)
#line 808
		return NC_NOERR;
#line 808

#line 808
	assert(value != NULL);
#line 808

#line 808
#ifdef ERANGE_FILL
#line 808
        fillp = malloc(varp->xsz);
#line 808
        status = NC3_inq_var_fill(varp, fillp);
#line 808
#endif
#line 808

#line 808
	for(;;)
#line 808
	{
#line 808
		size_t extent = MIN(remaining, ncp->chunk);
#line 808
		size_t nput = ncx_howmany(varp->type, extent);
#line 808

#line 808
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 808
				 RGN_WRITE, &xp);
#line 808
		if(lstatus != NC_NOERR)
#line 808
			return lstatus;
#line 808

#line 808
		lstatus = ncx_putn_double_uint(&xp, nput, value ,fillp);
#line 808
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 808
		{
#line 808
			/* not fatal to the loop */
#line 808
			status = lstatus;
#line 808
		}
#line 808

#line 808
		(void) ncio_rel(ncp->nciop, offset,
#line 808
				 RGN_MODIFIED);
#line 808

#line 808
		remaining -= extent;
#line 808
		if(remaining == 0)
#line 808
			break; /* normal loop exit */
#line 808
		offset += (off_t)extent;
#line 808
		value += nput;
#line 808

#line 808
	}
#line 808
#ifdef ERANGE_FILL
#line 808
        free(fillp);
#line 808
#endif
#line 808

#line 808
	return status;
#line 808
}
#line 808

static int
#line 809
putNCvx_double_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 809
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 809
{
#line 809
	off_t offset = NC_varoffset(ncp, varp, start);
#line 809
	size_t remaining = varp->xsz * nelems;
#line 809
	int status = NC_NOERR;
#line 809
	void *xp;
#line 809
        void *fillp=NULL;
#line 809

#line 809
	if(nelems == 0)
#line 809
		return NC_NOERR;
#line 809

#line 809
	assert(value != NULL);
#line 809

#line 809
#ifdef ERANGE_FILL
#line 809
        fillp = malloc(varp->xsz);
#line 809
        status = NC3_inq_var_fill(varp, fillp);
#line 809
#endif
#line 809

#line 809
	for(;;)
#line 809
	{
#line 809
		size_t extent = MIN(remaining, ncp->chunk);
#line 809
		size_t nput = ncx_howmany(varp->type, extent);
#line 809

#line 809
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 809
				 RGN_WRITE, &xp);
#line 809
		if(lstatus != NC_NOERR)
#line 809
			return lstatus;
#line 809

#line 809
		lstatus = ncx_putn_double_ulonglong(&xp, nput, value ,fillp);
#line 809
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 809
		{
#line 809
			/* not fatal to the loop */
#line 809
			status = lstatus;
#line 809
		}
#line 809

#line 809
		(void) ncio_rel(ncp->nciop, offset,
#line 809
				 RGN_MODIFIED);
#line 809

#line 809
		remaining -= extent;
#line 809
		if(remaining == 0)
#line 809
			break; /* normal loop exit */
#line 809
		offset += (off_t)extent;
#line 809
		value += nput;
#line 809

#line 809
	}
#line 809
#ifdef ERANGE_FILL
#line 809
        free(fillp);
#line 809
#endif
#line 809

#line 809
	return status;
#line 809
}
#line 809


static int
#line 811
putNCvx_uchar_schar(NC3_INFO* ncp, const NC_var *varp,
#line 811
		 const size_t *start, size_t nelems, const schar *value)
#line 811
{
#line 811
	off_t offset = NC_varoffset(ncp, varp, start);
#line 811
	size_t remaining = varp->xsz * nelems;
#line 811
	int status = NC_NOERR;
#line 811
	void *xp;
#line 811
        void *fillp=NULL;
#line 811

#line 811
	if(nelems == 0)
#line 811
		return NC_NOERR;
#line 811

#line 811
	assert(value != NULL);
#line 811

#line 811
#ifdef ERANGE_FILL
#line 811
        fillp = malloc(varp->xsz);
#line 811
        status = NC3_inq_var_fill(varp, fillp);
#line 811
#endif
#line 811

#line 811
	for(;;)
#line 811
	{
#line 811
		size_t extent = MIN(remaining, ncp->chunk);
#line 811
		size_t nput = ncx_howmany(varp->type, extent);
#line 811

#line 811
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 811
				 RGN_WRITE, &xp);
#line 811
		if(lstatus != NC_NOERR)
#line 811
			return lstatus;
#line 811

#line 811
		lstatus = ncx_putn_uchar_schar(&xp, nput, value ,fillp);
#line 811
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 811
		{
#line 811
			/* not fatal to the loop */
#line 811
			status = lstatus;
#line 811
		}
#line 811

#line 811
		(void) ncio_rel(ncp->nciop, offset,
#line 811
				 RGN_MODIFIED);
#line 811

#line 811
		remaining -= extent;
#line 811
		if(remaining == 0)
#line 811
			break; /* normal loop exit */
#line 811
		offset += (off_t)extent;
#line 811
		value += nput;
#line 811

#line 811
	}
#line 811
#ifdef ERANGE_FILL
#line 811
        free(fillp);
#line 811
#endif
#line 811

#line 811
	return status;
#line 811
}
#line 811

static int
#line 812
putNCvx_uchar_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 812
		 const size_t *start, size_t nelems, const uchar *value)
#line 812
{
#line 812
	off_t offset = NC_varoffset(ncp, varp, start);
#line 812
	size_t remaining = varp->xsz * nelems;
#line 812
	int status = NC_NOERR;
#line 812
	void *xp;
#line 812
        void *fillp=NULL;
#line 812

#line 812
	if(nelems == 0)
#line 812
		return NC_NOERR;
#line 812

#line 812
	assert(value != NULL);
#line 812

#line 812
#ifdef ERANGE_FILL
#line 812
        fillp = malloc(varp->xsz);
#line 812
        status = NC3_inq_var_fill(varp, fillp);
#line 812
#endif
#line 812

#line 812
	for(;;)
#line 812
	{
#line 812
		size_t extent = MIN(remaining, ncp->chunk);
#line 812
		size_t nput = ncx_howmany(varp->type, extent);
#line 812

#line 812
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 812
				 RGN_WRITE, &xp);
#line 812
		if(lstatus != NC_NOERR)
#line 812
			return lstatus;
#line 812

#line 812
		lstatus = ncx_putn_uchar_uchar(&xp, nput, value ,fillp);
#line 812
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 812
		{
#line 812
			/* not fatal to the loop */
#line 812
			status = lstatus;
#line 812
		}
#line 812

#line 812
		(void) ncio_rel(ncp->nciop, offset,
#line 812
				 RGN_MODIFIED);
#line 812

#line 812
		remaining -= extent;
#line 812
		if(remaining == 0)
#line 812
			break; /* normal loop exit */
#line 812
		offset += (off_t)extent;
#line 812
		value += nput;
#line 812

#line 812
	}
#line 812
#ifdef ERANGE_FILL
#line 812
        free(fillp);
#line 812
#endif
#line 812

#line 812
	return status;
#line 812
}
#line 812

static int
#line 813
putNCvx_uchar_short(NC3_INFO* ncp, const NC_var *varp,
#line 813
		 const size_t *start, size_t nelems, const short *value)
#line 813
{
#line 813
	off_t offset = NC_varoffset(ncp, varp, start);
#line 813
	size_t remaining = varp->xsz * nelems;
#line 813
	int status = NC_NOERR;
#line 813
	void *xp;
#line 813
        void *fillp=NULL;
#line 813

#line 813
	if(nelems == 0)
#line 813
		return NC_NOERR;
#line 813

#line 813
	assert(value != NULL);
#line 813

#line 813
#ifdef ERANGE_FILL
#line 813
        fillp = malloc(varp->xsz);
#line 813
        status = NC3_inq_var_fill(varp, fillp);
#line 813
#endif
#line 813

#line 813
	for(;;)
#line 813
	{
#line 813
		size_t extent = MIN(remaining, ncp->chunk);
#line 813
		size_t nput = ncx_howmany(varp->type, extent);
#line 813

#line 813
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 813
				 RGN_WRITE, &xp);
#line 813
		if(lstatus != NC_NOERR)
#line 813
			return lstatus;
#line 813

#line 813
		lstatus = ncx_putn_uchar_short(&xp, nput, value ,fillp);
#line 813
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 813
		{
#line 813
			/* not fatal to the loop */
#line 813
			status = lstatus;
#line 813
		}
#line 813

#line 813
		(void) ncio_rel(ncp->nciop, offset,
#line 813
				 RGN_MODIFIED);
#line 813

#line 813
		remaining -= extent;
#line 813
		if(remaining == 0)
#line 813
			break; /* normal loop exit */
#line 813
		offset += (off_t)extent;
#line 813
		value += nput;
#line 813

#line 813
	}
#line 813
#ifdef ERANGE_FILL
#line 813
        free(fillp);
#line 813
#endif
#line 813

#line 813
	return status;
#line 813
}
#line 813

static int
#line 814
putNCvx_uchar_int(NC3_INFO* ncp, const NC_var *varp,
#line 814
		 const size_t *start, size_t nelems, const int *value)
#line 814
{
#line 814
	off_t offset = NC_varoffset(ncp, varp, start);
#line 814
	size_t remaining = varp->xsz * nelems;
#line 814
	int status = NC_NOERR;
#line 814
	void *xp;
#line 814
        void *fillp=NULL;
#line 814

#line 814
	if(nelems == 0)
#line 814
		return NC_NOERR;
#line 814

#line 814
	assert(value != NULL);
#line 814

#line 814
#ifdef ERANGE_FILL
#line 814
        fillp = malloc(varp->xsz);
#line 814
        status = NC3_inq_var_fill(varp, fillp);
#line 814
#endif
#line 814

#line 814
	for(;;)
#line 814
	{
#line 814
		size_t extent = MIN(remaining, ncp->chunk);
#line 814
		size_t nput = ncx_howmany(varp->type, extent);
#line 814

#line 814
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 814
				 RGN_WRITE, &xp);
#line 814
		if(lstatus != NC_NOERR)
#line 814
			return lstatus;
#line 814

#line 814
		lstatus = ncx_putn_uchar_int(&xp, nput, value ,fillp);
#line 814
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 814
		{
#line 814
			/* not fatal to the loop */
#line 814
			status = lstatus;
#line 814
		}
#line 814

#line 814
		(void) ncio_rel(ncp->nciop, offset,
#line 814
				 RGN_MODIFIED);
#line 814

#line 814
		remaining -= extent;
#line 814
		if(remaining == 0)
#line 814
			break; /* normal loop exit */
#line 814
		offset += (off_t)extent;
#line 814
		value += nput;
#line 814

#line 814
	}
#line 814
#ifdef ERANGE_FILL
#line 814
        free(fillp);
#line 814
#endif
#line 814

#line 814
	return status;
#line 814
}
#line 814

static int
#line 815
putNCvx_uchar_float(NC3_INFO* ncp, const NC_var *varp,
#line 815
		 const size_t *start, size_t nelems, const float *value)
#line 815
{
#line 815
	off_t offset = NC_varoffset(ncp, varp, start);
#line 815
	size_t remaining = varp->xsz * nelems;
#line 815
	int status = NC_NOERR;
#line 815
	void *xp;
#line 815
        void *fillp=NULL;
#line 815

#line 815
	if(nelems == 0)
#line 815
		return NC_NOERR;
#line 815

#line 815
	assert(value != NULL);
#line 815

#line 815
#ifdef ERANGE_FILL
#line 815
        fillp = malloc(varp->xsz);
#line 815
        status = NC3_inq_var_fill(varp, fillp);
#line 815
#endif
#line 815

#line 815
	for(;;)
#line 815
	{
#line 815
		size_t extent = MIN(remaining, ncp->chunk);
#line 815
		size_t nput = ncx_howmany(varp->type, extent);
#line 815

#line 815
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 815
				 RGN_WRITE, &xp);
#line 815
		if(lstatus != NC_NOERR)
#line 815
			return lstatus;
#line 815

#line 815
		lstatus = ncx_putn_uchar_float(&xp, nput, value ,fillp);
#line 815
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 815
		{
#line 815
			/* not fatal to the loop */
#line 815
			status = lstatus;
#line 815
		}
#line 815

#line 815
		(void) ncio_rel(ncp->nciop, offset,
#line 815
				 RGN_MODIFIED);
#line 815

#line 815
		remaining -= extent;
#line 815
		if(remaining == 0)
#line 815
			break; /* normal loop exit */
#line 815
		offset += (off_t)extent;
#line 815
		value += nput;
#line 815

#line 815
	}
#line 815
#ifdef ERANGE_FILL
#line 815
        free(fillp);
#line 815
#endif
#line 815

#line 815
	return status;
#line 815
}
#line 815

static int
#line 816
putNCvx_uchar_double(NC3_INFO* ncp, const NC_var *varp,
#line 816
		 const size_t *start, size_t nelems, const double *value)
#line 816
{
#line 816
	off_t offset = NC_varoffset(ncp, varp, start);
#line 816
	size_t remaining = varp->xsz * nelems;
#line 816
	int status = NC_NOERR;
#line 816
	void *xp;
#line 816
        void *fillp=NULL;
#line 816

#line 816
	if(nelems == 0)
#line 816
		return NC_NOERR;
#line 816

#line 816
	assert(value != NULL);
#line 816

#line 816
#ifdef ERANGE_FILL
#line 816
        fillp = malloc(varp->xsz);
#line 816
        status = NC3_inq_var_fill(varp, fillp);
#line 816
#endif
#line 816

#line 816
	for(;;)
#line 816
	{
#line 816
		size_t extent = MIN(remaining, ncp->chunk);
#line 816
		size_t nput = ncx_howmany(varp->type, extent);
#line 816

#line 816
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 816
				 RGN_WRITE, &xp);
#line 816
		if(lstatus != NC_NOERR)
#line 816
			return lstatus;
#line 816

#line 816
		lstatus = ncx_putn_uchar_double(&xp, nput, value ,fillp);
#line 816
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 816
		{
#line 816
			/* not fatal to the loop */
#line 816
			status = lstatus;
#line 816
		}
#line 816

#line 816
		(void) ncio_rel(ncp->nciop, offset,
#line 816
				 RGN_MODIFIED);
#line 816

#line 816
		remaining -= extent;
#line 816
		if(remaining == 0)
#line 816
			break; /* normal loop exit */
#line 816
		offset += (off_t)extent;
#line 816
		value += nput;
#line 816

#line 816
	}
#line 816
#ifdef ERANGE_FILL
#line 816
        free(fillp);
#line 816
#endif
#line 816

#line 816
	return status;
#line 816
}
#line 816

static int
#line 817
putNCvx_uchar_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 817
		 const size_t *start, size_t nelems, const longlong *value)
#line 817
{
#line 817
	off_t offset = NC_varoffset(ncp, varp, start);
#line 817
	size_t remaining = varp->xsz * nelems;
#line 817
	int status = NC_NOERR;
#line 817
	void *xp;
#line 817
        void *fillp=NULL;
#line 817

#line 817
	if(nelems == 0)
#line 817
		return NC_NOERR;
#line 817

#line 817
	assert(value != NULL);
#line 817

#line 817
#ifdef ERANGE_FILL
#line 817
        fillp = malloc(varp->xsz);
#line 817
        status = NC3_inq_var_fill(varp, fillp);
#line 817
#endif
#line 817

#line 817
	for(;;)
#line 817
	{
#line 817
		size_t extent = MIN(remaining, ncp->chunk);
#line 817
		size_t nput = ncx_howmany(varp->type, extent);
#line 817

#line 817
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 817
				 RGN_WRITE, &xp);
#line 817
		if(lstatus != NC_NOERR)
#line 817
			return lstatus;
#line 817

#line 817
		lstatus = ncx_putn_uchar_longlong(&xp, nput, value ,fillp);
#line 817
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 817
		{
#line 817
			/* not fatal to the loop */
#line 817
			status = lstatus;
#line 817
		}
#line 817

#line 817
		(void) ncio_rel(ncp->nciop, offset,
#line 817
				 RGN_MODIFIED);
#line 817

#line 817
		remaining -= extent;
#line 817
		if(remaining == 0)
#line 817
			break; /* normal loop exit */
#line 817
		offset += (off_t)extent;
#line 817
		value += nput;
#line 817

#line 817
	}
#line 817
#ifdef ERANGE_FILL
#line 817
        free(fillp);
#line 817
#endif
#line 817

#line 817
	return status;
#line 817
}
#line 817

static int
#line 818
putNCvx_uchar_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 818
		 const size_t *start, size_t nelems, const ushort *value)
#line 818
{
#line 818
	off_t offset = NC_varoffset(ncp, varp, start);
#line 818
	size_t remaining = varp->xsz * nelems;
#line 818
	int status = NC_NOERR;
#line 818
	void *xp;
#line 818
        void *fillp=NULL;
#line 818

#line 818
	if(nelems == 0)
#line 818
		return NC_NOERR;
#line 818

#line 818
	assert(value != NULL);
#line 818

#line 818
#ifdef ERANGE_FILL
#line 818
        fillp = malloc(varp->xsz);
#line 818
        status = NC3_inq_var_fill(varp, fillp);
#line 818
#endif
#line 818

#line 818
	for(;;)
#line 818
	{
#line 818
		size_t extent = MIN(remaining, ncp->chunk);
#line 818
		size_t nput = ncx_howmany(varp->type, extent);
#line 818

#line 818
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 818
				 RGN_WRITE, &xp);
#line 818
		if(lstatus != NC_NOERR)
#line 818
			return lstatus;
#line 818

#line 818
		lstatus = ncx_putn_uchar_ushort(&xp, nput, value ,fillp);
#line 818
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 818
		{
#line 818
			/* not fatal to the loop */
#line 818
			status = lstatus;
#line 818
		}
#line 818

#line 818
		(void) ncio_rel(ncp->nciop, offset,
#line 818
				 RGN_MODIFIED);
#line 818

#line 818
		remaining -= extent;
#line 818
		if(remaining == 0)
#line 818
			break; /* normal loop exit */
#line 818
		offset += (off_t)extent;
#line 818
		value += nput;
#line 818

#line 818
	}
#line 818
#ifdef ERANGE_FILL
#line 818
        free(fillp);
#line 818
#endif
#line 818

#line 818
	return status;
#line 818
}
#line 818

static int
#line 819
putNCvx_uchar_uint(NC3_INFO* ncp, const NC_var *varp,
#line 819
		 const size_t *start, size_t nelems, const uint *value)
#line 819
{
#line 819
	off_t offset = NC_varoffset(ncp, varp, start);
#line 819
	size_t remaining = varp->xsz * nelems;
#line 819
	int status = NC_NOERR;
#line 819
	void *xp;
#line 819
        void *fillp=NULL;
#line 819

#line 819
	if(nelems == 0)
#line 819
		return NC_NOERR;
#line 819

#line 819
	assert(value != NULL);
#line 819

#line 819
#ifdef ERANGE_FILL
#line 819
        fillp = malloc(varp->xsz);
#line 819
        status = NC3_inq_var_fill(varp, fillp);
#line 819
#endif
#line 819

#line 819
	for(;;)
#line 819
	{
#line 819
		size_t extent = MIN(remaining, ncp->chunk);
#line 819
		size_t nput = ncx_howmany(varp->type, extent);
#line 819

#line 819
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 819
				 RGN_WRITE, &xp);
#line 819
		if(lstatus != NC_NOERR)
#line 819
			return lstatus;
#line 819

#line 819
		lstatus = ncx_putn_uchar_uint(&xp, nput, value ,fillp);
#line 819
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 819
		{
#line 819
			/* not fatal to the loop */
#line 819
			status = lstatus;
#line 819
		}
#line 819

#line 819
		(void) ncio_rel(ncp->nciop, offset,
#line 819
				 RGN_MODIFIED);
#line 819

#line 819
		remaining -= extent;
#line 819
		if(remaining == 0)
#line 819
			break; /* normal loop exit */
#line 819
		offset += (off_t)extent;
#line 819
		value += nput;
#line 819

#line 819
	}
#line 819
#ifdef ERANGE_FILL
#line 819
        free(fillp);
#line 819
#endif
#line 819

#line 819
	return status;
#line 819
}
#line 819

static int
#line 820
putNCvx_uchar_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 820
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 820
{
#line 820
	off_t offset = NC_varoffset(ncp, varp, start);
#line 820
	size_t remaining = varp->xsz * nelems;
#line 820
	int status = NC_NOERR;
#line 820
	void *xp;
#line 820
        void *fillp=NULL;
#line 820

#line 820
	if(nelems == 0)
#line 820
		return NC_NOERR;
#line 820

#line 820
	assert(value != NULL);
#line 820

#line 820
#ifdef ERANGE_FILL
#line 820
        fillp = malloc(varp->xsz);
#line 820
        status = NC3_inq_var_fill(varp, fillp);
#line 820
#endif
#line 820

#line 820
	for(;;)
#line 820
	{
#line 820
		size_t extent = MIN(remaining, ncp->chunk);
#line 820
		size_t nput = ncx_howmany(varp->type, extent);
#line 820

#line 820
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 820
				 RGN_WRITE, &xp);
#line 820
		if(lstatus != NC_NOERR)
#line 820
			return lstatus;
#line 820

#line 820
		lstatus = ncx_putn_uchar_ulonglong(&xp, nput, value ,fillp);
#line 820
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 820
		{
#line 820
			/* not fatal to the loop */
#line 820
			status = lstatus;
#line 820
		}
#line 820

#line 820
		(void) ncio_rel(ncp->nciop, offset,
#line 820
				 RGN_MODIFIED);
#line 820

#line 820
		remaining -= extent;
#line 820
		if(remaining == 0)
#line 820
			break; /* normal loop exit */
#line 820
		offset += (off_t)extent;
#line 820
		value += nput;
#line 820

#line 820
	}
#line 820
#ifdef ERANGE_FILL
#line 820
        free(fillp);
#line 820
#endif
#line 820

#line 820
	return status;
#line 820
}
#line 820


static int
#line 822
putNCvx_ushort_schar(NC3_INFO* ncp, const NC_var *varp,
#line 822
		 const size_t *start, size_t nelems, const schar *value)
#line 822
{
#line 822
	off_t offset = NC_varoffset(ncp, varp, start);
#line 822
	size_t remaining = varp->xsz * nelems;
#line 822
	int status = NC_NOERR;
#line 822
	void *xp;
#line 822
        void *fillp=NULL;
#line 822

#line 822
	if(nelems == 0)
#line 822
		return NC_NOERR;
#line 822

#line 822
	assert(value != NULL);
#line 822

#line 822
#ifdef ERANGE_FILL
#line 822
        fillp = malloc(varp->xsz);
#line 822
        status = NC3_inq_var_fill(varp, fillp);
#line 822
#endif
#line 822

#line 822
	for(;;)
#line 822
	{
#line 822
		size_t extent = MIN(remaining, ncp->chunk);
#line 822
		size_t nput = ncx_howmany(varp->type, extent);
#line 822

#line 822
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 822
				 RGN_WRITE, &xp);
#line 822
		if(lstatus != NC_NOERR)
#line 822
			return lstatus;
#line 822

#line 822
		lstatus = ncx_putn_ushort_schar(&xp, nput, value ,fillp);
#line 822
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 822
		{
#line 822
			/* not fatal to the loop */
#line 822
			status = lstatus;
#line 822
		}
#line 822

#line 822
		(void) ncio_rel(ncp->nciop, offset,
#line 822
				 RGN_MODIFIED);
#line 822

#line 822
		remaining -= extent;
#line 822
		if(remaining == 0)
#line 822
			break; /* normal loop exit */
#line 822
		offset += (off_t)extent;
#line 822
		value += nput;
#line 822

#line 822
	}
#line 822
#ifdef ERANGE_FILL
#line 822
        free(fillp);
#line 822
#endif
#line 822

#line 822
	return status;
#line 822
}
#line 822

static int
#line 823
putNCvx_ushort_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 823
		 const size_t *start, size_t nelems, const uchar *value)
#line 823
{
#line 823
	off_t offset = NC_varoffset(ncp, varp, start);
#line 823
	size_t remaining = varp->xsz * nelems;
#line 823
	int status = NC_NOERR;
#line 823
	void *xp;
#line 823
        void *fillp=NULL;
#line 823

#line 823
	if(nelems == 0)
#line 823
		return NC_NOERR;
#line 823

#line 823
	assert(value != NULL);
#line 823

#line 823
#ifdef ERANGE_FILL
#line 823
        fillp = malloc(varp->xsz);
#line 823
        status = NC3_inq_var_fill(varp, fillp);
#line 823
#endif
#line 823

#line 823
	for(;;)
#line 823
	{
#line 823
		size_t extent = MIN(remaining, ncp->chunk);
#line 823
		size_t nput = ncx_howmany(varp->type, extent);
#line 823

#line 823
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 823
				 RGN_WRITE, &xp);
#line 823
		if(lstatus != NC_NOERR)
#line 823
			return lstatus;
#line 823

#line 823
		lstatus = ncx_putn_ushort_uchar(&xp, nput, value ,fillp);
#line 823
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 823
		{
#line 823
			/* not fatal to the loop */
#line 823
			status = lstatus;
#line 823
		}
#line 823

#line 823
		(void) ncio_rel(ncp->nciop, offset,
#line 823
				 RGN_MODIFIED);
#line 823

#line 823
		remaining -= extent;
#line 823
		if(remaining == 0)
#line 823
			break; /* normal loop exit */
#line 823
		offset += (off_t)extent;
#line 823
		value += nput;
#line 823

#line 823
	}
#line 823
#ifdef ERANGE_FILL
#line 823
        free(fillp);
#line 823
#endif
#line 823

#line 823
	return status;
#line 823
}
#line 823

static int
#line 824
putNCvx_ushort_short(NC3_INFO* ncp, const NC_var *varp,
#line 824
		 const size_t *start, size_t nelems, const short *value)
#line 824
{
#line 824
	off_t offset = NC_varoffset(ncp, varp, start);
#line 824
	size_t remaining = varp->xsz * nelems;
#line 824
	int status = NC_NOERR;
#line 824
	void *xp;
#line 824
        void *fillp=NULL;
#line 824

#line 824
	if(nelems == 0)
#line 824
		return NC_NOERR;
#line 824

#line 824
	assert(value != NULL);
#line 824

#line 824
#ifdef ERANGE_FILL
#line 824
        fillp = malloc(varp->xsz);
#line 824
        status = NC3_inq_var_fill(varp, fillp);
#line 824
#endif
#line 824

#line 824
	for(;;)
#line 824
	{
#line 824
		size_t extent = MIN(remaining, ncp->chunk);
#line 824
		size_t nput = ncx_howmany(varp->type, extent);
#line 824

#line 824
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 824
				 RGN_WRITE, &xp);
#line 824
		if(lstatus != NC_NOERR)
#line 824
			return lstatus;
#line 824

#line 824
		lstatus = ncx_putn_ushort_short(&xp, nput, value ,fillp);
#line 824
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 824
		{
#line 824
			/* not fatal to the loop */
#line 824
			status = lstatus;
#line 824
		}
#line 824

#line 824
		(void) ncio_rel(ncp->nciop, offset,
#line 824
				 RGN_MODIFIED);
#line 824

#line 824
		remaining -= extent;
#line 824
		if(remaining == 0)
#line 824
			break; /* normal loop exit */
#line 824
		offset += (off_t)extent;
#line 824
		value += nput;
#line 824

#line 824
	}
#line 824
#ifdef ERANGE_FILL
#line 824
        free(fillp);
#line 824
#endif
#line 824

#line 824
	return status;
#line 824
}
#line 824

static int
#line 825
putNCvx_ushort_int(NC3_INFO* ncp, const NC_var *varp,
#line 825
		 const size_t *start, size_t nelems, const int *value)
#line 825
{
#line 825
	off_t offset = NC_varoffset(ncp, varp, start);
#line 825
	size_t remaining = varp->xsz * nelems;
#line 825
	int status = NC_NOERR;
#line 825
	void *xp;
#line 825
        void *fillp=NULL;
#line 825

#line 825
	if(nelems == 0)
#line 825
		return NC_NOERR;
#line 825

#line 825
	assert(value != NULL);
#line 825

#line 825
#ifdef ERANGE_FILL
#line 825
        fillp = malloc(varp->xsz);
#line 825
        status = NC3_inq_var_fill(varp, fillp);
#line 825
#endif
#line 825

#line 825
	for(;;)
#line 825
	{
#line 825
		size_t extent = MIN(remaining, ncp->chunk);
#line 825
		size_t nput = ncx_howmany(varp->type, extent);
#line 825

#line 825
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 825
				 RGN_WRITE, &xp);
#line 825
		if(lstatus != NC_NOERR)
#line 825
			return lstatus;
#line 825

#line 825
		lstatus = ncx_putn_ushort_int(&xp, nput, value ,fillp);
#line 825
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 825
		{
#line 825
			/* not fatal to the loop */
#line 825
			status = lstatus;
#line 825
		}
#line 825

#line 825
		(void) ncio_rel(ncp->nciop, offset,
#line 825
				 RGN_MODIFIED);
#line 825

#line 825
		remaining -= extent;
#line 825
		if(remaining == 0)
#line 825
			break; /* normal loop exit */
#line 825
		offset += (off_t)extent;
#line 825
		value += nput;
#line 825

#line 825
	}
#line 825
#ifdef ERANGE_FILL
#line 825
        free(fillp);
#line 825
#endif
#line 825

#line 825
	return status;
#line 825
}
#line 825

static int
#line 826
putNCvx_ushort_float(NC3_INFO* ncp, const NC_var *varp,
#line 826
		 const size_t *start, size_t nelems, const float *value)
#line 826
{
#line 826
	off_t offset = NC_varoffset(ncp, varp, start);
#line 826
	size_t remaining = varp->xsz * nelems;
#line 826
	int status = NC_NOERR;
#line 826
	void *xp;
#line 826
        void *fillp=NULL;
#line 826

#line 826
	if(nelems == 0)
#line 826
		return NC_NOERR;
#line 826

#line 826
	assert(value != NULL);
#line 826

#line 826
#ifdef ERANGE_FILL
#line 826
        fillp = malloc(varp->xsz);
#line 826
        status = NC3_inq_var_fill(varp, fillp);
#line 826
#endif
#line 826

#line 826
	for(;;)
#line 826
	{
#line 826
		size_t extent = MIN(remaining, ncp->chunk);
#line 826
		size_t nput = ncx_howmany(varp->type, extent);
#line 826

#line 826
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 826
				 RGN_WRITE, &xp);
#line 826
		if(lstatus != NC_NOERR)
#line 826
			return lstatus;
#line 826

#line 826
		lstatus = ncx_putn_ushort_float(&xp, nput, value ,fillp);
#line 826
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 826
		{
#line 826
			/* not fatal to the loop */
#line 826
			status = lstatus;
#line 826
		}
#line 826

#line 826
		(void) ncio_rel(ncp->nciop, offset,
#line 826
				 RGN_MODIFIED);
#line 826

#line 826
		remaining -= extent;
#line 826
		if(remaining == 0)
#line 826
			break; /* normal loop exit */
#line 826
		offset += (off_t)extent;
#line 826
		value += nput;
#line 826

#line 826
	}
#line 826
#ifdef ERANGE_FILL
#line 826
        free(fillp);
#line 826
#endif
#line 826

#line 826
	return status;
#line 826
}
#line 826

static int
#line 827
putNCvx_ushort_double(NC3_INFO* ncp, const NC_var *varp,
#line 827
		 const size_t *start, size_t nelems, const double *value)
#line 827
{
#line 827
	off_t offset = NC_varoffset(ncp, varp, start);
#line 827
	size_t remaining = varp->xsz * nelems;
#line 827
	int status = NC_NOERR;
#line 827
	void *xp;
#line 827
        void *fillp=NULL;
#line 827

#line 827
	if(nelems == 0)
#line 827
		return NC_NOERR;
#line 827

#line 827
	assert(value != NULL);
#line 827

#line 827
#ifdef ERANGE_FILL
#line 827
        fillp = malloc(varp->xsz);
#line 827
        status = NC3_inq_var_fill(varp, fillp);
#line 827
#endif
#line 827

#line 827
	for(;;)
#line 827
	{
#line 827
		size_t extent = MIN(remaining, ncp->chunk);
#line 827
		size_t nput = ncx_howmany(varp->type, extent);
#line 827

#line 827
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 827
				 RGN_WRITE, &xp);
#line 827
		if(lstatus != NC_NOERR)
#line 827
			return lstatus;
#line 827

#line 827
		lstatus = ncx_putn_ushort_double(&xp, nput, value ,fillp);
#line 827
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 827
		{
#line 827
			/* not fatal to the loop */
#line 827
			status = lstatus;
#line 827
		}
#line 827

#line 827
		(void) ncio_rel(ncp->nciop, offset,
#line 827
				 RGN_MODIFIED);
#line 827

#line 827
		remaining -= extent;
#line 827
		if(remaining == 0)
#line 827
			break; /* normal loop exit */
#line 827
		offset += (off_t)extent;
#line 827
		value += nput;
#line 827

#line 827
	}
#line 827
#ifdef ERANGE_FILL
#line 827
        free(fillp);
#line 827
#endif
#line 827

#line 827
	return status;
#line 827
}
#line 827

static int
#line 828
putNCvx_ushort_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 828
		 const size_t *start, size_t nelems, const longlong *value)
#line 828
{
#line 828
	off_t offset = NC_varoffset(ncp, varp, start);
#line 828
	size_t remaining = varp->xsz * nelems;
#line 828
	int status = NC_NOERR;
#line 828
	void *xp;
#line 828
        void *fillp=NULL;
#line 828

#line 828
	if(nelems == 0)
#line 828
		return NC_NOERR;
#line 828

#line 828
	assert(value != NULL);
#line 828

#line 828
#ifdef ERANGE_FILL
#line 828
        fillp = malloc(varp->xsz);
#line 828
        status = NC3_inq_var_fill(varp, fillp);
#line 828
#endif
#line 828

#line 828
	for(;;)
#line 828
	{
#line 828
		size_t extent = MIN(remaining, ncp->chunk);
#line 828
		size_t nput = ncx_howmany(varp->type, extent);
#line 828

#line 828
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 828
				 RGN_WRITE, &xp);
#line 828
		if(lstatus != NC_NOERR)
#line 828
			return lstatus;
#line 828

#line 828
		lstatus = ncx_putn_ushort_longlong(&xp, nput, value ,fillp);
#line 828
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 828
		{
#line 828
			/* not fatal to the loop */
#line 828
			status = lstatus;
#line 828
		}
#line 828

#line 828
		(void) ncio_rel(ncp->nciop, offset,
#line 828
				 RGN_MODIFIED);
#line 828

#line 828
		remaining -= extent;
#line 828
		if(remaining == 0)
#line 828
			break; /* normal loop exit */
#line 828
		offset += (off_t)extent;
#line 828
		value += nput;
#line 828

#line 828
	}
#line 828
#ifdef ERANGE_FILL
#line 828
        free(fillp);
#line 828
#endif
#line 828

#line 828
	return status;
#line 828
}
#line 828

static int
#line 829
putNCvx_ushort_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 829
		 const size_t *start, size_t nelems, const ushort *value)
#line 829
{
#line 829
	off_t offset = NC_varoffset(ncp, varp, start);
#line 829
	size_t remaining = varp->xsz * nelems;
#line 829
	int status = NC_NOERR;
#line 829
	void *xp;
#line 829
        void *fillp=NULL;
#line 829

#line 829
	if(nelems == 0)
#line 829
		return NC_NOERR;
#line 829

#line 829
	assert(value != NULL);
#line 829

#line 829
#ifdef ERANGE_FILL
#line 829
        fillp = malloc(varp->xsz);
#line 829
        status = NC3_inq_var_fill(varp, fillp);
#line 829
#endif
#line 829

#line 829
	for(;;)
#line 829
	{
#line 829
		size_t extent = MIN(remaining, ncp->chunk);
#line 829
		size_t nput = ncx_howmany(varp->type, extent);
#line 829

#line 829
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 829
				 RGN_WRITE, &xp);
#line 829
		if(lstatus != NC_NOERR)
#line 829
			return lstatus;
#line 829

#line 829
		lstatus = ncx_putn_ushort_ushort(&xp, nput, value ,fillp);
#line 829
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 829
		{
#line 829
			/* not fatal to the loop */
#line 829
			status = lstatus;
#line 829
		}
#line 829

#line 829
		(void) ncio_rel(ncp->nciop, offset,
#line 829
				 RGN_MODIFIED);
#line 829

#line 829
		remaining -= extent;
#line 829
		if(remaining == 0)
#line 829
			break; /* normal loop exit */
#line 829
		offset += (off_t)extent;
#line 829
		value += nput;
#line 829

#line 829
	}
#line 829
#ifdef ERANGE_FILL
#line 829
        free(fillp);
#line 829
#endif
#line 829

#line 829
	return status;
#line 829
}
#line 829

static int
#line 830
putNCvx_ushort_uint(NC3_INFO* ncp, const NC_var *varp,
#line 830
		 const size_t *start, size_t nelems, const uint *value)
#line 830
{
#line 830
	off_t offset = NC_varoffset(ncp, varp, start);
#line 830
	size_t remaining = varp->xsz * nelems;
#line 830
	int status = NC_NOERR;
#line 830
	void *xp;
#line 830
        void *fillp=NULL;
#line 830

#line 830
	if(nelems == 0)
#line 830
		return NC_NOERR;
#line 830

#line 830
	assert(value != NULL);
#line 830

#line 830
#ifdef ERANGE_FILL
#line 830
        fillp = malloc(varp->xsz);
#line 830
        status = NC3_inq_var_fill(varp, fillp);
#line 830
#endif
#line 830

#line 830
	for(;;)
#line 830
	{
#line 830
		size_t extent = MIN(remaining, ncp->chunk);
#line 830
		size_t nput = ncx_howmany(varp->type, extent);
#line 830

#line 830
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 830
				 RGN_WRITE, &xp);
#line 830
		if(lstatus != NC_NOERR)
#line 830
			return lstatus;
#line 830

#line 830
		lstatus = ncx_putn_ushort_uint(&xp, nput, value ,fillp);
#line 830
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 830
		{
#line 830
			/* not fatal to the loop */
#line 830
			status = lstatus;
#line 830
		}
#line 830

#line 830
		(void) ncio_rel(ncp->nciop, offset,
#line 830
				 RGN_MODIFIED);
#line 830

#line 830
		remaining -= extent;
#line 830
		if(remaining == 0)
#line 830
			break; /* normal loop exit */
#line 830
		offset += (off_t)extent;
#line 830
		value += nput;
#line 830

#line 830
	}
#line 830
#ifdef ERANGE_FILL
#line 830
        free(fillp);
#line 830
#endif
#line 830

#line 830
	return status;
#line 830
}
#line 830

static int
#line 831
putNCvx_ushort_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 831
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 831
{
#line 831
	off_t offset = NC_varoffset(ncp, varp, start);
#line 831
	size_t remaining = varp->xsz * nelems;
#line 831
	int status = NC_NOERR;
#line 831
	void *xp;
#line 831
        void *fillp=NULL;
#line 831

#line 831
	if(nelems == 0)
#line 831
		return NC_NOERR;
#line 831

#line 831
	assert(value != NULL);
#line 831

#line 831
#ifdef ERANGE_FILL
#line 831
        fillp = malloc(varp->xsz);
#line 831
        status = NC3_inq_var_fill(varp, fillp);
#line 831
#endif
#line 831

#line 831
	for(;;)
#line 831
	{
#line 831
		size_t extent = MIN(remaining, ncp->chunk);
#line 831
		size_t nput = ncx_howmany(varp->type, extent);
#line 831

#line 831
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 831
				 RGN_WRITE, &xp);
#line 831
		if(lstatus != NC_NOERR)
#line 831
			return lstatus;
#line 831

#line 831
		lstatus = ncx_putn_ushort_ulonglong(&xp, nput, value ,fillp);
#line 831
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 831
		{
#line 831
			/* not fatal to the loop */
#line 831
			status = lstatus;
#line 831
		}
#line 831

#line 831
		(void) ncio_rel(ncp->nciop, offset,
#line 831
				 RGN_MODIFIED);
#line 831

#line 831
		remaining -= extent;
#line 831
		if(remaining == 0)
#line 831
			break; /* normal loop exit */
#line 831
		offset += (off_t)extent;
#line 831
		value += nput;
#line 831

#line 831
	}
#line 831
#ifdef ERANGE_FILL
#line 831
        free(fillp);
#line 831
#endif
#line 831

#line 831
	return status;
#line 831
}
#line 831


static int
#line 833
putNCvx_uint_schar(NC3_INFO* ncp, const NC_var *varp,
#line 833
		 const size_t *start, size_t nelems, const schar *value)
#line 833
{
#line 833
	off_t offset = NC_varoffset(ncp, varp, start);
#line 833
	size_t remaining = varp->xsz * nelems;
#line 833
	int status = NC_NOERR;
#line 833
	void *xp;
#line 833
        void *fillp=NULL;
#line 833

#line 833
	if(nelems == 0)
#line 833
		return NC_NOERR;
#line 833

#line 833
	assert(value != NULL);
#line 833

#line 833
#ifdef ERANGE_FILL
#line 833
        fillp = malloc(varp->xsz);
#line 833
        status = NC3_inq_var_fill(varp, fillp);
#line 833
#endif
#line 833

#line 833
	for(;;)
#line 833
	{
#line 833
		size_t extent = MIN(remaining, ncp->chunk);
#line 833
		size_t nput = ncx_howmany(varp->type, extent);
#line 833

#line 833
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 833
				 RGN_WRITE, &xp);
#line 833
		if(lstatus != NC_NOERR)
#line 833
			return lstatus;
#line 833

#line 833
		lstatus = ncx_putn_uint_schar(&xp, nput, value ,fillp);
#line 833
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 833
		{
#line 833
			/* not fatal to the loop */
#line 833
			status = lstatus;
#line 833
		}
#line 833

#line 833
		(void) ncio_rel(ncp->nciop, offset,
#line 833
				 RGN_MODIFIED);
#line 833

#line 833
		remaining -= extent;
#line 833
		if(remaining == 0)
#line 833
			break; /* normal loop exit */
#line 833
		offset += (off_t)extent;
#line 833
		value += nput;
#line 833

#line 833
	}
#line 833
#ifdef ERANGE_FILL
#line 833
        free(fillp);
#line 833
#endif
#line 833

#line 833
	return status;
#line 833
}
#line 833

static int
#line 834
putNCvx_uint_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 834
		 const size_t *start, size_t nelems, const uchar *value)
#line 834
{
#line 834
	off_t offset = NC_varoffset(ncp, varp, start);
#line 834
	size_t remaining = varp->xsz * nelems;
#line 834
	int status = NC_NOERR;
#line 834
	void *xp;
#line 834
        void *fillp=NULL;
#line 834

#line 834
	if(nelems == 0)
#line 834
		return NC_NOERR;
#line 834

#line 834
	assert(value != NULL);
#line 834

#line 834
#ifdef ERANGE_FILL
#line 834
        fillp = malloc(varp->xsz);
#line 834
        status = NC3_inq_var_fill(varp, fillp);
#line 834
#endif
#line 834

#line 834
	for(;;)
#line 834
	{
#line 834
		size_t extent = MIN(remaining, ncp->chunk);
#line 834
		size_t nput = ncx_howmany(varp->type, extent);
#line 834

#line 834
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 834
				 RGN_WRITE, &xp);
#line 834
		if(lstatus != NC_NOERR)
#line 834
			return lstatus;
#line 834

#line 834
		lstatus = ncx_putn_uint_uchar(&xp, nput, value ,fillp);
#line 834
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 834
		{
#line 834
			/* not fatal to the loop */
#line 834
			status = lstatus;
#line 834
		}
#line 834

#line 834
		(void) ncio_rel(ncp->nciop, offset,
#line 834
				 RGN_MODIFIED);
#line 834

#line 834
		remaining -= extent;
#line 834
		if(remaining == 0)
#line 834
			break; /* normal loop exit */
#line 834
		offset += (off_t)extent;
#line 834
		value += nput;
#line 834

#line 834
	}
#line 834
#ifdef ERANGE_FILL
#line 834
        free(fillp);
#line 834
#endif
#line 834

#line 834
	return status;
#line 834
}
#line 834

static int
#line 835
putNCvx_uint_short(NC3_INFO* ncp, const NC_var *varp,
#line 835
		 const size_t *start, size_t nelems, const short *value)
#line 835
{
#line 835
	off_t offset = NC_varoffset(ncp, varp, start);
#line 835
	size_t remaining = varp->xsz * nelems;
#line 835
	int status = NC_NOERR;
#line 835
	void *xp;
#line 835
        void *fillp=NULL;
#line 835

#line 835
	if(nelems == 0)
#line 835
		return NC_NOERR;
#line 835

#line 835
	assert(value != NULL);
#line 835

#line 835
#ifdef ERANGE_FILL
#line 835
        fillp = malloc(varp->xsz);
#line 835
        status = NC3_inq_var_fill(varp, fillp);
#line 835
#endif
#line 835

#line 835
	for(;;)
#line 835
	{
#line 835
		size_t extent = MIN(remaining, ncp->chunk);
#line 835
		size_t nput = ncx_howmany(varp->type, extent);
#line 835

#line 835
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 835
				 RGN_WRITE, &xp);
#line 835
		if(lstatus != NC_NOERR)
#line 835
			return lstatus;
#line 835

#line 835
		lstatus = ncx_putn_uint_short(&xp, nput, value ,fillp);
#line 835
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 835
		{
#line 835
			/* not fatal to the loop */
#line 835
			status = lstatus;
#line 835
		}
#line 835

#line 835
		(void) ncio_rel(ncp->nciop, offset,
#line 835
				 RGN_MODIFIED);
#line 835

#line 835
		remaining -= extent;
#line 835
		if(remaining == 0)
#line 835
			break; /* normal loop exit */
#line 835
		offset += (off_t)extent;
#line 835
		value += nput;
#line 835

#line 835
	}
#line 835
#ifdef ERANGE_FILL
#line 835
        free(fillp);
#line 835
#endif
#line 835

#line 835
	return status;
#line 835
}
#line 835

static int
#line 836
putNCvx_uint_int(NC3_INFO* ncp, const NC_var *varp,
#line 836
		 const size_t *start, size_t nelems, const int *value)
#line 836
{
#line 836
	off_t offset = NC_varoffset(ncp, varp, start);
#line 836
	size_t remaining = varp->xsz * nelems;
#line 836
	int status = NC_NOERR;
#line 836
	void *xp;
#line 836
        void *fillp=NULL;
#line 836

#line 836
	if(nelems == 0)
#line 836
		return NC_NOERR;
#line 836

#line 836
	assert(value != NULL);
#line 836

#line 836
#ifdef ERANGE_FILL
#line 836
        fillp = malloc(varp->xsz);
#line 836
        status = NC3_inq_var_fill(varp, fillp);
#line 836
#endif
#line 836

#line 836
	for(;;)
#line 836
	{
#line 836
		size_t extent = MIN(remaining, ncp->chunk);
#line 836
		size_t nput = ncx_howmany(varp->type, extent);
#line 836

#line 836
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 836
				 RGN_WRITE, &xp);
#line 836
		if(lstatus != NC_NOERR)
#line 836
			return lstatus;
#line 836

#line 836
		lstatus = ncx_putn_uint_int(&xp, nput, value ,fillp);
#line 836
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 836
		{
#line 836
			/* not fatal to the loop */
#line 836
			status = lstatus;
#line 836
		}
#line 836

#line 836
		(void) ncio_rel(ncp->nciop, offset,
#line 836
				 RGN_MODIFIED);
#line 836

#line 836
		remaining -= extent;
#line 836
		if(remaining == 0)
#line 836
			break; /* normal loop exit */
#line 836
		offset += (off_t)extent;
#line 836
		value += nput;
#line 836

#line 836
	}
#line 836
#ifdef ERANGE_FILL
#line 836
        free(fillp);
#line 836
#endif
#line 836

#line 836
	return status;
#line 836
}
#line 836

static int
#line 837
putNCvx_uint_float(NC3_INFO* ncp, const NC_var *varp,
#line 837
		 const size_t *start, size_t nelems, const float *value)
#line 837
{
#line 837
	off_t offset = NC_varoffset(ncp, varp, start);
#line 837
	size_t remaining = varp->xsz * nelems;
#line 837
	int status = NC_NOERR;
#line 837
	void *xp;
#line 837
        void *fillp=NULL;
#line 837

#line 837
	if(nelems == 0)
#line 837
		return NC_NOERR;
#line 837

#line 837
	assert(value != NULL);
#line 837

#line 837
#ifdef ERANGE_FILL
#line 837
        fillp = malloc(varp->xsz);
#line 837
        status = NC3_inq_var_fill(varp, fillp);
#line 837
#endif
#line 837

#line 837
	for(;;)
#line 837
	{
#line 837
		size_t extent = MIN(remaining, ncp->chunk);
#line 837
		size_t nput = ncx_howmany(varp->type, extent);
#line 837

#line 837
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 837
				 RGN_WRITE, &xp);
#line 837
		if(lstatus != NC_NOERR)
#line 837
			return lstatus;
#line 837

#line 837
		lstatus = ncx_putn_uint_float(&xp, nput, value ,fillp);
#line 837
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 837
		{
#line 837
			/* not fatal to the loop */
#line 837
			status = lstatus;
#line 837
		}
#line 837

#line 837
		(void) ncio_rel(ncp->nciop, offset,
#line 837
				 RGN_MODIFIED);
#line 837

#line 837
		remaining -= extent;
#line 837
		if(remaining == 0)
#line 837
			break; /* normal loop exit */
#line 837
		offset += (off_t)extent;
#line 837
		value += nput;
#line 837

#line 837
	}
#line 837
#ifdef ERANGE_FILL
#line 837
        free(fillp);
#line 837
#endif
#line 837

#line 837
	return status;
#line 837
}
#line 837

static int
#line 838
putNCvx_uint_double(NC3_INFO* ncp, const NC_var *varp,
#line 838
		 const size_t *start, size_t nelems, const double *value)
#line 838
{
#line 838
	off_t offset = NC_varoffset(ncp, varp, start);
#line 838
	size_t remaining = varp->xsz * nelems;
#line 838
	int status = NC_NOERR;
#line 838
	void *xp;
#line 838
        void *fillp=NULL;
#line 838

#line 838
	if(nelems == 0)
#line 838
		return NC_NOERR;
#line 838

#line 838
	assert(value != NULL);
#line 838

#line 838
#ifdef ERANGE_FILL
#line 838
        fillp = malloc(varp->xsz);
#line 838
        status = NC3_inq_var_fill(varp, fillp);
#line 838
#endif
#line 838

#line 838
	for(;;)
#line 838
	{
#line 838
		size_t extent = MIN(remaining, ncp->chunk);
#line 838
		size_t nput = ncx_howmany(varp->type, extent);
#line 838

#line 838
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 838
				 RGN_WRITE, &xp);
#line 838
		if(lstatus != NC_NOERR)
#line 838
			return lstatus;
#line 838

#line 838
		lstatus = ncx_putn_uint_double(&xp, nput, value ,fillp);
#line 838
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 838
		{
#line 838
			/* not fatal to the loop */
#line 838
			status = lstatus;
#line 838
		}
#line 838

#line 838
		(void) ncio_rel(ncp->nciop, offset,
#line 838
				 RGN_MODIFIED);
#line 838

#line 838
		remaining -= extent;
#line 838
		if(remaining == 0)
#line 838
			break; /* normal loop exit */
#line 838
		offset += (off_t)extent;
#line 838
		value += nput;
#line 838

#line 838
	}
#line 838
#ifdef ERANGE_FILL
#line 838
        free(fillp);
#line 838
#endif
#line 838

#line 838
	return status;
#line 838
}
#line 838

static int
#line 839
putNCvx_uint_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 839
		 const size_t *start, size_t nelems, const longlong *value)
#line 839
{
#line 839
	off_t offset = NC_varoffset(ncp, varp, start);
#line 839
	size_t remaining = varp->xsz * nelems;
#line 839
	int status = NC_NOERR;
#line 839
	void *xp;
#line 839
        void *fillp=NULL;
#line 839

#line 839
	if(nelems == 0)
#line 839
		return NC_NOERR;
#line 839

#line 839
	assert(value != NULL);
#line 839

#line 839
#ifdef ERANGE_FILL
#line 839
        fillp = malloc(varp->xsz);
#line 839
        status = NC3_inq_var_fill(varp, fillp);
#line 839
#endif
#line 839

#line 839
	for(;;)
#line 839
	{
#line 839
		size_t extent = MIN(remaining, ncp->chunk);
#line 839
		size_t nput = ncx_howmany(varp->type, extent);
#line 839

#line 839
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 839
				 RGN_WRITE, &xp);
#line 839
		if(lstatus != NC_NOERR)
#line 839
			return lstatus;
#line 839

#line 839
		lstatus = ncx_putn_uint_longlong(&xp, nput, value ,fillp);
#line 839
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 839
		{
#line 839
			/* not fatal to the loop */
#line 839
			status = lstatus;
#line 839
		}
#line 839

#line 839
		(void) ncio_rel(ncp->nciop, offset,
#line 839
				 RGN_MODIFIED);
#line 839

#line 839
		remaining -= extent;
#line 839
		if(remaining == 0)
#line 839
			break; /* normal loop exit */
#line 839
		offset += (off_t)extent;
#line 839
		value += nput;
#line 839

#line 839
	}
#line 839
#ifdef ERANGE_FILL
#line 839
        free(fillp);
#line 839
#endif
#line 839

#line 839
	return status;
#line 839
}
#line 839

static int
#line 840
putNCvx_uint_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 840
		 const size_t *start, size_t nelems, const ushort *value)
#line 840
{
#line 840
	off_t offset = NC_varoffset(ncp, varp, start);
#line 840
	size_t remaining = varp->xsz * nelems;
#line 840
	int status = NC_NOERR;
#line 840
	void *xp;
#line 840
        void *fillp=NULL;
#line 840

#line 840
	if(nelems == 0)
#line 840
		return NC_NOERR;
#line 840

#line 840
	assert(value != NULL);
#line 840

#line 840
#ifdef ERANGE_FILL
#line 840
        fillp = malloc(varp->xsz);
#line 840
        status = NC3_inq_var_fill(varp, fillp);
#line 840
#endif
#line 840

#line 840
	for(;;)
#line 840
	{
#line 840
		size_t extent = MIN(remaining, ncp->chunk);
#line 840
		size_t nput = ncx_howmany(varp->type, extent);
#line 840

#line 840
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 840
				 RGN_WRITE, &xp);
#line 840
		if(lstatus != NC_NOERR)
#line 840
			return lstatus;
#line 840

#line 840
		lstatus = ncx_putn_uint_ushort(&xp, nput, value ,fillp);
#line 840
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 840
		{
#line 840
			/* not fatal to the loop */
#line 840
			status = lstatus;
#line 840
		}
#line 840

#line 840
		(void) ncio_rel(ncp->nciop, offset,
#line 840
				 RGN_MODIFIED);
#line 840

#line 840
		remaining -= extent;
#line 840
		if(remaining == 0)
#line 840
			break; /* normal loop exit */
#line 840
		offset += (off_t)extent;
#line 840
		value += nput;
#line 840

#line 840
	}
#line 840
#ifdef ERANGE_FILL
#line 840
        free(fillp);
#line 840
#endif
#line 840

#line 840
	return status;
#line 840
}
#line 840

static int
#line 841
putNCvx_uint_uint(NC3_INFO* ncp, const NC_var *varp,
#line 841
		 const size_t *start, size_t nelems, const uint *value)
#line 841
{
#line 841
	off_t offset = NC_varoffset(ncp, varp, start);
#line 841
	size_t remaining = varp->xsz * nelems;
#line 841
	int status = NC_NOERR;
#line 841
	void *xp;
#line 841
        void *fillp=NULL;
#line 841

#line 841
	if(nelems == 0)
#line 841
		return NC_NOERR;
#line 841

#line 841
	assert(value != NULL);
#line 841

#line 841
#ifdef ERANGE_FILL
#line 841
        fillp = malloc(varp->xsz);
#line 841
        status = NC3_inq_var_fill(varp, fillp);
#line 841
#endif
#line 841

#line 841
	for(;;)
#line 841
	{
#line 841
		size_t extent = MIN(remaining, ncp->chunk);
#line 841
		size_t nput = ncx_howmany(varp->type, extent);
#line 841

#line 841
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 841
				 RGN_WRITE, &xp);
#line 841
		if(lstatus != NC_NOERR)
#line 841
			return lstatus;
#line 841

#line 841
		lstatus = ncx_putn_uint_uint(&xp, nput, value ,fillp);
#line 841
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 841
		{
#line 841
			/* not fatal to the loop */
#line 841
			status = lstatus;
#line 841
		}
#line 841

#line 841
		(void) ncio_rel(ncp->nciop, offset,
#line 841
				 RGN_MODIFIED);
#line 841

#line 841
		remaining -= extent;
#line 841
		if(remaining == 0)
#line 841
			break; /* normal loop exit */
#line 841
		offset += (off_t)extent;
#line 841
		value += nput;
#line 841

#line 841
	}
#line 841
#ifdef ERANGE_FILL
#line 841
        free(fillp);
#line 841
#endif
#line 841

#line 841
	return status;
#line 841
}
#line 841

static int
#line 842
putNCvx_uint_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 842
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 842
{
#line 842
	off_t offset = NC_varoffset(ncp, varp, start);
#line 842
	size_t remaining = varp->xsz * nelems;
#line 842
	int status = NC_NOERR;
#line 842
	void *xp;
#line 842
        void *fillp=NULL;
#line 842

#line 842
	if(nelems == 0)
#line 842
		return NC_NOERR;
#line 842

#line 842
	assert(value != NULL);
#line 842

#line 842
#ifdef ERANGE_FILL
#line 842
        fillp = malloc(varp->xsz);
#line 842
        status = NC3_inq_var_fill(varp, fillp);
#line 842
#endif
#line 842

#line 842
	for(;;)
#line 842
	{
#line 842
		size_t extent = MIN(remaining, ncp->chunk);
#line 842
		size_t nput = ncx_howmany(varp->type, extent);
#line 842

#line 842
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 842
				 RGN_WRITE, &xp);
#line 842
		if(lstatus != NC_NOERR)
#line 842
			return lstatus;
#line 842

#line 842
		lstatus = ncx_putn_uint_ulonglong(&xp, nput, value ,fillp);
#line 842
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 842
		{
#line 842
			/* not fatal to the loop */
#line 842
			status = lstatus;
#line 842
		}
#line 842

#line 842
		(void) ncio_rel(ncp->nciop, offset,
#line 842
				 RGN_MODIFIED);
#line 842

#line 842
		remaining -= extent;
#line 842
		if(remaining == 0)
#line 842
			break; /* normal loop exit */
#line 842
		offset += (off_t)extent;
#line 842
		value += nput;
#line 842

#line 842
	}
#line 842
#ifdef ERANGE_FILL
#line 842
        free(fillp);
#line 842
#endif
#line 842

#line 842
	return status;
#line 842
}
#line 842


static int
#line 844
putNCvx_longlong_schar(NC3_INFO* ncp, const NC_var *varp,
#line 844
		 const size_t *start, size_t nelems, const schar *value)
#line 844
{
#line 844
	off_t offset = NC_varoffset(ncp, varp, start);
#line 844
	size_t remaining = varp->xsz * nelems;
#line 844
	int status = NC_NOERR;
#line 844
	void *xp;
#line 844
        void *fillp=NULL;
#line 844

#line 844
	if(nelems == 0)
#line 844
		return NC_NOERR;
#line 844

#line 844
	assert(value != NULL);
#line 844

#line 844
#ifdef ERANGE_FILL
#line 844
        fillp = malloc(varp->xsz);
#line 844
        status = NC3_inq_var_fill(varp, fillp);
#line 844
#endif
#line 844

#line 844
	for(;;)
#line 844
	{
#line 844
		size_t extent = MIN(remaining, ncp->chunk);
#line 844
		size_t nput = ncx_howmany(varp->type, extent);
#line 844

#line 844
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 844
				 RGN_WRITE, &xp);
#line 844
		if(lstatus != NC_NOERR)
#line 844
			return lstatus;
#line 844

#line 844
		lstatus = ncx_putn_longlong_schar(&xp, nput, value ,fillp);
#line 844
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 844
		{
#line 844
			/* not fatal to the loop */
#line 844
			status = lstatus;
#line 844
		}
#line 844

#line 844
		(void) ncio_rel(ncp->nciop, offset,
#line 844
				 RGN_MODIFIED);
#line 844

#line 844
		remaining -= extent;
#line 844
		if(remaining == 0)
#line 844
			break; /* normal loop exit */
#line 844
		offset += (off_t)extent;
#line 844
		value += nput;
#line 844

#line 844
	}
#line 844
#ifdef ERANGE_FILL
#line 844
        free(fillp);
#line 844
#endif
#line 844

#line 844
	return status;
#line 844
}
#line 844

static int
#line 845
putNCvx_longlong_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 845
		 const size_t *start, size_t nelems, const uchar *value)
#line 845
{
#line 845
	off_t offset = NC_varoffset(ncp, varp, start);
#line 845
	size_t remaining = varp->xsz * nelems;
#line 845
	int status = NC_NOERR;
#line 845
	void *xp;
#line 845
        void *fillp=NULL;
#line 845

#line 845
	if(nelems == 0)
#line 845
		return NC_NOERR;
#line 845

#line 845
	assert(value != NULL);
#line 845

#line 845
#ifdef ERANGE_FILL
#line 845
        fillp = malloc(varp->xsz);
#line 845
        status = NC3_inq_var_fill(varp, fillp);
#line 845
#endif
#line 845

#line 845
	for(;;)
#line 845
	{
#line 845
		size_t extent = MIN(remaining, ncp->chunk);
#line 845
		size_t nput = ncx_howmany(varp->type, extent);
#line 845

#line 845
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 845
				 RGN_WRITE, &xp);
#line 845
		if(lstatus != NC_NOERR)
#line 845
			return lstatus;
#line 845

#line 845
		lstatus = ncx_putn_longlong_uchar(&xp, nput, value ,fillp);
#line 845
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 845
		{
#line 845
			/* not fatal to the loop */
#line 845
			status = lstatus;
#line 845
		}
#line 845

#line 845
		(void) ncio_rel(ncp->nciop, offset,
#line 845
				 RGN_MODIFIED);
#line 845

#line 845
		remaining -= extent;
#line 845
		if(remaining == 0)
#line 845
			break; /* normal loop exit */
#line 845
		offset += (off_t)extent;
#line 845
		value += nput;
#line 845

#line 845
	}
#line 845
#ifdef ERANGE_FILL
#line 845
        free(fillp);
#line 845
#endif
#line 845

#line 845
	return status;
#line 845
}
#line 845

static int
#line 846
putNCvx_longlong_short(NC3_INFO* ncp, const NC_var *varp,
#line 846
		 const size_t *start, size_t nelems, const short *value)
#line 846
{
#line 846
	off_t offset = NC_varoffset(ncp, varp, start);
#line 846
	size_t remaining = varp->xsz * nelems;
#line 846
	int status = NC_NOERR;
#line 846
	void *xp;
#line 846
        void *fillp=NULL;
#line 846

#line 846
	if(nelems == 0)
#line 846
		return NC_NOERR;
#line 846

#line 846
	assert(value != NULL);
#line 846

#line 846
#ifdef ERANGE_FILL
#line 846
        fillp = malloc(varp->xsz);
#line 846
        status = NC3_inq_var_fill(varp, fillp);
#line 846
#endif
#line 846

#line 846
	for(;;)
#line 846
	{
#line 846
		size_t extent = MIN(remaining, ncp->chunk);
#line 846
		size_t nput = ncx_howmany(varp->type, extent);
#line 846

#line 846
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 846
				 RGN_WRITE, &xp);
#line 846
		if(lstatus != NC_NOERR)
#line 846
			return lstatus;
#line 846

#line 846
		lstatus = ncx_putn_longlong_short(&xp, nput, value ,fillp);
#line 846
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 846
		{
#line 846
			/* not fatal to the loop */
#line 846
			status = lstatus;
#line 846
		}
#line 846

#line 846
		(void) ncio_rel(ncp->nciop, offset,
#line 846
				 RGN_MODIFIED);
#line 846

#line 846
		remaining -= extent;
#line 846
		if(remaining == 0)
#line 846
			break; /* normal loop exit */
#line 846
		offset += (off_t)extent;
#line 846
		value += nput;
#line 846

#line 846
	}
#line 846
#ifdef ERANGE_FILL
#line 846
        free(fillp);
#line 846
#endif
#line 846

#line 846
	return status;
#line 846
}
#line 846

static int
#line 847
putNCvx_longlong_int(NC3_INFO* ncp, const NC_var *varp,
#line 847
		 const size_t *start, size_t nelems, const int *value)
#line 847
{
#line 847
	off_t offset = NC_varoffset(ncp, varp, start);
#line 847
	size_t remaining = varp->xsz * nelems;
#line 847
	int status = NC_NOERR;
#line 847
	void *xp;
#line 847
        void *fillp=NULL;
#line 847

#line 847
	if(nelems == 0)
#line 847
		return NC_NOERR;
#line 847

#line 847
	assert(value != NULL);
#line 847

#line 847
#ifdef ERANGE_FILL
#line 847
        fillp = malloc(varp->xsz);
#line 847
        status = NC3_inq_var_fill(varp, fillp);
#line 847
#endif
#line 847

#line 847
	for(;;)
#line 847
	{
#line 847
		size_t extent = MIN(remaining, ncp->chunk);
#line 847
		size_t nput = ncx_howmany(varp->type, extent);
#line 847

#line 847
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 847
				 RGN_WRITE, &xp);
#line 847
		if(lstatus != NC_NOERR)
#line 847
			return lstatus;
#line 847

#line 847
		lstatus = ncx_putn_longlong_int(&xp, nput, value ,fillp);
#line 847
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 847
		{
#line 847
			/* not fatal to the loop */
#line 847
			status = lstatus;
#line 847
		}
#line 847

#line 847
		(void) ncio_rel(ncp->nciop, offset,
#line 847
				 RGN_MODIFIED);
#line 847

#line 847
		remaining -= extent;
#line 847
		if(remaining == 0)
#line 847
			break; /* normal loop exit */
#line 847
		offset += (off_t)extent;
#line 847
		value += nput;
#line 847

#line 847
	}
#line 847
#ifdef ERANGE_FILL
#line 847
        free(fillp);
#line 847
#endif
#line 847

#line 847
	return status;
#line 847
}
#line 847

static int
#line 848
putNCvx_longlong_float(NC3_INFO* ncp, const NC_var *varp,
#line 848
		 const size_t *start, size_t nelems, const float *value)
#line 848
{
#line 848
	off_t offset = NC_varoffset(ncp, varp, start);
#line 848
	size_t remaining = varp->xsz * nelems;
#line 848
	int status = NC_NOERR;
#line 848
	void *xp;
#line 848
        void *fillp=NULL;
#line 848

#line 848
	if(nelems == 0)
#line 848
		return NC_NOERR;
#line 848

#line 848
	assert(value != NULL);
#line 848

#line 848
#ifdef ERANGE_FILL
#line 848
        fillp = malloc(varp->xsz);
#line 848
        status = NC3_inq_var_fill(varp, fillp);
#line 848
#endif
#line 848

#line 848
	for(;;)
#line 848
	{
#line 848
		size_t extent = MIN(remaining, ncp->chunk);
#line 848
		size_t nput = ncx_howmany(varp->type, extent);
#line 848

#line 848
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 848
				 RGN_WRITE, &xp);
#line 848
		if(lstatus != NC_NOERR)
#line 848
			return lstatus;
#line 848

#line 848
		lstatus = ncx_putn_longlong_float(&xp, nput, value ,fillp);
#line 848
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 848
		{
#line 848
			/* not fatal to the loop */
#line 848
			status = lstatus;
#line 848
		}
#line 848

#line 848
		(void) ncio_rel(ncp->nciop, offset,
#line 848
				 RGN_MODIFIED);
#line 848

#line 848
		remaining -= extent;
#line 848
		if(remaining == 0)
#line 848
			break; /* normal loop exit */
#line 848
		offset += (off_t)extent;
#line 848
		value += nput;
#line 848

#line 848
	}
#line 848
#ifdef ERANGE_FILL
#line 848
        free(fillp);
#line 848
#endif
#line 848

#line 848
	return status;
#line 848
}
#line 848

static int
#line 849
putNCvx_longlong_double(NC3_INFO* ncp, const NC_var *varp,
#line 849
		 const size_t *start, size_t nelems, const double *value)
#line 849
{
#line 849
	off_t offset = NC_varoffset(ncp, varp, start);
#line 849
	size_t remaining = varp->xsz * nelems;
#line 849
	int status = NC_NOERR;
#line 849
	void *xp;
#line 849
        void *fillp=NULL;
#line 849

#line 849
	if(nelems == 0)
#line 849
		return NC_NOERR;
#line 849

#line 849
	assert(value != NULL);
#line 849

#line 849
#ifdef ERANGE_FILL
#line 849
        fillp = malloc(varp->xsz);
#line 849
        status = NC3_inq_var_fill(varp, fillp);
#line 849
#endif
#line 849

#line 849
	for(;;)
#line 849
	{
#line 849
		size_t extent = MIN(remaining, ncp->chunk);
#line 849
		size_t nput = ncx_howmany(varp->type, extent);
#line 849

#line 849
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 849
				 RGN_WRITE, &xp);
#line 849
		if(lstatus != NC_NOERR)
#line 849
			return lstatus;
#line 849

#line 849
		lstatus = ncx_putn_longlong_double(&xp, nput, value ,fillp);
#line 849
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 849
		{
#line 849
			/* not fatal to the loop */
#line 849
			status = lstatus;
#line 849
		}
#line 849

#line 849
		(void) ncio_rel(ncp->nciop, offset,
#line 849
				 RGN_MODIFIED);
#line 849

#line 849
		remaining -= extent;
#line 849
		if(remaining == 0)
#line 849
			break; /* normal loop exit */
#line 849
		offset += (off_t)extent;
#line 849
		value += nput;
#line 849

#line 849
	}
#line 849
#ifdef ERANGE_FILL
#line 849
        free(fillp);
#line 849
#endif
#line 849

#line 849
	return status;
#line 849
}
#line 849

static int
#line 850
putNCvx_longlong_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 850
		 const size_t *start, size_t nelems, const longlong *value)
#line 850
{
#line 850
	off_t offset = NC_varoffset(ncp, varp, start);
#line 850
	size_t remaining = varp->xsz * nelems;
#line 850
	int status = NC_NOERR;
#line 850
	void *xp;
#line 850
        void *fillp=NULL;
#line 850

#line 850
	if(nelems == 0)
#line 850
		return NC_NOERR;
#line 850

#line 850
	assert(value != NULL);
#line 850

#line 850
#ifdef ERANGE_FILL
#line 850
        fillp = malloc(varp->xsz);
#line 850
        status = NC3_inq_var_fill(varp, fillp);
#line 850
#endif
#line 850

#line 850
	for(;;)
#line 850
	{
#line 850
		size_t extent = MIN(remaining, ncp->chunk);
#line 850
		size_t nput = ncx_howmany(varp->type, extent);
#line 850

#line 850
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 850
				 RGN_WRITE, &xp);
#line 850
		if(lstatus != NC_NOERR)
#line 850
			return lstatus;
#line 850

#line 850
		lstatus = ncx_putn_longlong_longlong(&xp, nput, value ,fillp);
#line 850
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 850
		{
#line 850
			/* not fatal to the loop */
#line 850
			status = lstatus;
#line 850
		}
#line 850

#line 850
		(void) ncio_rel(ncp->nciop, offset,
#line 850
				 RGN_MODIFIED);
#line 850

#line 850
		remaining -= extent;
#line 850
		if(remaining == 0)
#line 850
			break; /* normal loop exit */
#line 850
		offset += (off_t)extent;
#line 850
		value += nput;
#line 850

#line 850
	}
#line 850
#ifdef ERANGE_FILL
#line 850
        free(fillp);
#line 850
#endif
#line 850

#line 850
	return status;
#line 850
}
#line 850

static int
#line 851
putNCvx_longlong_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 851
		 const size_t *start, size_t nelems, const ushort *value)
#line 851
{
#line 851
	off_t offset = NC_varoffset(ncp, varp, start);
#line 851
	size_t remaining = varp->xsz * nelems;
#line 851
	int status = NC_NOERR;
#line 851
	void *xp;
#line 851
        void *fillp=NULL;
#line 851

#line 851
	if(nelems == 0)
#line 851
		return NC_NOERR;
#line 851

#line 851
	assert(value != NULL);
#line 851

#line 851
#ifdef ERANGE_FILL
#line 851
        fillp = malloc(varp->xsz);
#line 851
        status = NC3_inq_var_fill(varp, fillp);
#line 851
#endif
#line 851

#line 851
	for(;;)
#line 851
	{
#line 851
		size_t extent = MIN(remaining, ncp->chunk);
#line 851
		size_t nput = ncx_howmany(varp->type, extent);
#line 851

#line 851
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 851
				 RGN_WRITE, &xp);
#line 851
		if(lstatus != NC_NOERR)
#line 851
			return lstatus;
#line 851

#line 851
		lstatus = ncx_putn_longlong_ushort(&xp, nput, value ,fillp);
#line 851
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 851
		{
#line 851
			/* not fatal to the loop */
#line 851
			status = lstatus;
#line 851
		}
#line 851

#line 851
		(void) ncio_rel(ncp->nciop, offset,
#line 851
				 RGN_MODIFIED);
#line 851

#line 851
		remaining -= extent;
#line 851
		if(remaining == 0)
#line 851
			break; /* normal loop exit */
#line 851
		offset += (off_t)extent;
#line 851
		value += nput;
#line 851

#line 851
	}
#line 851
#ifdef ERANGE_FILL
#line 851
        free(fillp);
#line 851
#endif
#line 851

#line 851
	return status;
#line 851
}
#line 851

static int
#line 852
putNCvx_longlong_uint(NC3_INFO* ncp, const NC_var *varp,
#line 852
		 const size_t *start, size_t nelems, const uint *value)
#line 852
{
#line 852
	off_t offset = NC_varoffset(ncp, varp, start);
#line 852
	size_t remaining = varp->xsz * nelems;
#line 852
	int status = NC_NOERR;
#line 852
	void *xp;
#line 852
        void *fillp=NULL;
#line 852

#line 852
	if(nelems == 0)
#line 852
		return NC_NOERR;
#line 852

#line 852
	assert(value != NULL);
#line 852

#line 852
#ifdef ERANGE_FILL
#line 852
        fillp = malloc(varp->xsz);
#line 852
        status = NC3_inq_var_fill(varp, fillp);
#line 852
#endif
#line 852

#line 852
	for(;;)
#line 852
	{
#line 852
		size_t extent = MIN(remaining, ncp->chunk);
#line 852
		size_t nput = ncx_howmany(varp->type, extent);
#line 852

#line 852
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 852
				 RGN_WRITE, &xp);
#line 852
		if(lstatus != NC_NOERR)
#line 852
			return lstatus;
#line 852

#line 852
		lstatus = ncx_putn_longlong_uint(&xp, nput, value ,fillp);
#line 852
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 852
		{
#line 852
			/* not fatal to the loop */
#line 852
			status = lstatus;
#line 852
		}
#line 852

#line 852
		(void) ncio_rel(ncp->nciop, offset,
#line 852
				 RGN_MODIFIED);
#line 852

#line 852
		remaining -= extent;
#line 852
		if(remaining == 0)
#line 852
			break; /* normal loop exit */
#line 852
		offset += (off_t)extent;
#line 852
		value += nput;
#line 852

#line 852
	}
#line 852
#ifdef ERANGE_FILL
#line 852
        free(fillp);
#line 852
#endif
#line 852

#line 852
	return status;
#line 852
}
#line 852

static int
#line 853
putNCvx_longlong_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 853
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 853
{
#line 853
	off_t offset = NC_varoffset(ncp, varp, start);
#line 853
	size_t remaining = varp->xsz * nelems;
#line 853
	int status = NC_NOERR;
#line 853
	void *xp;
#line 853
        void *fillp=NULL;
#line 853

#line 853
	if(nelems == 0)
#line 853
		return NC_NOERR;
#line 853

#line 853
	assert(value != NULL);
#line 853

#line 853
#ifdef ERANGE_FILL
#line 853
        fillp = malloc(varp->xsz);
#line 853
        status = NC3_inq_var_fill(varp, fillp);
#line 853
#endif
#line 853

#line 853
	for(;;)
#line 853
	{
#line 853
		size_t extent = MIN(remaining, ncp->chunk);
#line 853
		size_t nput = ncx_howmany(varp->type, extent);
#line 853

#line 853
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 853
				 RGN_WRITE, &xp);
#line 853
		if(lstatus != NC_NOERR)
#line 853
			return lstatus;
#line 853

#line 853
		lstatus = ncx_putn_longlong_ulonglong(&xp, nput, value ,fillp);
#line 853
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 853
		{
#line 853
			/* not fatal to the loop */
#line 853
			status = lstatus;
#line 853
		}
#line 853

#line 853
		(void) ncio_rel(ncp->nciop, offset,
#line 853
				 RGN_MODIFIED);
#line 853

#line 853
		remaining -= extent;
#line 853
		if(remaining == 0)
#line 853
			break; /* normal loop exit */
#line 853
		offset += (off_t)extent;
#line 853
		value += nput;
#line 853

#line 853
	}
#line 853
#ifdef ERANGE_FILL
#line 853
        free(fillp);
#line 853
#endif
#line 853

#line 853
	return status;
#line 853
}
#line 853


static int
#line 855
putNCvx_ulonglong_schar(NC3_INFO* ncp, const NC_var *varp,
#line 855
		 const size_t *start, size_t nelems, const schar *value)
#line 855
{
#line 855
	off_t offset = NC_varoffset(ncp, varp, start);
#line 855
	size_t remaining = varp->xsz * nelems;
#line 855
	int status = NC_NOERR;
#line 855
	void *xp;
#line 855
        void *fillp=NULL;
#line 855

#line 855
	if(nelems == 0)
#line 855
		return NC_NOERR;
#line 855

#line 855
	assert(value != NULL);
#line 855

#line 855
#ifdef ERANGE_FILL
#line 855
        fillp = malloc(varp->xsz);
#line 855
        status = NC3_inq_var_fill(varp, fillp);
#line 855
#endif
#line 855

#line 855
	for(;;)
#line 855
	{
#line 855
		size_t extent = MIN(remaining, ncp->chunk);
#line 855
		size_t nput = ncx_howmany(varp->type, extent);
#line 855

#line 855
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 855
				 RGN_WRITE, &xp);
#line 855
		if(lstatus != NC_NOERR)
#line 855
			return lstatus;
#line 855

#line 855
		lstatus = ncx_putn_ulonglong_schar(&xp, nput, value ,fillp);
#line 855
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 855
		{
#line 855
			/* not fatal to the loop */
#line 855
			status = lstatus;
#line 855
		}
#line 855

#line 855
		(void) ncio_rel(ncp->nciop, offset,
#line 855
				 RGN_MODIFIED);
#line 855

#line 855
		remaining -= extent;
#line 855
		if(remaining == 0)
#line 855
			break; /* normal loop exit */
#line 855
		offset += (off_t)extent;
#line 855
		value += nput;
#line 855

#line 855
	}
#line 855
#ifdef ERANGE_FILL
#line 855
        free(fillp);
#line 855
#endif
#line 855

#line 855
	return status;
#line 855
}
#line 855

static int
#line 856
putNCvx_ulonglong_uchar(NC3_INFO* ncp, const NC_var *varp,
#line 856
		 const size_t *start, size_t nelems, const uchar *value)
#line 856
{
#line 856
	off_t offset = NC_varoffset(ncp, varp, start);
#line 856
	size_t remaining = varp->xsz * nelems;
#line 856
	int status = NC_NOERR;
#line 856
	void *xp;
#line 856
        void *fillp=NULL;
#line 856

#line 856
	if(nelems == 0)
#line 856
		return NC_NOERR;
#line 856

#line 856
	assert(value != NULL);
#line 856

#line 856
#ifdef ERANGE_FILL
#line 856
        fillp = malloc(varp->xsz);
#line 856
        status = NC3_inq_var_fill(varp, fillp);
#line 856
#endif
#line 856

#line 856
	for(;;)
#line 856
	{
#line 856
		size_t extent = MIN(remaining, ncp->chunk);
#line 856
		size_t nput = ncx_howmany(varp->type, extent);
#line 856

#line 856
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 856
				 RGN_WRITE, &xp);
#line 856
		if(lstatus != NC_NOERR)
#line 856
			return lstatus;
#line 856

#line 856
		lstatus = ncx_putn_ulonglong_uchar(&xp, nput, value ,fillp);
#line 856
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 856
		{
#line 856
			/* not fatal to the loop */
#line 856
			status = lstatus;
#line 856
		}
#line 856

#line 856
		(void) ncio_rel(ncp->nciop, offset,
#line 856
				 RGN_MODIFIED);
#line 856

#line 856
		remaining -= extent;
#line 856
		if(remaining == 0)
#line 856
			break; /* normal loop exit */
#line 856
		offset += (off_t)extent;
#line 856
		value += nput;
#line 856

#line 856
	}
#line 856
#ifdef ERANGE_FILL
#line 856
        free(fillp);
#line 856
#endif
#line 856

#line 856
	return status;
#line 856
}
#line 856

static int
#line 857
putNCvx_ulonglong_short(NC3_INFO* ncp, const NC_var *varp,
#line 857
		 const size_t *start, size_t nelems, const short *value)
#line 857
{
#line 857
	off_t offset = NC_varoffset(ncp, varp, start);
#line 857
	size_t remaining = varp->xsz * nelems;
#line 857
	int status = NC_NOERR;
#line 857
	void *xp;
#line 857
        void *fillp=NULL;
#line 857

#line 857
	if(nelems == 0)
#line 857
		return NC_NOERR;
#line 857

#line 857
	assert(value != NULL);
#line 857

#line 857
#ifdef ERANGE_FILL
#line 857
        fillp = malloc(varp->xsz);
#line 857
        status = NC3_inq_var_fill(varp, fillp);
#line 857
#endif
#line 857

#line 857
	for(;;)
#line 857
	{
#line 857
		size_t extent = MIN(remaining, ncp->chunk);
#line 857
		size_t nput = ncx_howmany(varp->type, extent);
#line 857

#line 857
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 857
				 RGN_WRITE, &xp);
#line 857
		if(lstatus != NC_NOERR)
#line 857
			return lstatus;
#line 857

#line 857
		lstatus = ncx_putn_ulonglong_short(&xp, nput, value ,fillp);
#line 857
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 857
		{
#line 857
			/* not fatal to the loop */
#line 857
			status = lstatus;
#line 857
		}
#line 857

#line 857
		(void) ncio_rel(ncp->nciop, offset,
#line 857
				 RGN_MODIFIED);
#line 857

#line 857
		remaining -= extent;
#line 857
		if(remaining == 0)
#line 857
			break; /* normal loop exit */
#line 857
		offset += (off_t)extent;
#line 857
		value += nput;
#line 857

#line 857
	}
#line 857
#ifdef ERANGE_FILL
#line 857
        free(fillp);
#line 857
#endif
#line 857

#line 857
	return status;
#line 857
}
#line 857

static int
#line 858
putNCvx_ulonglong_int(NC3_INFO* ncp, const NC_var *varp,
#line 858
		 const size_t *start, size_t nelems, const int *value)
#line 858
{
#line 858
	off_t offset = NC_varoffset(ncp, varp, start);
#line 858
	size_t remaining = varp->xsz * nelems;
#line 858
	int status = NC_NOERR;
#line 858
	void *xp;
#line 858
        void *fillp=NULL;
#line 858

#line 858
	if(nelems == 0)
#line 858
		return NC_NOERR;
#line 858

#line 858
	assert(value != NULL);
#line 858

#line 858
#ifdef ERANGE_FILL
#line 858
        fillp = malloc(varp->xsz);
#line 858
        status = NC3_inq_var_fill(varp, fillp);
#line 858
#endif
#line 858

#line 858
	for(;;)
#line 858
	{
#line 858
		size_t extent = MIN(remaining, ncp->chunk);
#line 858
		size_t nput = ncx_howmany(varp->type, extent);
#line 858

#line 858
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 858
				 RGN_WRITE, &xp);
#line 858
		if(lstatus != NC_NOERR)
#line 858
			return lstatus;
#line 858

#line 858
		lstatus = ncx_putn_ulonglong_int(&xp, nput, value ,fillp);
#line 858
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 858
		{
#line 858
			/* not fatal to the loop */
#line 858
			status = lstatus;
#line 858
		}
#line 858

#line 858
		(void) ncio_rel(ncp->nciop, offset,
#line 858
				 RGN_MODIFIED);
#line 858

#line 858
		remaining -= extent;
#line 858
		if(remaining == 0)
#line 858
			break; /* normal loop exit */
#line 858
		offset += (off_t)extent;
#line 858
		value += nput;
#line 858

#line 858
	}
#line 858
#ifdef ERANGE_FILL
#line 858
        free(fillp);
#line 858
#endif
#line 858

#line 858
	return status;
#line 858
}
#line 858

static int
#line 859
putNCvx_ulonglong_float(NC3_INFO* ncp, const NC_var *varp,
#line 859
		 const size_t *start, size_t nelems, const float *value)
#line 859
{
#line 859
	off_t offset = NC_varoffset(ncp, varp, start);
#line 859
	size_t remaining = varp->xsz * nelems;
#line 859
	int status = NC_NOERR;
#line 859
	void *xp;
#line 859
        void *fillp=NULL;
#line 859

#line 859
	if(nelems == 0)
#line 859
		return NC_NOERR;
#line 859

#line 859
	assert(value != NULL);
#line 859

#line 859
#ifdef ERANGE_FILL
#line 859
        fillp = malloc(varp->xsz);
#line 859
        status = NC3_inq_var_fill(varp, fillp);
#line 859
#endif
#line 859

#line 859
	for(;;)
#line 859
	{
#line 859
		size_t extent = MIN(remaining, ncp->chunk);
#line 859
		size_t nput = ncx_howmany(varp->type, extent);
#line 859

#line 859
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 859
				 RGN_WRITE, &xp);
#line 859
		if(lstatus != NC_NOERR)
#line 859
			return lstatus;
#line 859

#line 859
		lstatus = ncx_putn_ulonglong_float(&xp, nput, value ,fillp);
#line 859
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 859
		{
#line 859
			/* not fatal to the loop */
#line 859
			status = lstatus;
#line 859
		}
#line 859

#line 859
		(void) ncio_rel(ncp->nciop, offset,
#line 859
				 RGN_MODIFIED);
#line 859

#line 859
		remaining -= extent;
#line 859
		if(remaining == 0)
#line 859
			break; /* normal loop exit */
#line 859
		offset += (off_t)extent;
#line 859
		value += nput;
#line 859

#line 859
	}
#line 859
#ifdef ERANGE_FILL
#line 859
        free(fillp);
#line 859
#endif
#line 859

#line 859
	return status;
#line 859
}
#line 859

static int
#line 860
putNCvx_ulonglong_double(NC3_INFO* ncp, const NC_var *varp,
#line 860
		 const size_t *start, size_t nelems, const double *value)
#line 860
{
#line 860
	off_t offset = NC_varoffset(ncp, varp, start);
#line 860
	size_t remaining = varp->xsz * nelems;
#line 860
	int status = NC_NOERR;
#line 860
	void *xp;
#line 860
        void *fillp=NULL;
#line 860

#line 860
	if(nelems == 0)
#line 860
		return NC_NOERR;
#line 860

#line 860
	assert(value != NULL);
#line 860

#line 860
#ifdef ERANGE_FILL
#line 860
        fillp = malloc(varp->xsz);
#line 860
        status = NC3_inq_var_fill(varp, fillp);
#line 860
#endif
#line 860

#line 860
	for(;;)
#line 860
	{
#line 860
		size_t extent = MIN(remaining, ncp->chunk);
#line 860
		size_t nput = ncx_howmany(varp->type, extent);
#line 860

#line 860
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 860
				 RGN_WRITE, &xp);
#line 860
		if(lstatus != NC_NOERR)
#line 860
			return lstatus;
#line 860

#line 860
		lstatus = ncx_putn_ulonglong_double(&xp, nput, value ,fillp);
#line 860
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 860
		{
#line 860
			/* not fatal to the loop */
#line 860
			status = lstatus;
#line 860
		}
#line 860

#line 860
		(void) ncio_rel(ncp->nciop, offset,
#line 860
				 RGN_MODIFIED);
#line 860

#line 860
		remaining -= extent;
#line 860
		if(remaining == 0)
#line 860
			break; /* normal loop exit */
#line 860
		offset += (off_t)extent;
#line 860
		value += nput;
#line 860

#line 860
	}
#line 860
#ifdef ERANGE_FILL
#line 860
        free(fillp);
#line 860
#endif
#line 860

#line 860
	return status;
#line 860
}
#line 860

static int
#line 861
putNCvx_ulonglong_longlong(NC3_INFO* ncp, const NC_var *varp,
#line 861
		 const size_t *start, size_t nelems, const longlong *value)
#line 861
{
#line 861
	off_t offset = NC_varoffset(ncp, varp, start);
#line 861
	size_t remaining = varp->xsz * nelems;
#line 861
	int status = NC_NOERR;
#line 861
	void *xp;
#line 861
        void *fillp=NULL;
#line 861

#line 861
	if(nelems == 0)
#line 861
		return NC_NOERR;
#line 861

#line 861
	assert(value != NULL);
#line 861

#line 861
#ifdef ERANGE_FILL
#line 861
        fillp = malloc(varp->xsz);
#line 861
        status = NC3_inq_var_fill(varp, fillp);
#line 861
#endif
#line 861

#line 861
	for(;;)
#line 861
	{
#line 861
		size_t extent = MIN(remaining, ncp->chunk);
#line 861
		size_t nput = ncx_howmany(varp->type, extent);
#line 861

#line 861
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 861
				 RGN_WRITE, &xp);
#line 861
		if(lstatus != NC_NOERR)
#line 861
			return lstatus;
#line 861

#line 861
		lstatus = ncx_putn_ulonglong_longlong(&xp, nput, value ,fillp);
#line 861
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 861
		{
#line 861
			/* not fatal to the loop */
#line 861
			status = lstatus;
#line 861
		}
#line 861

#line 861
		(void) ncio_rel(ncp->nciop, offset,
#line 861
				 RGN_MODIFIED);
#line 861

#line 861
		remaining -= extent;
#line 861
		if(remaining == 0)
#line 861
			break; /* normal loop exit */
#line 861
		offset += (off_t)extent;
#line 861
		value += nput;
#line 861

#line 861
	}
#line 861
#ifdef ERANGE_FILL
#line 861
        free(fillp);
#line 861
#endif
#line 861

#line 861
	return status;
#line 861
}
#line 861

static int
#line 862
putNCvx_ulonglong_ushort(NC3_INFO* ncp, const NC_var *varp,
#line 862
		 const size_t *start, size_t nelems, const ushort *value)
#line 862
{
#line 862
	off_t offset = NC_varoffset(ncp, varp, start);
#line 862
	size_t remaining = varp->xsz * nelems;
#line 862
	int status = NC_NOERR;
#line 862
	void *xp;
#line 862
        void *fillp=NULL;
#line 862

#line 862
	if(nelems == 0)
#line 862
		return NC_NOERR;
#line 862

#line 862
	assert(value != NULL);
#line 862

#line 862
#ifdef ERANGE_FILL
#line 862
        fillp = malloc(varp->xsz);
#line 862
        status = NC3_inq_var_fill(varp, fillp);
#line 862
#endif
#line 862

#line 862
	for(;;)
#line 862
	{
#line 862
		size_t extent = MIN(remaining, ncp->chunk);
#line 862
		size_t nput = ncx_howmany(varp->type, extent);
#line 862

#line 862
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 862
				 RGN_WRITE, &xp);
#line 862
		if(lstatus != NC_NOERR)
#line 862
			return lstatus;
#line 862

#line 862
		lstatus = ncx_putn_ulonglong_ushort(&xp, nput, value ,fillp);
#line 862
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 862
		{
#line 862
			/* not fatal to the loop */
#line 862
			status = lstatus;
#line 862
		}
#line 862

#line 862
		(void) ncio_rel(ncp->nciop, offset,
#line 862
				 RGN_MODIFIED);
#line 862

#line 862
		remaining -= extent;
#line 862
		if(remaining == 0)
#line 862
			break; /* normal loop exit */
#line 862
		offset += (off_t)extent;
#line 862
		value += nput;
#line 862

#line 862
	}
#line 862
#ifdef ERANGE_FILL
#line 862
        free(fillp);
#line 862
#endif
#line 862

#line 862
	return status;
#line 862
}
#line 862

static int
#line 863
putNCvx_ulonglong_uint(NC3_INFO* ncp, const NC_var *varp,
#line 863
		 const size_t *start, size_t nelems, const uint *value)
#line 863
{
#line 863
	off_t offset = NC_varoffset(ncp, varp, start);
#line 863
	size_t remaining = varp->xsz * nelems;
#line 863
	int status = NC_NOERR;
#line 863
	void *xp;
#line 863
        void *fillp=NULL;
#line 863

#line 863
	if(nelems == 0)
#line 863
		return NC_NOERR;
#line 863

#line 863
	assert(value != NULL);
#line 863

#line 863
#ifdef ERANGE_FILL
#line 863
        fillp = malloc(varp->xsz);
#line 863
        status = NC3_inq_var_fill(varp, fillp);
#line 863
#endif
#line 863

#line 863
	for(;;)
#line 863
	{
#line 863
		size_t extent = MIN(remaining, ncp->chunk);
#line 863
		size_t nput = ncx_howmany(varp->type, extent);
#line 863

#line 863
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 863
				 RGN_WRITE, &xp);
#line 863
		if(lstatus != NC_NOERR)
#line 863
			return lstatus;
#line 863

#line 863
		lstatus = ncx_putn_ulonglong_uint(&xp, nput, value ,fillp);
#line 863
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 863
		{
#line 863
			/* not fatal to the loop */
#line 863
			status = lstatus;
#line 863
		}
#line 863

#line 863
		(void) ncio_rel(ncp->nciop, offset,
#line 863
				 RGN_MODIFIED);
#line 863

#line 863
		remaining -= extent;
#line 863
		if(remaining == 0)
#line 863
			break; /* normal loop exit */
#line 863
		offset += (off_t)extent;
#line 863
		value += nput;
#line 863

#line 863
	}
#line 863
#ifdef ERANGE_FILL
#line 863
        free(fillp);
#line 863
#endif
#line 863

#line 863
	return status;
#line 863
}
#line 863

static int
#line 864
putNCvx_ulonglong_ulonglong(NC3_INFO* ncp, const NC_var *varp,
#line 864
		 const size_t *start, size_t nelems, const ulonglong *value)
#line 864
{
#line 864
	off_t offset = NC_varoffset(ncp, varp, start);
#line 864
	size_t remaining = varp->xsz * nelems;
#line 864
	int status = NC_NOERR;
#line 864
	void *xp;
#line 864
        void *fillp=NULL;
#line 864

#line 864
	if(nelems == 0)
#line 864
		return NC_NOERR;
#line 864

#line 864
	assert(value != NULL);
#line 864

#line 864
#ifdef ERANGE_FILL
#line 864
        fillp = malloc(varp->xsz);
#line 864
        status = NC3_inq_var_fill(varp, fillp);
#line 864
#endif
#line 864

#line 864
	for(;;)
#line 864
	{
#line 864
		size_t extent = MIN(remaining, ncp->chunk);
#line 864
		size_t nput = ncx_howmany(varp->type, extent);
#line 864

#line 864
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 864
				 RGN_WRITE, &xp);
#line 864
		if(lstatus != NC_NOERR)
#line 864
			return lstatus;
#line 864

#line 864
		lstatus = ncx_putn_ulonglong_ulonglong(&xp, nput, value ,fillp);
#line 864
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 864
		{
#line 864
			/* not fatal to the loop */
#line 864
			status = lstatus;
#line 864
		}
#line 864

#line 864
		(void) ncio_rel(ncp->nciop, offset,
#line 864
				 RGN_MODIFIED);
#line 864

#line 864
		remaining -= extent;
#line 864
		if(remaining == 0)
#line 864
			break; /* normal loop exit */
#line 864
		offset += (off_t)extent;
#line 864
		value += nput;
#line 864

#line 864
	}
#line 864
#ifdef ERANGE_FILL
#line 864
        free(fillp);
#line 864
#endif
#line 864

#line 864
	return status;
#line 864
}
#line 864


#line 911

static int
#line 912
getNCvx_char_char(const NC3_INFO* ncp, const NC_var *varp,
#line 912
		 const size_t *start, size_t nelems, char *value)
#line 912
{
#line 912
	off_t offset = NC_varoffset(ncp, varp, start);
#line 912
	size_t remaining = varp->xsz * nelems;
#line 912
	int status = NC_NOERR;
#line 912
	const void *xp;
#line 912

#line 912
	if(nelems == 0)
#line 912
		return NC_NOERR;
#line 912

#line 912
	assert(value != NULL);
#line 912

#line 912
	for(;;)
#line 912
	{
#line 912
		size_t extent = MIN(remaining, ncp->chunk);
#line 912
		size_t nget = ncx_howmany(varp->type, extent);
#line 912

#line 912
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 912
				 0, (void **)&xp);	/* cast away const */
#line 912
		if(lstatus != NC_NOERR)
#line 912
			return lstatus;
#line 912

#line 912
		lstatus = ncx_getn_char_char(&xp, nget, value);
#line 912
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 912
			status = lstatus;
#line 912

#line 912
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 912

#line 912
		remaining -= extent;
#line 912
		if(remaining == 0)
#line 912
			break; /* normal loop exit */
#line 912
		offset += (off_t)extent;
#line 912
		value += nget;
#line 912
	}
#line 912

#line 912
	return status;
#line 912
}
#line 912


static int
#line 914
getNCvx_schar_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 914
		 const size_t *start, size_t nelems, schar *value)
#line 914
{
#line 914
	off_t offset = NC_varoffset(ncp, varp, start);
#line 914
	size_t remaining = varp->xsz * nelems;
#line 914
	int status = NC_NOERR;
#line 914
	const void *xp;
#line 914

#line 914
	if(nelems == 0)
#line 914
		return NC_NOERR;
#line 914

#line 914
	assert(value != NULL);
#line 914

#line 914
	for(;;)
#line 914
	{
#line 914
		size_t extent = MIN(remaining, ncp->chunk);
#line 914
		size_t nget = ncx_howmany(varp->type, extent);
#line 914

#line 914
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 914
				 0, (void **)&xp);	/* cast away const */
#line 914
		if(lstatus != NC_NOERR)
#line 914
			return lstatus;
#line 914

#line 914
		lstatus = ncx_getn_schar_schar(&xp, nget, value);
#line 914
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 914
			status = lstatus;
#line 914

#line 914
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 914

#line 914
		remaining -= extent;
#line 914
		if(remaining == 0)
#line 914
			break; /* normal loop exit */
#line 914
		offset += (off_t)extent;
#line 914
		value += nget;
#line 914
	}
#line 914

#line 914
	return status;
#line 914
}
#line 914

static int
#line 915
getNCvx_schar_short(const NC3_INFO* ncp, const NC_var *varp,
#line 915
		 const size_t *start, size_t nelems, short *value)
#line 915
{
#line 915
	off_t offset = NC_varoffset(ncp, varp, start);
#line 915
	size_t remaining = varp->xsz * nelems;
#line 915
	int status = NC_NOERR;
#line 915
	const void *xp;
#line 915

#line 915
	if(nelems == 0)
#line 915
		return NC_NOERR;
#line 915

#line 915
	assert(value != NULL);
#line 915

#line 915
	for(;;)
#line 915
	{
#line 915
		size_t extent = MIN(remaining, ncp->chunk);
#line 915
		size_t nget = ncx_howmany(varp->type, extent);
#line 915

#line 915
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 915
				 0, (void **)&xp);	/* cast away const */
#line 915
		if(lstatus != NC_NOERR)
#line 915
			return lstatus;
#line 915

#line 915
		lstatus = ncx_getn_schar_short(&xp, nget, value);
#line 915
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 915
			status = lstatus;
#line 915

#line 915
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 915

#line 915
		remaining -= extent;
#line 915
		if(remaining == 0)
#line 915
			break; /* normal loop exit */
#line 915
		offset += (off_t)extent;
#line 915
		value += nget;
#line 915
	}
#line 915

#line 915
	return status;
#line 915
}
#line 915

static int
#line 916
getNCvx_schar_int(const NC3_INFO* ncp, const NC_var *varp,
#line 916
		 const size_t *start, size_t nelems, int *value)
#line 916
{
#line 916
	off_t offset = NC_varoffset(ncp, varp, start);
#line 916
	size_t remaining = varp->xsz * nelems;
#line 916
	int status = NC_NOERR;
#line 916
	const void *xp;
#line 916

#line 916
	if(nelems == 0)
#line 916
		return NC_NOERR;
#line 916

#line 916
	assert(value != NULL);
#line 916

#line 916
	for(;;)
#line 916
	{
#line 916
		size_t extent = MIN(remaining, ncp->chunk);
#line 916
		size_t nget = ncx_howmany(varp->type, extent);
#line 916

#line 916
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 916
				 0, (void **)&xp);	/* cast away const */
#line 916
		if(lstatus != NC_NOERR)
#line 916
			return lstatus;
#line 916

#line 916
		lstatus = ncx_getn_schar_int(&xp, nget, value);
#line 916
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 916
			status = lstatus;
#line 916

#line 916
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 916

#line 916
		remaining -= extent;
#line 916
		if(remaining == 0)
#line 916
			break; /* normal loop exit */
#line 916
		offset += (off_t)extent;
#line 916
		value += nget;
#line 916
	}
#line 916

#line 916
	return status;
#line 916
}
#line 916

static int
#line 917
getNCvx_schar_float(const NC3_INFO* ncp, const NC_var *varp,
#line 917
		 const size_t *start, size_t nelems, float *value)
#line 917
{
#line 917
	off_t offset = NC_varoffset(ncp, varp, start);
#line 917
	size_t remaining = varp->xsz * nelems;
#line 917
	int status = NC_NOERR;
#line 917
	const void *xp;
#line 917

#line 917
	if(nelems == 0)
#line 917
		return NC_NOERR;
#line 917

#line 917
	assert(value != NULL);
#line 917

#line 917
	for(;;)
#line 917
	{
#line 917
		size_t extent = MIN(remaining, ncp->chunk);
#line 917
		size_t nget = ncx_howmany(varp->type, extent);
#line 917

#line 917
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 917
				 0, (void **)&xp);	/* cast away const */
#line 917
		if(lstatus != NC_NOERR)
#line 917
			return lstatus;
#line 917

#line 917
		lstatus = ncx_getn_schar_float(&xp, nget, value);
#line 917
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 917
			status = lstatus;
#line 917

#line 917
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 917

#line 917
		remaining -= extent;
#line 917
		if(remaining == 0)
#line 917
			break; /* normal loop exit */
#line 917
		offset += (off_t)extent;
#line 917
		value += nget;
#line 917
	}
#line 917

#line 917
	return status;
#line 917
}
#line 917

static int
#line 918
getNCvx_schar_double(const NC3_INFO* ncp, const NC_var *varp,
#line 918
		 const size_t *start, size_t nelems, double *value)
#line 918
{
#line 918
	off_t offset = NC_varoffset(ncp, varp, start);
#line 918
	size_t remaining = varp->xsz * nelems;
#line 918
	int status = NC_NOERR;
#line 918
	const void *xp;
#line 918

#line 918
	if(nelems == 0)
#line 918
		return NC_NOERR;
#line 918

#line 918
	assert(value != NULL);
#line 918

#line 918
	for(;;)
#line 918
	{
#line 918
		size_t extent = MIN(remaining, ncp->chunk);
#line 918
		size_t nget = ncx_howmany(varp->type, extent);
#line 918

#line 918
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 918
				 0, (void **)&xp);	/* cast away const */
#line 918
		if(lstatus != NC_NOERR)
#line 918
			return lstatus;
#line 918

#line 918
		lstatus = ncx_getn_schar_double(&xp, nget, value);
#line 918
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 918
			status = lstatus;
#line 918

#line 918
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 918

#line 918
		remaining -= extent;
#line 918
		if(remaining == 0)
#line 918
			break; /* normal loop exit */
#line 918
		offset += (off_t)extent;
#line 918
		value += nget;
#line 918
	}
#line 918

#line 918
	return status;
#line 918
}
#line 918

static int
#line 919
getNCvx_schar_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 919
		 const size_t *start, size_t nelems, longlong *value)
#line 919
{
#line 919
	off_t offset = NC_varoffset(ncp, varp, start);
#line 919
	size_t remaining = varp->xsz * nelems;
#line 919
	int status = NC_NOERR;
#line 919
	const void *xp;
#line 919

#line 919
	if(nelems == 0)
#line 919
		return NC_NOERR;
#line 919

#line 919
	assert(value != NULL);
#line 919

#line 919
	for(;;)
#line 919
	{
#line 919
		size_t extent = MIN(remaining, ncp->chunk);
#line 919
		size_t nget = ncx_howmany(varp->type, extent);
#line 919

#line 919
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 919
				 0, (void **)&xp);	/* cast away const */
#line 919
		if(lstatus != NC_NOERR)
#line 919
			return lstatus;
#line 919

#line 919
		lstatus = ncx_getn_schar_longlong(&xp, nget, value);
#line 919
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 919
			status = lstatus;
#line 919

#line 919
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 919

#line 919
		remaining -= extent;
#line 919
		if(remaining == 0)
#line 919
			break; /* normal loop exit */
#line 919
		offset += (off_t)extent;
#line 919
		value += nget;
#line 919
	}
#line 919

#line 919
	return status;
#line 919
}
#line 919

static int
#line 920
getNCvx_schar_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 920
		 const size_t *start, size_t nelems, uint *value)
#line 920
{
#line 920
	off_t offset = NC_varoffset(ncp, varp, start);
#line 920
	size_t remaining = varp->xsz * nelems;
#line 920
	int status = NC_NOERR;
#line 920
	const void *xp;
#line 920

#line 920
	if(nelems == 0)
#line 920
		return NC_NOERR;
#line 920

#line 920
	assert(value != NULL);
#line 920

#line 920
	for(;;)
#line 920
	{
#line 920
		size_t extent = MIN(remaining, ncp->chunk);
#line 920
		size_t nget = ncx_howmany(varp->type, extent);
#line 920

#line 920
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 920
				 0, (void **)&xp);	/* cast away const */
#line 920
		if(lstatus != NC_NOERR)
#line 920
			return lstatus;
#line 920

#line 920
		lstatus = ncx_getn_schar_uint(&xp, nget, value);
#line 920
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 920
			status = lstatus;
#line 920

#line 920
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 920

#line 920
		remaining -= extent;
#line 920
		if(remaining == 0)
#line 920
			break; /* normal loop exit */
#line 920
		offset += (off_t)extent;
#line 920
		value += nget;
#line 920
	}
#line 920

#line 920
	return status;
#line 920
}
#line 920

static int
#line 921
getNCvx_schar_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 921
		 const size_t *start, size_t nelems, ulonglong *value)
#line 921
{
#line 921
	off_t offset = NC_varoffset(ncp, varp, start);
#line 921
	size_t remaining = varp->xsz * nelems;
#line 921
	int status = NC_NOERR;
#line 921
	const void *xp;
#line 921

#line 921
	if(nelems == 0)
#line 921
		return NC_NOERR;
#line 921

#line 921
	assert(value != NULL);
#line 921

#line 921
	for(;;)
#line 921
	{
#line 921
		size_t extent = MIN(remaining, ncp->chunk);
#line 921
		size_t nget = ncx_howmany(varp->type, extent);
#line 921

#line 921
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 921
				 0, (void **)&xp);	/* cast away const */
#line 921
		if(lstatus != NC_NOERR)
#line 921
			return lstatus;
#line 921

#line 921
		lstatus = ncx_getn_schar_ulonglong(&xp, nget, value);
#line 921
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 921
			status = lstatus;
#line 921

#line 921
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 921

#line 921
		remaining -= extent;
#line 921
		if(remaining == 0)
#line 921
			break; /* normal loop exit */
#line 921
		offset += (off_t)extent;
#line 921
		value += nget;
#line 921
	}
#line 921

#line 921
	return status;
#line 921
}
#line 921

static int
#line 922
getNCvx_schar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 922
		 const size_t *start, size_t nelems, uchar *value)
#line 922
{
#line 922
	off_t offset = NC_varoffset(ncp, varp, start);
#line 922
	size_t remaining = varp->xsz * nelems;
#line 922
	int status = NC_NOERR;
#line 922
	const void *xp;
#line 922

#line 922
	if(nelems == 0)
#line 922
		return NC_NOERR;
#line 922

#line 922
	assert(value != NULL);
#line 922

#line 922
	for(;;)
#line 922
	{
#line 922
		size_t extent = MIN(remaining, ncp->chunk);
#line 922
		size_t nget = ncx_howmany(varp->type, extent);
#line 922

#line 922
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 922
				 0, (void **)&xp);	/* cast away const */
#line 922
		if(lstatus != NC_NOERR)
#line 922
			return lstatus;
#line 922

#line 922
		lstatus = ncx_getn_schar_uchar(&xp, nget, value);
#line 922
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 922
			status = lstatus;
#line 922

#line 922
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 922

#line 922
		remaining -= extent;
#line 922
		if(remaining == 0)
#line 922
			break; /* normal loop exit */
#line 922
		offset += (off_t)extent;
#line 922
		value += nget;
#line 922
	}
#line 922

#line 922
	return status;
#line 922
}
#line 922

static int
#line 923
getNCvx_schar_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 923
		 const size_t *start, size_t nelems, ushort *value)
#line 923
{
#line 923
	off_t offset = NC_varoffset(ncp, varp, start);
#line 923
	size_t remaining = varp->xsz * nelems;
#line 923
	int status = NC_NOERR;
#line 923
	const void *xp;
#line 923

#line 923
	if(nelems == 0)
#line 923
		return NC_NOERR;
#line 923

#line 923
	assert(value != NULL);
#line 923

#line 923
	for(;;)
#line 923
	{
#line 923
		size_t extent = MIN(remaining, ncp->chunk);
#line 923
		size_t nget = ncx_howmany(varp->type, extent);
#line 923

#line 923
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 923
				 0, (void **)&xp);	/* cast away const */
#line 923
		if(lstatus != NC_NOERR)
#line 923
			return lstatus;
#line 923

#line 923
		lstatus = ncx_getn_schar_ushort(&xp, nget, value);
#line 923
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 923
			status = lstatus;
#line 923

#line 923
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 923

#line 923
		remaining -= extent;
#line 923
		if(remaining == 0)
#line 923
			break; /* normal loop exit */
#line 923
		offset += (off_t)extent;
#line 923
		value += nget;
#line 923
	}
#line 923

#line 923
	return status;
#line 923
}
#line 923


static int
#line 925
getNCvx_short_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 925
		 const size_t *start, size_t nelems, schar *value)
#line 925
{
#line 925
	off_t offset = NC_varoffset(ncp, varp, start);
#line 925
	size_t remaining = varp->xsz * nelems;
#line 925
	int status = NC_NOERR;
#line 925
	const void *xp;
#line 925

#line 925
	if(nelems == 0)
#line 925
		return NC_NOERR;
#line 925

#line 925
	assert(value != NULL);
#line 925

#line 925
	for(;;)
#line 925
	{
#line 925
		size_t extent = MIN(remaining, ncp->chunk);
#line 925
		size_t nget = ncx_howmany(varp->type, extent);
#line 925

#line 925
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 925
				 0, (void **)&xp);	/* cast away const */
#line 925
		if(lstatus != NC_NOERR)
#line 925
			return lstatus;
#line 925

#line 925
		lstatus = ncx_getn_short_schar(&xp, nget, value);
#line 925
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 925
			status = lstatus;
#line 925

#line 925
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 925

#line 925
		remaining -= extent;
#line 925
		if(remaining == 0)
#line 925
			break; /* normal loop exit */
#line 925
		offset += (off_t)extent;
#line 925
		value += nget;
#line 925
	}
#line 925

#line 925
	return status;
#line 925
}
#line 925

static int
#line 926
getNCvx_short_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 926
		 const size_t *start, size_t nelems, uchar *value)
#line 926
{
#line 926
	off_t offset = NC_varoffset(ncp, varp, start);
#line 926
	size_t remaining = varp->xsz * nelems;
#line 926
	int status = NC_NOERR;
#line 926
	const void *xp;
#line 926

#line 926
	if(nelems == 0)
#line 926
		return NC_NOERR;
#line 926

#line 926
	assert(value != NULL);
#line 926

#line 926
	for(;;)
#line 926
	{
#line 926
		size_t extent = MIN(remaining, ncp->chunk);
#line 926
		size_t nget = ncx_howmany(varp->type, extent);
#line 926

#line 926
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 926
				 0, (void **)&xp);	/* cast away const */
#line 926
		if(lstatus != NC_NOERR)
#line 926
			return lstatus;
#line 926

#line 926
		lstatus = ncx_getn_short_uchar(&xp, nget, value);
#line 926
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 926
			status = lstatus;
#line 926

#line 926
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 926

#line 926
		remaining -= extent;
#line 926
		if(remaining == 0)
#line 926
			break; /* normal loop exit */
#line 926
		offset += (off_t)extent;
#line 926
		value += nget;
#line 926
	}
#line 926

#line 926
	return status;
#line 926
}
#line 926

static int
#line 927
getNCvx_short_short(const NC3_INFO* ncp, const NC_var *varp,
#line 927
		 const size_t *start, size_t nelems, short *value)
#line 927
{
#line 927
	off_t offset = NC_varoffset(ncp, varp, start);
#line 927
	size_t remaining = varp->xsz * nelems;
#line 927
	int status = NC_NOERR;
#line 927
	const void *xp;
#line 927

#line 927
	if(nelems == 0)
#line 927
		return NC_NOERR;
#line 927

#line 927
	assert(value != NULL);
#line 927

#line 927
	for(;;)
#line 927
	{
#line 927
		size_t extent = MIN(remaining, ncp->chunk);
#line 927
		size_t nget = ncx_howmany(varp->type, extent);
#line 927

#line 927
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 927
				 0, (void **)&xp);	/* cast away const */
#line 927
		if(lstatus != NC_NOERR)
#line 927
			return lstatus;
#line 927

#line 927
		lstatus = ncx_getn_short_short(&xp, nget, value);
#line 927
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 927
			status = lstatus;
#line 927

#line 927
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 927

#line 927
		remaining -= extent;
#line 927
		if(remaining == 0)
#line 927
			break; /* normal loop exit */
#line 927
		offset += (off_t)extent;
#line 927
		value += nget;
#line 927
	}
#line 927

#line 927
	return status;
#line 927
}
#line 927

static int
#line 928
getNCvx_short_int(const NC3_INFO* ncp, const NC_var *varp,
#line 928
		 const size_t *start, size_t nelems, int *value)
#line 928
{
#line 928
	off_t offset = NC_varoffset(ncp, varp, start);
#line 928
	size_t remaining = varp->xsz * nelems;
#line 928
	int status = NC_NOERR;
#line 928
	const void *xp;
#line 928

#line 928
	if(nelems == 0)
#line 928
		return NC_NOERR;
#line 928

#line 928
	assert(value != NULL);
#line 928

#line 928
	for(;;)
#line 928
	{
#line 928
		size_t extent = MIN(remaining, ncp->chunk);
#line 928
		size_t nget = ncx_howmany(varp->type, extent);
#line 928

#line 928
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 928
				 0, (void **)&xp);	/* cast away const */
#line 928
		if(lstatus != NC_NOERR)
#line 928
			return lstatus;
#line 928

#line 928
		lstatus = ncx_getn_short_int(&xp, nget, value);
#line 928
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 928
			status = lstatus;
#line 928

#line 928
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 928

#line 928
		remaining -= extent;
#line 928
		if(remaining == 0)
#line 928
			break; /* normal loop exit */
#line 928
		offset += (off_t)extent;
#line 928
		value += nget;
#line 928
	}
#line 928

#line 928
	return status;
#line 928
}
#line 928

static int
#line 929
getNCvx_short_float(const NC3_INFO* ncp, const NC_var *varp,
#line 929
		 const size_t *start, size_t nelems, float *value)
#line 929
{
#line 929
	off_t offset = NC_varoffset(ncp, varp, start);
#line 929
	size_t remaining = varp->xsz * nelems;
#line 929
	int status = NC_NOERR;
#line 929
	const void *xp;
#line 929

#line 929
	if(nelems == 0)
#line 929
		return NC_NOERR;
#line 929

#line 929
	assert(value != NULL);
#line 929

#line 929
	for(;;)
#line 929
	{
#line 929
		size_t extent = MIN(remaining, ncp->chunk);
#line 929
		size_t nget = ncx_howmany(varp->type, extent);
#line 929

#line 929
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 929
				 0, (void **)&xp);	/* cast away const */
#line 929
		if(lstatus != NC_NOERR)
#line 929
			return lstatus;
#line 929

#line 929
		lstatus = ncx_getn_short_float(&xp, nget, value);
#line 929
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 929
			status = lstatus;
#line 929

#line 929
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 929

#line 929
		remaining -= extent;
#line 929
		if(remaining == 0)
#line 929
			break; /* normal loop exit */
#line 929
		offset += (off_t)extent;
#line 929
		value += nget;
#line 929
	}
#line 929

#line 929
	return status;
#line 929
}
#line 929

static int
#line 930
getNCvx_short_double(const NC3_INFO* ncp, const NC_var *varp,
#line 930
		 const size_t *start, size_t nelems, double *value)
#line 930
{
#line 930
	off_t offset = NC_varoffset(ncp, varp, start);
#line 930
	size_t remaining = varp->xsz * nelems;
#line 930
	int status = NC_NOERR;
#line 930
	const void *xp;
#line 930

#line 930
	if(nelems == 0)
#line 930
		return NC_NOERR;
#line 930

#line 930
	assert(value != NULL);
#line 930

#line 930
	for(;;)
#line 930
	{
#line 930
		size_t extent = MIN(remaining, ncp->chunk);
#line 930
		size_t nget = ncx_howmany(varp->type, extent);
#line 930

#line 930
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 930
				 0, (void **)&xp);	/* cast away const */
#line 930
		if(lstatus != NC_NOERR)
#line 930
			return lstatus;
#line 930

#line 930
		lstatus = ncx_getn_short_double(&xp, nget, value);
#line 930
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 930
			status = lstatus;
#line 930

#line 930
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 930

#line 930
		remaining -= extent;
#line 930
		if(remaining == 0)
#line 930
			break; /* normal loop exit */
#line 930
		offset += (off_t)extent;
#line 930
		value += nget;
#line 930
	}
#line 930

#line 930
	return status;
#line 930
}
#line 930

static int
#line 931
getNCvx_short_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 931
		 const size_t *start, size_t nelems, longlong *value)
#line 931
{
#line 931
	off_t offset = NC_varoffset(ncp, varp, start);
#line 931
	size_t remaining = varp->xsz * nelems;
#line 931
	int status = NC_NOERR;
#line 931
	const void *xp;
#line 931

#line 931
	if(nelems == 0)
#line 931
		return NC_NOERR;
#line 931

#line 931
	assert(value != NULL);
#line 931

#line 931
	for(;;)
#line 931
	{
#line 931
		size_t extent = MIN(remaining, ncp->chunk);
#line 931
		size_t nget = ncx_howmany(varp->type, extent);
#line 931

#line 931
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 931
				 0, (void **)&xp);	/* cast away const */
#line 931
		if(lstatus != NC_NOERR)
#line 931
			return lstatus;
#line 931

#line 931
		lstatus = ncx_getn_short_longlong(&xp, nget, value);
#line 931
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 931
			status = lstatus;
#line 931

#line 931
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 931

#line 931
		remaining -= extent;
#line 931
		if(remaining == 0)
#line 931
			break; /* normal loop exit */
#line 931
		offset += (off_t)extent;
#line 931
		value += nget;
#line 931
	}
#line 931

#line 931
	return status;
#line 931
}
#line 931

static int
#line 932
getNCvx_short_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 932
		 const size_t *start, size_t nelems, uint *value)
#line 932
{
#line 932
	off_t offset = NC_varoffset(ncp, varp, start);
#line 932
	size_t remaining = varp->xsz * nelems;
#line 932
	int status = NC_NOERR;
#line 932
	const void *xp;
#line 932

#line 932
	if(nelems == 0)
#line 932
		return NC_NOERR;
#line 932

#line 932
	assert(value != NULL);
#line 932

#line 932
	for(;;)
#line 932
	{
#line 932
		size_t extent = MIN(remaining, ncp->chunk);
#line 932
		size_t nget = ncx_howmany(varp->type, extent);
#line 932

#line 932
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 932
				 0, (void **)&xp);	/* cast away const */
#line 932
		if(lstatus != NC_NOERR)
#line 932
			return lstatus;
#line 932

#line 932
		lstatus = ncx_getn_short_uint(&xp, nget, value);
#line 932
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 932
			status = lstatus;
#line 932

#line 932
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 932

#line 932
		remaining -= extent;
#line 932
		if(remaining == 0)
#line 932
			break; /* normal loop exit */
#line 932
		offset += (off_t)extent;
#line 932
		value += nget;
#line 932
	}
#line 932

#line 932
	return status;
#line 932
}
#line 932

static int
#line 933
getNCvx_short_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 933
		 const size_t *start, size_t nelems, ulonglong *value)
#line 933
{
#line 933
	off_t offset = NC_varoffset(ncp, varp, start);
#line 933
	size_t remaining = varp->xsz * nelems;
#line 933
	int status = NC_NOERR;
#line 933
	const void *xp;
#line 933

#line 933
	if(nelems == 0)
#line 933
		return NC_NOERR;
#line 933

#line 933
	assert(value != NULL);
#line 933

#line 933
	for(;;)
#line 933
	{
#line 933
		size_t extent = MIN(remaining, ncp->chunk);
#line 933
		size_t nget = ncx_howmany(varp->type, extent);
#line 933

#line 933
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 933
				 0, (void **)&xp);	/* cast away const */
#line 933
		if(lstatus != NC_NOERR)
#line 933
			return lstatus;
#line 933

#line 933
		lstatus = ncx_getn_short_ulonglong(&xp, nget, value);
#line 933
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 933
			status = lstatus;
#line 933

#line 933
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 933

#line 933
		remaining -= extent;
#line 933
		if(remaining == 0)
#line 933
			break; /* normal loop exit */
#line 933
		offset += (off_t)extent;
#line 933
		value += nget;
#line 933
	}
#line 933

#line 933
	return status;
#line 933
}
#line 933

static int
#line 934
getNCvx_short_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 934
		 const size_t *start, size_t nelems, ushort *value)
#line 934
{
#line 934
	off_t offset = NC_varoffset(ncp, varp, start);
#line 934
	size_t remaining = varp->xsz * nelems;
#line 934
	int status = NC_NOERR;
#line 934
	const void *xp;
#line 934

#line 934
	if(nelems == 0)
#line 934
		return NC_NOERR;
#line 934

#line 934
	assert(value != NULL);
#line 934

#line 934
	for(;;)
#line 934
	{
#line 934
		size_t extent = MIN(remaining, ncp->chunk);
#line 934
		size_t nget = ncx_howmany(varp->type, extent);
#line 934

#line 934
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 934
				 0, (void **)&xp);	/* cast away const */
#line 934
		if(lstatus != NC_NOERR)
#line 934
			return lstatus;
#line 934

#line 934
		lstatus = ncx_getn_short_ushort(&xp, nget, value);
#line 934
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 934
			status = lstatus;
#line 934

#line 934
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 934

#line 934
		remaining -= extent;
#line 934
		if(remaining == 0)
#line 934
			break; /* normal loop exit */
#line 934
		offset += (off_t)extent;
#line 934
		value += nget;
#line 934
	}
#line 934

#line 934
	return status;
#line 934
}
#line 934


static int
#line 936
getNCvx_int_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 936
		 const size_t *start, size_t nelems, schar *value)
#line 936
{
#line 936
	off_t offset = NC_varoffset(ncp, varp, start);
#line 936
	size_t remaining = varp->xsz * nelems;
#line 936
	int status = NC_NOERR;
#line 936
	const void *xp;
#line 936

#line 936
	if(nelems == 0)
#line 936
		return NC_NOERR;
#line 936

#line 936
	assert(value != NULL);
#line 936

#line 936
	for(;;)
#line 936
	{
#line 936
		size_t extent = MIN(remaining, ncp->chunk);
#line 936
		size_t nget = ncx_howmany(varp->type, extent);
#line 936

#line 936
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 936
				 0, (void **)&xp);	/* cast away const */
#line 936
		if(lstatus != NC_NOERR)
#line 936
			return lstatus;
#line 936

#line 936
		lstatus = ncx_getn_int_schar(&xp, nget, value);
#line 936
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 936
			status = lstatus;
#line 936

#line 936
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 936

#line 936
		remaining -= extent;
#line 936
		if(remaining == 0)
#line 936
			break; /* normal loop exit */
#line 936
		offset += (off_t)extent;
#line 936
		value += nget;
#line 936
	}
#line 936

#line 936
	return status;
#line 936
}
#line 936

static int
#line 937
getNCvx_int_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 937
		 const size_t *start, size_t nelems, uchar *value)
#line 937
{
#line 937
	off_t offset = NC_varoffset(ncp, varp, start);
#line 937
	size_t remaining = varp->xsz * nelems;
#line 937
	int status = NC_NOERR;
#line 937
	const void *xp;
#line 937

#line 937
	if(nelems == 0)
#line 937
		return NC_NOERR;
#line 937

#line 937
	assert(value != NULL);
#line 937

#line 937
	for(;;)
#line 937
	{
#line 937
		size_t extent = MIN(remaining, ncp->chunk);
#line 937
		size_t nget = ncx_howmany(varp->type, extent);
#line 937

#line 937
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 937
				 0, (void **)&xp);	/* cast away const */
#line 937
		if(lstatus != NC_NOERR)
#line 937
			return lstatus;
#line 937

#line 937
		lstatus = ncx_getn_int_uchar(&xp, nget, value);
#line 937
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 937
			status = lstatus;
#line 937

#line 937
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 937

#line 937
		remaining -= extent;
#line 937
		if(remaining == 0)
#line 937
			break; /* normal loop exit */
#line 937
		offset += (off_t)extent;
#line 937
		value += nget;
#line 937
	}
#line 937

#line 937
	return status;
#line 937
}
#line 937

static int
#line 938
getNCvx_int_short(const NC3_INFO* ncp, const NC_var *varp,
#line 938
		 const size_t *start, size_t nelems, short *value)
#line 938
{
#line 938
	off_t offset = NC_varoffset(ncp, varp, start);
#line 938
	size_t remaining = varp->xsz * nelems;
#line 938
	int status = NC_NOERR;
#line 938
	const void *xp;
#line 938

#line 938
	if(nelems == 0)
#line 938
		return NC_NOERR;
#line 938

#line 938
	assert(value != NULL);
#line 938

#line 938
	for(;;)
#line 938
	{
#line 938
		size_t extent = MIN(remaining, ncp->chunk);
#line 938
		size_t nget = ncx_howmany(varp->type, extent);
#line 938

#line 938
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 938
				 0, (void **)&xp);	/* cast away const */
#line 938
		if(lstatus != NC_NOERR)
#line 938
			return lstatus;
#line 938

#line 938
		lstatus = ncx_getn_int_short(&xp, nget, value);
#line 938
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 938
			status = lstatus;
#line 938

#line 938
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 938

#line 938
		remaining -= extent;
#line 938
		if(remaining == 0)
#line 938
			break; /* normal loop exit */
#line 938
		offset += (off_t)extent;
#line 938
		value += nget;
#line 938
	}
#line 938

#line 938
	return status;
#line 938
}
#line 938

static int
#line 939
getNCvx_int_int(const NC3_INFO* ncp, const NC_var *varp,
#line 939
		 const size_t *start, size_t nelems, int *value)
#line 939
{
#line 939
	off_t offset = NC_varoffset(ncp, varp, start);
#line 939
	size_t remaining = varp->xsz * nelems;
#line 939
	int status = NC_NOERR;
#line 939
	const void *xp;
#line 939

#line 939
	if(nelems == 0)
#line 939
		return NC_NOERR;
#line 939

#line 939
	assert(value != NULL);
#line 939

#line 939
	for(;;)
#line 939
	{
#line 939
		size_t extent = MIN(remaining, ncp->chunk);
#line 939
		size_t nget = ncx_howmany(varp->type, extent);
#line 939

#line 939
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 939
				 0, (void **)&xp);	/* cast away const */
#line 939
		if(lstatus != NC_NOERR)
#line 939
			return lstatus;
#line 939

#line 939
		lstatus = ncx_getn_int_int(&xp, nget, value);
#line 939
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 939
			status = lstatus;
#line 939

#line 939
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 939

#line 939
		remaining -= extent;
#line 939
		if(remaining == 0)
#line 939
			break; /* normal loop exit */
#line 939
		offset += (off_t)extent;
#line 939
		value += nget;
#line 939
	}
#line 939

#line 939
	return status;
#line 939
}
#line 939

static int
#line 940
getNCvx_int_float(const NC3_INFO* ncp, const NC_var *varp,
#line 940
		 const size_t *start, size_t nelems, float *value)
#line 940
{
#line 940
	off_t offset = NC_varoffset(ncp, varp, start);
#line 940
	size_t remaining = varp->xsz * nelems;
#line 940
	int status = NC_NOERR;
#line 940
	const void *xp;
#line 940

#line 940
	if(nelems == 0)
#line 940
		return NC_NOERR;
#line 940

#line 940
	assert(value != NULL);
#line 940

#line 940
	for(;;)
#line 940
	{
#line 940
		size_t extent = MIN(remaining, ncp->chunk);
#line 940
		size_t nget = ncx_howmany(varp->type, extent);
#line 940

#line 940
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 940
				 0, (void **)&xp);	/* cast away const */
#line 940
		if(lstatus != NC_NOERR)
#line 940
			return lstatus;
#line 940

#line 940
		lstatus = ncx_getn_int_float(&xp, nget, value);
#line 940
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 940
			status = lstatus;
#line 940

#line 940
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 940

#line 940
		remaining -= extent;
#line 940
		if(remaining == 0)
#line 940
			break; /* normal loop exit */
#line 940
		offset += (off_t)extent;
#line 940
		value += nget;
#line 940
	}
#line 940

#line 940
	return status;
#line 940
}
#line 940

static int
#line 941
getNCvx_int_double(const NC3_INFO* ncp, const NC_var *varp,
#line 941
		 const size_t *start, size_t nelems, double *value)
#line 941
{
#line 941
	off_t offset = NC_varoffset(ncp, varp, start);
#line 941
	size_t remaining = varp->xsz * nelems;
#line 941
	int status = NC_NOERR;
#line 941
	const void *xp;
#line 941

#line 941
	if(nelems == 0)
#line 941
		return NC_NOERR;
#line 941

#line 941
	assert(value != NULL);
#line 941

#line 941
	for(;;)
#line 941
	{
#line 941
		size_t extent = MIN(remaining, ncp->chunk);
#line 941
		size_t nget = ncx_howmany(varp->type, extent);
#line 941

#line 941
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 941
				 0, (void **)&xp);	/* cast away const */
#line 941
		if(lstatus != NC_NOERR)
#line 941
			return lstatus;
#line 941

#line 941
		lstatus = ncx_getn_int_double(&xp, nget, value);
#line 941
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 941
			status = lstatus;
#line 941

#line 941
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 941

#line 941
		remaining -= extent;
#line 941
		if(remaining == 0)
#line 941
			break; /* normal loop exit */
#line 941
		offset += (off_t)extent;
#line 941
		value += nget;
#line 941
	}
#line 941

#line 941
	return status;
#line 941
}
#line 941

static int
#line 942
getNCvx_int_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 942
		 const size_t *start, size_t nelems, longlong *value)
#line 942
{
#line 942
	off_t offset = NC_varoffset(ncp, varp, start);
#line 942
	size_t remaining = varp->xsz * nelems;
#line 942
	int status = NC_NOERR;
#line 942
	const void *xp;
#line 942

#line 942
	if(nelems == 0)
#line 942
		return NC_NOERR;
#line 942

#line 942
	assert(value != NULL);
#line 942

#line 942
	for(;;)
#line 942
	{
#line 942
		size_t extent = MIN(remaining, ncp->chunk);
#line 942
		size_t nget = ncx_howmany(varp->type, extent);
#line 942

#line 942
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 942
				 0, (void **)&xp);	/* cast away const */
#line 942
		if(lstatus != NC_NOERR)
#line 942
			return lstatus;
#line 942

#line 942
		lstatus = ncx_getn_int_longlong(&xp, nget, value);
#line 942
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 942
			status = lstatus;
#line 942

#line 942
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 942

#line 942
		remaining -= extent;
#line 942
		if(remaining == 0)
#line 942
			break; /* normal loop exit */
#line 942
		offset += (off_t)extent;
#line 942
		value += nget;
#line 942
	}
#line 942

#line 942
	return status;
#line 942
}
#line 942

static int
#line 943
getNCvx_int_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 943
		 const size_t *start, size_t nelems, uint *value)
#line 943
{
#line 943
	off_t offset = NC_varoffset(ncp, varp, start);
#line 943
	size_t remaining = varp->xsz * nelems;
#line 943
	int status = NC_NOERR;
#line 943
	const void *xp;
#line 943

#line 943
	if(nelems == 0)
#line 943
		return NC_NOERR;
#line 943

#line 943
	assert(value != NULL);
#line 943

#line 943
	for(;;)
#line 943
	{
#line 943
		size_t extent = MIN(remaining, ncp->chunk);
#line 943
		size_t nget = ncx_howmany(varp->type, extent);
#line 943

#line 943
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 943
				 0, (void **)&xp);	/* cast away const */
#line 943
		if(lstatus != NC_NOERR)
#line 943
			return lstatus;
#line 943

#line 943
		lstatus = ncx_getn_int_uint(&xp, nget, value);
#line 943
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 943
			status = lstatus;
#line 943

#line 943
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 943

#line 943
		remaining -= extent;
#line 943
		if(remaining == 0)
#line 943
			break; /* normal loop exit */
#line 943
		offset += (off_t)extent;
#line 943
		value += nget;
#line 943
	}
#line 943

#line 943
	return status;
#line 943
}
#line 943

static int
#line 944
getNCvx_int_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 944
		 const size_t *start, size_t nelems, ulonglong *value)
#line 944
{
#line 944
	off_t offset = NC_varoffset(ncp, varp, start);
#line 944
	size_t remaining = varp->xsz * nelems;
#line 944
	int status = NC_NOERR;
#line 944
	const void *xp;
#line 944

#line 944
	if(nelems == 0)
#line 944
		return NC_NOERR;
#line 944

#line 944
	assert(value != NULL);
#line 944

#line 944
	for(;;)
#line 944
	{
#line 944
		size_t extent = MIN(remaining, ncp->chunk);
#line 944
		size_t nget = ncx_howmany(varp->type, extent);
#line 944

#line 944
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 944
				 0, (void **)&xp);	/* cast away const */
#line 944
		if(lstatus != NC_NOERR)
#line 944
			return lstatus;
#line 944

#line 944
		lstatus = ncx_getn_int_ulonglong(&xp, nget, value);
#line 944
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 944
			status = lstatus;
#line 944

#line 944
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 944

#line 944
		remaining -= extent;
#line 944
		if(remaining == 0)
#line 944
			break; /* normal loop exit */
#line 944
		offset += (off_t)extent;
#line 944
		value += nget;
#line 944
	}
#line 944

#line 944
	return status;
#line 944
}
#line 944

static int
#line 945
getNCvx_int_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 945
		 const size_t *start, size_t nelems, ushort *value)
#line 945
{
#line 945
	off_t offset = NC_varoffset(ncp, varp, start);
#line 945
	size_t remaining = varp->xsz * nelems;
#line 945
	int status = NC_NOERR;
#line 945
	const void *xp;
#line 945

#line 945
	if(nelems == 0)
#line 945
		return NC_NOERR;
#line 945

#line 945
	assert(value != NULL);
#line 945

#line 945
	for(;;)
#line 945
	{
#line 945
		size_t extent = MIN(remaining, ncp->chunk);
#line 945
		size_t nget = ncx_howmany(varp->type, extent);
#line 945

#line 945
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 945
				 0, (void **)&xp);	/* cast away const */
#line 945
		if(lstatus != NC_NOERR)
#line 945
			return lstatus;
#line 945

#line 945
		lstatus = ncx_getn_int_ushort(&xp, nget, value);
#line 945
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 945
			status = lstatus;
#line 945

#line 945
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 945

#line 945
		remaining -= extent;
#line 945
		if(remaining == 0)
#line 945
			break; /* normal loop exit */
#line 945
		offset += (off_t)extent;
#line 945
		value += nget;
#line 945
	}
#line 945

#line 945
	return status;
#line 945
}
#line 945


static int
#line 947
getNCvx_float_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 947
		 const size_t *start, size_t nelems, schar *value)
#line 947
{
#line 947
	off_t offset = NC_varoffset(ncp, varp, start);
#line 947
	size_t remaining = varp->xsz * nelems;
#line 947
	int status = NC_NOERR;
#line 947
	const void *xp;
#line 947

#line 947
	if(nelems == 0)
#line 947
		return NC_NOERR;
#line 947

#line 947
	assert(value != NULL);
#line 947

#line 947
	for(;;)
#line 947
	{
#line 947
		size_t extent = MIN(remaining, ncp->chunk);
#line 947
		size_t nget = ncx_howmany(varp->type, extent);
#line 947

#line 947
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 947
				 0, (void **)&xp);	/* cast away const */
#line 947
		if(lstatus != NC_NOERR)
#line 947
			return lstatus;
#line 947

#line 947
		lstatus = ncx_getn_float_schar(&xp, nget, value);
#line 947
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 947
			status = lstatus;
#line 947

#line 947
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 947

#line 947
		remaining -= extent;
#line 947
		if(remaining == 0)
#line 947
			break; /* normal loop exit */
#line 947
		offset += (off_t)extent;
#line 947
		value += nget;
#line 947
	}
#line 947

#line 947
	return status;
#line 947
}
#line 947

static int
#line 948
getNCvx_float_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 948
		 const size_t *start, size_t nelems, uchar *value)
#line 948
{
#line 948
	off_t offset = NC_varoffset(ncp, varp, start);
#line 948
	size_t remaining = varp->xsz * nelems;
#line 948
	int status = NC_NOERR;
#line 948
	const void *xp;
#line 948

#line 948
	if(nelems == 0)
#line 948
		return NC_NOERR;
#line 948

#line 948
	assert(value != NULL);
#line 948

#line 948
	for(;;)
#line 948
	{
#line 948
		size_t extent = MIN(remaining, ncp->chunk);
#line 948
		size_t nget = ncx_howmany(varp->type, extent);
#line 948

#line 948
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 948
				 0, (void **)&xp);	/* cast away const */
#line 948
		if(lstatus != NC_NOERR)
#line 948
			return lstatus;
#line 948

#line 948
		lstatus = ncx_getn_float_uchar(&xp, nget, value);
#line 948
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 948
			status = lstatus;
#line 948

#line 948
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 948

#line 948
		remaining -= extent;
#line 948
		if(remaining == 0)
#line 948
			break; /* normal loop exit */
#line 948
		offset += (off_t)extent;
#line 948
		value += nget;
#line 948
	}
#line 948

#line 948
	return status;
#line 948
}
#line 948

static int
#line 949
getNCvx_float_short(const NC3_INFO* ncp, const NC_var *varp,
#line 949
		 const size_t *start, size_t nelems, short *value)
#line 949
{
#line 949
	off_t offset = NC_varoffset(ncp, varp, start);
#line 949
	size_t remaining = varp->xsz * nelems;
#line 949
	int status = NC_NOERR;
#line 949
	const void *xp;
#line 949

#line 949
	if(nelems == 0)
#line 949
		return NC_NOERR;
#line 949

#line 949
	assert(value != NULL);
#line 949

#line 949
	for(;;)
#line 949
	{
#line 949
		size_t extent = MIN(remaining, ncp->chunk);
#line 949
		size_t nget = ncx_howmany(varp->type, extent);
#line 949

#line 949
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 949
				 0, (void **)&xp);	/* cast away const */
#line 949
		if(lstatus != NC_NOERR)
#line 949
			return lstatus;
#line 949

#line 949
		lstatus = ncx_getn_float_short(&xp, nget, value);
#line 949
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 949
			status = lstatus;
#line 949

#line 949
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 949

#line 949
		remaining -= extent;
#line 949
		if(remaining == 0)
#line 949
			break; /* normal loop exit */
#line 949
		offset += (off_t)extent;
#line 949
		value += nget;
#line 949
	}
#line 949

#line 949
	return status;
#line 949
}
#line 949

static int
#line 950
getNCvx_float_int(const NC3_INFO* ncp, const NC_var *varp,
#line 950
		 const size_t *start, size_t nelems, int *value)
#line 950
{
#line 950
	off_t offset = NC_varoffset(ncp, varp, start);
#line 950
	size_t remaining = varp->xsz * nelems;
#line 950
	int status = NC_NOERR;
#line 950
	const void *xp;
#line 950

#line 950
	if(nelems == 0)
#line 950
		return NC_NOERR;
#line 950

#line 950
	assert(value != NULL);
#line 950

#line 950
	for(;;)
#line 950
	{
#line 950
		size_t extent = MIN(remaining, ncp->chunk);
#line 950
		size_t nget = ncx_howmany(varp->type, extent);
#line 950

#line 950
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 950
				 0, (void **)&xp);	/* cast away const */
#line 950
		if(lstatus != NC_NOERR)
#line 950
			return lstatus;
#line 950

#line 950
		lstatus = ncx_getn_float_int(&xp, nget, value);
#line 950
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 950
			status = lstatus;
#line 950

#line 950
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 950

#line 950
		remaining -= extent;
#line 950
		if(remaining == 0)
#line 950
			break; /* normal loop exit */
#line 950
		offset += (off_t)extent;
#line 950
		value += nget;
#line 950
	}
#line 950

#line 950
	return status;
#line 950
}
#line 950

static int
#line 951
getNCvx_float_float(const NC3_INFO* ncp, const NC_var *varp,
#line 951
		 const size_t *start, size_t nelems, float *value)
#line 951
{
#line 951
	off_t offset = NC_varoffset(ncp, varp, start);
#line 951
	size_t remaining = varp->xsz * nelems;
#line 951
	int status = NC_NOERR;
#line 951
	const void *xp;
#line 951

#line 951
	if(nelems == 0)
#line 951
		return NC_NOERR;
#line 951

#line 951
	assert(value != NULL);
#line 951

#line 951
	for(;;)
#line 951
	{
#line 951
		size_t extent = MIN(remaining, ncp->chunk);
#line 951
		size_t nget = ncx_howmany(varp->type, extent);
#line 951

#line 951
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 951
				 0, (void **)&xp);	/* cast away const */
#line 951
		if(lstatus != NC_NOERR)
#line 951
			return lstatus;
#line 951

#line 951
		lstatus = ncx_getn_float_float(&xp, nget, value);
#line 951
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 951
			status = lstatus;
#line 951

#line 951
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 951

#line 951
		remaining -= extent;
#line 951
		if(remaining == 0)
#line 951
			break; /* normal loop exit */
#line 951
		offset += (off_t)extent;
#line 951
		value += nget;
#line 951
	}
#line 951

#line 951
	return status;
#line 951
}
#line 951

static int
#line 952
getNCvx_float_double(const NC3_INFO* ncp, const NC_var *varp,
#line 952
		 const size_t *start, size_t nelems, double *value)
#line 952
{
#line 952
	off_t offset = NC_varoffset(ncp, varp, start);
#line 952
	size_t remaining = varp->xsz * nelems;
#line 952
	int status = NC_NOERR;
#line 952
	const void *xp;
#line 952

#line 952
	if(nelems == 0)
#line 952
		return NC_NOERR;
#line 952

#line 952
	assert(value != NULL);
#line 952

#line 952
	for(;;)
#line 952
	{
#line 952
		size_t extent = MIN(remaining, ncp->chunk);
#line 952
		size_t nget = ncx_howmany(varp->type, extent);
#line 952

#line 952
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 952
				 0, (void **)&xp);	/* cast away const */
#line 952
		if(lstatus != NC_NOERR)
#line 952
			return lstatus;
#line 952

#line 952
		lstatus = ncx_getn_float_double(&xp, nget, value);
#line 952
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 952
			status = lstatus;
#line 952

#line 952
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 952

#line 952
		remaining -= extent;
#line 952
		if(remaining == 0)
#line 952
			break; /* normal loop exit */
#line 952
		offset += (off_t)extent;
#line 952
		value += nget;
#line 952
	}
#line 952

#line 952
	return status;
#line 952
}
#line 952

static int
#line 953
getNCvx_float_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 953
		 const size_t *start, size_t nelems, longlong *value)
#line 953
{
#line 953
	off_t offset = NC_varoffset(ncp, varp, start);
#line 953
	size_t remaining = varp->xsz * nelems;
#line 953
	int status = NC_NOERR;
#line 953
	const void *xp;
#line 953

#line 953
	if(nelems == 0)
#line 953
		return NC_NOERR;
#line 953

#line 953
	assert(value != NULL);
#line 953

#line 953
	for(;;)
#line 953
	{
#line 953
		size_t extent = MIN(remaining, ncp->chunk);
#line 953
		size_t nget = ncx_howmany(varp->type, extent);
#line 953

#line 953
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 953
				 0, (void **)&xp);	/* cast away const */
#line 953
		if(lstatus != NC_NOERR)
#line 953
			return lstatus;
#line 953

#line 953
		lstatus = ncx_getn_float_longlong(&xp, nget, value);
#line 953
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 953
			status = lstatus;
#line 953

#line 953
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 953

#line 953
		remaining -= extent;
#line 953
		if(remaining == 0)
#line 953
			break; /* normal loop exit */
#line 953
		offset += (off_t)extent;
#line 953
		value += nget;
#line 953
	}
#line 953

#line 953
	return status;
#line 953
}
#line 953

static int
#line 954
getNCvx_float_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 954
		 const size_t *start, size_t nelems, uint *value)
#line 954
{
#line 954
	off_t offset = NC_varoffset(ncp, varp, start);
#line 954
	size_t remaining = varp->xsz * nelems;
#line 954
	int status = NC_NOERR;
#line 954
	const void *xp;
#line 954

#line 954
	if(nelems == 0)
#line 954
		return NC_NOERR;
#line 954

#line 954
	assert(value != NULL);
#line 954

#line 954
	for(;;)
#line 954
	{
#line 954
		size_t extent = MIN(remaining, ncp->chunk);
#line 954
		size_t nget = ncx_howmany(varp->type, extent);
#line 954

#line 954
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 954
				 0, (void **)&xp);	/* cast away const */
#line 954
		if(lstatus != NC_NOERR)
#line 954
			return lstatus;
#line 954

#line 954
		lstatus = ncx_getn_float_uint(&xp, nget, value);
#line 954
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 954
			status = lstatus;
#line 954

#line 954
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 954

#line 954
		remaining -= extent;
#line 954
		if(remaining == 0)
#line 954
			break; /* normal loop exit */
#line 954
		offset += (off_t)extent;
#line 954
		value += nget;
#line 954
	}
#line 954

#line 954
	return status;
#line 954
}
#line 954

static int
#line 955
getNCvx_float_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 955
		 const size_t *start, size_t nelems, ulonglong *value)
#line 955
{
#line 955
	off_t offset = NC_varoffset(ncp, varp, start);
#line 955
	size_t remaining = varp->xsz * nelems;
#line 955
	int status = NC_NOERR;
#line 955
	const void *xp;
#line 955

#line 955
	if(nelems == 0)
#line 955
		return NC_NOERR;
#line 955

#line 955
	assert(value != NULL);
#line 955

#line 955
	for(;;)
#line 955
	{
#line 955
		size_t extent = MIN(remaining, ncp->chunk);
#line 955
		size_t nget = ncx_howmany(varp->type, extent);
#line 955

#line 955
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 955
				 0, (void **)&xp);	/* cast away const */
#line 955
		if(lstatus != NC_NOERR)
#line 955
			return lstatus;
#line 955

#line 955
		lstatus = ncx_getn_float_ulonglong(&xp, nget, value);
#line 955
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 955
			status = lstatus;
#line 955

#line 955
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 955

#line 955
		remaining -= extent;
#line 955
		if(remaining == 0)
#line 955
			break; /* normal loop exit */
#line 955
		offset += (off_t)extent;
#line 955
		value += nget;
#line 955
	}
#line 955

#line 955
	return status;
#line 955
}
#line 955

static int
#line 956
getNCvx_float_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 956
		 const size_t *start, size_t nelems, ushort *value)
#line 956
{
#line 956
	off_t offset = NC_varoffset(ncp, varp, start);
#line 956
	size_t remaining = varp->xsz * nelems;
#line 956
	int status = NC_NOERR;
#line 956
	const void *xp;
#line 956

#line 956
	if(nelems == 0)
#line 956
		return NC_NOERR;
#line 956

#line 956
	assert(value != NULL);
#line 956

#line 956
	for(;;)
#line 956
	{
#line 956
		size_t extent = MIN(remaining, ncp->chunk);
#line 956
		size_t nget = ncx_howmany(varp->type, extent);
#line 956

#line 956
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 956
				 0, (void **)&xp);	/* cast away const */
#line 956
		if(lstatus != NC_NOERR)
#line 956
			return lstatus;
#line 956

#line 956
		lstatus = ncx_getn_float_ushort(&xp, nget, value);
#line 956
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 956
			status = lstatus;
#line 956

#line 956
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 956

#line 956
		remaining -= extent;
#line 956
		if(remaining == 0)
#line 956
			break; /* normal loop exit */
#line 956
		offset += (off_t)extent;
#line 956
		value += nget;
#line 956
	}
#line 956

#line 956
	return status;
#line 956
}
#line 956


static int
#line 958
getNCvx_double_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 958
		 const size_t *start, size_t nelems, schar *value)
#line 958
{
#line 958
	off_t offset = NC_varoffset(ncp, varp, start);
#line 958
	size_t remaining = varp->xsz * nelems;
#line 958
	int status = NC_NOERR;
#line 958
	const void *xp;
#line 958

#line 958
	if(nelems == 0)
#line 958
		return NC_NOERR;
#line 958

#line 958
	assert(value != NULL);
#line 958

#line 958
	for(;;)
#line 958
	{
#line 958
		size_t extent = MIN(remaining, ncp->chunk);
#line 958
		size_t nget = ncx_howmany(varp->type, extent);
#line 958

#line 958
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 958
				 0, (void **)&xp);	/* cast away const */
#line 958
		if(lstatus != NC_NOERR)
#line 958
			return lstatus;
#line 958

#line 958
		lstatus = ncx_getn_double_schar(&xp, nget, value);
#line 958
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 958
			status = lstatus;
#line 958

#line 958
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 958

#line 958
		remaining -= extent;
#line 958
		if(remaining == 0)
#line 958
			break; /* normal loop exit */
#line 958
		offset += (off_t)extent;
#line 958
		value += nget;
#line 958
	}
#line 958

#line 958
	return status;
#line 958
}
#line 958

static int
#line 959
getNCvx_double_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 959
		 const size_t *start, size_t nelems, uchar *value)
#line 959
{
#line 959
	off_t offset = NC_varoffset(ncp, varp, start);
#line 959
	size_t remaining = varp->xsz * nelems;
#line 959
	int status = NC_NOERR;
#line 959
	const void *xp;
#line 959

#line 959
	if(nelems == 0)
#line 959
		return NC_NOERR;
#line 959

#line 959
	assert(value != NULL);
#line 959

#line 959
	for(;;)
#line 959
	{
#line 959
		size_t extent = MIN(remaining, ncp->chunk);
#line 959
		size_t nget = ncx_howmany(varp->type, extent);
#line 959

#line 959
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 959
				 0, (void **)&xp);	/* cast away const */
#line 959
		if(lstatus != NC_NOERR)
#line 959
			return lstatus;
#line 959

#line 959
		lstatus = ncx_getn_double_uchar(&xp, nget, value);
#line 959
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 959
			status = lstatus;
#line 959

#line 959
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 959

#line 959
		remaining -= extent;
#line 959
		if(remaining == 0)
#line 959
			break; /* normal loop exit */
#line 959
		offset += (off_t)extent;
#line 959
		value += nget;
#line 959
	}
#line 959

#line 959
	return status;
#line 959
}
#line 959

static int
#line 960
getNCvx_double_short(const NC3_INFO* ncp, const NC_var *varp,
#line 960
		 const size_t *start, size_t nelems, short *value)
#line 960
{
#line 960
	off_t offset = NC_varoffset(ncp, varp, start);
#line 960
	size_t remaining = varp->xsz * nelems;
#line 960
	int status = NC_NOERR;
#line 960
	const void *xp;
#line 960

#line 960
	if(nelems == 0)
#line 960
		return NC_NOERR;
#line 960

#line 960
	assert(value != NULL);
#line 960

#line 960
	for(;;)
#line 960
	{
#line 960
		size_t extent = MIN(remaining, ncp->chunk);
#line 960
		size_t nget = ncx_howmany(varp->type, extent);
#line 960

#line 960
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 960
				 0, (void **)&xp);	/* cast away const */
#line 960
		if(lstatus != NC_NOERR)
#line 960
			return lstatus;
#line 960

#line 960
		lstatus = ncx_getn_double_short(&xp, nget, value);
#line 960
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 960
			status = lstatus;
#line 960

#line 960
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 960

#line 960
		remaining -= extent;
#line 960
		if(remaining == 0)
#line 960
			break; /* normal loop exit */
#line 960
		offset += (off_t)extent;
#line 960
		value += nget;
#line 960
	}
#line 960

#line 960
	return status;
#line 960
}
#line 960

static int
#line 961
getNCvx_double_int(const NC3_INFO* ncp, const NC_var *varp,
#line 961
		 const size_t *start, size_t nelems, int *value)
#line 961
{
#line 961
	off_t offset = NC_varoffset(ncp, varp, start);
#line 961
	size_t remaining = varp->xsz * nelems;
#line 961
	int status = NC_NOERR;
#line 961
	const void *xp;
#line 961

#line 961
	if(nelems == 0)
#line 961
		return NC_NOERR;
#line 961

#line 961
	assert(value != NULL);
#line 961

#line 961
	for(;;)
#line 961
	{
#line 961
		size_t extent = MIN(remaining, ncp->chunk);
#line 961
		size_t nget = ncx_howmany(varp->type, extent);
#line 961

#line 961
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 961
				 0, (void **)&xp);	/* cast away const */
#line 961
		if(lstatus != NC_NOERR)
#line 961
			return lstatus;
#line 961

#line 961
		lstatus = ncx_getn_double_int(&xp, nget, value);
#line 961
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 961
			status = lstatus;
#line 961

#line 961
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 961

#line 961
		remaining -= extent;
#line 961
		if(remaining == 0)
#line 961
			break; /* normal loop exit */
#line 961
		offset += (off_t)extent;
#line 961
		value += nget;
#line 961
	}
#line 961

#line 961
	return status;
#line 961
}
#line 961

static int
#line 962
getNCvx_double_float(const NC3_INFO* ncp, const NC_var *varp,
#line 962
		 const size_t *start, size_t nelems, float *value)
#line 962
{
#line 962
	off_t offset = NC_varoffset(ncp, varp, start);
#line 962
	size_t remaining = varp->xsz * nelems;
#line 962
	int status = NC_NOERR;
#line 962
	const void *xp;
#line 962

#line 962
	if(nelems == 0)
#line 962
		return NC_NOERR;
#line 962

#line 962
	assert(value != NULL);
#line 962

#line 962
	for(;;)
#line 962
	{
#line 962
		size_t extent = MIN(remaining, ncp->chunk);
#line 962
		size_t nget = ncx_howmany(varp->type, extent);
#line 962

#line 962
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 962
				 0, (void **)&xp);	/* cast away const */
#line 962
		if(lstatus != NC_NOERR)
#line 962
			return lstatus;
#line 962

#line 962
		lstatus = ncx_getn_double_float(&xp, nget, value);
#line 962
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 962
			status = lstatus;
#line 962

#line 962
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 962

#line 962
		remaining -= extent;
#line 962
		if(remaining == 0)
#line 962
			break; /* normal loop exit */
#line 962
		offset += (off_t)extent;
#line 962
		value += nget;
#line 962
	}
#line 962

#line 962
	return status;
#line 962
}
#line 962

static int
#line 963
getNCvx_double_double(const NC3_INFO* ncp, const NC_var *varp,
#line 963
		 const size_t *start, size_t nelems, double *value)
#line 963
{
#line 963
	off_t offset = NC_varoffset(ncp, varp, start);
#line 963
	size_t remaining = varp->xsz * nelems;
#line 963
	int status = NC_NOERR;
#line 963
	const void *xp;
#line 963

#line 963
	if(nelems == 0)
#line 963
		return NC_NOERR;
#line 963

#line 963
	assert(value != NULL);
#line 963

#line 963
	for(;;)
#line 963
	{
#line 963
		size_t extent = MIN(remaining, ncp->chunk);
#line 963
		size_t nget = ncx_howmany(varp->type, extent);
#line 963

#line 963
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 963
				 0, (void **)&xp);	/* cast away const */
#line 963
		if(lstatus != NC_NOERR)
#line 963
			return lstatus;
#line 963

#line 963
		lstatus = ncx_getn_double_double(&xp, nget, value);
#line 963
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 963
			status = lstatus;
#line 963

#line 963
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 963

#line 963
		remaining -= extent;
#line 963
		if(remaining == 0)
#line 963
			break; /* normal loop exit */
#line 963
		offset += (off_t)extent;
#line 963
		value += nget;
#line 963
	}
#line 963

#line 963
	return status;
#line 963
}
#line 963

static int
#line 964
getNCvx_double_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 964
		 const size_t *start, size_t nelems, longlong *value)
#line 964
{
#line 964
	off_t offset = NC_varoffset(ncp, varp, start);
#line 964
	size_t remaining = varp->xsz * nelems;
#line 964
	int status = NC_NOERR;
#line 964
	const void *xp;
#line 964

#line 964
	if(nelems == 0)
#line 964
		return NC_NOERR;
#line 964

#line 964
	assert(value != NULL);
#line 964

#line 964
	for(;;)
#line 964
	{
#line 964
		size_t extent = MIN(remaining, ncp->chunk);
#line 964
		size_t nget = ncx_howmany(varp->type, extent);
#line 964

#line 964
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 964
				 0, (void **)&xp);	/* cast away const */
#line 964
		if(lstatus != NC_NOERR)
#line 964
			return lstatus;
#line 964

#line 964
		lstatus = ncx_getn_double_longlong(&xp, nget, value);
#line 964
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 964
			status = lstatus;
#line 964

#line 964
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 964

#line 964
		remaining -= extent;
#line 964
		if(remaining == 0)
#line 964
			break; /* normal loop exit */
#line 964
		offset += (off_t)extent;
#line 964
		value += nget;
#line 964
	}
#line 964

#line 964
	return status;
#line 964
}
#line 964

static int
#line 965
getNCvx_double_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 965
		 const size_t *start, size_t nelems, uint *value)
#line 965
{
#line 965
	off_t offset = NC_varoffset(ncp, varp, start);
#line 965
	size_t remaining = varp->xsz * nelems;
#line 965
	int status = NC_NOERR;
#line 965
	const void *xp;
#line 965

#line 965
	if(nelems == 0)
#line 965
		return NC_NOERR;
#line 965

#line 965
	assert(value != NULL);
#line 965

#line 965
	for(;;)
#line 965
	{
#line 965
		size_t extent = MIN(remaining, ncp->chunk);
#line 965
		size_t nget = ncx_howmany(varp->type, extent);
#line 965

#line 965
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 965
				 0, (void **)&xp);	/* cast away const */
#line 965
		if(lstatus != NC_NOERR)
#line 965
			return lstatus;
#line 965

#line 965
		lstatus = ncx_getn_double_uint(&xp, nget, value);
#line 965
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 965
			status = lstatus;
#line 965

#line 965
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 965

#line 965
		remaining -= extent;
#line 965
		if(remaining == 0)
#line 965
			break; /* normal loop exit */
#line 965
		offset += (off_t)extent;
#line 965
		value += nget;
#line 965
	}
#line 965

#line 965
	return status;
#line 965
}
#line 965

static int
#line 966
getNCvx_double_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 966
		 const size_t *start, size_t nelems, ulonglong *value)
#line 966
{
#line 966
	off_t offset = NC_varoffset(ncp, varp, start);
#line 966
	size_t remaining = varp->xsz * nelems;
#line 966
	int status = NC_NOERR;
#line 966
	const void *xp;
#line 966

#line 966
	if(nelems == 0)
#line 966
		return NC_NOERR;
#line 966

#line 966
	assert(value != NULL);
#line 966

#line 966
	for(;;)
#line 966
	{
#line 966
		size_t extent = MIN(remaining, ncp->chunk);
#line 966
		size_t nget = ncx_howmany(varp->type, extent);
#line 966

#line 966
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 966
				 0, (void **)&xp);	/* cast away const */
#line 966
		if(lstatus != NC_NOERR)
#line 966
			return lstatus;
#line 966

#line 966
		lstatus = ncx_getn_double_ulonglong(&xp, nget, value);
#line 966
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 966
			status = lstatus;
#line 966

#line 966
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 966

#line 966
		remaining -= extent;
#line 966
		if(remaining == 0)
#line 966
			break; /* normal loop exit */
#line 966
		offset += (off_t)extent;
#line 966
		value += nget;
#line 966
	}
#line 966

#line 966
	return status;
#line 966
}
#line 966

static int
#line 967
getNCvx_double_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 967
		 const size_t *start, size_t nelems, ushort *value)
#line 967
{
#line 967
	off_t offset = NC_varoffset(ncp, varp, start);
#line 967
	size_t remaining = varp->xsz * nelems;
#line 967
	int status = NC_NOERR;
#line 967
	const void *xp;
#line 967

#line 967
	if(nelems == 0)
#line 967
		return NC_NOERR;
#line 967

#line 967
	assert(value != NULL);
#line 967

#line 967
	for(;;)
#line 967
	{
#line 967
		size_t extent = MIN(remaining, ncp->chunk);
#line 967
		size_t nget = ncx_howmany(varp->type, extent);
#line 967

#line 967
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 967
				 0, (void **)&xp);	/* cast away const */
#line 967
		if(lstatus != NC_NOERR)
#line 967
			return lstatus;
#line 967

#line 967
		lstatus = ncx_getn_double_ushort(&xp, nget, value);
#line 967
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 967
			status = lstatus;
#line 967

#line 967
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 967

#line 967
		remaining -= extent;
#line 967
		if(remaining == 0)
#line 967
			break; /* normal loop exit */
#line 967
		offset += (off_t)extent;
#line 967
		value += nget;
#line 967
	}
#line 967

#line 967
	return status;
#line 967
}
#line 967


static int
#line 969
getNCvx_uchar_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 969
		 const size_t *start, size_t nelems, schar *value)
#line 969
{
#line 969
	off_t offset = NC_varoffset(ncp, varp, start);
#line 969
	size_t remaining = varp->xsz * nelems;
#line 969
	int status = NC_NOERR;
#line 969
	const void *xp;
#line 969

#line 969
	if(nelems == 0)
#line 969
		return NC_NOERR;
#line 969

#line 969
	assert(value != NULL);
#line 969

#line 969
	for(;;)
#line 969
	{
#line 969
		size_t extent = MIN(remaining, ncp->chunk);
#line 969
		size_t nget = ncx_howmany(varp->type, extent);
#line 969

#line 969
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 969
				 0, (void **)&xp);	/* cast away const */
#line 969
		if(lstatus != NC_NOERR)
#line 969
			return lstatus;
#line 969

#line 969
		lstatus = ncx_getn_uchar_schar(&xp, nget, value);
#line 969
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 969
			status = lstatus;
#line 969

#line 969
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 969

#line 969
		remaining -= extent;
#line 969
		if(remaining == 0)
#line 969
			break; /* normal loop exit */
#line 969
		offset += (off_t)extent;
#line 969
		value += nget;
#line 969
	}
#line 969

#line 969
	return status;
#line 969
}
#line 969

static int
#line 970
getNCvx_uchar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 970
		 const size_t *start, size_t nelems, uchar *value)
#line 970
{
#line 970
	off_t offset = NC_varoffset(ncp, varp, start);
#line 970
	size_t remaining = varp->xsz * nelems;
#line 970
	int status = NC_NOERR;
#line 970
	const void *xp;
#line 970

#line 970
	if(nelems == 0)
#line 970
		return NC_NOERR;
#line 970

#line 970
	assert(value != NULL);
#line 970

#line 970
	for(;;)
#line 970
	{
#line 970
		size_t extent = MIN(remaining, ncp->chunk);
#line 970
		size_t nget = ncx_howmany(varp->type, extent);
#line 970

#line 970
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 970
				 0, (void **)&xp);	/* cast away const */
#line 970
		if(lstatus != NC_NOERR)
#line 970
			return lstatus;
#line 970

#line 970
		lstatus = ncx_getn_uchar_uchar(&xp, nget, value);
#line 970
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 970
			status = lstatus;
#line 970

#line 970
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 970

#line 970
		remaining -= extent;
#line 970
		if(remaining == 0)
#line 970
			break; /* normal loop exit */
#line 970
		offset += (off_t)extent;
#line 970
		value += nget;
#line 970
	}
#line 970

#line 970
	return status;
#line 970
}
#line 970

static int
#line 971
getNCvx_uchar_short(const NC3_INFO* ncp, const NC_var *varp,
#line 971
		 const size_t *start, size_t nelems, short *value)
#line 971
{
#line 971
	off_t offset = NC_varoffset(ncp, varp, start);
#line 971
	size_t remaining = varp->xsz * nelems;
#line 971
	int status = NC_NOERR;
#line 971
	const void *xp;
#line 971

#line 971
	if(nelems == 0)
#line 971
		return NC_NOERR;
#line 971

#line 971
	assert(value != NULL);
#line 971

#line 971
	for(;;)
#line 971
	{
#line 971
		size_t extent = MIN(remaining, ncp->chunk);
#line 971
		size_t nget = ncx_howmany(varp->type, extent);
#line 971

#line 971
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 971
				 0, (void **)&xp);	/* cast away const */
#line 971
		if(lstatus != NC_NOERR)
#line 971
			return lstatus;
#line 971

#line 971
		lstatus = ncx_getn_uchar_short(&xp, nget, value);
#line 971
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 971
			status = lstatus;
#line 971

#line 971
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 971

#line 971
		remaining -= extent;
#line 971
		if(remaining == 0)
#line 971
			break; /* normal loop exit */
#line 971
		offset += (off_t)extent;
#line 971
		value += nget;
#line 971
	}
#line 971

#line 971
	return status;
#line 971
}
#line 971

static int
#line 972
getNCvx_uchar_int(const NC3_INFO* ncp, const NC_var *varp,
#line 972
		 const size_t *start, size_t nelems, int *value)
#line 972
{
#line 972
	off_t offset = NC_varoffset(ncp, varp, start);
#line 972
	size_t remaining = varp->xsz * nelems;
#line 972
	int status = NC_NOERR;
#line 972
	const void *xp;
#line 972

#line 972
	if(nelems == 0)
#line 972
		return NC_NOERR;
#line 972

#line 972
	assert(value != NULL);
#line 972

#line 972
	for(;;)
#line 972
	{
#line 972
		size_t extent = MIN(remaining, ncp->chunk);
#line 972
		size_t nget = ncx_howmany(varp->type, extent);
#line 972

#line 972
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 972
				 0, (void **)&xp);	/* cast away const */
#line 972
		if(lstatus != NC_NOERR)
#line 972
			return lstatus;
#line 972

#line 972
		lstatus = ncx_getn_uchar_int(&xp, nget, value);
#line 972
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 972
			status = lstatus;
#line 972

#line 972
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 972

#line 972
		remaining -= extent;
#line 972
		if(remaining == 0)
#line 972
			break; /* normal loop exit */
#line 972
		offset += (off_t)extent;
#line 972
		value += nget;
#line 972
	}
#line 972

#line 972
	return status;
#line 972
}
#line 972

static int
#line 973
getNCvx_uchar_float(const NC3_INFO* ncp, const NC_var *varp,
#line 973
		 const size_t *start, size_t nelems, float *value)
#line 973
{
#line 973
	off_t offset = NC_varoffset(ncp, varp, start);
#line 973
	size_t remaining = varp->xsz * nelems;
#line 973
	int status = NC_NOERR;
#line 973
	const void *xp;
#line 973

#line 973
	if(nelems == 0)
#line 973
		return NC_NOERR;
#line 973

#line 973
	assert(value != NULL);
#line 973

#line 973
	for(;;)
#line 973
	{
#line 973
		size_t extent = MIN(remaining, ncp->chunk);
#line 973
		size_t nget = ncx_howmany(varp->type, extent);
#line 973

#line 973
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 973
				 0, (void **)&xp);	/* cast away const */
#line 973
		if(lstatus != NC_NOERR)
#line 973
			return lstatus;
#line 973

#line 973
		lstatus = ncx_getn_uchar_float(&xp, nget, value);
#line 973
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 973
			status = lstatus;
#line 973

#line 973
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 973

#line 973
		remaining -= extent;
#line 973
		if(remaining == 0)
#line 973
			break; /* normal loop exit */
#line 973
		offset += (off_t)extent;
#line 973
		value += nget;
#line 973
	}
#line 973

#line 973
	return status;
#line 973
}
#line 973

static int
#line 974
getNCvx_uchar_double(const NC3_INFO* ncp, const NC_var *varp,
#line 974
		 const size_t *start, size_t nelems, double *value)
#line 974
{
#line 974
	off_t offset = NC_varoffset(ncp, varp, start);
#line 974
	size_t remaining = varp->xsz * nelems;
#line 974
	int status = NC_NOERR;
#line 974
	const void *xp;
#line 974

#line 974
	if(nelems == 0)
#line 974
		return NC_NOERR;
#line 974

#line 974
	assert(value != NULL);
#line 974

#line 974
	for(;;)
#line 974
	{
#line 974
		size_t extent = MIN(remaining, ncp->chunk);
#line 974
		size_t nget = ncx_howmany(varp->type, extent);
#line 974

#line 974
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 974
				 0, (void **)&xp);	/* cast away const */
#line 974
		if(lstatus != NC_NOERR)
#line 974
			return lstatus;
#line 974

#line 974
		lstatus = ncx_getn_uchar_double(&xp, nget, value);
#line 974
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 974
			status = lstatus;
#line 974

#line 974
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 974

#line 974
		remaining -= extent;
#line 974
		if(remaining == 0)
#line 974
			break; /* normal loop exit */
#line 974
		offset += (off_t)extent;
#line 974
		value += nget;
#line 974
	}
#line 974

#line 974
	return status;
#line 974
}
#line 974

static int
#line 975
getNCvx_uchar_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 975
		 const size_t *start, size_t nelems, longlong *value)
#line 975
{
#line 975
	off_t offset = NC_varoffset(ncp, varp, start);
#line 975
	size_t remaining = varp->xsz * nelems;
#line 975
	int status = NC_NOERR;
#line 975
	const void *xp;
#line 975

#line 975
	if(nelems == 0)
#line 975
		return NC_NOERR;
#line 975

#line 975
	assert(value != NULL);
#line 975

#line 975
	for(;;)
#line 975
	{
#line 975
		size_t extent = MIN(remaining, ncp->chunk);
#line 975
		size_t nget = ncx_howmany(varp->type, extent);
#line 975

#line 975
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 975
				 0, (void **)&xp);	/* cast away const */
#line 975
		if(lstatus != NC_NOERR)
#line 975
			return lstatus;
#line 975

#line 975
		lstatus = ncx_getn_uchar_longlong(&xp, nget, value);
#line 975
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 975
			status = lstatus;
#line 975

#line 975
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 975

#line 975
		remaining -= extent;
#line 975
		if(remaining == 0)
#line 975
			break; /* normal loop exit */
#line 975
		offset += (off_t)extent;
#line 975
		value += nget;
#line 975
	}
#line 975

#line 975
	return status;
#line 975
}
#line 975

static int
#line 976
getNCvx_uchar_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 976
		 const size_t *start, size_t nelems, uint *value)
#line 976
{
#line 976
	off_t offset = NC_varoffset(ncp, varp, start);
#line 976
	size_t remaining = varp->xsz * nelems;
#line 976
	int status = NC_NOERR;
#line 976
	const void *xp;
#line 976

#line 976
	if(nelems == 0)
#line 976
		return NC_NOERR;
#line 976

#line 976
	assert(value != NULL);
#line 976

#line 976
	for(;;)
#line 976
	{
#line 976
		size_t extent = MIN(remaining, ncp->chunk);
#line 976
		size_t nget = ncx_howmany(varp->type, extent);
#line 976

#line 976
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 976
				 0, (void **)&xp);	/* cast away const */
#line 976
		if(lstatus != NC_NOERR)
#line 976
			return lstatus;
#line 976

#line 976
		lstatus = ncx_getn_uchar_uint(&xp, nget, value);
#line 976
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 976
			status = lstatus;
#line 976

#line 976
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 976

#line 976
		remaining -= extent;
#line 976
		if(remaining == 0)
#line 976
			break; /* normal loop exit */
#line 976
		offset += (off_t)extent;
#line 976
		value += nget;
#line 976
	}
#line 976

#line 976
	return status;
#line 976
}
#line 976

static int
#line 977
getNCvx_uchar_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 977
		 const size_t *start, size_t nelems, ulonglong *value)
#line 977
{
#line 977
	off_t offset = NC_varoffset(ncp, varp, start);
#line 977
	size_t remaining = varp->xsz * nelems;
#line 977
	int status = NC_NOERR;
#line 977
	const void *xp;
#line 977

#line 977
	if(nelems == 0)
#line 977
		return NC_NOERR;
#line 977

#line 977
	assert(value != NULL);
#line 977

#line 977
	for(;;)
#line 977
	{
#line 977
		size_t extent = MIN(remaining, ncp->chunk);
#line 977
		size_t nget = ncx_howmany(varp->type, extent);
#line 977

#line 977
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 977
				 0, (void **)&xp);	/* cast away const */
#line 977
		if(lstatus != NC_NOERR)
#line 977
			return lstatus;
#line 977

#line 977
		lstatus = ncx_getn_uchar_ulonglong(&xp, nget, value);
#line 977
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 977
			status = lstatus;
#line 977

#line 977
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 977

#line 977
		remaining -= extent;
#line 977
		if(remaining == 0)
#line 977
			break; /* normal loop exit */
#line 977
		offset += (off_t)extent;
#line 977
		value += nget;
#line 977
	}
#line 977

#line 977
	return status;
#line 977
}
#line 977

static int
#line 978
getNCvx_uchar_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 978
		 const size_t *start, size_t nelems, ushort *value)
#line 978
{
#line 978
	off_t offset = NC_varoffset(ncp, varp, start);
#line 978
	size_t remaining = varp->xsz * nelems;
#line 978
	int status = NC_NOERR;
#line 978
	const void *xp;
#line 978

#line 978
	if(nelems == 0)
#line 978
		return NC_NOERR;
#line 978

#line 978
	assert(value != NULL);
#line 978

#line 978
	for(;;)
#line 978
	{
#line 978
		size_t extent = MIN(remaining, ncp->chunk);
#line 978
		size_t nget = ncx_howmany(varp->type, extent);
#line 978

#line 978
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 978
				 0, (void **)&xp);	/* cast away const */
#line 978
		if(lstatus != NC_NOERR)
#line 978
			return lstatus;
#line 978

#line 978
		lstatus = ncx_getn_uchar_ushort(&xp, nget, value);
#line 978
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 978
			status = lstatus;
#line 978

#line 978
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 978

#line 978
		remaining -= extent;
#line 978
		if(remaining == 0)
#line 978
			break; /* normal loop exit */
#line 978
		offset += (off_t)extent;
#line 978
		value += nget;
#line 978
	}
#line 978

#line 978
	return status;
#line 978
}
#line 978


static int
#line 980
getNCvx_ushort_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 980
		 const size_t *start, size_t nelems, schar *value)
#line 980
{
#line 980
	off_t offset = NC_varoffset(ncp, varp, start);
#line 980
	size_t remaining = varp->xsz * nelems;
#line 980
	int status = NC_NOERR;
#line 980
	const void *xp;
#line 980

#line 980
	if(nelems == 0)
#line 980
		return NC_NOERR;
#line 980

#line 980
	assert(value != NULL);
#line 980

#line 980
	for(;;)
#line 980
	{
#line 980
		size_t extent = MIN(remaining, ncp->chunk);
#line 980
		size_t nget = ncx_howmany(varp->type, extent);
#line 980

#line 980
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 980
				 0, (void **)&xp);	/* cast away const */
#line 980
		if(lstatus != NC_NOERR)
#line 980
			return lstatus;
#line 980

#line 980
		lstatus = ncx_getn_ushort_schar(&xp, nget, value);
#line 980
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 980
			status = lstatus;
#line 980

#line 980
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 980

#line 980
		remaining -= extent;
#line 980
		if(remaining == 0)
#line 980
			break; /* normal loop exit */
#line 980
		offset += (off_t)extent;
#line 980
		value += nget;
#line 980
	}
#line 980

#line 980
	return status;
#line 980
}
#line 980

static int
#line 981
getNCvx_ushort_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 981
		 const size_t *start, size_t nelems, uchar *value)
#line 981
{
#line 981
	off_t offset = NC_varoffset(ncp, varp, start);
#line 981
	size_t remaining = varp->xsz * nelems;
#line 981
	int status = NC_NOERR;
#line 981
	const void *xp;
#line 981

#line 981
	if(nelems == 0)
#line 981
		return NC_NOERR;
#line 981

#line 981
	assert(value != NULL);
#line 981

#line 981
	for(;;)
#line 981
	{
#line 981
		size_t extent = MIN(remaining, ncp->chunk);
#line 981
		size_t nget = ncx_howmany(varp->type, extent);
#line 981

#line 981
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 981
				 0, (void **)&xp);	/* cast away const */
#line 981
		if(lstatus != NC_NOERR)
#line 981
			return lstatus;
#line 981

#line 981
		lstatus = ncx_getn_ushort_uchar(&xp, nget, value);
#line 981
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 981
			status = lstatus;
#line 981

#line 981
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 981

#line 981
		remaining -= extent;
#line 981
		if(remaining == 0)
#line 981
			break; /* normal loop exit */
#line 981
		offset += (off_t)extent;
#line 981
		value += nget;
#line 981
	}
#line 981

#line 981
	return status;
#line 981
}
#line 981

static int
#line 982
getNCvx_ushort_short(const NC3_INFO* ncp, const NC_var *varp,
#line 982
		 const size_t *start, size_t nelems, short *value)
#line 982
{
#line 982
	off_t offset = NC_varoffset(ncp, varp, start);
#line 982
	size_t remaining = varp->xsz * nelems;
#line 982
	int status = NC_NOERR;
#line 982
	const void *xp;
#line 982

#line 982
	if(nelems == 0)
#line 982
		return NC_NOERR;
#line 982

#line 982
	assert(value != NULL);
#line 982

#line 982
	for(;;)
#line 982
	{
#line 982
		size_t extent = MIN(remaining, ncp->chunk);
#line 982
		size_t nget = ncx_howmany(varp->type, extent);
#line 982

#line 982
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 982
				 0, (void **)&xp);	/* cast away const */
#line 982
		if(lstatus != NC_NOERR)
#line 982
			return lstatus;
#line 982

#line 982
		lstatus = ncx_getn_ushort_short(&xp, nget, value);
#line 982
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 982
			status = lstatus;
#line 982

#line 982
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 982

#line 982
		remaining -= extent;
#line 982
		if(remaining == 0)
#line 982
			break; /* normal loop exit */
#line 982
		offset += (off_t)extent;
#line 982
		value += nget;
#line 982
	}
#line 982

#line 982
	return status;
#line 982
}
#line 982

static int
#line 983
getNCvx_ushort_int(const NC3_INFO* ncp, const NC_var *varp,
#line 983
		 const size_t *start, size_t nelems, int *value)
#line 983
{
#line 983
	off_t offset = NC_varoffset(ncp, varp, start);
#line 983
	size_t remaining = varp->xsz * nelems;
#line 983
	int status = NC_NOERR;
#line 983
	const void *xp;
#line 983

#line 983
	if(nelems == 0)
#line 983
		return NC_NOERR;
#line 983

#line 983
	assert(value != NULL);
#line 983

#line 983
	for(;;)
#line 983
	{
#line 983
		size_t extent = MIN(remaining, ncp->chunk);
#line 983
		size_t nget = ncx_howmany(varp->type, extent);
#line 983

#line 983
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 983
				 0, (void **)&xp);	/* cast away const */
#line 983
		if(lstatus != NC_NOERR)
#line 983
			return lstatus;
#line 983

#line 983
		lstatus = ncx_getn_ushort_int(&xp, nget, value);
#line 983
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 983
			status = lstatus;
#line 983

#line 983
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 983

#line 983
		remaining -= extent;
#line 983
		if(remaining == 0)
#line 983
			break; /* normal loop exit */
#line 983
		offset += (off_t)extent;
#line 983
		value += nget;
#line 983
	}
#line 983

#line 983
	return status;
#line 983
}
#line 983

static int
#line 984
getNCvx_ushort_float(const NC3_INFO* ncp, const NC_var *varp,
#line 984
		 const size_t *start, size_t nelems, float *value)
#line 984
{
#line 984
	off_t offset = NC_varoffset(ncp, varp, start);
#line 984
	size_t remaining = varp->xsz * nelems;
#line 984
	int status = NC_NOERR;
#line 984
	const void *xp;
#line 984

#line 984
	if(nelems == 0)
#line 984
		return NC_NOERR;
#line 984

#line 984
	assert(value != NULL);
#line 984

#line 984
	for(;;)
#line 984
	{
#line 984
		size_t extent = MIN(remaining, ncp->chunk);
#line 984
		size_t nget = ncx_howmany(varp->type, extent);
#line 984

#line 984
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 984
				 0, (void **)&xp);	/* cast away const */
#line 984
		if(lstatus != NC_NOERR)
#line 984
			return lstatus;
#line 984

#line 984
		lstatus = ncx_getn_ushort_float(&xp, nget, value);
#line 984
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 984
			status = lstatus;
#line 984

#line 984
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 984

#line 984
		remaining -= extent;
#line 984
		if(remaining == 0)
#line 984
			break; /* normal loop exit */
#line 984
		offset += (off_t)extent;
#line 984
		value += nget;
#line 984
	}
#line 984

#line 984
	return status;
#line 984
}
#line 984

static int
#line 985
getNCvx_ushort_double(const NC3_INFO* ncp, const NC_var *varp,
#line 985
		 const size_t *start, size_t nelems, double *value)
#line 985
{
#line 985
	off_t offset = NC_varoffset(ncp, varp, start);
#line 985
	size_t remaining = varp->xsz * nelems;
#line 985
	int status = NC_NOERR;
#line 985
	const void *xp;
#line 985

#line 985
	if(nelems == 0)
#line 985
		return NC_NOERR;
#line 985

#line 985
	assert(value != NULL);
#line 985

#line 985
	for(;;)
#line 985
	{
#line 985
		size_t extent = MIN(remaining, ncp->chunk);
#line 985
		size_t nget = ncx_howmany(varp->type, extent);
#line 985

#line 985
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 985
				 0, (void **)&xp);	/* cast away const */
#line 985
		if(lstatus != NC_NOERR)
#line 985
			return lstatus;
#line 985

#line 985
		lstatus = ncx_getn_ushort_double(&xp, nget, value);
#line 985
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 985
			status = lstatus;
#line 985

#line 985
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 985

#line 985
		remaining -= extent;
#line 985
		if(remaining == 0)
#line 985
			break; /* normal loop exit */
#line 985
		offset += (off_t)extent;
#line 985
		value += nget;
#line 985
	}
#line 985

#line 985
	return status;
#line 985
}
#line 985

static int
#line 986
getNCvx_ushort_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 986
		 const size_t *start, size_t nelems, longlong *value)
#line 986
{
#line 986
	off_t offset = NC_varoffset(ncp, varp, start);
#line 986
	size_t remaining = varp->xsz * nelems;
#line 986
	int status = NC_NOERR;
#line 986
	const void *xp;
#line 986

#line 986
	if(nelems == 0)
#line 986
		return NC_NOERR;
#line 986

#line 986
	assert(value != NULL);
#line 986

#line 986
	for(;;)
#line 986
	{
#line 986
		size_t extent = MIN(remaining, ncp->chunk);
#line 986
		size_t nget = ncx_howmany(varp->type, extent);
#line 986

#line 986
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 986
				 0, (void **)&xp);	/* cast away const */
#line 986
		if(lstatus != NC_NOERR)
#line 986
			return lstatus;
#line 986

#line 986
		lstatus = ncx_getn_ushort_longlong(&xp, nget, value);
#line 986
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 986
			status = lstatus;
#line 986

#line 986
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 986

#line 986
		remaining -= extent;
#line 986
		if(remaining == 0)
#line 986
			break; /* normal loop exit */
#line 986
		offset += (off_t)extent;
#line 986
		value += nget;
#line 986
	}
#line 986

#line 986
	return status;
#line 986
}
#line 986

static int
#line 987
getNCvx_ushort_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 987
		 const size_t *start, size_t nelems, uint *value)
#line 987
{
#line 987
	off_t offset = NC_varoffset(ncp, varp, start);
#line 987
	size_t remaining = varp->xsz * nelems;
#line 987
	int status = NC_NOERR;
#line 987
	const void *xp;
#line 987

#line 987
	if(nelems == 0)
#line 987
		return NC_NOERR;
#line 987

#line 987
	assert(value != NULL);
#line 987

#line 987
	for(;;)
#line 987
	{
#line 987
		size_t extent = MIN(remaining, ncp->chunk);
#line 987
		size_t nget = ncx_howmany(varp->type, extent);
#line 987

#line 987
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 987
				 0, (void **)&xp);	/* cast away const */
#line 987
		if(lstatus != NC_NOERR)
#line 987
			return lstatus;
#line 987

#line 987
		lstatus = ncx_getn_ushort_uint(&xp, nget, value);
#line 987
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 987
			status = lstatus;
#line 987

#line 987
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 987

#line 987
		remaining -= extent;
#line 987
		if(remaining == 0)
#line 987
			break; /* normal loop exit */
#line 987
		offset += (off_t)extent;
#line 987
		value += nget;
#line 987
	}
#line 987

#line 987
	return status;
#line 987
}
#line 987

static int
#line 988
getNCvx_ushort_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 988
		 const size_t *start, size_t nelems, ulonglong *value)
#line 988
{
#line 988
	off_t offset = NC_varoffset(ncp, varp, start);
#line 988
	size_t remaining = varp->xsz * nelems;
#line 988
	int status = NC_NOERR;
#line 988
	const void *xp;
#line 988

#line 988
	if(nelems == 0)
#line 988
		return NC_NOERR;
#line 988

#line 988
	assert(value != NULL);
#line 988

#line 988
	for(;;)
#line 988
	{
#line 988
		size_t extent = MIN(remaining, ncp->chunk);
#line 988
		size_t nget = ncx_howmany(varp->type, extent);
#line 988

#line 988
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 988
				 0, (void **)&xp);	/* cast away const */
#line 988
		if(lstatus != NC_NOERR)
#line 988
			return lstatus;
#line 988

#line 988
		lstatus = ncx_getn_ushort_ulonglong(&xp, nget, value);
#line 988
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 988
			status = lstatus;
#line 988

#line 988
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 988

#line 988
		remaining -= extent;
#line 988
		if(remaining == 0)
#line 988
			break; /* normal loop exit */
#line 988
		offset += (off_t)extent;
#line 988
		value += nget;
#line 988
	}
#line 988

#line 988
	return status;
#line 988
}
#line 988

static int
#line 989
getNCvx_ushort_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 989
		 const size_t *start, size_t nelems, ushort *value)
#line 989
{
#line 989
	off_t offset = NC_varoffset(ncp, varp, start);
#line 989
	size_t remaining = varp->xsz * nelems;
#line 989
	int status = NC_NOERR;
#line 989
	const void *xp;
#line 989

#line 989
	if(nelems == 0)
#line 989
		return NC_NOERR;
#line 989

#line 989
	assert(value != NULL);
#line 989

#line 989
	for(;;)
#line 989
	{
#line 989
		size_t extent = MIN(remaining, ncp->chunk);
#line 989
		size_t nget = ncx_howmany(varp->type, extent);
#line 989

#line 989
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 989
				 0, (void **)&xp);	/* cast away const */
#line 989
		if(lstatus != NC_NOERR)
#line 989
			return lstatus;
#line 989

#line 989
		lstatus = ncx_getn_ushort_ushort(&xp, nget, value);
#line 989
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 989
			status = lstatus;
#line 989

#line 989
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 989

#line 989
		remaining -= extent;
#line 989
		if(remaining == 0)
#line 989
			break; /* normal loop exit */
#line 989
		offset += (off_t)extent;
#line 989
		value += nget;
#line 989
	}
#line 989

#line 989
	return status;
#line 989
}
#line 989


static int
#line 991
getNCvx_uint_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 991
		 const size_t *start, size_t nelems, schar *value)
#line 991
{
#line 991
	off_t offset = NC_varoffset(ncp, varp, start);
#line 991
	size_t remaining = varp->xsz * nelems;
#line 991
	int status = NC_NOERR;
#line 991
	const void *xp;
#line 991

#line 991
	if(nelems == 0)
#line 991
		return NC_NOERR;
#line 991

#line 991
	assert(value != NULL);
#line 991

#line 991
	for(;;)
#line 991
	{
#line 991
		size_t extent = MIN(remaining, ncp->chunk);
#line 991
		size_t nget = ncx_howmany(varp->type, extent);
#line 991

#line 991
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 991
				 0, (void **)&xp);	/* cast away const */
#line 991
		if(lstatus != NC_NOERR)
#line 991
			return lstatus;
#line 991

#line 991
		lstatus = ncx_getn_uint_schar(&xp, nget, value);
#line 991
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 991
			status = lstatus;
#line 991

#line 991
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 991

#line 991
		remaining -= extent;
#line 991
		if(remaining == 0)
#line 991
			break; /* normal loop exit */
#line 991
		offset += (off_t)extent;
#line 991
		value += nget;
#line 991
	}
#line 991

#line 991
	return status;
#line 991
}
#line 991

static int
#line 992
getNCvx_uint_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 992
		 const size_t *start, size_t nelems, uchar *value)
#line 992
{
#line 992
	off_t offset = NC_varoffset(ncp, varp, start);
#line 992
	size_t remaining = varp->xsz * nelems;
#line 992
	int status = NC_NOERR;
#line 992
	const void *xp;
#line 992

#line 992
	if(nelems == 0)
#line 992
		return NC_NOERR;
#line 992

#line 992
	assert(value != NULL);
#line 992

#line 992
	for(;;)
#line 992
	{
#line 992
		size_t extent = MIN(remaining, ncp->chunk);
#line 992
		size_t nget = ncx_howmany(varp->type, extent);
#line 992

#line 992
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 992
				 0, (void **)&xp);	/* cast away const */
#line 992
		if(lstatus != NC_NOERR)
#line 992
			return lstatus;
#line 992

#line 992
		lstatus = ncx_getn_uint_uchar(&xp, nget, value);
#line 992
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 992
			status = lstatus;
#line 992

#line 992
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 992

#line 992
		remaining -= extent;
#line 992
		if(remaining == 0)
#line 992
			break; /* normal loop exit */
#line 992
		offset += (off_t)extent;
#line 992
		value += nget;
#line 992
	}
#line 992

#line 992
	return status;
#line 992
}
#line 992

static int
#line 993
getNCvx_uint_short(const NC3_INFO* ncp, const NC_var *varp,
#line 993
		 const size_t *start, size_t nelems, short *value)
#line 993
{
#line 993
	off_t offset = NC_varoffset(ncp, varp, start);
#line 993
	size_t remaining = varp->xsz * nelems;
#line 993
	int status = NC_NOERR;
#line 993
	const void *xp;
#line 993

#line 993
	if(nelems == 0)
#line 993
		return NC_NOERR;
#line 993

#line 993
	assert(value != NULL);
#line 993

#line 993
	for(;;)
#line 993
	{
#line 993
		size_t extent = MIN(remaining, ncp->chunk);
#line 993
		size_t nget = ncx_howmany(varp->type, extent);
#line 993

#line 993
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 993
				 0, (void **)&xp);	/* cast away const */
#line 993
		if(lstatus != NC_NOERR)
#line 993
			return lstatus;
#line 993

#line 993
		lstatus = ncx_getn_uint_short(&xp, nget, value);
#line 993
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 993
			status = lstatus;
#line 993

#line 993
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 993

#line 993
		remaining -= extent;
#line 993
		if(remaining == 0)
#line 993
			break; /* normal loop exit */
#line 993
		offset += (off_t)extent;
#line 993
		value += nget;
#line 993
	}
#line 993

#line 993
	return status;
#line 993
}
#line 993

static int
#line 994
getNCvx_uint_int(const NC3_INFO* ncp, const NC_var *varp,
#line 994
		 const size_t *start, size_t nelems, int *value)
#line 994
{
#line 994
	off_t offset = NC_varoffset(ncp, varp, start);
#line 994
	size_t remaining = varp->xsz * nelems;
#line 994
	int status = NC_NOERR;
#line 994
	const void *xp;
#line 994

#line 994
	if(nelems == 0)
#line 994
		return NC_NOERR;
#line 994

#line 994
	assert(value != NULL);
#line 994

#line 994
	for(;;)
#line 994
	{
#line 994
		size_t extent = MIN(remaining, ncp->chunk);
#line 994
		size_t nget = ncx_howmany(varp->type, extent);
#line 994

#line 994
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 994
				 0, (void **)&xp);	/* cast away const */
#line 994
		if(lstatus != NC_NOERR)
#line 994
			return lstatus;
#line 994

#line 994
		lstatus = ncx_getn_uint_int(&xp, nget, value);
#line 994
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 994
			status = lstatus;
#line 994

#line 994
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 994

#line 994
		remaining -= extent;
#line 994
		if(remaining == 0)
#line 994
			break; /* normal loop exit */
#line 994
		offset += (off_t)extent;
#line 994
		value += nget;
#line 994
	}
#line 994

#line 994
	return status;
#line 994
}
#line 994

static int
#line 995
getNCvx_uint_float(const NC3_INFO* ncp, const NC_var *varp,
#line 995
		 const size_t *start, size_t nelems, float *value)
#line 995
{
#line 995
	off_t offset = NC_varoffset(ncp, varp, start);
#line 995
	size_t remaining = varp->xsz * nelems;
#line 995
	int status = NC_NOERR;
#line 995
	const void *xp;
#line 995

#line 995
	if(nelems == 0)
#line 995
		return NC_NOERR;
#line 995

#line 995
	assert(value != NULL);
#line 995

#line 995
	for(;;)
#line 995
	{
#line 995
		size_t extent = MIN(remaining, ncp->chunk);
#line 995
		size_t nget = ncx_howmany(varp->type, extent);
#line 995

#line 995
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 995
				 0, (void **)&xp);	/* cast away const */
#line 995
		if(lstatus != NC_NOERR)
#line 995
			return lstatus;
#line 995

#line 995
		lstatus = ncx_getn_uint_float(&xp, nget, value);
#line 995
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 995
			status = lstatus;
#line 995

#line 995
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 995

#line 995
		remaining -= extent;
#line 995
		if(remaining == 0)
#line 995
			break; /* normal loop exit */
#line 995
		offset += (off_t)extent;
#line 995
		value += nget;
#line 995
	}
#line 995

#line 995
	return status;
#line 995
}
#line 995

static int
#line 996
getNCvx_uint_double(const NC3_INFO* ncp, const NC_var *varp,
#line 996
		 const size_t *start, size_t nelems, double *value)
#line 996
{
#line 996
	off_t offset = NC_varoffset(ncp, varp, start);
#line 996
	size_t remaining = varp->xsz * nelems;
#line 996
	int status = NC_NOERR;
#line 996
	const void *xp;
#line 996

#line 996
	if(nelems == 0)
#line 996
		return NC_NOERR;
#line 996

#line 996
	assert(value != NULL);
#line 996

#line 996
	for(;;)
#line 996
	{
#line 996
		size_t extent = MIN(remaining, ncp->chunk);
#line 996
		size_t nget = ncx_howmany(varp->type, extent);
#line 996

#line 996
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 996
				 0, (void **)&xp);	/* cast away const */
#line 996
		if(lstatus != NC_NOERR)
#line 996
			return lstatus;
#line 996

#line 996
		lstatus = ncx_getn_uint_double(&xp, nget, value);
#line 996
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 996
			status = lstatus;
#line 996

#line 996
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 996

#line 996
		remaining -= extent;
#line 996
		if(remaining == 0)
#line 996
			break; /* normal loop exit */
#line 996
		offset += (off_t)extent;
#line 996
		value += nget;
#line 996
	}
#line 996

#line 996
	return status;
#line 996
}
#line 996

static int
#line 997
getNCvx_uint_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 997
		 const size_t *start, size_t nelems, longlong *value)
#line 997
{
#line 997
	off_t offset = NC_varoffset(ncp, varp, start);
#line 997
	size_t remaining = varp->xsz * nelems;
#line 997
	int status = NC_NOERR;
#line 997
	const void *xp;
#line 997

#line 997
	if(nelems == 0)
#line 997
		return NC_NOERR;
#line 997

#line 997
	assert(value != NULL);
#line 997

#line 997
	for(;;)
#line 997
	{
#line 997
		size_t extent = MIN(remaining, ncp->chunk);
#line 997
		size_t nget = ncx_howmany(varp->type, extent);
#line 997

#line 997
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 997
				 0, (void **)&xp);	/* cast away const */
#line 997
		if(lstatus != NC_NOERR)
#line 997
			return lstatus;
#line 997

#line 997
		lstatus = ncx_getn_uint_longlong(&xp, nget, value);
#line 997
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 997
			status = lstatus;
#line 997

#line 997
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 997

#line 997
		remaining -= extent;
#line 997
		if(remaining == 0)
#line 997
			break; /* normal loop exit */
#line 997
		offset += (off_t)extent;
#line 997
		value += nget;
#line 997
	}
#line 997

#line 997
	return status;
#line 997
}
#line 997

static int
#line 998
getNCvx_uint_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 998
		 const size_t *start, size_t nelems, uint *value)
#line 998
{
#line 998
	off_t offset = NC_varoffset(ncp, varp, start);
#line 998
	size_t remaining = varp->xsz * nelems;
#line 998
	int status = NC_NOERR;
#line 998
	const void *xp;
#line 998

#line 998
	if(nelems == 0)
#line 998
		return NC_NOERR;
#line 998

#line 998
	assert(value != NULL);
#line 998

#line 998
	for(;;)
#line 998
	{
#line 998
		size_t extent = MIN(remaining, ncp->chunk);
#line 998
		size_t nget = ncx_howmany(varp->type, extent);
#line 998

#line 998
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 998
				 0, (void **)&xp);	/* cast away const */
#line 998
		if(lstatus != NC_NOERR)
#line 998
			return lstatus;
#line 998

#line 998
		lstatus = ncx_getn_uint_uint(&xp, nget, value);
#line 998
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 998
			status = lstatus;
#line 998

#line 998
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 998

#line 998
		remaining -= extent;
#line 998
		if(remaining == 0)
#line 998
			break; /* normal loop exit */
#line 998
		offset += (off_t)extent;
#line 998
		value += nget;
#line 998
	}
#line 998

#line 998
	return status;
#line 998
}
#line 998

static int
#line 999
getNCvx_uint_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 999
		 const size_t *start, size_t nelems, ulonglong *value)
#line 999
{
#line 999
	off_t offset = NC_varoffset(ncp, varp, start);
#line 999
	size_t remaining = varp->xsz * nelems;
#line 999
	int status = NC_NOERR;
#line 999
	const void *xp;
#line 999

#line 999
	if(nelems == 0)
#line 999
		return NC_NOERR;
#line 999

#line 999
	assert(value != NULL);
#line 999

#line 999
	for(;;)
#line 999
	{
#line 999
		size_t extent = MIN(remaining, ncp->chunk);
#line 999
		size_t nget = ncx_howmany(varp->type, extent);
#line 999

#line 999
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 999
				 0, (void **)&xp);	/* cast away const */
#line 999
		if(lstatus != NC_NOERR)
#line 999
			return lstatus;
#line 999

#line 999
		lstatus = ncx_getn_uint_ulonglong(&xp, nget, value);
#line 999
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 999
			status = lstatus;
#line 999

#line 999
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 999

#line 999
		remaining -= extent;
#line 999
		if(remaining == 0)
#line 999
			break; /* normal loop exit */
#line 999
		offset += (off_t)extent;
#line 999
		value += nget;
#line 999
	}
#line 999

#line 999
	return status;
#line 999
}
#line 999

static int
#line 1000
getNCvx_uint_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 1000
		 const size_t *start, size_t nelems, ushort *value)
#line 1000
{
#line 1000
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1000
	size_t remaining = varp->xsz * nelems;
#line 1000
	int status = NC_NOERR;
#line 1000
	const void *xp;
#line 1000

#line 1000
	if(nelems == 0)
#line 1000
		return NC_NOERR;
#line 1000

#line 1000
	assert(value != NULL);
#line 1000

#line 1000
	for(;;)
#line 1000
	{
#line 1000
		size_t extent = MIN(remaining, ncp->chunk);
#line 1000
		size_t nget = ncx_howmany(varp->type, extent);
#line 1000

#line 1000
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1000
				 0, (void **)&xp);	/* cast away const */
#line 1000
		if(lstatus != NC_NOERR)
#line 1000
			return lstatus;
#line 1000

#line 1000
		lstatus = ncx_getn_uint_ushort(&xp, nget, value);
#line 1000
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1000
			status = lstatus;
#line 1000

#line 1000
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1000

#line 1000
		remaining -= extent;
#line 1000
		if(remaining == 0)
#line 1000
			break; /* normal loop exit */
#line 1000
		offset += (off_t)extent;
#line 1000
		value += nget;
#line 1000
	}
#line 1000

#line 1000
	return status;
#line 1000
}
#line 1000


static int
#line 1002
getNCvx_longlong_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 1002
		 const size_t *start, size_t nelems, schar *value)
#line 1002
{
#line 1002
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1002
	size_t remaining = varp->xsz * nelems;
#line 1002
	int status = NC_NOERR;
#line 1002
	const void *xp;
#line 1002

#line 1002
	if(nelems == 0)
#line 1002
		return NC_NOERR;
#line 1002

#line 1002
	assert(value != NULL);
#line 1002

#line 1002
	for(;;)
#line 1002
	{
#line 1002
		size_t extent = MIN(remaining, ncp->chunk);
#line 1002
		size_t nget = ncx_howmany(varp->type, extent);
#line 1002

#line 1002
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1002
				 0, (void **)&xp);	/* cast away const */
#line 1002
		if(lstatus != NC_NOERR)
#line 1002
			return lstatus;
#line 1002

#line 1002
		lstatus = ncx_getn_longlong_schar(&xp, nget, value);
#line 1002
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1002
			status = lstatus;
#line 1002

#line 1002
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1002

#line 1002
		remaining -= extent;
#line 1002
		if(remaining == 0)
#line 1002
			break; /* normal loop exit */
#line 1002
		offset += (off_t)extent;
#line 1002
		value += nget;
#line 1002
	}
#line 1002

#line 1002
	return status;
#line 1002
}
#line 1002

static int
#line 1003
getNCvx_longlong_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 1003
		 const size_t *start, size_t nelems, uchar *value)
#line 1003
{
#line 1003
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1003
	size_t remaining = varp->xsz * nelems;
#line 1003
	int status = NC_NOERR;
#line 1003
	const void *xp;
#line 1003

#line 1003
	if(nelems == 0)
#line 1003
		return NC_NOERR;
#line 1003

#line 1003
	assert(value != NULL);
#line 1003

#line 1003
	for(;;)
#line 1003
	{
#line 1003
		size_t extent = MIN(remaining, ncp->chunk);
#line 1003
		size_t nget = ncx_howmany(varp->type, extent);
#line 1003

#line 1003
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1003
				 0, (void **)&xp);	/* cast away const */
#line 1003
		if(lstatus != NC_NOERR)
#line 1003
			return lstatus;
#line 1003

#line 1003
		lstatus = ncx_getn_longlong_uchar(&xp, nget, value);
#line 1003
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1003
			status = lstatus;
#line 1003

#line 1003
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1003

#line 1003
		remaining -= extent;
#line 1003
		if(remaining == 0)
#line 1003
			break; /* normal loop exit */
#line 1003
		offset += (off_t)extent;
#line 1003
		value += nget;
#line 1003
	}
#line 1003

#line 1003
	return status;
#line 1003
}
#line 1003

static int
#line 1004
getNCvx_longlong_short(const NC3_INFO* ncp, const NC_var *varp,
#line 1004
		 const size_t *start, size_t nelems, short *value)
#line 1004
{
#line 1004
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1004
	size_t remaining = varp->xsz * nelems;
#line 1004
	int status = NC_NOERR;
#line 1004
	const void *xp;
#line 1004

#line 1004
	if(nelems == 0)
#line 1004
		return NC_NOERR;
#line 1004

#line 1004
	assert(value != NULL);
#line 1004

#line 1004
	for(;;)
#line 1004
	{
#line 1004
		size_t extent = MIN(remaining, ncp->chunk);
#line 1004
		size_t nget = ncx_howmany(varp->type, extent);
#line 1004

#line 1004
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1004
				 0, (void **)&xp);	/* cast away const */
#line 1004
		if(lstatus != NC_NOERR)
#line 1004
			return lstatus;
#line 1004

#line 1004
		lstatus = ncx_getn_longlong_short(&xp, nget, value);
#line 1004
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1004
			status = lstatus;
#line 1004

#line 1004
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1004

#line 1004
		remaining -= extent;
#line 1004
		if(remaining == 0)
#line 1004
			break; /* normal loop exit */
#line 1004
		offset += (off_t)extent;
#line 1004
		value += nget;
#line 1004
	}
#line 1004

#line 1004
	return status;
#line 1004
}
#line 1004

static int
#line 1005
getNCvx_longlong_int(const NC3_INFO* ncp, const NC_var *varp,
#line 1005
		 const size_t *start, size_t nelems, int *value)
#line 1005
{
#line 1005
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1005
	size_t remaining = varp->xsz * nelems;
#line 1005
	int status = NC_NOERR;
#line 1005
	const void *xp;
#line 1005

#line 1005
	if(nelems == 0)
#line 1005
		return NC_NOERR;
#line 1005

#line 1005
	assert(value != NULL);
#line 1005

#line 1005
	for(;;)
#line 1005
	{
#line 1005
		size_t extent = MIN(remaining, ncp->chunk);
#line 1005
		size_t nget = ncx_howmany(varp->type, extent);
#line 1005

#line 1005
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1005
				 0, (void **)&xp);	/* cast away const */
#line 1005
		if(lstatus != NC_NOERR)
#line 1005
			return lstatus;
#line 1005

#line 1005
		lstatus = ncx_getn_longlong_int(&xp, nget, value);
#line 1005
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1005
			status = lstatus;
#line 1005

#line 1005
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1005

#line 1005
		remaining -= extent;
#line 1005
		if(remaining == 0)
#line 1005
			break; /* normal loop exit */
#line 1005
		offset += (off_t)extent;
#line 1005
		value += nget;
#line 1005
	}
#line 1005

#line 1005
	return status;
#line 1005
}
#line 1005

static int
#line 1006
getNCvx_longlong_float(const NC3_INFO* ncp, const NC_var *varp,
#line 1006
		 const size_t *start, size_t nelems, float *value)
#line 1006
{
#line 1006
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1006
	size_t remaining = varp->xsz * nelems;
#line 1006
	int status = NC_NOERR;
#line 1006
	const void *xp;
#line 1006

#line 1006
	if(nelems == 0)
#line 1006
		return NC_NOERR;
#line 1006

#line 1006
	assert(value != NULL);
#line 1006

#line 1006
	for(;;)
#line 1006
	{
#line 1006
		size_t extent = MIN(remaining, ncp->chunk);
#line 1006
		size_t nget = ncx_howmany(varp->type, extent);
#line 1006

#line 1006
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1006
				 0, (void **)&xp);	/* cast away const */
#line 1006
		if(lstatus != NC_NOERR)
#line 1006
			return lstatus;
#line 1006

#line 1006
		lstatus = ncx_getn_longlong_float(&xp, nget, value);
#line 1006
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1006
			status = lstatus;
#line 1006

#line 1006
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1006

#line 1006
		remaining -= extent;
#line 1006
		if(remaining == 0)
#line 1006
			break; /* normal loop exit */
#line 1006
		offset += (off_t)extent;
#line 1006
		value += nget;
#line 1006
	}
#line 1006

#line 1006
	return status;
#line 1006
}
#line 1006

static int
#line 1007
getNCvx_longlong_double(const NC3_INFO* ncp, const NC_var *varp,
#line 1007
		 const size_t *start, size_t nelems, double *value)
#line 1007
{
#line 1007
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1007
	size_t remaining = varp->xsz * nelems;
#line 1007
	int status = NC_NOERR;
#line 1007
	const void *xp;
#line 1007

#line 1007
	if(nelems == 0)
#line 1007
		return NC_NOERR;
#line 1007

#line 1007
	assert(value != NULL);
#line 1007

#line 1007
	for(;;)
#line 1007
	{
#line 1007
		size_t extent = MIN(remaining, ncp->chunk);
#line 1007
		size_t nget = ncx_howmany(varp->type, extent);
#line 1007

#line 1007
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1007
				 0, (void **)&xp);	/* cast away const */
#line 1007
		if(lstatus != NC_NOERR)
#line 1007
			return lstatus;
#line 1007

#line 1007
		lstatus = ncx_getn_longlong_double(&xp, nget, value);
#line 1007
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1007
			status = lstatus;
#line 1007

#line 1007
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1007

#line 1007
		remaining -= extent;
#line 1007
		if(remaining == 0)
#line 1007
			break; /* normal loop exit */
#line 1007
		offset += (off_t)extent;
#line 1007
		value += nget;
#line 1007
	}
#line 1007

#line 1007
	return status;
#line 1007
}
#line 1007

static int
#line 1008
getNCvx_longlong_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 1008
		 const size_t *start, size_t nelems, longlong *value)
#line 1008
{
#line 1008
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1008
	size_t remaining = varp->xsz * nelems;
#line 1008
	int status = NC_NOERR;
#line 1008
	const void *xp;
#line 1008

#line 1008
	if(nelems == 0)
#line 1008
		return NC_NOERR;
#line 1008

#line 1008
	assert(value != NULL);
#line 1008

#line 1008
	for(;;)
#line 1008
	{
#line 1008
		size_t extent = MIN(remaining, ncp->chunk);
#line 1008
		size_t nget = ncx_howmany(varp->type, extent);
#line 1008

#line 1008
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1008
				 0, (void **)&xp);	/* cast away const */
#line 1008
		if(lstatus != NC_NOERR)
#line 1008
			return lstatus;
#line 1008

#line 1008
		lstatus = ncx_getn_longlong_longlong(&xp, nget, value);
#line 1008
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1008
			status = lstatus;
#line 1008

#line 1008
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1008

#line 1008
		remaining -= extent;
#line 1008
		if(remaining == 0)
#line 1008
			break; /* normal loop exit */
#line 1008
		offset += (off_t)extent;
#line 1008
		value += nget;
#line 1008
	}
#line 1008

#line 1008
	return status;
#line 1008
}
#line 1008

static int
#line 1009
getNCvx_longlong_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 1009
		 const size_t *start, size_t nelems, uint *value)
#line 1009
{
#line 1009
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1009
	size_t remaining = varp->xsz * nelems;
#line 1009
	int status = NC_NOERR;
#line 1009
	const void *xp;
#line 1009

#line 1009
	if(nelems == 0)
#line 1009
		return NC_NOERR;
#line 1009

#line 1009
	assert(value != NULL);
#line 1009

#line 1009
	for(;;)
#line 1009
	{
#line 1009
		size_t extent = MIN(remaining, ncp->chunk);
#line 1009
		size_t nget = ncx_howmany(varp->type, extent);
#line 1009

#line 1009
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1009
				 0, (void **)&xp);	/* cast away const */
#line 1009
		if(lstatus != NC_NOERR)
#line 1009
			return lstatus;
#line 1009

#line 1009
		lstatus = ncx_getn_longlong_uint(&xp, nget, value);
#line 1009
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1009
			status = lstatus;
#line 1009

#line 1009
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1009

#line 1009
		remaining -= extent;
#line 1009
		if(remaining == 0)
#line 1009
			break; /* normal loop exit */
#line 1009
		offset += (off_t)extent;
#line 1009
		value += nget;
#line 1009
	}
#line 1009

#line 1009
	return status;
#line 1009
}
#line 1009

static int
#line 1010
getNCvx_longlong_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 1010
		 const size_t *start, size_t nelems, ulonglong *value)
#line 1010
{
#line 1010
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1010
	size_t remaining = varp->xsz * nelems;
#line 1010
	int status = NC_NOERR;
#line 1010
	const void *xp;
#line 1010

#line 1010
	if(nelems == 0)
#line 1010
		return NC_NOERR;
#line 1010

#line 1010
	assert(value != NULL);
#line 1010

#line 1010
	for(;;)
#line 1010
	{
#line 1010
		size_t extent = MIN(remaining, ncp->chunk);
#line 1010
		size_t nget = ncx_howmany(varp->type, extent);
#line 1010

#line 1010
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1010
				 0, (void **)&xp);	/* cast away const */
#line 1010
		if(lstatus != NC_NOERR)
#line 1010
			return lstatus;
#line 1010

#line 1010
		lstatus = ncx_getn_longlong_ulonglong(&xp, nget, value);
#line 1010
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1010
			status = lstatus;
#line 1010

#line 1010
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1010

#line 1010
		remaining -= extent;
#line 1010
		if(remaining == 0)
#line 1010
			break; /* normal loop exit */
#line 1010
		offset += (off_t)extent;
#line 1010
		value += nget;
#line 1010
	}
#line 1010

#line 1010
	return status;
#line 1010
}
#line 1010

static int
#line 1011
getNCvx_longlong_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 1011
		 const size_t *start, size_t nelems, ushort *value)
#line 1011
{
#line 1011
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1011
	size_t remaining = varp->xsz * nelems;
#line 1011
	int status = NC_NOERR;
#line 1011
	const void *xp;
#line 1011

#line 1011
	if(nelems == 0)
#line 1011
		return NC_NOERR;
#line 1011

#line 1011
	assert(value != NULL);
#line 1011

#line 1011
	for(;;)
#line 1011
	{
#line 1011
		size_t extent = MIN(remaining, ncp->chunk);
#line 1011
		size_t nget = ncx_howmany(varp->type, extent);
#line 1011

#line 1011
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1011
				 0, (void **)&xp);	/* cast away const */
#line 1011
		if(lstatus != NC_NOERR)
#line 1011
			return lstatus;
#line 1011

#line 1011
		lstatus = ncx_getn_longlong_ushort(&xp, nget, value);
#line 1011
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1011
			status = lstatus;
#line 1011

#line 1011
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1011

#line 1011
		remaining -= extent;
#line 1011
		if(remaining == 0)
#line 1011
			break; /* normal loop exit */
#line 1011
		offset += (off_t)extent;
#line 1011
		value += nget;
#line 1011
	}
#line 1011

#line 1011
	return status;
#line 1011
}
#line 1011


static int
#line 1013
getNCvx_ulonglong_schar(const NC3_INFO* ncp, const NC_var *varp,
#line 1013
		 const size_t *start, size_t nelems, schar *value)
#line 1013
{
#line 1013
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1013
	size_t remaining = varp->xsz * nelems;
#line 1013
	int status = NC_NOERR;
#line 1013
	const void *xp;
#line 1013

#line 1013
	if(nelems == 0)
#line 1013
		return NC_NOERR;
#line 1013

#line 1013
	assert(value != NULL);
#line 1013

#line 1013
	for(;;)
#line 1013
	{
#line 1013
		size_t extent = MIN(remaining, ncp->chunk);
#line 1013
		size_t nget = ncx_howmany(varp->type, extent);
#line 1013

#line 1013
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1013
				 0, (void **)&xp);	/* cast away const */
#line 1013
		if(lstatus != NC_NOERR)
#line 1013
			return lstatus;
#line 1013

#line 1013
		lstatus = ncx_getn_ulonglong_schar(&xp, nget, value);
#line 1013
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1013
			status = lstatus;
#line 1013

#line 1013
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1013

#line 1013
		remaining -= extent;
#line 1013
		if(remaining == 0)
#line 1013
			break; /* normal loop exit */
#line 1013
		offset += (off_t)extent;
#line 1013
		value += nget;
#line 1013
	}
#line 1013

#line 1013
	return status;
#line 1013
}
#line 1013

static int
#line 1014
getNCvx_ulonglong_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 1014
		 const size_t *start, size_t nelems, uchar *value)
#line 1014
{
#line 1014
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1014
	size_t remaining = varp->xsz * nelems;
#line 1014
	int status = NC_NOERR;
#line 1014
	const void *xp;
#line 1014

#line 1014
	if(nelems == 0)
#line 1014
		return NC_NOERR;
#line 1014

#line 1014
	assert(value != NULL);
#line 1014

#line 1014
	for(;;)
#line 1014
	{
#line 1014
		size_t extent = MIN(remaining, ncp->chunk);
#line 1014
		size_t nget = ncx_howmany(varp->type, extent);
#line 1014

#line 1014
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1014
				 0, (void **)&xp);	/* cast away const */
#line 1014
		if(lstatus != NC_NOERR)
#line 1014
			return lstatus;
#line 1014

#line 1014
		lstatus = ncx_getn_ulonglong_uchar(&xp, nget, value);
#line 1014
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1014
			status = lstatus;
#line 1014

#line 1014
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1014

#line 1014
		remaining -= extent;
#line 1014
		if(remaining == 0)
#line 1014
			break; /* normal loop exit */
#line 1014
		offset += (off_t)extent;
#line 1014
		value += nget;
#line 1014
	}
#line 1014

#line 1014
	return status;
#line 1014
}
#line 1014

static int
#line 1015
getNCvx_ulonglong_short(const NC3_INFO* ncp, const NC_var *varp,
#line 1015
		 const size_t *start, size_t nelems, short *value)
#line 1015
{
#line 1015
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1015
	size_t remaining = varp->xsz * nelems;
#line 1015
	int status = NC_NOERR;
#line 1015
	const void *xp;
#line 1015

#line 1015
	if(nelems == 0)
#line 1015
		return NC_NOERR;
#line 1015

#line 1015
	assert(value != NULL);
#line 1015

#line 1015
	for(;;)
#line 1015
	{
#line 1015
		size_t extent = MIN(remaining, ncp->chunk);
#line 1015
		size_t nget = ncx_howmany(varp->type, extent);
#line 1015

#line 1015
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1015
				 0, (void **)&xp);	/* cast away const */
#line 1015
		if(lstatus != NC_NOERR)
#line 1015
			return lstatus;
#line 1015

#line 1015
		lstatus = ncx_getn_ulonglong_short(&xp, nget, value);
#line 1015
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1015
			status = lstatus;
#line 1015

#line 1015
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1015

#line 1015
		remaining -= extent;
#line 1015
		if(remaining == 0)
#line 1015
			break; /* normal loop exit */
#line 1015
		offset += (off_t)extent;
#line 1015
		value += nget;
#line 1015
	}
#line 1015

#line 1015
	return status;
#line 1015
}
#line 1015

static int
#line 1016
getNCvx_ulonglong_int(const NC3_INFO* ncp, const NC_var *varp,
#line 1016
		 const size_t *start, size_t nelems, int *value)
#line 1016
{
#line 1016
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1016
	size_t remaining = varp->xsz * nelems;
#line 1016
	int status = NC_NOERR;
#line 1016
	const void *xp;
#line 1016

#line 1016
	if(nelems == 0)
#line 1016
		return NC_NOERR;
#line 1016

#line 1016
	assert(value != NULL);
#line 1016

#line 1016
	for(;;)
#line 1016
	{
#line 1016
		size_t extent = MIN(remaining, ncp->chunk);
#line 1016
		size_t nget = ncx_howmany(varp->type, extent);
#line 1016

#line 1016
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1016
				 0, (void **)&xp);	/* cast away const */
#line 1016
		if(lstatus != NC_NOERR)
#line 1016
			return lstatus;
#line 1016

#line 1016
		lstatus = ncx_getn_ulonglong_int(&xp, nget, value);
#line 1016
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1016
			status = lstatus;
#line 1016

#line 1016
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1016

#line 1016
		remaining -= extent;
#line 1016
		if(remaining == 0)
#line 1016
			break; /* normal loop exit */
#line 1016
		offset += (off_t)extent;
#line 1016
		value += nget;
#line 1016
	}
#line 1016

#line 1016
	return status;
#line 1016
}
#line 1016

static int
#line 1017
getNCvx_ulonglong_float(const NC3_INFO* ncp, const NC_var *varp,
#line 1017
		 const size_t *start, size_t nelems, float *value)
#line 1017
{
#line 1017
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1017
	size_t remaining = varp->xsz * nelems;
#line 1017
	int status = NC_NOERR;
#line 1017
	const void *xp;
#line 1017

#line 1017
	if(nelems == 0)
#line 1017
		return NC_NOERR;
#line 1017

#line 1017
	assert(value != NULL);
#line 1017

#line 1017
	for(;;)
#line 1017
	{
#line 1017
		size_t extent = MIN(remaining, ncp->chunk);
#line 1017
		size_t nget = ncx_howmany(varp->type, extent);
#line 1017

#line 1017
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1017
				 0, (void **)&xp);	/* cast away const */
#line 1017
		if(lstatus != NC_NOERR)
#line 1017
			return lstatus;
#line 1017

#line 1017
		lstatus = ncx_getn_ulonglong_float(&xp, nget, value);
#line 1017
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1017
			status = lstatus;
#line 1017

#line 1017
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1017

#line 1017
		remaining -= extent;
#line 1017
		if(remaining == 0)
#line 1017
			break; /* normal loop exit */
#line 1017
		offset += (off_t)extent;
#line 1017
		value += nget;
#line 1017
	}
#line 1017

#line 1017
	return status;
#line 1017
}
#line 1017

static int
#line 1018
getNCvx_ulonglong_double(const NC3_INFO* ncp, const NC_var *varp,
#line 1018
		 const size_t *start, size_t nelems, double *value)
#line 1018
{
#line 1018
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1018
	size_t remaining = varp->xsz * nelems;
#line 1018
	int status = NC_NOERR;
#line 1018
	const void *xp;
#line 1018

#line 1018
	if(nelems == 0)
#line 1018
		return NC_NOERR;
#line 1018

#line 1018
	assert(value != NULL);
#line 1018

#line 1018
	for(;;)
#line 1018
	{
#line 1018
		size_t extent = MIN(remaining, ncp->chunk);
#line 1018
		size_t nget = ncx_howmany(varp->type, extent);
#line 1018

#line 1018
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1018
				 0, (void **)&xp);	/* cast away const */
#line 1018
		if(lstatus != NC_NOERR)
#line 1018
			return lstatus;
#line 1018

#line 1018
		lstatus = ncx_getn_ulonglong_double(&xp, nget, value);
#line 1018
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1018
			status = lstatus;
#line 1018

#line 1018
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1018

#line 1018
		remaining -= extent;
#line 1018
		if(remaining == 0)
#line 1018
			break; /* normal loop exit */
#line 1018
		offset += (off_t)extent;
#line 1018
		value += nget;
#line 1018
	}
#line 1018

#line 1018
	return status;
#line 1018
}
#line 1018

static int
#line 1019
getNCvx_ulonglong_longlong(const NC3_INFO* ncp, const NC_var *varp,
#line 1019
		 const size_t *start, size_t nelems, longlong *value)
#line 1019
{
#line 1019
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1019
	size_t remaining = varp->xsz * nelems;
#line 1019
	int status = NC_NOERR;
#line 1019
	const void *xp;
#line 1019

#line 1019
	if(nelems == 0)
#line 1019
		return NC_NOERR;
#line 1019

#line 1019
	assert(value != NULL);
#line 1019

#line 1019
	for(;;)
#line 1019
	{
#line 1019
		size_t extent = MIN(remaining, ncp->chunk);
#line 1019
		size_t nget = ncx_howmany(varp->type, extent);
#line 1019

#line 1019
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1019
				 0, (void **)&xp);	/* cast away const */
#line 1019
		if(lstatus != NC_NOERR)
#line 1019
			return lstatus;
#line 1019

#line 1019
		lstatus = ncx_getn_ulonglong_longlong(&xp, nget, value);
#line 1019
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1019
			status = lstatus;
#line 1019

#line 1019
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1019

#line 1019
		remaining -= extent;
#line 1019
		if(remaining == 0)
#line 1019
			break; /* normal loop exit */
#line 1019
		offset += (off_t)extent;
#line 1019
		value += nget;
#line 1019
	}
#line 1019

#line 1019
	return status;
#line 1019
}
#line 1019

static int
#line 1020
getNCvx_ulonglong_uint(const NC3_INFO* ncp, const NC_var *varp,
#line 1020
		 const size_t *start, size_t nelems, uint *value)
#line 1020
{
#line 1020
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1020
	size_t remaining = varp->xsz * nelems;
#line 1020
	int status = NC_NOERR;
#line 1020
	const void *xp;
#line 1020

#line 1020
	if(nelems == 0)
#line 1020
		return NC_NOERR;
#line 1020

#line 1020
	assert(value != NULL);
#line 1020

#line 1020
	for(;;)
#line 1020
	{
#line 1020
		size_t extent = MIN(remaining, ncp->chunk);
#line 1020
		size_t nget = ncx_howmany(varp->type, extent);
#line 1020

#line 1020
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1020
				 0, (void **)&xp);	/* cast away const */
#line 1020
		if(lstatus != NC_NOERR)
#line 1020
			return lstatus;
#line 1020

#line 1020
		lstatus = ncx_getn_ulonglong_uint(&xp, nget, value);
#line 1020
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1020
			status = lstatus;
#line 1020

#line 1020
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1020

#line 1020
		remaining -= extent;
#line 1020
		if(remaining == 0)
#line 1020
			break; /* normal loop exit */
#line 1020
		offset += (off_t)extent;
#line 1020
		value += nget;
#line 1020
	}
#line 1020

#line 1020
	return status;
#line 1020
}
#line 1020

static int
#line 1021
getNCvx_ulonglong_ulonglong(const NC3_INFO* ncp, const NC_var *varp,
#line 1021
		 const size_t *start, size_t nelems, ulonglong *value)
#line 1021
{
#line 1021
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1021
	size_t remaining = varp->xsz * nelems;
#line 1021
	int status = NC_NOERR;
#line 1021
	const void *xp;
#line 1021

#line 1021
	if(nelems == 0)
#line 1021
		return NC_NOERR;
#line 1021

#line 1021
	assert(value != NULL);
#line 1021

#line 1021
	for(;;)
#line 1021
	{
#line 1021
		size_t extent = MIN(remaining, ncp->chunk);
#line 1021
		size_t nget = ncx_howmany(varp->type, extent);
#line 1021

#line 1021
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1021
				 0, (void **)&xp);	/* cast away const */
#line 1021
		if(lstatus != NC_NOERR)
#line 1021
			return lstatus;
#line 1021

#line 1021
		lstatus = ncx_getn_ulonglong_ulonglong(&xp, nget, value);
#line 1021
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1021
			status = lstatus;
#line 1021

#line 1021
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1021

#line 1021
		remaining -= extent;
#line 1021
		if(remaining == 0)
#line 1021
			break; /* normal loop exit */
#line 1021
		offset += (off_t)extent;
#line 1021
		value += nget;
#line 1021
	}
#line 1021

#line 1021
	return status;
#line 1021
}
#line 1021

static int
#line 1022
getNCvx_ulonglong_ushort(const NC3_INFO* ncp, const NC_var *varp,
#line 1022
		 const size_t *start, size_t nelems, ushort *value)
#line 1022
{
#line 1022
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1022
	size_t remaining = varp->xsz * nelems;
#line 1022
	int status = NC_NOERR;
#line 1022
	const void *xp;
#line 1022

#line 1022
	if(nelems == 0)
#line 1022
		return NC_NOERR;
#line 1022

#line 1022
	assert(value != NULL);
#line 1022

#line 1022
	for(;;)
#line 1022
	{
#line 1022
		size_t extent = MIN(remaining, ncp->chunk);
#line 1022
		size_t nget = ncx_howmany(varp->type, extent);
#line 1022

#line 1022
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1022
				 0, (void **)&xp);	/* cast away const */
#line 1022
		if(lstatus != NC_NOERR)
#line 1022
			return lstatus;
#line 1022

#line 1022
		lstatus = ncx_getn_ulonglong_ushort(&xp, nget, value);
#line 1022
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1022
			status = lstatus;
#line 1022

#line 1022
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1022

#line 1022
		remaining -= extent;
#line 1022
		if(remaining == 0)
#line 1022
			break; /* normal loop exit */
#line 1022
		offset += (off_t)extent;
#line 1022
		value += nget;
#line 1022
	}
#line 1022

#line 1022
	return status;
#line 1022
}
#line 1022


#line 1025
#ifdef NOTUSED
static int
#line 1026
getNCvx_schar_uchar(const NC3_INFO* ncp, const NC_var *varp,
#line 1026
		 const size_t *start, size_t nelems, uchar *value)
#line 1026
{
#line 1026
	off_t offset = NC_varoffset(ncp, varp, start);
#line 1026
	size_t remaining = varp->xsz * nelems;
#line 1026
	int status = NC_NOERR;
#line 1026
	const void *xp;
#line 1026

#line 1026
	if(nelems == 0)
#line 1026
		return NC_NOERR;
#line 1026

#line 1026
	assert(value != NULL);
#line 1026

#line 1026
	for(;;)
#line 1026
	{
#line 1026
		size_t extent = MIN(remaining, ncp->chunk);
#line 1026
		size_t nget = ncx_howmany(varp->type, extent);
#line 1026

#line 1026
		int lstatus = ncio_get(ncp->nciop, offset, extent,
#line 1026
				 0, (void **)&xp);	/* cast away const */
#line 1026
		if(lstatus != NC_NOERR)
#line 1026
			return lstatus;
#line 1026

#line 1026
		lstatus = ncx_getn_schar_uchar(&xp, nget, value);
#line 1026
		if(lstatus != NC_NOERR && status == NC_NOERR)
#line 1026
			status = lstatus;
#line 1026

#line 1026
		(void) ncio_rel(ncp->nciop, offset, 0);
#line 1026

#line 1026
		remaining -= extent;
#line 1026
		if(remaining == 0)
#line 1026
			break; /* normal loop exit */
#line 1026
		offset += (off_t)extent;
#line 1026
		value += nget;
#line 1026
	}
#line 1026

#line 1026
	return status;
#line 1026
}
#line 1026

#endif /*NOTUSED*/

/*
 *  For ncvar{put,get},
 *  find the largest contiguous block from within 'edges'.
 *  returns the index to the left of this (which may be -1).
 *  Compute the number of contiguous elements and return
 *  that in *iocountp.
 *  The presence of "record" variables makes this routine
 *  overly subtle.
 */
static int
NCiocount(const NC3_INFO* const ncp, const NC_var *const varp,
	const size_t *const edges,
	size_t *const iocountp)
{
	const size_t *edp0 = edges;
	const size_t *edp = edges + varp->ndims;
	const size_t *shp = varp->shape + varp->ndims;

	if(IS_RECVAR(varp))
	{
		if(varp->ndims == 1 && ncp->recsize <= varp->len)
		{
			/* one dimensional && the only 'record' variable */
			*iocountp = *edges;
			return(0);
		}
		/* else */
		edp0++;
	}

	assert(edges != NULL);

	/* find max contiguous */
	while(edp > edp0)
	{
		shp--; edp--;
		if(*edp < *shp )
		{
			const size_t *zedp = edp;
			while(zedp >= edp0)
			{
				if(*zedp == 0)
				{
					*iocountp = 0;
					goto done;
				}
				/* Tip of the hat to segmented architectures */
				if(zedp == edp0)
					break;
				zedp--;
			}
			break;
		}
		assert(*edp == *shp);
	}

	/*
	 * edp, shp reference rightmost index s.t. *(edp +1) == *(shp +1)
	 *
	 * Or there is only one dimension.
	 * If there is only one dimension and it is 'non record' dimension,
	 * 	edp is &edges[0] and we will return -1.
	 * If there is only one dimension and and it is a "record dimension",
	 *	edp is &edges[1] (out of bounds) and we will return 0;
	 */
	assert(shp >= varp->shape + varp->ndims -1
		|| *(edp +1) == *(shp +1));

	/* now accumulate max count for a single io operation */
	for(*iocountp = 1, edp0 = edp;
		 	edp0 < edges + varp->ndims;
			edp0++)
	{
		*iocountp *= *edp0;
	}

done:
	return((int)(edp - edges) - 1);
}


/*
 * Set the elements of the array 'upp' to
 * the sum of the corresponding elements of
 * 'stp' and 'edp'. 'end' should be &stp[nelems].
 */
static void
set_upper(size_t *upp, /* modified on return */
	const size_t *stp,
	const size_t *edp,
	const size_t *const end)
{
	while(upp < end) {
		*upp++ = *stp++ + *edp++;
	}
}


/*
 * The infamous and oft-discussed odometer code.
 *
 * 'start[]' is the starting coordinate.
 * 'upper[]' is the upper bound s.t. start[ii] < upper[ii].
 * 'coord[]' is the register, the current coordinate value.
 * For some ii,
 * upp == &upper[ii]
 * cdp == &coord[ii]
 *
 * Running this routine increments *cdp.
 *
 * If after the increment, *cdp is equal to *upp
 * (and cdp is not the leftmost dimension),
 * *cdp is "zeroed" to the starting value and
 * we need to "carry", eg, increment one place to
 * the left.
 *
 * TODO: Some architectures hate recursion?
 * 	Reimplement non-recursively.
 */
static void
odo1(const size_t *const start, const size_t *const upper,
	size_t *const coord, /* modified on return */
	const size_t *upp,
	size_t *cdp)
{
	assert(coord <= cdp && cdp <= coord + NC_MAX_VAR_DIMS);
	assert(upper <= upp && upp <= upper + NC_MAX_VAR_DIMS);
	assert(upp - upper == cdp - coord);

	assert(*cdp <= *upp);

	(*cdp)++;
	if(cdp != coord && *cdp >= *upp)
	{
		*cdp = start[cdp - coord];
		odo1(start, upper, coord, upp -1, cdp -1);
	}
}
#ifdef _CRAYC
#pragma _CRI noinline odo1
#endif


#line 1188

/* Define a macro to allow hash on two type values */
#define CASE(nc1,nc2) (nc1*256+nc2)

static int
readNCv(const NC3_INFO* ncp, const NC_var* varp, const size_t* start,
        const size_t nelems, void* value, const nc_type memtype)
{
    int status = NC_NOERR;
    switch (CASE(varp->type,memtype)) {

    case CASE(NC_CHAR,NC_CHAR):
    case CASE(NC_CHAR,NC_UBYTE):
#ifndef __CHAR_UNSIGNED__
       return getNCvx_char_char(ncp,varp,start,nelems,(char*)value);
#else
    return getNCvx_schar_schar(ncp,varp,start,nelems,(signed char*)value);
#endif
    break;
    case CASE(NC_BYTE,NC_BYTE):
        return getNCvx_schar_schar(ncp,varp,start,nelems, (schar*)value);
	break;
    case CASE(NC_BYTE,NC_UBYTE):
        if (fIsSet(ncp->flags,NC_64BIT_DATA))
            return getNCvx_schar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
        else
            /* for CDF-1 and CDF-2, NC_BYTE is treated the same type as uchar memtype */
            return getNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_BYTE,NC_SHORT):
        return getNCvx_schar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_BYTE,NC_INT):
        return getNCvx_schar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_BYTE,NC_FLOAT):
        return getNCvx_schar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_BYTE,NC_DOUBLE):
        return getNCvx_schar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_BYTE,NC_INT64):
        return getNCvx_schar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_BYTE,NC_UINT):
        return getNCvx_schar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_BYTE,NC_UINT64):
        return getNCvx_schar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
    	break;
    case CASE(NC_BYTE,NC_USHORT):
        return getNCvx_schar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_SHORT,NC_BYTE):
        return getNCvx_short_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_SHORT,NC_UBYTE):
        return getNCvx_short_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_SHORT,NC_SHORT):
        return getNCvx_short_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_SHORT,NC_INT):
        return getNCvx_short_int(ncp,varp,start,nelems,(int*)value);
	break;
   case CASE(NC_SHORT,NC_FLOAT):
        return getNCvx_short_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_SHORT,NC_DOUBLE):
        return getNCvx_short_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_SHORT,NC_INT64):
        return getNCvx_short_longlong(ncp,varp,start,nelems,(long long*)value);
   	break;
    case CASE(NC_SHORT,NC_UINT):
        return getNCvx_short_uint(ncp,varp,start,nelems,(unsigned int*)value);
    	break;
    case CASE(NC_SHORT,NC_UINT64):
        return getNCvx_short_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_SHORT,NC_USHORT):
        return getNCvx_short_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_INT,NC_BYTE):
        return getNCvx_int_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT,NC_UBYTE):
        return getNCvx_int_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT,NC_SHORT):
        return getNCvx_int_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT,NC_INT):
        return getNCvx_int_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT,NC_FLOAT):
        return getNCvx_int_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT,NC_DOUBLE):
        return getNCvx_int_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT,NC_INT64):
        return getNCvx_int_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT,NC_UINT):
        return getNCvx_int_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT,NC_UINT64):
        return getNCvx_int_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT,NC_USHORT):
        return getNCvx_int_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_FLOAT,NC_BYTE):
        return getNCvx_float_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_FLOAT,NC_UBYTE):
        return getNCvx_float_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_FLOAT,NC_SHORT):
        return getNCvx_float_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_FLOAT,NC_INT):
        return getNCvx_float_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_FLOAT,NC_FLOAT):
        return getNCvx_float_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_FLOAT,NC_DOUBLE):
        return getNCvx_float_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_FLOAT,NC_INT64):
        return getNCvx_float_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT):
        return getNCvx_float_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT64):
        return getNCvx_float_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_FLOAT,NC_USHORT):
        return getNCvx_float_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_DOUBLE,NC_BYTE):
        return getNCvx_double_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_DOUBLE,NC_UBYTE):
        return getNCvx_double_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_DOUBLE,NC_SHORT):
        return getNCvx_double_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT):
        return getNCvx_double_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_DOUBLE,NC_FLOAT):
        return getNCvx_double_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_DOUBLE,NC_DOUBLE):
        return getNCvx_double_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT64):
        return getNCvx_double_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT):
        return getNCvx_double_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT64):
        return getNCvx_double_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_USHORT):
        return getNCvx_double_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UBYTE,NC_UBYTE):
        return getNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UBYTE,NC_BYTE):
        return getNCvx_uchar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UBYTE,NC_SHORT):
        return getNCvx_uchar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UBYTE,NC_INT):
        return getNCvx_uchar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UBYTE,NC_FLOAT):
        return getNCvx_uchar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UBYTE,NC_DOUBLE):
        return getNCvx_uchar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_UBYTE,NC_INT64):
        return getNCvx_uchar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT):
        return getNCvx_uchar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT64):
        return getNCvx_uchar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UBYTE,NC_USHORT):
        return getNCvx_uchar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_USHORT,NC_BYTE):
        return getNCvx_ushort_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_USHORT,NC_UBYTE):
        return getNCvx_ushort_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_USHORT,NC_SHORT):
        return getNCvx_ushort_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_USHORT,NC_INT):
        return getNCvx_ushort_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_USHORT,NC_FLOAT):
        return getNCvx_ushort_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_USHORT,NC_DOUBLE):
        return getNCvx_ushort_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_USHORT,NC_INT64):
        return getNCvx_ushort_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_USHORT,NC_UINT):
        return getNCvx_ushort_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_USHORT,NC_UINT64):
        return getNCvx_ushort_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_USHORT,NC_USHORT):
        return getNCvx_ushort_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UINT,NC_BYTE):
        return getNCvx_uint_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT,NC_UBYTE):
        return getNCvx_uint_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT,NC_SHORT):
        return getNCvx_uint_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT,NC_INT):
        return getNCvx_uint_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT,NC_FLOAT):
        return getNCvx_uint_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT,NC_DOUBLE):
        return getNCvx_uint_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT,NC_INT64):
        return getNCvx_uint_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT,NC_UINT):
        return getNCvx_uint_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT,NC_UINT64):
        return getNCvx_uint_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT,NC_USHORT):
        return getNCvx_uint_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_INT64,NC_BYTE):
        return getNCvx_longlong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT64,NC_UBYTE):
        return getNCvx_longlong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT64,NC_SHORT):
        return getNCvx_longlong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT64,NC_INT):
        return getNCvx_longlong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT64,NC_FLOAT):
        return getNCvx_longlong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT64,NC_DOUBLE):
        return getNCvx_longlong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT64,NC_INT64):
        return getNCvx_longlong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT64,NC_UINT):
        return getNCvx_longlong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT64,NC_UINT64):
        return getNCvx_longlong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT64,NC_USHORT):
        return getNCvx_longlong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    case CASE(NC_UINT64,NC_BYTE):
        return getNCvx_ulonglong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT64,NC_UBYTE):
        return getNCvx_ulonglong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT64,NC_SHORT):
        return getNCvx_ulonglong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT64,NC_INT):
        return getNCvx_ulonglong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT64,NC_FLOAT):
        return getNCvx_ulonglong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT64,NC_DOUBLE):
        return getNCvx_ulonglong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT64,NC_INT64):
        return getNCvx_ulonglong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT64,NC_UINT):
        return getNCvx_ulonglong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT64,NC_UINT64):
        return getNCvx_ulonglong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT64,NC_USHORT):
        return getNCvx_ulonglong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    default:
	return NC_EBADTYPE;
	break;
    }
    return status;
}


static int
writeNCv(NC3_INFO* ncp, const NC_var* varp, const size_t* start,
         const size_t nelems, const void* value, const nc_type memtype)
{
    int status = NC_NOERR;
    switch (CASE(varp->type,memtype)) {

    case CASE(NC_CHAR,NC_CHAR):
    case CASE(NC_CHAR,NC_UBYTE):
        return putNCvx_char_char(ncp,varp,start,nelems,(char*)value);
	break;
    case CASE(NC_BYTE,NC_BYTE):
        return putNCvx_schar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_BYTE,NC_UBYTE):
        if (fIsSet(ncp->flags,NC_64BIT_DATA))
            return putNCvx_schar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
        else
            /* for CDF-1 and CDF-2, NC_BYTE is treated the same type as uchar memtype */
            return putNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_BYTE,NC_SHORT):
        return putNCvx_schar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_BYTE,NC_INT):
        return putNCvx_schar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_BYTE,NC_FLOAT):
        return putNCvx_schar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_BYTE,NC_DOUBLE):
        return putNCvx_schar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_BYTE,NC_INT64):
        return putNCvx_schar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_BYTE,NC_UINT):
        return putNCvx_schar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_BYTE,NC_UINT64):
        return putNCvx_schar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_BYTE,NC_USHORT):
        return putNCvx_schar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_SHORT,NC_BYTE):
        return putNCvx_short_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_SHORT,NC_UBYTE):
        return putNCvx_short_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_SHORT,NC_SHORT):
        return putNCvx_short_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_SHORT,NC_INT):
        return putNCvx_short_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_SHORT,NC_FLOAT):
        return putNCvx_short_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_SHORT,NC_DOUBLE):
        return putNCvx_short_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_SHORT,NC_INT64):
        return putNCvx_short_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_SHORT,NC_UINT):
        return putNCvx_short_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_SHORT,NC_UINT64):
        return putNCvx_short_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_SHORT,NC_USHORT):
        return putNCvx_short_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_INT,NC_BYTE):
        return putNCvx_int_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT,NC_UBYTE):
        return putNCvx_int_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT,NC_SHORT):
        return putNCvx_int_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT,NC_INT):
        return putNCvx_int_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT,NC_FLOAT):
        return putNCvx_int_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT,NC_DOUBLE):
        return putNCvx_int_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT,NC_INT64):
        return putNCvx_int_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT,NC_UINT):
        return putNCvx_int_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT,NC_UINT64):
        return putNCvx_int_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT,NC_USHORT):
        return putNCvx_int_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_FLOAT,NC_BYTE):
        return putNCvx_float_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_FLOAT,NC_UBYTE):
        return putNCvx_float_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_FLOAT,NC_SHORT):
        return putNCvx_float_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_FLOAT,NC_INT):
        return putNCvx_float_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_FLOAT,NC_FLOAT):
        return putNCvx_float_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_FLOAT,NC_DOUBLE):
        return putNCvx_float_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_FLOAT,NC_INT64):
        return putNCvx_float_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT):
        return putNCvx_float_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_FLOAT,NC_UINT64):
        return putNCvx_float_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_FLOAT,NC_USHORT):
        return putNCvx_float_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_DOUBLE,NC_BYTE):
        return putNCvx_double_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_DOUBLE,NC_UBYTE):
        return putNCvx_double_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_DOUBLE,NC_SHORT):
        return putNCvx_double_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT):
        return putNCvx_double_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_DOUBLE,NC_FLOAT):
        return putNCvx_double_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_DOUBLE,NC_DOUBLE):
        return putNCvx_double_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_DOUBLE,NC_INT64):
        return putNCvx_double_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT):
        return putNCvx_double_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_DOUBLE,NC_UINT64):
        return putNCvx_double_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_DOUBLE,NC_USHORT):
        return putNCvx_double_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UBYTE,NC_UBYTE):
        return putNCvx_uchar_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UBYTE,NC_BYTE):
        return putNCvx_uchar_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UBYTE,NC_SHORT):
        return putNCvx_uchar_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UBYTE,NC_INT):
        return putNCvx_uchar_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UBYTE,NC_FLOAT):
        return putNCvx_uchar_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UBYTE,NC_DOUBLE):
        return putNCvx_uchar_double(ncp,varp,start,nelems,(double *)value);
	break;
    case CASE(NC_UBYTE,NC_INT64):
        return putNCvx_uchar_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT):
        return putNCvx_uchar_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UBYTE,NC_UINT64):
        return putNCvx_uchar_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UBYTE,NC_USHORT):
        return putNCvx_uchar_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_USHORT,NC_BYTE):
        return putNCvx_ushort_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_USHORT,NC_UBYTE):
        return putNCvx_ushort_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_USHORT,NC_SHORT):
        return putNCvx_ushort_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_USHORT,NC_INT):
        return putNCvx_ushort_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_USHORT,NC_FLOAT):
        return putNCvx_ushort_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_USHORT,NC_DOUBLE):
        return putNCvx_ushort_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_USHORT,NC_INT64):
        return putNCvx_ushort_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_USHORT,NC_UINT):
        return putNCvx_ushort_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_USHORT,NC_UINT64):
        return putNCvx_ushort_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_USHORT,NC_USHORT):
        return putNCvx_ushort_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UINT,NC_BYTE):
        return putNCvx_uint_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT,NC_UBYTE):
        return putNCvx_uint_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT,NC_SHORT):
        return putNCvx_uint_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT,NC_INT):
        return putNCvx_uint_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT,NC_FLOAT):
        return putNCvx_uint_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT,NC_DOUBLE):
        return putNCvx_uint_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT,NC_INT64):
        return putNCvx_uint_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT,NC_UINT):
        return putNCvx_uint_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT,NC_UINT64):
        return putNCvx_uint_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT,NC_USHORT):
        return putNCvx_uint_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_INT64,NC_BYTE):
        return putNCvx_longlong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_INT64,NC_UBYTE):
        return putNCvx_longlong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_INT64,NC_SHORT):
        return putNCvx_longlong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_INT64,NC_INT):
        return putNCvx_longlong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_INT64,NC_FLOAT):
        return putNCvx_longlong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_INT64,NC_DOUBLE):
        return putNCvx_longlong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_INT64,NC_INT64):
        return putNCvx_longlong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_INT64,NC_UINT):
        return putNCvx_longlong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_INT64,NC_UINT64):
        return putNCvx_longlong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_INT64,NC_USHORT):
        return putNCvx_longlong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;
    case CASE(NC_UINT64,NC_BYTE):
        return putNCvx_ulonglong_schar(ncp,varp,start,nelems,(schar*)value);
	break;
    case CASE(NC_UINT64,NC_UBYTE):
        return putNCvx_ulonglong_uchar(ncp,varp,start,nelems,(unsigned char*)value);
	break;
    case CASE(NC_UINT64,NC_SHORT):
        return putNCvx_ulonglong_short(ncp,varp,start,nelems,(short*)value);
	break;
    case CASE(NC_UINT64,NC_INT):
        return putNCvx_ulonglong_int(ncp,varp,start,nelems,(int*)value);
	break;
    case CASE(NC_UINT64,NC_FLOAT):
        return putNCvx_ulonglong_float(ncp,varp,start,nelems,(float*)value);
	break;
    case CASE(NC_UINT64,NC_DOUBLE):
        return putNCvx_ulonglong_double(ncp,varp,start,nelems,(double*)value);
	break;
    case CASE(NC_UINT64,NC_INT64):
        return putNCvx_ulonglong_longlong(ncp,varp,start,nelems,(long long*)value);
	break;
    case CASE(NC_UINT64,NC_UINT):
        return putNCvx_ulonglong_uint(ncp,varp,start,nelems,(unsigned int*)value);
	break;
    case CASE(NC_UINT64,NC_UINT64):
        return putNCvx_ulonglong_ulonglong(ncp,varp,start,nelems,(unsigned long long*)value);
	break;
    case CASE(NC_UINT64,NC_USHORT):
        return putNCvx_ulonglong_ushort(ncp,varp,start,nelems,(unsigned short*)value);
	break;

    default:
	return NC_EBADTYPE;
	break;
    }
    return status;
}

/**************************************************/

int
NC3_get_vara(int ncid, int varid,
	    const size_t *start, const size_t *edges0,
            void *value0,
	    nc_type memtype)
{
    int status = NC_NOERR;
    NC* nc;
    NC3_INFO* nc3;
    NC_var *varp;
    int ii;
    size_t iocount;
    size_t memtypelen;
    signed char* value = (signed char*) value0; /* legally allow ptr arithmetic */
    const size_t* edges = edges0; /* so we can modify for special cases */
    size_t modedges[NC_MAX_VAR_DIMS];

    status = NC_check_id(ncid, &nc);
    if(status != NC_NOERR)
        return status;
    nc3 = NC3_DATA(nc);

    if(NC_indef(nc3))
        return NC_EINDEFINE;

    status = NC_lookupvar(nc3, varid, &varp);
    if(status != NC_NOERR)
        return status;

    if(memtype == NC_NAT) memtype=varp->type;

    if(memtype == NC_CHAR && varp->type != NC_CHAR)
        return NC_ECHAR;
    else if(memtype != NC_CHAR && varp->type == NC_CHAR)
        return NC_ECHAR;

    /* If edges is NULL, then this was called from nc_get_var() */
    if(edges == NULL && varp->ndims > 0) {
	/* If this is a record variable, then we have to
           substitute the number of records into dimension 0. */
	if(varp->shape[0] == 0) {
	    (void)memcpy((void*)modedges,(void*)varp->shape,
                          sizeof(size_t)*varp->ndims);
	    modedges[0] = NC_get_numrecs(nc3);
	    edges = modedges;
	} else
	    edges = varp->shape;
    }

    status = NCcoordck(nc3, varp, start);
    if(status != NC_NOERR)
        return status;

    status = NCedgeck(nc3, varp, start, edges);
    if(status != NC_NOERR)
        return status;

    /* Get the size of the memtype */
    memtypelen = nctypelen(memtype);

    if(varp->ndims == 0) /* scalar variable */
    {
        return( readNCv(nc3, varp, start, 1, (void*)value, memtype) );
    }

    if(IS_RECVAR(varp))
    {
        if(*start + *edges > NC_get_numrecs(nc3))
            return NC_EEDGE;
        if(varp->ndims == 1 && nc3->recsize <= varp->len)
        {
            /* one dimensional && the only record variable  */
            return( readNCv(nc3, varp, start, *edges, (void*)value, memtype) );
        }
    }

    /*
     * find max contiguous
     *   and accumulate max count for a single io operation
     */
    ii = NCiocount(nc3, varp, edges, &iocount);

    if(ii == -1)
    {
        return( readNCv(nc3, varp, start, iocount, (void*)value, memtype) );
    }

    assert(ii >= 0);

    { /* inline */
    ALLOC_ONSTACK(coord, size_t, varp->ndims);
    ALLOC_ONSTACK(upper, size_t, varp->ndims);
    const size_t index = ii;

    /* copy in starting indices */
    (void) memcpy(coord, start, varp->ndims * sizeof(size_t));

    /* set up in maximum indices */
    set_upper(upper, start, edges, &upper[varp->ndims]);

    /* ripple counter */
    while(*coord < *upper)
    {
        const int lstatus = readNCv(nc3, varp, coord, iocount, (void*)value, memtype);
	if(lstatus != NC_NOERR)
        {
            if(lstatus != NC_ERANGE)
            {
                status = lstatus;
                /* fatal for the loop */
                break;
            }
            /* else NC_ERANGE, not fatal for the loop */
            if(status == NC_NOERR)
                status = lstatus;
        }
        value += (iocount * memtypelen);
        odo1(start, upper, coord, &upper[index], &coord[index]);
    }

    FREE_ONSTACK(upper);
    FREE_ONSTACK(coord);
    } /* end inline */

    return status;
}

int
NC3_put_vara(int ncid, int varid,
	    const size_t *start, const size_t *edges0,
            const void *value0,
	    nc_type memtype)
{
    int status = NC_NOERR;
    NC *nc;
    NC3_INFO* nc3;
    NC_var *varp;
    int ii;
    size_t iocount;
    size_t memtypelen;
    signed char* value = (signed char*) value0; /* legally allow ptr arithmetic */
    const size_t* edges = edges0; /* so we can modify for special cases */
    size_t modedges[NC_MAX_VAR_DIMS];

    status = NC_check_id(ncid, &nc);
    if(status != NC_NOERR)
        return status;
    nc3 = NC3_DATA(nc);

    if(NC_readonly(nc3))
        return NC_EPERM;

    if(NC_indef(nc3))
        return NC_EINDEFINE;

    status = NC_lookupvar(nc3, varid, &varp);
    if(status != NC_NOERR)
       return status; /*invalid varid */


    if(memtype == NC_NAT) memtype=varp->type;

    if(memtype == NC_CHAR && varp->type != NC_CHAR)
        return NC_ECHAR;
    else if(memtype != NC_CHAR && varp->type == NC_CHAR)
        return NC_ECHAR;

    /* Get the size of the memtype */
    memtypelen = nctypelen(memtype);

    /* If edges is NULL, then this was called from nc_get_var() */
    if(edges == NULL && varp->ndims > 0) {
	/* If this is a record variable, then we have to
           substitute the number of records into dimension 0. */
	if(varp->shape[0] == 0) {
	    (void)memcpy((void*)modedges,(void*)varp->shape,
                          sizeof(size_t)*varp->ndims);
	    modedges[0] = NC_get_numrecs(nc3);
	    edges = modedges;
	} else
	    edges = varp->shape;
    }

    status = NCcoordck(nc3, varp, start);
    if(status != NC_NOERR)
        return status;
    status = NCedgeck(nc3, varp, start, edges);
    if(status != NC_NOERR)
        return status;

    if(varp->ndims == 0) /* scalar variable */
    {
        return( writeNCv(nc3, varp, start, 1, (void*)value, memtype) );
    }

    if(IS_RECVAR(varp))
    {
        status = NCvnrecs(nc3, *start + *edges);
        if(status != NC_NOERR)
            return status;

        if(varp->ndims == 1
            && nc3->recsize <= varp->len)
        {
            /* one dimensional && the only record variable  */
            return( writeNCv(nc3, varp, start, *edges, (void*)value, memtype) );
        }
    }

    /*
     * find max contiguous
     *   and accumulate max count for a single io operation
     */
    ii = NCiocount(nc3, varp, edges, &iocount);

    if(ii == -1)
    {
        return( writeNCv(nc3, varp, start, iocount, (void*)value, memtype) );
    }

    assert(ii >= 0);

    { /* inline */
    ALLOC_ONSTACK(coord, size_t, varp->ndims);
    ALLOC_ONSTACK(upper, size_t, varp->ndims);
    const size_t index = ii;

    /* copy in starting indices */
    (void) memcpy(coord, start, varp->ndims * sizeof(size_t));

    /* set up in maximum indices */
    set_upper(upper, start, edges, &upper[varp->ndims]);

    /* ripple counter */
    while(*coord < *upper)
    {
        const int lstatus = writeNCv(nc3, varp, coord, iocount, (void*)value, memtype);
        if(lstatus != NC_NOERR)
        {
            if(lstatus != NC_ERANGE)
            {
                status = lstatus;
                /* fatal for the loop */
                break;
            }
            /* else NC_ERANGE, not fatal for the loop */
            if(status == NC_NOERR)
                status = lstatus;
        }
        value += (iocount * memtypelen);
        odo1(start, upper, coord, &upper[index], &coord[index]);
    }

    FREE_ONSTACK(upper);
    FREE_ONSTACK(coord);
    } /* end inline */

    return status;
}
