<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/gearman/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/gearman/metadata.yaml"
sidebar_label: "Gearman"
learn_status: "Published"
learn_rel_path: "Data Collection/Distributed Computing Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Gearman


<img src="https://netdata.cloud/img/gearman.png" width="150"/>


Plugin: python.d.plugin
Module: gearman

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor Gearman metrics for proficient system task distribution. Track job counts, worker statuses, and queue lengths for effective distributed task management.

This collector connects to a Gearman instance via either TCP or unix socket.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

When no configuration file is found, the collector tries to connect to TCP/IP socket: localhost:4730.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Gearman instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| gearman.total_jobs | Pending, Running | Jobs |

### Per gearman job

Metrics related to Gearman jobs. Each job produces its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| gearman.single_job | Pending, Idle, Runnning | Jobs |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ gearman_workers_queued ](https://github.com/netdata/netdata/blob/master/health/health.d/gearman.conf) | gearman.single_job | average number of queued jobs over the last 10 minutes |


## Setup

### Prerequisites

#### Socket permissions

The gearman UNIX socket should have read permission for user netdata.


### Configuration

#### File

The configuration file name for this integration is `python.d/gearman.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/gearman.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |
| host | URL or IP where gearman is running. | localhost | no |
| port | Port of URL or IP where gearman is running. | 4730 | no |
| tls | Use tls to connect to gearman. | false | no |
| cert | Provide a certificate file if needed to connect to a TLS gearman instance. |  | no |
| key | Provide a key file if needed to connect to a TLS gearman instance. |  | no |

</details>

#### Examples

##### Local gearman service

A basic host and port gearman configuration for localhost.

```yaml
localhost:
  name: 'local'
  host: 'localhost'
  port: 4730

```
##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
localhost:
  name: 'local'
  host: 'localhost'
  port: 4730

remote:
  name: 'remote'
  host: '192.0.2.1'
  port: 4730

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `gearman` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin gearman debug trace
  ```


