# Configuring Metrics Centralization Points

Metrics streaming configuration for both Netdata Children and Parents is done via `stream.conf`.

`netdata.conf` and `stream.conf` have the same `ini` format, but `netdata.conf` is considered a non-sensitive file, while `stream.conf` contains API keys, IPs and other sensitive information that enable communication between Netdata agents.

`stream.conf` has 2 main sections:

- The `[stream]` section includes options for the **sending Netdata** (ie Netdata Children, or Netdata Parents that stream to Grand Parents, or to other sibling Netdata Parents in a cluster).
- The rest includes multiple sections that define API keys for the **receiving Netdata** (ie. Netdata Parents).

## Edit `stream.conf`

To edit `stream.conf`, run this on your terminal:

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config stream.conf
```

Your editor will open, with defaults and commented `stream.conf` options.

## Configuring a Netdata Parent

To enable the reception of metrics from Netdata Children, generate a random API key with this command:

```bash
uuidgen
```

Then, copy the UUID generated, [edit `stream.conf`](#edit-streamconf), find the section that reads like the following and replace `API_KEY` with the UUID you generated:

```ini
[API_KEY]
    # Accept metrics streaming from other Agents with the specified API key
    enabled = yes
```

Save the file and restart Netdata.

## Configuring Netdata Children

To enable streaming metrics to a Netdata Parent, [edit `stream.conf`](#edit-streamconf), and at the `[stream]` section at the top, set:

```ini
[stream]
    # Stream metrics to another Netdata
    enabled = yes
    # The IP and PORT of the parent
    destination = PARENT_IP_ADDRESS:19999
    # The shared API key, generated by uuidgen
    api key = API_KEY
```

Save the file and restart Netdata.

## Enable TLS/SSL Communication

While encrypting the connection between your parent and child nodes is recommended for security, it's not required to get started.

This example uses self-signed certificates. 

> **Note**  
> This section assumes you have read the documentation on [how to edit the Netdata configuration files](/docs/netdata-agent/configuration/README.md).  
<!-- here we need link to the section that will contain the restarting instructions -->

1. **Parent node**  
   To generate an SSL key and certificate using `openssl`, take a look at the related section around [Securing Netdata Agents](/src/web/server/README.md#enable-httpstls-support) in our Documentation.

2. **Child node**  
   Update `stream.conf` to enable SSL/TLS and allow self-signed certificates. Append ':SSL' to the destination and uncomment 'ssl skip certificate verification'.

    ```conf
    [stream]
        enabled = yes
        destination = 203.0.113.0:SSL
        ssl skip certificate verification = yes
        api key = 11111111-2222-3333-4444-555555555555
    ```

3. Restart the Netdata Agent on both the parent and child nodes, to stream encrypted metrics using TLS/SSL.



## Troubleshooting Streaming Connections

You can find any issues related to streaming at Netdata logs.

### From the UI

Netdata logs to systemd-journald by default, and its logs are available at the `Logs` tab of the UI. At the `MESSAGE_ID` field look for `Netdata connection from child` and `Netdata connection to parent`.

### From the terminal

On the Parents:

```bash
journalctl -r --namespace=netdata MESSAGE_ID=ed4cdb8f1beb4ad3b57cb3cae2d162fa
```

On the Children:

```bash
journalctl -r --namespace=netdata MESSAGE_ID=6e2e3839067648968b646045dbf28d66
```
