/*
 * JFrameMain.java
 *
 * Created on 17. Mai 2008, 15:02
 */

package imgtomap;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author  maik
 */
public class JFrameMain extends javax.swing.JFrame {

    /** Creates new form JFrameMain */
    public JFrameMain() {
        initComponents();
        String testinput = "/mnt/data/nexuizsvn/nexuiz/trunk/tools/ImgToMap/test1.png";
        String testoutput = "/tmp/test.map";
        
        if(new File(testinput).exists()) {
            jTextFieldInput.setText(testinput);
            jTextFieldOutput.setText(testoutput);
        }
        
        enableSkyPanel(jCheckBoxSky.isSelected());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jTextFieldInput = new javax.swing.JTextField();
        jButtonInput = new javax.swing.JButton();
        jTextFieldOutput = new javax.swing.JTextField();
        jButtonOutput = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jCheckBoxDetail = new javax.swing.JCheckBox();
        jTextFieldTexture = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jSpinnerUnits = new javax.swing.JSpinner();
        jSpinnerHeight = new javax.swing.JSpinner();
        jSpinnerTextureScale = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jCheckBoxVisBlocker = new javax.swing.JCheckBox();
        jPanelSky = new javax.swing.JPanel();
        jCheckBoxSky = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        jSpinnerSkyHeight = new javax.swing.JSpinner();
        jCheckBoxSkyFill = new javax.swing.JCheckBox();
        jLabel6 = new javax.swing.JLabel();
        jTextFieldSkyTexture = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ImgToMap");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Files"));

        jButtonInput.setText("Select input file");
        jButtonInput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonInputActionPerformed(evt);
            }
        });

        jButtonOutput.setText("Select output file");
        jButtonOutput.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOutputActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jTextFieldOutput, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 299, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jTextFieldInput, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 299, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jButtonInput, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jButtonOutput, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 142, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonInput)
                    .add(jTextFieldInput, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonOutput)
                    .add(jTextFieldOutput, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButtonOK.setText("Start conversion!");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Terrain configuration"));

        jCheckBoxDetail.setSelected(true);
        jCheckBoxDetail.setText("make detail");

        jTextFieldTexture.setText("terrain/terrain1");

        jLabel3.setText("Cover terrain surface with texture:");

        jSpinnerUnits.setModel(new javax.swing.SpinnerNumberModel(256, 1, 2048, 1));

        jSpinnerHeight.setModel(new javax.swing.SpinnerNumberModel(2048, 256, 16384, 1));
        jSpinnerHeight.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerHeightStateChanged(evt);
            }
        });

        jSpinnerTextureScale.setModel(new javax.swing.SpinnerNumberModel(1.0d, 0.25d, 16.0d, 0.25d));

        jLabel4.setText("Texture scale:");

        jLabel2.setText("Height for white:");

        jLabel1.setText("Units per pixel:");

        jCheckBoxVisBlocker.setSelected(true);
        jCheckBoxVisBlocker.setText("generate visblockers");

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jTextFieldTexture, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 447, Short.MAX_VALUE)
                        .addContainerGap())
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel3)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jCheckBoxDetail)
                                .add(18, 18, 18)
                                .add(jCheckBoxVisBlocker))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(jLabel1)
                                    .add(jLabel2))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                    .add(jSpinnerHeight, 0, 0, Short.MAX_VALUE)
                                    .add(jSpinnerUnits))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel4)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jSpinnerTextureScale, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 89, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(0, 0, 0))))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jSpinnerUnits, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1)
                    .add(jLabel4)
                    .add(jSpinnerTextureScale, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(jSpinnerHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jCheckBoxDetail)
                    .add(jCheckBoxVisBlocker))
                .add(14, 14, 14)
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTextFieldTexture, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelSky.setBorder(javax.swing.BorderFactory.createTitledBorder("Sky configuration"));

        jCheckBoxSky.setSelected(true);
        jCheckBoxSky.setText("generate a skybox");
        jCheckBoxSky.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkyActionPerformed(evt);
            }
        });

        jLabel5.setText("Sky height:");

        jSpinnerSkyHeight.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(2048), Integer.valueOf(256), null, Integer.valueOf(1)));
        jSpinnerSkyHeight.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerSkyHeightStateChanged(evt);
            }
        });

        jCheckBoxSkyFill.setSelected(true);
        jCheckBoxSkyFill.setText("fill alpha-gaps with sky");

        jLabel6.setText("Sky texture:");

        jTextFieldSkyTexture.setText("skies/sky1");

        org.jdesktop.layout.GroupLayout jPanelSkyLayout = new org.jdesktop.layout.GroupLayout(jPanelSky);
        jPanelSky.setLayout(jPanelSkyLayout);
        jPanelSkyLayout.setHorizontalGroup(
            jPanelSkyLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanelSkyLayout.createSequentialGroup()
                .addContainerGap()
                .add(jPanelSkyLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jTextFieldSkyTexture, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 447, Short.MAX_VALUE)
                    .add(jPanelSkyLayout.createSequentialGroup()
                        .add(jCheckBoxSky)
                        .add(18, 18, 18)
                        .add(jCheckBoxSkyFill))
                    .add(jPanelSkyLayout.createSequentialGroup()
                        .add(jLabel5)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jSpinnerSkyHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 82, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jLabel6))
                .addContainerGap())
        );
        jPanelSkyLayout.setVerticalGroup(
            jPanelSkyLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanelSkyLayout.createSequentialGroup()
                .add(jPanelSkyLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jCheckBoxSky)
                    .add(jCheckBoxSkyFill))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanelSkyLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(jSpinnerSkyHeight, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabel6)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTextFieldSkyTexture, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jPanelSky, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jButtonOK))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanelSky, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jButtonOK)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void jButtonInputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonInputActionPerformed
    JFileChooser fc = new JFileChooser();
    int ret = fc.showOpenDialog(this);
    
    if(ret == fc.APPROVE_OPTION) {
        File f = fc.getSelectedFile();
        if(f.exists()) {
            jTextFieldInput.setText(f.getAbsolutePath());
        }
    }
}//GEN-LAST:event_jButtonInputActionPerformed

private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
    this.setVisible(false);
    Parameters p = new Parameters();
    p.infile = jTextFieldInput.getText();
    p.outfile = jTextFieldOutput.getText();
    p.texture = jTextFieldTexture.getText();
    p.skytexture = jTextFieldSkyTexture.getText();
    p.pixelsize = (Integer)jSpinnerUnits.getValue();
    p.height = (Integer)jSpinnerHeight.getValue();
    p.sky = jCheckBoxSky.isSelected();
    p.skyfill = jCheckBoxSkyFill.isSelected() && p.sky;
    p.visblockers = jCheckBoxVisBlocker.isSelected();
    p.skyheight = (Integer)jSpinnerSkyHeight.getValue();
    p.texturescale = (Double)jSpinnerTextureScale.getValue();
    p.detail = jCheckBoxDetail.isSelected();
    int ret = new MapWriter().writeMap(p);
    if(ret == 0) {
        JOptionPane.showMessageDialog(this, "Map successfully generated!", "Success!", JOptionPane.INFORMATION_MESSAGE);
    } else {
        JOptionPane.showMessageDialog(this, "Error occured! Oh no!", "Error!", JOptionPane.ERROR_MESSAGE);
    }
    
    
    this.setVisible(true);
}//GEN-LAST:event_jButtonOKActionPerformed

private void jButtonOutputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOutputActionPerformed
    JFileChooser fc = new JFileChooser();
    int ret = fc.showOpenDialog(this);
    
    if(ret == fc.APPROVE_OPTION) {
        File f = fc.getSelectedFile();
        jTextFieldOutput.setText(f.getAbsolutePath());
    }
}//GEN-LAST:event_jButtonOutputActionPerformed

private void jCheckBoxSkyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSkyActionPerformed
    enableSkyPanel(jCheckBoxSky.isSelected());
}//GEN-LAST:event_jCheckBoxSkyActionPerformed

private void jSpinnerHeightStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerHeightStateChanged
    int value = (Integer)jSpinnerHeight.getValue();
    int skyheight = (Integer)jSpinnerSkyHeight.getValue();
    if(skyheight < value) {
        jSpinnerSkyHeight.setValue(value);
    }
}//GEN-LAST:event_jSpinnerHeightStateChanged

private void jSpinnerSkyHeightStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerSkyHeightStateChanged
    int value =(Integer)jSpinnerSkyHeight.getValue();
    int height = (Integer)jSpinnerHeight.getValue();
    if(height > value) {
        jSpinnerHeight.setValue(value);
    }
}//GEN-LAST:event_jSpinnerSkyHeightStateChanged

private void enableSkyPanel(boolean b) {
    jCheckBoxSkyFill.setEnabled(b);
    jSpinnerSkyHeight.setEnabled(b);
    jTextFieldSkyTexture.setEnabled(b);
}

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JFrameMain().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonInput;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JButton jButtonOutput;
    private javax.swing.JCheckBox jCheckBoxDetail;
    private javax.swing.JCheckBox jCheckBoxSky;
    private javax.swing.JCheckBox jCheckBoxSkyFill;
    private javax.swing.JCheckBox jCheckBoxVisBlocker;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelSky;
    private javax.swing.JSpinner jSpinnerHeight;
    private javax.swing.JSpinner jSpinnerSkyHeight;
    private javax.swing.JSpinner jSpinnerTextureScale;
    private javax.swing.JSpinner jSpinnerUnits;
    private javax.swing.JTextField jTextFieldInput;
    private javax.swing.JTextField jTextFieldOutput;
    private javax.swing.JTextField jTextFieldSkyTexture;
    private javax.swing.JTextField jTextFieldTexture;
    // End of variables declaration//GEN-END:variables

}
