<!--

@license Apache-2.0

Copyright (c) 2021 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# String Path Constants

> Standard library string path constants.

<section class="usage">

## Usage

```javascript
var constants = require( '@stdlib/constants/path' );
```

#### constants

Standard library string path constants.

```javascript
var ns = constants;
// returns {...}
```

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`DELIMITER_POSIX`][@stdlib/constants/path/delimiter-posix]</span><span class="delimiter">: </span><span class="description">POSIX path delimiter.</span>
-   <span class="signature">[`DELIMITER_WIN32`][@stdlib/constants/path/delimiter-win32]</span><span class="delimiter">: </span><span class="description">Windows path delimiter.</span>
-   <span class="signature">[`DELIMITER`][@stdlib/constants/path/delimiter]</span><span class="delimiter">: </span><span class="description">platform-specific path delimiter.</span>
-   <span class="signature">[`SEP_POSIX`][@stdlib/constants/path/sep-posix]</span><span class="delimiter">: </span><span class="description">POSIX path segment separator.</span>
-   <span class="signature">[`SEP_WIN32`][@stdlib/constants/path/sep-win32]</span><span class="delimiter">: </span><span class="description">Windows path segment separator.</span>
-   <span class="signature">[`SEP`][@stdlib/constants/path/sep]</span><span class="delimiter">: </span><span class="description">platform-specific path segment separator.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var constants = require( '@stdlib/constants/path' );

console.log( objectKeys( constants ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/constants/path/delimiter-posix]: https://github.com/stdlib-js/constants/tree/main/path/delimiter-posix

[@stdlib/constants/path/delimiter-win32]: https://github.com/stdlib-js/constants/tree/main/path/delimiter-win32

[@stdlib/constants/path/delimiter]: https://github.com/stdlib-js/constants/tree/main/path/delimiter

[@stdlib/constants/path/sep-posix]: https://github.com/stdlib-js/constants/tree/main/path/sep-posix

[@stdlib/constants/path/sep-win32]: https://github.com/stdlib-js/constants/tree/main/path/sep-win32

[@stdlib/constants/path/sep]: https://github.com/stdlib-js/constants/tree/main/path/sep

<!-- </toc-links> -->

</section>

<!-- /.links -->
