// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_EditForm_HeaderFile
#define _IFSelect_EditForm_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_EditForm_HeaderFile
#include <Handle_IFSelect_EditForm.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColStd_Array1OfTransient_HeaderFile
#include <TColStd_Array1OfTransient.hxx>
#endif
#ifndef _Handle_IFSelect_Editor_HeaderFile
#include <Handle_IFSelect_Editor.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_IFSelect_ListEditor_HeaderFile
#include <Handle_IFSelect_ListEditor.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
class IFSelect_Editor;
class Standard_Transient;
class Interface_InterfaceModel;
class TColStd_SequenceOfInteger;
class IFSelect_ListEditor;
class TCollection_HAsciiString;
class TColStd_HSequenceOfHAsciiString;
class Message_Messenger;


//! An EditForm is the way to apply an Editor on an Entity or on <br>
//!           the Model <br>
//!           It gives read-only or read-write access, with or without undo <br>
//! <br>
//!           It can be complete (all the values of the Editor are present) <br>
//!           or partial (a sub-list of these value are present) <br>
//!           Anyway, all references to Number (argument <num>) refer to <br>
//!           Number of Value for the Editor <br>
//!           While references to Rank are for rank in the EditForm, which <br>
//!           may differ if it is not Complete <br>
//!           Two methods give the correspondance between this Number and <br>
//!           the Rank in the EditForm : RankFromNumber and NumberFromRank <br>
//! <br>
class IFSelect_EditForm : public MMgt_TShared {

public:

  //! Creates a complete EditForm from an Editor <br>
//!           A specific Label can be given <br>
  Standard_EXPORT   IFSelect_EditForm(const Handle(IFSelect_Editor)& editor,const Standard_Boolean readonly,const Standard_Boolean undoable,const Standard_CString label = "");
  //! Creates an extracted EditForm from an Editor, limited to <br>
//!           the values identified in <nums> <br>
//!           A specific Label can be given <br>
  Standard_EXPORT   IFSelect_EditForm(const Handle(IFSelect_Editor)& editor,const TColStd_SequenceOfInteger& nums,const Standard_Boolean readonly,const Standard_Boolean undoable,const Standard_CString label = "");
  //! Returns and may change the keep status on modif <br>
//!           It starts as False <br>
//!           If it is True, Apply does not clear modification status <br>
//!           and the EditForm can be loaded again, modified value remain <br>
//!           and may be applied again <br>
//!           Remark that ApplyData does not clear the modification status, <br>
//!           a call to ClearEdit does <br>
  Standard_EXPORT     Standard_Boolean& EditKeepStatus() ;
  
  Standard_EXPORT     Standard_CString Label() const;
  //! Tells if the EditForm is loaded now <br>
  Standard_EXPORT     Standard_Boolean IsLoaded() const;
  
  Standard_EXPORT     void ClearData() ;
  
  Standard_EXPORT     void SetData(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;
  
  Standard_EXPORT     void SetEntity(const Handle(Standard_Transient)& ent) ;
  
  Standard_EXPORT     void SetModel(const Handle(Interface_InterfaceModel)& model) ;
  
  Standard_EXPORT     Handle_Standard_Transient Entity() const;
  
  Standard_EXPORT     Handle_Interface_InterfaceModel Model() const;
  
  Standard_EXPORT     Handle_IFSelect_Editor Editor() const;
  //! Tells if an EditForm is complete or is an extract from Editor <br>
  Standard_EXPORT     Standard_Boolean IsComplete() const;
  //! Returns the count of values <br>
//!           <editable> True : count of editable values, i.e. <br>
//!             For a complete EditForm, it is given by the Editor <br>
//!             Else, it is the length of the extraction map <br>
//!           <editable> False : all the values from the Editor <br>
  Standard_EXPORT     Standard_Integer NbValues(const Standard_Boolean editable) const;
  //! Returns the Value Number in the Editor from a given Rank in <br>
//!           the EditForm <br>
//!           For a complete EditForm, both are equal <br>
//!           Else, it is given by the extraction map <br>
//!           Returns 0 if <rank> exceeds the count of editable values, <br>
  Standard_EXPORT     Standard_Integer NumberFromRank(const Standard_Integer rank) const;
  //! Returns the Rank in the EditForm from a given Number of Value <br>
//!           for the Editor <br>
//!           For a complete EditForm, both are equal <br>
//!           Else, it is given by the extraction map <br>
//!           Returns 0 if <number> is not forecast to be edited, or is <br>
//!             out of range <br>
  Standard_EXPORT     Standard_Integer RankFromNumber(const Standard_Integer number) const;
  //! Returns the Value Number in the Editor for a given Name <br>
//!           i.e. the true ValueNumber which can be used in various methods <br>
//!           of EditForm <br>
//!           If it is not complete, for a recorded (in the Editor) but <br>
//!           non-loaded name, returns negative value (- number) <br>
  Standard_EXPORT     Standard_Integer NameNumber(const Standard_CString name) const;
  //! Returns the Rank of Value in the EditForm for a given Name <br>
//!           i.e. if it is not complete, for a recorded (in the Editor) but <br>
//!           non-loaded name, returns 0 <br>
  Standard_EXPORT     Standard_Integer NameRank(const Standard_CString name) const;
  //! For a read-write undoable EditForm, loads original values <br>
//!           from defaults stored in the Editor <br>
  Standard_EXPORT     void LoadDefault() ;
  //! Loads modifications to data <br>
//!           Default uses Editor. Can be redefined <br>
//!           Remark that <ent> and/or <model> may be null, according to the <br>
//!           kind of Editor. Shortcuts are available for these cases, but <br>
//!           they finally call LoadData (hence, just ignore non-used args) <br>
  Standard_EXPORT   virtual  Standard_Boolean LoadData(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;
  //! Shortcut for LoadData when <model> is not used <br>
  Standard_EXPORT     Standard_Boolean LoadEntity(const Handle(Standard_Transient)& ent) ;
  //! Shortcut for LoadData when only the model is concerned <br>
  Standard_EXPORT     Standard_Boolean LoadModel(const Handle(Interface_InterfaceModel)& model) ;
  //! Shortcut when both <ent> and <model> are not used <br>
//!           (when the Editor works on fully static or global data) <br>
  Standard_EXPORT     Standard_Boolean LoadData() ;
  //! Returns a ListEditor to edit the parameter <num> of the <br>
//!           EditForm, if it is a List <br>
//!           The Editor created it (by ListEditor) then loads it (by <br>
//!             ListValue) <br>
//!           For a single parameter, returns a Null Handle ... <br>
  Standard_EXPORT     Handle_IFSelect_ListEditor ListEditor(const Standard_Integer num) const;
  //! Loads an original value (single). Called by the Editor only <br>
  Standard_EXPORT     void LoadValue(const Standard_Integer num,const Handle(TCollection_HAsciiString)& val) ;
  //! Loads an original value as a list. Called by the Editor only <br>
  Standard_EXPORT     void LoadList(const Standard_Integer num,const Handle(TColStd_HSequenceOfHAsciiString)& list) ;
  //! From an edited value, returns its ... value (original one) <br>
//!           Null means that this value is not defined <br>
//!           <num> is for the EditForm, not the Editor <br>
//!           It is for a single parameter. For a list, gives a Null Handle <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString OriginalValue(const Standard_Integer num) const;
  //! Returns an original value, as a list <br>
//!           <num> is for the EditForm, not the Editor <br>
//!           For a single parameter, gives a Null Handle <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfHAsciiString OriginalList(const Standard_Integer num) const;
  //! Returns the Edited (i.e. Modified) Value (string for single) <br>
//!           <num> reports to the EditForm <br>
//!           If IsModified is False, returns OriginalValue <br>
//!           Null with IsModified True : means that this value is not <br>
//!             defined or has been removed <br>
//!           It is for a single parameter. For a list, gives a Null Handle <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString EditedValue(const Standard_Integer num) const;
  //! Returns the Edited Value as a list <br>
//!           If IsModified is False, returns OriginalValue <br>
//!           Null with IsModified True : means that this value is not <br>
//!             defined or has been removed <br>
//!           For a single parameter, gives a Null Handle <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfHAsciiString EditedList(const Standard_Integer num) const;
  //! Tells if a Value (of the EditForm) is modified (directly or <br>
//!           through touching by Update) <br>
  Standard_EXPORT     Standard_Boolean IsModified(const Standard_Integer num) const;
  //! Tells if a Value (of the EditForm) has been touched, i.e. <br>
//!           not modified directly but by the modification of another one <br>
//!           (by method Update from the Editor) <br>
  Standard_EXPORT     Standard_Boolean IsTouched(const Standard_Integer num) const;
  //! Gives a new value for the item <num> of the EditForm, if <br>
//!           it is a single parameter (for a list, just returns False) <br>
//!           Null means to Remove it <br>
//!           <enforce> True to overpass Protected or Computed Access Mode <br>
//!           Calls the method Update from the Editor, which can touch other <br>
//!           parameters (see NbTouched) <br>
//!           Returns True if well recorded, False if this value is not <br>
//!           allowed <br>
//!  Warning : Does not apply immediately : will be applied by the method <br>
//!           Apply <br>
  Standard_EXPORT     Standard_Boolean Modify(const Standard_Integer num,const Handle(TCollection_HAsciiString)& newval,const Standard_Boolean enforce = Standard_False) ;
  //! Changes the value of an item of the EditForm, if it is a List <br>
//!           (else, just returns False) <br>
//!           The ListEditor contains the edited values of the list <br>
//!           If no edition was recorded, just returns False <br>
//!           Calls the method Update from the Editor, which can touch other <br>
//!           parameters (see NbTouched) <br>
//!           Returns True if well recorded, False if this value is not <br>
//!           allowed <br>
//!  Warning : Does not apply immediately : will be applied by the method <br>
//!           Apply <br>
  Standard_EXPORT     Standard_Boolean ModifyList(const Standard_Integer num,const Handle(IFSelect_ListEditor)& edited,const Standard_Boolean enforce = Standard_False) ;
  //! As ModifyList but the new value is given as such <br>
//!           Creates a ListEditor, Loads it, then calls ModifyList <br>
  Standard_EXPORT     Standard_Boolean ModifyListValue(const Standard_Integer num,const Handle(TColStd_HSequenceOfHAsciiString)& list,const Standard_Boolean enforce = Standard_False) ;
  //! Gives a new value computed by the Editor, if another parameter <br>
//!           commands the value of <num> <br>
//!           It is generally the case for a Computed Parameter for instance <br>
//!           Increments the counter of touched parameters <br>
//!  Warning : it gives no protection for ReadOnly etc... while it is the <br>
//!           internal way of touching parameters <br>
//!           Does not work (returns False) if <num> is for a list <br>
  Standard_EXPORT     Standard_Boolean Touch(const Standard_Integer num,const Handle(TCollection_HAsciiString)& newval) ;
  //! Acts as Touch but for a list <br>
//!           Does not work (returns False) if <num> is for a single param <br>
  Standard_EXPORT     Standard_Boolean TouchList(const Standard_Integer num,const Handle(TColStd_HSequenceOfHAsciiString)& newlist) ;
  //! Returns the count of parameters touched by the last Modify <br>
//!           (apart from the modified parameter itself) <br>
//!           Normally it is zero <br>
  Standard_EXPORT     Standard_Integer NbTouched() const;
  //! Clears modification status : by default all, or one by its <br>
//!           numbers (in the Editor) <br>
  Standard_EXPORT     void ClearEdit(const Standard_Integer num = 0) ;
  //! Prints Definitions, relative to the Editor <br>
  Standard_EXPORT     void PrintDefs(const Handle(Message_Messenger)& S) const;
  //! Prints Values, according to what and alsolist <br>
//!           <names> True : prints Long Names; False : prints Short Names <br>
//!           <what> < 0 : prints Original Values (+ flag Modified) <br>
//!           <what> > 0 : prints Final Values (+flag Modified) <br>
//!           <what> = 0 : prints Modified Values (Original + Edited) <br>
//!           <alsolist> False (D) : lists are printed only as their count <br>
//!           <alsolist> True : lists are printed for all their items <br>
  Standard_EXPORT     void PrintValues(const Handle(Message_Messenger)& S,const Standard_Integer what,const Standard_Boolean names,const Standard_Boolean alsolist = Standard_False) const;
  //! Applies modifications to own data <br>
//!           Calls ApplyData then Clears Status according EditKeepStatus <br>
  Standard_EXPORT     Standard_Boolean Apply() ;
  //! Tells if this EditForm can work with its Editor and its actual <br>
//!           Data (Entity and Model) <br>
//!           Default uses Editor. Can be redefined <br>
  Standard_EXPORT   virtual  Standard_Boolean Recognize() const;
  //! Applies modifications to data <br>
//!           Default uses Editor. Can be redefined <br>
  Standard_EXPORT   virtual  Standard_Boolean ApplyData(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;
  //! For an undoable EditForm, Applies ... origibal values ! <br>
//!           and clears modified ones <br>
//!           Can be run only once <br>
  Standard_EXPORT     Standard_Boolean Undo() ;




  DEFINE_STANDARD_RTTI(IFSelect_EditForm)

protected:




private: 


Standard_Boolean thecomplete;
Standard_Boolean theloaded;
Standard_Boolean thekeepst;
TCollection_AsciiString thelabel;
TColStd_Array1OfInteger thenums;
TColStd_Array1OfTransient theorigs;
TColStd_Array1OfTransient themodifs;
TColStd_Array1OfInteger thestatus;
Handle_IFSelect_Editor theeditor;
Handle_Standard_Transient theent;
Handle_Interface_InterfaceModel themodel;
Standard_Integer thetouched;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
