##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import centos


class CentOSParserTestCase(unittest.TestCase):

    ## Initial Setup
    centos_parser_obj = centos.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/CESA-015574.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.centos_parser_obj, 'Html_content', self.Html_content)

        ptr = open('./test/unit_test/work/input/CESA-redhat-adv.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.redhat_adv_con = "".join(lines)


    def test_getCVE(self):
        print "\nTesting CentOS Parser Test Suite ..."
        req_out_put = 'CVE-2008-5077'

        out_put = self.centos_parser_obj.getCVE(self.redhat_adv_con)
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'CESA-2009:0004-01'

        out_put = self.centos_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'openssl'

        out_put = self.centos_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "  OpenSSL is a toolkit that implements Secure Sockets Layer (SSL v2/v3) and\n  Transport Layer Security (TLS v1) protocols as well as a full-strength,\n  general purpose, cryptography library.\n  \n  The Google security team discovered a flaw in the way OpenSSL checked the\n  verification of certificates. An attacker in control of a malicious server,\n  or able to effect a &quot;man in the middle&quot; attack, could present a malformed\n  SSL/TLS signature from a certificate chain to a vulnerable client and\n  bypass validation. (CVE-2008-5077)\n  \n  All OpenSSL users should upgrade to these updated packages, which contain\n  backported patches to resolve these issues. For the update to take effect,\n  all running OpenSSL client applications must be restarted, or the system\n  rebooted.\n" 

        out_put = self.centos_parser_obj.getDescription(self.redhat_adv_con)
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['CentOS 2']

        out_put = self.centos_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'CENTOS2': ['openssl-0.9.6b-49', 'openssl-devel-0.9.6b-49', 'openssl-perl-0.9.6b-49', 'openssl095a-0.9.5a-34', 'openssl096-0.9.6-34']}

        prod_list = ['CentOS 2']
        out_put = self.centos_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://lists.centos.org/pipermail/centos-announce/2009-February/015574.html'

        main_url = 'http://lists.centos.org/pipermail/centos-announce/'
        file_name = '2009-February_015574.html'
        out_put = self.centos_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://lists.centos.org/pipermail/centos-announce/2009-February/015574.html'

        main_url = 'http://lists.centos.org/pipermail/centos-announce'
        file_name = '2009-February_015574.html'
        out_put = self.centos_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_getRedhatAdvCon1(self):
        req_out_put = '=====================================================================\n                   Red Hat Security Advisory\n\nSynopsis:          Important: openssl security update\nAdvisory ID:       RHSA-2009:0004-01\nProduct:           Red Hat Enterprise Linux\nAdvisory URL:      <a  rel="nofollow" href="https://rhn.redhat.com/errata/RHSA-2009-0004.html">https://rhn.redhat.com/errata/RHSA-2009-0004.html</a>\nIssue date:        2009-01-07\nCVE Names:         CVE-2008-5077 \n=====================================================================\n\n3. Description:\n\nOpenSSL is a toolkit that implements Secure Sockets Layer (SSL v2/v3) and\nTransport Layer Security (TLS v1) protocols as well as a full-strength,\ngeneral purpose, cryptography library.\n\nThe Google security team discovered a flaw in the way OpenSSL checked the\nverification of certificates. An attacker in control of a malicious server,\nor able to effect a &quot;man in the middle&quot; attack, could present a malformed\nSSL/TLS signature from a certificate chain to a vulnerable client and\nbypass validation. (CVE-2008-5077)\n\nAll OpenSSL users should upgrade to these updated packages, which contain\nbackported patches to resolve these issues. For the update to take effect,\nall running OpenSSL client applications must be restarted, or the system\nrebooted.\n\n4. Solution:\n\nBefore applying this update, make sure that all previously-released\n'

        adv_id = 'CESA-2009:0004-01'
        adv_id_link_map = {'RHSA-2009:0004-01': './test/unit_test/work/input/CESA-redhat-adv.html'} 
        setattr(self.centos_parser_obj, 'adv_id_link_map', adv_id_link_map)
        out_put = self.centos_parser_obj.getRedhatAdvCon(adv_id)
        self.assertEquals(out_put, req_out_put)


    def test_getRedhatAdvCon2(self):
        req_out_put = '=====================================================================\n                   Red Hat Security Advisory\n\nSynopsis:          Important: openssl security update\nAdvisory ID:       RHSA-2009:0004-01\nProduct:           Red Hat Enterprise Linux\nAdvisory URL:      <a  rel="nofollow" href="https://rhn.redhat.com/errata/RHSA-2009-0004.html">https://rhn.redhat.com/errata/RHSA-2009-0004.html</a>\nIssue date:        2009-01-07\nCVE Names:         CVE-2008-5077 \n=====================================================================\n\n3. Description:\n\nOpenSSL is a toolkit that implements Secure Sockets Layer (SSL v2/v3) and\nTransport Layer Security (TLS v1) protocols as well as a full-strength,\ngeneral purpose, cryptography library.\n\nThe Google security team discovered a flaw in the way OpenSSL checked the\nverification of certificates. An attacker in control of a malicious server,\nor able to effect a &quot;man in the middle&quot; attack, could present a malformed\nSSL/TLS signature from a certificate chain to a vulnerable client and\nbypass validation. (CVE-2008-5077)\n\nAll OpenSSL users should upgrade to these updated packages, which contain\nbackported patches to resolve these issues. For the update to take effect,\nall running OpenSSL client applications must be restarted, or the system\nrebooted.\n\n4. Solution:\n\nBefore applying this update, make sure that all previously-released\n'

        adv_id = 'CESA-2009:0004'
        adv_id_link_map = {'RHSA-2009:0004-01': './test/unit_test/work/input/CESA-redhat-adv.html'} 
        setattr(self.centos_parser_obj, 'adv_id_link_map', adv_id_link_map)
        out_put = self.centos_parser_obj.getRedhatAdvCon(adv_id)
        self.assertEquals(out_put, req_out_put)


    def test_getFileName1(self):
        req_out_put = 'CESA-2009_0004-01_openssl_centos2_i386'

        file_name = '2009-February_015574.html'
        adv_id = 'CESA-2009:0004-01'
        prod = 'openssl'
        platform = 'CentOS 2'
        (out_put, os, arch) = self.centos_parser_obj.getFileName(adv_id, prod, platform)
        self.assertEquals(out_put, req_out_put)


    def test_getFileName2(self):
        req_out_put = 'CESA-2009_0004-01_openssl_centos2'

        file_name = '2009-February_015574.html'
        adv_id = 'CESA-2009:0004-01'
        prod = 'openssl'
        platform = 'CentOS 2'
        setattr(self.centos_parser_obj, 'Html_content', self.redhat_adv_con)
        (out_put, os, arch) = self.centos_parser_obj.getFileName(adv_id, prod, platform)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        adv_id_link_map = {'RHSA-2009:0004-01': './test/unit_test/work/input/CESA-redhat-adv.html'} 
        setattr(self.centos_parser_obj, 'adv_id_link_map', adv_id_link_map)
        out_put = self.centos_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['http://lists.centos.org/pipermail/centos-announce/2009-February/thread.html', 'http://lists.centos.org/pipermail/centos-announce/2009-January/thread.html']

        link = './test/unit_test/work/input/centos-advisory-main.html'
        year = '2009'
        append_url = 'http://lists.centos.org/pipermail/centos-announce/'
        out_put = self.centos_parser_obj._getYearLinks(link, year, append_url)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['http://lists.centos.org/pipermail/centos-announce/input/015572.html', 'http://lists.centos.org/pipermail/centos-announce/input/015573.html', 'http://lists.centos.org/pipermail/centos-announce/input/015574.html', 'http://lists.centos.org/pipermail/centos-announce/input/015575.html', 'http://lists.centos.org/pipermail/centos-announce/input/015576.html', 'http://lists.centos.org/pipermail/centos-announce/input/015586.html', 'http://lists.centos.org/pipermail/centos-announce/input/015587.html', 'http://lists.centos.org/pipermail/centos-announce/input/015588.html', 'http://lists.centos.org/pipermail/centos-announce/input/015589.html', 'http://lists.centos.org/pipermail/centos-announce/input/015605.html', 'http://lists.centos.org/pipermail/centos-announce/input/015606.html', 'http://lists.centos.org/pipermail/centos-announce/input/015607.html', 'http://lists.centos.org/pipermail/centos-announce/input/015608.html', 'http://lists.centos.org/pipermail/centos-announce/input/015609.html', 'http://lists.centos.org/pipermail/centos-announce/input/015610.html', 'http://lists.centos.org/pipermail/centos-announce/input/015618.html', 'http://lists.centos.org/pipermail/centos-announce/input/015619.html', 'http://lists.centos.org/pipermail/centos-announce/input/015620.html', 'http://lists.centos.org/pipermail/centos-announce/input/015621.html', 'http://lists.centos.org/pipermail/centos-announce/input/015622.html', 'http://lists.centos.org/pipermail/centos-announce/input/015629.html', 'http://lists.centos.org/pipermail/centos-announce/input/015630.html', 'http://lists.centos.org/pipermail/centos-announce/input/015631.html', 'http://lists.centos.org/pipermail/centos-announce/input/015632.html', 'http://lists.centos.org/pipermail/centos-announce/input/015633.html', 'http://lists.centos.org/pipermail/centos-announce/input/015634.html', 'http://lists.centos.org/pipermail/centos-announce/input/015645.html', 'http://lists.centos.org/pipermail/centos-announce/input/015646.html', 'http://lists.centos.org/pipermail/centos-announce/input/015647.html', 'http://lists.centos.org/pipermail/centos-announce/input/015648.html']

        link = './test/unit_test/work/input/CESA-Feb-2009.html'
        out_put = self.centos_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

