###############################################################################
# OpenVAS Vulnerability Test
#
# Fetch results of SLAD queries from a remote machine
#
# Authors:
# Dirk Jagdmann
# Michael Wiegand
#
# Copyright:
# Copyright (c) 2005 DN-Systems GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

debug = 0;

include ("ssh_func.inc");
include ("slad.inc");

if (description) {
  script_id(90002);
  script_version ("1.0");
  name = "SLAD Run";
  
  script_name(name);
  script_tag(name:"risk_factor", value:"None");
  
  desc = "
This script connects to SLAD on a remote host to run
remote scanners.
To work properly, this script requires to be provided
with a valid SSH login by means of an SSH key with pass-
phrase if the SSH public key is passphrase-protected, or
a password to log in.";

  script_description(desc);
  
  summary = "Connects to SLAD to run programs remotely";
  script_summary(summary);
  
  script_category(ACT_GATHER_INFO);
  
  script_copyright("This script is Copyright 2005 DN Systems GmbH");
  family = "General";
  script_family(family);
  
  script_dependencies ("find_service.nes", "ssh_authorization.nasl");
  script_require_ports (22, "Services/ssh");

  # Dynamic entries for running from slad.inc
  if(defined_func("init_add_preferences")) {
    init_add_preferences ();
  } 

  exit(0);
}

{
  if (debug)
    dump_preferences ();

  sock = ssh_login_or_reuse_connection();
  if(!sock) {
# Send "error" as set by ssh_funcs.
    log_message(port:port, data:get_ssh_error());
    exit(0);
  }
  run_slad (sock: sock, slad_exe: "/opt/slad/bin/sladd");
  
  close (sock);
}
