#
# This script was written by Michael Scheidell SECNAP Network Security
#
# See the Nessus Scripts License for details

if(description)
{
 script_id(11231);
 script_bugtraq_id(6778);
 script_cve_id("CAN-2003-0004");
 script_version("$Revision: 8291 $");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");

 name = "Unchecked Buffer in XP Redirector (Q810577)";

 script_name(name);
 
 desc = "
The remote host is vulnerable to a flaw in the RPC redirector
which can allow a local attacker to run code of its choice
with the SYSTEM privileges.

Solution : see http://www.microsoft.com/technet/security/bulletin/ms03-005.mspx
Risk factor : Medium";

 script_description(desc);
 
 summary = "Checks for MS Hotfix Q810577";

 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2003 SECNAP Network Security");
 family = "Windows : Microsoft Bulletins";
 script_family(family);
 
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 script_require_ports(139, 445);
 exit(0);
}

include("secpod_reg.inc");

if ( hotfix_check_sp(xp:2) <= 0 ) exit(0);
if ( hotfix_missing(name:"810577") > 0 &&
     hotfix_missing(name:"885835") > 0  )
	security_warning(get_kb_item("SMB/transport"));
