///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ANIM_TIME_SLIDER_H
#define __ANIM_TIME_SLIDER_H

#include <core/scene/animation/AnimManager.h>

namespace Core {

/******************************************************************************
* This slider component controls the current scene time.
******************************************************************************/
class AnimationTimeSlider : public QFrame
{
	Q_OBJECT

public:
	/// Constructor..
	AnimationTimeSlider(QWidget* parentWindow = NULL);
	
protected Q_SLOTS:

	/// Is called when the user has activated or deactivated the animation mode.
	void OnAnimationModeChanged(bool active);

protected:

	/// Handles paint events.
	virtual void paintEvent(QPaintEvent* event);
	
	/// Handles mouse down events.
	virtual void mousePressEvent(QMouseEvent* event);	
	/// Handles mouse up events.
	virtual void mouseReleaseEvent(QMouseEvent* event);
	/// Handles mouse move events.
	virtual void mouseMoveEvent(QMouseEvent* event);
	
	/// Returns the recommended size for the widget.
	virtual QSize sizeHint() const;
	/// Returns the minimium size for the widget.
	virtual QSize minimumSizeHint() const { return sizeHint(); }
	
	/// Computes the coordinates of the slider thumb.
	QRect ThumbRectangle();
	
	/// the dragging start position
	int dragPos;
};

};

#endif // __ANIM_TIME_SLIDER_H
