///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include "BezierShape.h"

namespace Core {

/******************************************************************************
* Saves the shape to the given stream.
******************************************************************************/
void BezierShape::saveToStream(SaveStream& stream) const
{
	stream.beginChunk(0x01);

	stream.writeSizeT(curves().size());
	for(QVector<BezierCurve>::const_iterator curve = curves().begin(); curve != curves().end(); ++curve) {
		curve->saveToStream(stream);
	}

	stream.endChunk();
}

/******************************************************************************
* Loads the shape from the given stream.
******************************************************************************/
void BezierShape::loadFromStream(LoadStream& stream)
{
	stream.expectChunk(0x01);

	size_t ncurves;
	stream.readSizeT(ncurves);
	_curves.resize(ncurves);
	for(QVector<BezierCurve>::iterator curve = curves().begin(); curve != curves().end(); ++curve) {
		curve->loadFromStream(stream);
	}

	stream.closeChunk();
}

};	// End of namespace Core
