#ifndef _BLASR_CDFS_HPP_
#define _BLASR_CDFS_HPP_

#include <alignment/statistics/pdfs.hpp>

static const float NormCDFTable[2000] = {
    7.61985302416053e-24,
    8.42908720044307e-24,
    9.32333910390851e-24,
    1.03114418389443e-23,
    1.14031357813280e-23,
    1.26091606702069e-23,
    1.39413569342072e-23,
    1.54127771659480e-23,
    1.70378087485724e-23,
    1.88323087358676e-23,
    2.08137521949321e-23,
    2.30013953380610e-23,
    2.54164548995384e-23,
    2.80823053544230e-23,
    3.10246957313482e-23,
    3.42719879411367e-23,
    3.78554187290007e-23,
    4.18093875618591e-23,
    4.61717729854569e-23,
    5.09842802303871e-23,
    5.62928231137653e-23,
    6.21479435763827e-23,
    6.860527251602e-23,
    7.57260359288958e-23,
    8.3577610755683e-23,
    9.22341352493942e-23,
    1.01777179142962e-22,
    1.12296479398304e-22,
    1.23890747870050e-22,
    1.36668557820343e-22,
    1.50749316881020e-22,
    1.6626433478118e-22,
    1.83357994947588e-22,
    2.02189039948453e-22,
    2.22931981695015e-22,
    2.45778648347233e-22,
    2.70939880997893e-22,
    2.98647394442484e-22,
    3.29155817689778e-22,
    3.62744931340731e-22,
    3.99722120572624e-22,
    4.40425064223392e-22,
    4.85224682392038e-22,
    5.34528367069058e-22,
    5.88783522602465e-22,
    6.48481445307726e-22,
    7.14161574262827e-22,
    7.86416148313604e-22,
    8.65895307572446e-22,
    9.53312681249342e-22,
    1.04945150753626e-21,
    1.15517133550207e-21,
    1.27141536357825e-21,
    1.39921847426015e-21,
    1.53971603015202e-21,
    1.69415350248814e-21,
    1.86389700981111e-21,
    2.05044485163175e-21,
    2.25544012968370e-21,
    2.48068455788088e-21,
    2.72815357134612e-21,
    3.00001285497641e-21,
    3.29863642301526e-21,
    3.62662639309896e-21,
    3.98683461131598e-21,
    4.38238629906651e-21,
    4.81670590802906e-21,
    5.29354538645474e-21,
    5.81701507843054e-21,
    6.39161749781974e-21,
    7.02228424044163e-21,
    7.71441632185196e-21,
    8.4739282539989e-21,
    9.30729620224586e-21,
    1.02216105949631e-20,
    1.12246335913280e-20,
    1.23248618493586e-20,
    1.35315950758093e-20,
    1.48550108826456e-20,
    1.63062465217032e-20,
    1.78974881201405e-20,
    1.96420680947798e-20,
    2.15545714837844e-20,
    2.36509519997439e-20,
    2.59486586796199e-20,
    2.84667740846022e-20,
    3.12261650872937e-20,
    3.42496473753623e-20,
    3.75621649004811e-20,
    4.1190985609727e-20,
    4.51659149143546e-20,
    4.95195284787818e-20,
    5.42874260516386e-20,
    5.95085082117206e-20,
    6.52252780657133e-20,
    7.1484170112697e-20,
    7.83359086839063e-20,
    8.5835898576284e-20,
    9.4044650726485e-20,
    1.03028246019560e-19,
    1.12858840595384e-19,
    1.23615216307614e-19,
    1.35383380306580e-19,
    1.48257218061103e-19,
    1.62339204507009e-19,
    1.77741178414554e-19,
    1.94585185505699e-19,
    2.13004396328083e-19,
    2.33144105408587e-19,
    2.55162818769100e-19,
    2.79233437493965e-19,
    3.05544545696482e-19,
    3.34301811945149e-19,
    3.65729513983357e-19,
    4.00072197414327e-19,
    4.37596479930904e-19,
    4.78593013653989e-19,
    5.23378619209301e-19,
    5.7229860632712e-19,
    6.25729297000645e-19,
    6.84080768593555e-19,
    7.47799835754742e-19,
    8.1737329158706e-19,
    8.93331430237564e-19,
    9.76251874938821e-19,
    1.06676373754749e-18,
    1.16555213780823e-18,
    1.27336311293298e-18,
    1.39100895064098e-18,
    1.51937398157053e-18,
    1.65942086996478e-18,
    1.81219744477020e-18,
    1.97884411678722e-18,
    2.16060193129749e-18,
    2.35882130968722e-18,
    2.57497153801189e-18,
    2.81065106523422e-18,
    3.06759867904084e-18,
    3.34770563273514e-18,
    3.65302880274925e-18,
    3.98580496284818e-18,
    4.34846626815861e-18,
    4.74365704977974e-18,
    5.17425202897168e-18,
    5.64337606881557e-18,
    6.15442559085038e-18,
    6.71109179457108e-18,
    7.31738582887958e-18,
    7.97766607668324e-18,
    8.69666772689607e-18,
    9.47953482220332e-18,
    1.03318549861686e-17,
    1.12596970496900e-17,
    1.22696518145366e-17,
    1.33688762108225e-17,
    1.45651411259094e-17,
    1.58668832044827e-17,
    1.72832609435602e-17,
    1.88242154320746e-17,
    2.05005361125985e-17,
    2.23239319728804e-17,
    2.43071086073182e-17,
    2.64638516234818e-17,
    2.88091169065084e-17,
    3.13591282948427e-17,
    3.41314832645815e-17,
    3.71452672668869e-17,
    4.04211774137699e-17,
    4.39816562623235e-17,
    4.78510365064786e-17,
    5.20556974489026e-17,
    5.66242341940844e-17,
    6.15876405773299e-17,
    6.69795069237318e-17,
    7.2836233816555e-17,
    7.91972631464248e-17,
    8.61053278116287e-17,
    9.36067215463159e-17,
    1.01751590467945e-16,
    1.10594248058595e-16,
    1.20193515427359e-16,
    1.30613088843666e-16,
    1.41921936684837e-16,
    1.54194728106090e-16,
    1.67512295918692e-16,
    1.81962136352663e-16,
    1.97638948585499e-16,
    2.14645217138836e-16,
    2.33091840481832e-16,
    2.5309880943477e-16,
    2.74795939239823e-16,
    2.98323659460026e-16,
    3.23833866183229e-16,
    3.51490841347056e-16,
    3.81472244365282e-16,
    4.13970181627315e-16,
    4.49192359862693e-16,
    4.87363329813632e-16,
    5.28725827143121e-16,
    5.73542218025806e-16,
    6.22096057427178e-16,
    6.74693768675356e-16,
    7.31666453572489e-16,
    7.93371842982395e-16,
    8.60196398570778e-16,
    9.32557577168123e-16,
    1.01090627007634e-15,
    1.09572943055325e-15,
    1.18755290368805e-15,
    1.28694447393013e-15,
    1.39451714665926e-15,
    1.51093268139136e-15,
    1.63690539550678e-15,
    1.77320625877395e-15,
    1.92066730042609e-15,
    2.08018635213939e-15,
    2.25273215196613e-15,
    2.43934983610145e-15,
    2.64116684731894e-15,
    2.85939929100417e-15,
    3.0953587719587e-15,
    3.35045974754833e-15,
    3.62622743534104e-15,
    3.92430631613157e-15,
    4.24646927619696e-15,
    4.59462743577860e-15,
    4.97084071416196e-15,
    5.37732918533406e-15,
    5.81648528206159e-15,
    6.29088691036376e-15,
    6.80331154077401e-15,
    7.35675134750924e-15,
    7.9544294717215e-15,
    8.59981749040868e-15,
    9.29665417833992e-15,
    1.00489656565263e-14,
    1.08610870273690e-14,
    1.17376856036716e-14,
    1.26837858462427e-14,
    1.37047961328694e-14,
    1.48065374900481e-14,
    1.59952744280531e-14,
    1.72777480297408e-14,
    1.86612114539743e-14,
    2.01534680257531e-14,
    2.17629120970858e-14,
    2.34985728754111e-14,
    2.53701614299986e-14,
    2.73881211013013e-14,
    2.95636815537589e-14,
    3.19089167291090e-14,
    3.44368069749374e-14,
    3.71613056420548e-14,
    4.00974104643949e-14,
    4.32612400565811e-14,
    4.66701158871906e-14,
    5.03426501101292e-14,
    5.42988396625522e-14,
    5.85601670654849e-14,
    6.3149708392861e-14,
    6.80922489062002e-14,
    7.34144068857165e-14,
    7.91447662244323e-14,
    8.53140183899803e-14,
    9.19551143994013e-14,
    9.91034274954757e-14,
    1.0679692725923e-13,
    1.15076365942292e-13,
    1.23985477855031e-13,
    1.33571192702046e-13,
    1.43883863815759e-13,
    1.54977512301920e-13,
    1.66910088177930e-13,
    1.79743749656217e-13,
    1.93545161800965e-13,
    2.08385815867207e-13,
    2.24342370717358e-13,
    2.41497017801669e-13,
    2.59937871286364e-13,
    2.79759385016643e-13,
    3.01062798111745e-13,
    3.23956611106135e-13,
    3.48557094675241e-13,
    3.7498883311623e-13,
    4.03385304894755e-13,
    4.33889502717806e-13,
    4.66654595751316e-13,
    5.01844636769645e-13,
    5.3963531720292e-13,
    5.80214773238327e-13,
    6.23784446333159e-13,
    6.70560001711864e-13,
    7.20772308646748e-13,
    7.74668486563648e-13,
    8.32513021270262e-13,
    8.94588955876992e-13,
    9.6119916126894e-13,
    1.03266769129427e-12,
    1.10934122815914e-12,
    1.19159062386450e-12,
    1.27981254388584e-12,
    1.37443121968512e-12,
    1.47590031705553e-12,
    1.58470492773607e-12,
    1.70136369219568e-12,
    1.82643106197697e-12,
    1.96049971050927e-12,
    2.10420310185185e-12,
    2.25821822741171e-12,
    2.42326852129899e-12,
    2.60012696563817e-12,
    2.78961939784764e-12,
    2.99262803263505e-12,
    3.21009521223458e-12,
    3.44302739923701e-12,
    3.69249942723561e-12,
    3.95965902543588e-12,
    4.24573163435442e-12,
    4.55202553076802e-12,
    4.8799372811693e-12,
    5.23095754414459e-12,
    5.60667724331564e-12,
    6.00879413378503e-12,
    6.43911978639591e-12,
    6.89958701556968e-12,
    7.39225777801782e-12,
    7.91933157124842e-12,
    8.48315436250203e-12,
    9.08622808056533e-12,
    9.7312207048268e-12,
    1.04209769879652e-11,
    1.11585298507993e-11,
    1.19471124900909e-11,
    1.27901712424794e-11,
    1.36913792502502e-11,
    1.46546509773028e-11,
    1.56841576264994e-11,
    1.67843435125431e-11,
    1.79599434476731e-11,
    1.92160012007750e-11,
    2.05578890939952e-11,
    2.19913288046425e-11,
    2.35224134440417e-11,
    2.51576309891186e-11,
    2.69038891468201e-11,
    2.87685417360433e-11,
    3.07594166765647e-11,
    3.28848456795426e-11,
    3.51536957395174e-11,
    3.75754025334884e-11,
    4.01600058385912e-11,
    4.29181870861797e-11,
    4.58613091767249e-11,
    4.90014586869096e-11,
    5.23514906076399e-11,
    5.59250757594271e-11,
    5.97367510397311e-11,
    6.38019726654473e-11,
    6.81371725827341e-11,
    7.27598182259036e-11,
    7.76884758170981e-11,
    8.29428774090212e-11,
    8.85439918840776e-11,
    9.45141001349502e-11,
    1.00876874663930e-10,
    1.07657463851216e-10,
    1.14882581156030e-10,
    1.22580599528633e-10,
    1.30781651326424e-10,
    1.39517734043067e-10,
    1.48822822176231e-10,
    1.58732985576987e-10,
    1.69286514642305e-10,
    1.80524052731342e-10,
    1.92488736206550e-10,
    2.05226342521894e-10,
    2.18785446802903e-10,
    2.33217587386751e-10,
    2.48577440815301e-10,
    2.6492300679994e-10,
    2.82315803704329e-10,
    3.00821075119684e-10,
    3.20508008137342e-10,
    3.41449963954737e-10,
    3.63724721484069e-10,
    3.87414734667567e-10,
    4.12607404239677e-10,
    4.3939536471467e-10,
    4.67876787418161e-10,
    4.98155700423128e-10,
    5.30342326294884e-10,
    5.64553438595807e-10,
    6.00912738148843e-10,
    6.39551250109663e-10,
    6.80607742950414e-10,
    7.24229170513764e-10,
    7.70571138354246e-10,
    8.19798395645136e-10,
    8.72085353992974e-10,
    9.27616634569113e-10,
    9.86587645037698e-10,
    1.04920518783315e-09,
    1.11568810141717e-09,
    1.18626793622573e-09,
    1.26118966710109e-09,
    1.34071244409187e-09,
    1.42511038359657e-09,
    1.51467340192265e-09,
    1.60970809343425e-09,
    1.71053865556700e-09,
    1.81750786309943e-09,
    1.93097809418531e-09,
    2.05133241077260e-09,
    2.17897569616056e-09,
    2.31433585257856e-09,
    2.45786506180803e-09,
    2.61004111201292e-09,
    2.77136879409463e-09,
    2.94238137104436e-09,
    3.12364212393002e-09,
    3.31574597832617e-09,
    3.51932121517463e-09,
    3.73503127024975e-09,
    3.96357662659765e-09,
    4.20569680452203e-09,
    4.46217245390161e-09,
    4.73382755384558e-09,
    5.02153172492455e-09,
    5.3262026594555e-09,
    5.64880867557094e-09,
    5.99037140106353e-09,
    6.35196859327198e-09,
    6.73473710155753e-09,
    7.13987597921841e-09,
    7.56864975199771e-09,
    8.02239185066354e-09,
    8.50250821547506e-09,
    9.01048108069906e-09,
    9.54787294770427e-09,
    1.01163307555414e-08,
    1.07175902583109e-08,
    1.13534806190322e-08,
    1.20259292301549e-08,
    1.27369667712999e-08,
    1.34887325152785e-08,
    1.42834798939228e-08,
    1.51235823357610e-08,
    1.60115393880909e-08,
    1.69499831365509e-08,
    1.79416849358471e-08,
    1.89895624658877e-08,
    2.00966871281765e-08,
    2.12662917979592e-08,
    2.25017789482686e-08,
    2.38067291627004e-08,
    2.51849100544611e-08,
    2.66402856099673e-08,
    2.81770259760399e-08,
    2.97995177105363e-08,
    3.15123745170822e-08,
    3.33204484854287e-08,
    3.5228841859843e-08,
    3.72429193588712e-08,
    3.93683210707590e-08,
    4.16109759498197e-08,
    4.3977115940059e-08,
    4.64732907534413e-08,
    4.91063833312853e-08,
    5.18836260184242e-08,
    5.48126174809566e-08,
    5.79013403996459e-08,
    6.1158179972306e-08,
    6.4591943259825e-08,
    6.82118794118624e-08,
    7.20277008096596e-08,
    7.60496051648871e-08,
    8.02882986149588e-08,
    8.47550198568288e-08,
    8.94615653629075e-08,
    9.44203157244297e-08,
    9.96442631693347e-08,
    1.05147040303541e-07,
    1.10942950126346e-07,
    1.17046997372632e-07,
    1.23474921236516e-07,
    1.30243229533202e-07,
    1.37369234357842e-07,
    1.44871089302508e-07,
    1.52767828294566e-07,
    1.61079406122137e-07,
    1.6982674071476e-07,
    1.79031757249834e-07,
    1.8871743415806e-07,
    1.98907851103713e-07,
    2.09628239018370e-07,
    2.20905032269544e-07,
    2.327659230486e-07,
    2.4523991806537e-07,
    2.58357397639973e-07,
    2.72150177285582e-07,
    2.86651571879194e-07,
    3.01896462520848e-07,
    3.17921366185283e-07,
    3.34764508273617e-07,
    3.52465898176424e-07,
    3.71067407963333e-07,
    3.90612854318327e-07,
    4.11148083843931e-07,
    4.32721061861702e-07,
    4.55381964840732e-07,
    4.79183276590321e-07,
    5.04179888357536e-07,
    5.30429202975094e-07,
    5.57991243209782e-07,
    5.86928764466638e-07,
    6.17307372009198e-07,
    6.49195642861335e-07,
    6.82665252561663e-07,
    7.177911069469e-07,
    7.54651479146372e-07,
    7.93328151975595e-07,
    8.3390656592291e-07,
    8.76475972929203e-07,
    9.21129596167143e-07,
    9.67964796032733e-07,
    1.01708324256870e-06,
    1.06859109454593e-06,
    1.12259918543618e-06,
    1.17922321651640e-06,
    1.23858395735247e-06,
    1.30080745391728e-06,
    1.36602524460614e-06,
    1.43437458442013e-06,
    1.50599867759616e-06,
    1.58104691897051e-06,
    1.65967514437147e-06,
    1.74204589034466e-06,
    1.82832866352416e-06,
    1.91870021997090e-06,
    2.01334485480934e-06,
    2.11245470250285e-06,
    2.21623004811754e-06,
    2.32487964993441e-06,
    2.43862107377942e-06,
    2.55768103945153e-06,
    2.68229577963886e-06,
    2.81271141172421e-06,
    2.94918432289151e-06,
    3.09198156895618e-06,
    3.24138128735339e-06,
    3.39767312473006e-06,
    3.56115867959756e-06,
    3.73215196051449e-06,
    3.9109798602807e-06,
    4.09798264663636e-06,
    4.29351446997187e-06,
    4.49794388856792e-06,
    4.71165441189724e-06,
    4.93504506253327e-06,
    5.16853095722413e-06,
    5.41254390770387e-06,
    5.66753304182674e-06,
    5.93396544562466e-06,
    6.2123268269015e-06,
    6.50312220099279e-06,
    6.80687659933406e-06,
    7.12413580149534e-06,
    7.45546709135513e-06,
    7.80146003810134e-06,
    8.16272730276308e-06,
    8.53990547099181e-06,
    8.933655912827e-06,
    9.34466567019636e-06,
    9.77364837291759e-06,
    1.02213451839841e-05,
    1.06885257749344e-05,
    1.11759893321206e-05,
    1.16845655947074e-05,
    1.22151159252530e-05,
    1.27685344137350e-05,
    1.33457490159063e-05,
    1.39477227268813e-05,
    1.45754547908670e-05,
    1.52299819479779e-05,
    1.59123797190822e-05,
    1.66237637296523e-05,
    1.73652910736041e-05,
    1.81381617181309e-05,
    1.89436199505532e-05,
    1.97829558682240e-05,
    2.06575069125468e-05,
    2.15686594481806e-05,
    2.25178503885254e-05,
    2.35065688685956e-05,
    2.45363579664098e-05,
    2.56088164740415e-05,
    2.67256007194921e-05,
    2.78884264405639e-05,
    2.90990707119310e-05,
    3.03593739266182e-05,
    3.16712418331199e-05,
    3.30366476294024e-05,
    3.44576341150531e-05,
    3.59363159028538e-05,
    3.74748816910734e-05,
    3.90755965977875e-05,
    4.07408045585508e-05,
    4.24729307887612e-05,
    4.42744843120707e-05,
    4.61480605562088e-05,
    4.80963440176028e-05,
    5.01221109961885e-05,
    5.22282324018202e-05,
    5.44176766336997e-05,
    5.66935125342568e-05,
    5.90589124189226e-05,
    6.15171551832553e-05,
    6.40716294888745e-05,
    6.67258370296846e-05,
    6.94833958798653e-05,
    7.234804392512e-05,
    7.53236423786833e-05,
    7.8414179383585e-05,
    8.16237737026862e-05,
    8.4956678497998e-05,
    8.84172852008039e-05,
    9.20101274741054e-05,
    9.57398852689147e-05,
    9.96113889759167e-05,
    0.000103629623674031,
    0.000107799733477388,
    0.000112127025982247,
    0.000116616976815368,
    0.000121275234285358,
    0.000126107624138487,
    0.000131120154420485,
    0.000136319020445802,
    0.000141710609875819,
    0.000147301507907473,
    0.000153098502573756,
    0.000159108590157534,
    0.000165338980720110,
    0.000171797103745931,
    0.000178490613904847,
    0.000185427396933278,
    0.000192615575635633,
    0.00020006351600732,
    0.000207779833480621,
    0.000215773399294718,
    0.000224053346991093,
    0.000232629079035525,
    0.000241510273567836,
    0.000250706891280538,
    0.000260229182427467,
    0.000270087693963475,
    0.000280293276816177,
    0.000290857093290744,
    0.000301790624608638,
    0.0003131056785812,
    0.000324814397418878,
    0.000336929265676882,
    0.000349463118337972,
    0.000362429149033044,
    0.000375840918400083,
    0.000389712362582032,
    0.000404057801864022,
    0.00041889194945037,
    0.000434229920381655,
    0.000450087240592117,
    0.00046647985610755,
    0.000483424142383777,
    0.000500936913785722,
    0.000519035433206972,
    0.000537737421829696,
    0.000557061069024622,
    0.000577025042390767,
    0.000597648497934415,
    0.000618951090386836,
    0.000640952983660057,
    0.000663674861439968,
    0.000687137937915848,
    0.000711363968645365,
    0.000736375261553932,
    0.000762194688067235,
    0.000788845694375573,
    0.000816352312828564,
    0.000844739173458628,
    0.000874031515631568,
    0.00090425519982234,
    0.000935436719514101,
    0.000967603213218358,
    0.00100078247661401,
    0.00103500297480284,
    0.00107029385467892,
    0.00110668495740925,
    0.0011442068310227,
    0.00118289074310441,
    0.00122276869359226,
    0.0012638734276723,
    0.00130623844876947,
    0.00134989803163009,
    0.00139488723549225,
    0.00144124191734002,
    0.00148899874523747,
    0.00153819521173806,
    0.00158886964736487,
    0.001641061234157,
    0.00169481001927726,
    0.0017501569286761,
    0.00180714378080643,
    0.00186581330038404,
    0.00192620913218786,
    0.00198837585489433,
    0.00205235899493975,
    0.00211820504040462,
    0.00218596145491324,
    0.00225567669154232,
    0.00232740020673155,
    0.00240118247418925,
    0.00247707499878586,
    0.00255513033042793,
    0.00263540207790495,
    0.00271794492270126,
    0.00280281463276503,
    0.00289006807622615,
    0.00297976323505456,
    0.00307195921865049,
    0.0031667162773578,
    0.00326409581589132,
    0.00336416040666919,
    0.00346697380304067,
    0.00357260095239974,
    0.00368110800917499,
    0.00379256234768549,
    0.00390703257485278,
    0.00402458854275831,
    0.00414530136103605,
    0.00426924340908935,
    0.00439648834812131,
    0.00452711113296733,
    0.00466118802371875,
    0.00479879659712618,
    0.00494001575777064,
    0.00508492574899103,
    0.0052336081635558,
    0.00538614595406669,
    0.0055426234430826,
    0.00570312633295069,
    0.00586774171533257,
    0.00603655808041266,
    0.00620966532577613,
    0.00638715476494317,
    0.00656911913554677,
    0.00675565260714066,
    0.00694685078862432,
    0.00714281073527142,
    0.00734363095534836,
    0.00754941141630921,
    0.00776025355055365,
    0.00797626026073373,
    0.00819753592459614,
    0.0084241863993457,
    0.00865631902551655,
    0.00889404263033678,
    0.00913746753057268,
    0.00938670553483859,
    0.00964186994535833,
    0.00990307555916425,
    0.0101704386687197,
    0.0104440770619511,
    0.0107241100216758,
    0.0110106583244114,
    0.0113038442385528,
    0.0116037915219036,
    0.0119106254185471,
    0.0122244726550447,
    0.0125454614359466,
    0.0128737214386020,
    0.0132093838072563,
    0.0135525811464200,
    0.0139034475134986,
    0.0142621184106689,
    0.0146287307759893,
    0.0150034229737322,
    0.0153863347839254,
    0.0157776073910905,
    0.0161773833721661,
    0.016585806683605,
    0.0170030226476328,
    0.0174291779376571,
    0.0178644205628166,
    0.0183088998516590,
    0.0187627664349377,
    0.0192261722275173,
    0.0196992704093769,
    0.0201822154057044,
    0.0206751628660701,
    0.0211782696426723,
    0.0216916937676468,
    0.0222155944294315,
    0.0227501319481792,
    0.0232954677502118,
    0.0238517643415085,
    0.0244191852802225,
    0.0249978951482205,
    0.0255880595216387,
    0.0261898449404527,
    0.026803418877055,
    0.0274289497038368,
    0.0280666066597725,
    0.0287165598160018,
    0.0293789800404094,
    0.0300540389611999,
    0.030741908929466,
    0.0314427629807527,
    0.0321567747956137,
    0.0328841186591639,
    0.0336249694196283,
    0.03437950244589,
    0.0351478935840388,
    0.0359303191129258,
    0.0367269556987264,
    0.0375379803485168,
    0.0383635703628713,
    0.0392039032874827,
    0.0400591568638171,
    0.0409295089788074,
    0.0418151376135949,
    0.0427162207913289,
    0.043632936524032,
    0.0445654627585431,
    0.0455139773215499,
    0.0464786578637201,
    0.0474596818029473,
    0.0484572262667228,
    0.0494714680336481,
    0.0505025834741036,
    0.0515507484900895,
    0.0526161384542521,
    0.0536989281481198,
    0.054799291699558,
    0.0559174025194695,
    0.0570534332377542,
    0.058207555638553,
    0.059379940594793,
    0.0605707580020589,
    0.061780176711812,
    0.0630083644639785,
    0.0642554878189359,
    0.0655217120889165,
    0.066807201268858,
    0.0681121179667254,
    0.0694366233333317,
    0.0707808769916854,
    0.0721450369658939,
    0.0735292596096484,
    0.0749336995343271,
    0.0763585095367391,
    0.0778038405265464,
    0.0792698414533924,
    0.080756659233771,
    0.0822644386776688,
    0.0837933224150144,
    0.085343450821967,
    0.0869149619470851,
    0.0885079914374021,
    0.0901226724644525,
    0.0917591356502808,
    0.0934175089934717,
    0.095097917795239,
    0.0968004845856105,
    0.098525329049748,
    0.100272567954442,
    0.102042315074819,
    0.103834681121300,
    0.105649773666855,
    0.107487697074587,
    0.109348552425692,
    0.111232437447834,
    0.113139446443977,
    0.115069670221708,
    0.117023196023109,
    0.119000107455201,
    0.121000484421018,
    0.123024403051343,
    0.125071935637150,
    0.127143150562798,
    0.129238112240018,
    0.131356881042731,
    0.133499513242747,
    0.135666060946383,
    0.137856572032035,
    0.140071090088769,
    0.142309654355939,
    0.144572299663909,
    0.146859056375896,
    0.149169950330982,
    0.151505002788344,
    0.153864230372735,
    0.156247645021255,
    0.158655253931457,
    0.161087059510831,
    0.163543059327692,
    0.166023246063529,
    0.168527607466838,
    0.171056126308482,
    0.173608780338625,
    0.176185542245258,
    0.178786379614372,
    0.181411254891797,
    0.184060125346759,
    0.186732943037172,
    0.189429654776712,
    0.192150202103696,
    0.194894521251808,
    0.197662543122692,
    0.200454193260450,
    0.203269391828068,
    0.206108053585813,
    0.208970087871601,
    0.211855398583397,
    0.214763884163637,
    0.217695437585733,
    0.220649946342650,
    0.223627292437600,
    0.226627352376868,
    0.229649997164791,
    0.232695092300897,
    0.235762497779251,
    0.238852068089987,
    0.241963652223073,
    0.245097093674310,
    0.248252230453571,
    0.25142889509531,
    0.254626914671336,
    0.257846110805865,
    0.261086299692861,
    0.264347292115678,
    0.267628893468983,
    0.270930903783006,
    0.274253117750074,
    0.277595324753465,
    0.280957308898564,
    0.284338849046324,
    0.287739718849027,
    0.291159686788347,
    0.294598516215698,
    0.298055965394877,
    0.301531787546966,
    0.305025730897519,
    0.308537538725987,
    0.312066949417390,
    0.315613696516222,
    0.319177508782556,
    0.322758110250348,
    0.326355220287920,
    0.329968553660594,
    0.333597820595458,
    0.337242726848250,
    0.340902973772323,
    0.344578258389676,
    0.348268273464017,
    0.351972707575838,
    0.355691245199453,
    0.359423566782009,
    0.363169348824381,
    0.366928263963972,
    0.370699981059346,
    0.37448416527668,
    0.378280478177981,
    0.382088577811048,
    0.385908118801123,
    0.389738752444203,
    0.393580126801961,
    0.39743188679824,
    0.401293674317076,
    0.405165128302204,
    0.409045884857994,
    0.412935577351785,
    0.416833836517558,
    0.420740290560897,
    0.424654565265205,
    0.428576284099099,
    0.432505068324962,
    0.436440537108567,
    0.440382307629757,
    0.444329995194093,
    0.448283213345439,
    0.452241573979416,
    0.456204687457683,
    0.460172162722971,
    0.464143607414828,
    0.468118627986013,
    0.472096829819479,
    0.476077817345893,
    0.480061194161628,
    0.48404656314717,
    0.488033526585888,
    0.492021686283098,
    0.496010643685368,
    0.5,
    0.503989356314631,
    0.507978313716902,
    0.511966473414112,
    0.515953436852831,
    0.519938805838373,
    0.523922182654107,
    0.527903170180521,
    0.531881372013987,
    0.535856392585172,
    0.539827837277029,
    0.543795312542317,
    0.547758426020584,
    0.551716786654561,
    0.555670004805907,
    0.559617692370243,
    0.563559462891433,
    0.567494931675038,
    0.571423715900901,
    0.575345434734795,
    0.579259709439103,
    0.583166163482443,
    0.587064422648215,
    0.590954115142006,
    0.594834871697796,
    0.598706325682924,
    0.60256811320176,
    0.60641987319804,
    0.610261247555797,
    0.614091881198878,
    0.617911422188953,
    0.62171952182202,
    0.62551583472332,
    0.629300018940654,
    0.633071736036028,
    0.636830651175619,
    0.640576433217991,
    0.644308754800547,
    0.648027292424163,
    0.651731726535983,
    0.655421741610324,
    0.659097026227677,
    0.66275727315175,
    0.666402179404542,
    0.670031446339406,
    0.67364477971208,
    0.677241889749653,
    0.680822491217444,
    0.684386303483778,
    0.68793305058261,
    0.691462461274013,
    0.69497426910248,
    0.698468212453034,
    0.701944034605123,
    0.705401483784302,
    0.708840313211654,
    0.712260281150973,
    0.715661150953676,
    0.719042691101436,
    0.722404675246535,
    0.725746882249926,
    0.729069096216994,
    0.732371106531017,
    0.735652707884323,
    0.738913700307139,
    0.742153889194135,
    0.745373085328664,
    0.74857110490469,
    0.75174776954643,
    0.75490290632569,
    0.758036347776927,
    0.761147931910014,
    0.764237502220749,
    0.767304907699103,
    0.77035000283521,
    0.773372647623132,
    0.7763727075624,
    0.77935005365735,
    0.782304562414267,
    0.785236115836363,
    0.788144601416603,
    0.791029912128399,
    0.793891946414187,
    0.796730608171932,
    0.79954580673955,
    0.802337456877308,
    0.805105478748191,
    0.807849797896304,
    0.810570345223288,
    0.813267056962828,
    0.81593987465324,
    0.818588745108203,
    0.821213620385628,
    0.823814457754742,
    0.826391219661375,
    0.828943873691518,
    0.831472392533162,
    0.83397675393647,
    0.836456940672308,
    0.838912940489169,
    0.841344746068543,
    0.843752354978745,
    0.846135769627265,
    0.848494997211656,
    0.850830049669019,
    0.853140943624104,
    0.85542770033609,
    0.85769034564406,
    0.85992890991123,
    0.862143427967965,
    0.864333939053617,
    0.866500486757253,
    0.86864311895727,
    0.870761887759982,
    0.872856849437202,
    0.87492806436285,
    0.876975596948657,
    0.878999515578982,
    0.880999892544799,
    0.882976803976891,
    0.884930329778292,
    0.886860553556023,
    0.888767562552165,
    0.890651447574308,
    0.892512302925413,
    0.894350226333145,
    0.8961653188787,
    0.897957684925181,
    0.899727432045558,
    0.901474670950252,
    0.90319951541439,
    0.904902082204761,
    0.906582491006528,
    0.908240864349719,
    0.909877327535548,
    0.911492008562598,
    0.913085038052915,
    0.914656549178033,
    0.916206677584986,
    0.917735561322331,
    0.919243340766229,
    0.920730158546608,
    0.922196159473454,
    0.92364149046326,
    0.925066300465673,
    0.926470740390352,
    0.927854963034106,
    0.929219123008315,
    0.930563376666668,
    0.931887882033275,
    0.933192798731142,
    0.934478287911083,
    0.935744512181064,
    0.936991635536021,
    0.938219823288188,
    0.93942924199794,
    0.940620059405207,
    0.941792444361447,
    0.942946566762246,
    0.94408259748053,
    0.945200708300442,
    0.94630107185188,
    0.947383861545748,
    0.94844925150991,
    0.949497416525896,
    0.950528531966352,
    0.951542773733277,
    0.952540318197053,
    0.95352134213628,
    0.95448602267845,
    0.955434537241457,
    0.956367063475968,
    0.95728377920867,
    0.958184862386405,
    0.959070491021193,
    0.959940843136183,
    0.960796096712517,
    0.961636429637129,
    0.962462019651483,
    0.963273044301274,
    0.964069680887074,
    0.96485210641596,
    0.96562049755411,
    0.966375030580372,
    0.967115881340836,
    0.967843225204386,
    0.968557237019247,
    0.969258091070534,
    0.9699459610388,
    0.97062101995959,
    0.971283440183998,
    0.971933393340228,
    0.972571050296163,
    0.973196581122945,
    0.973810155059547,
    0.974411940478361,
    0.97500210485178,
    0.975580814719778,
    0.976148235658492,
    0.976704532249788,
    0.977249868051821,
    0.977784405570569,
    0.978308306232353,
    0.978821730357328,
    0.97932483713393,
    0.979817784594296,
    0.980300729590623,
    0.980773827772483,
    0.981237233565062,
    0.98169110014834,
    0.982135579437183,
    0.982570822062343,
    0.982996977352367,
    0.983414193316395,
    0.983822616627834,
    0.98422239260891,
    0.984613665216075,
    0.984996577026268,
    0.98537126922401,
    0.985737881589331,
    0.986096552486501,
    0.98644741885358,
    0.986790616192744,
    0.987126278561398,
    0.987454538564053,
    0.987775527344955,
    0.988089374581453,
    0.988396208478096,
    0.988696155761447,
    0.988989341675589,
    0.989275889978324,
    0.98955592293805,
    0.98982956133128,
    0.990096924440836,
    0.990358130054642,
    0.990613294465161,
    0.990862532469427,
    0.991105957369663,
    0.991343680974483,
    0.991575813600654,
    0.991802464075404,
    0.992023739739266,
    0.992239746449446,
    0.99245058858369,
    0.992656369044652,
    0.992857189264729,
    0.993053149211376,
    0.99324434739286,
    0.993430880864453,
    0.993612845235057,
    0.993790334674224,
    0.993963441919587,
    0.994132258284667,
    0.99429687366705,
    0.994457376556917,
    0.994613854045933,
    0.994766391836444,
    0.99491507425101,
    0.99505998424223,
    0.995201203402874,
    0.995338811976281,
    0.995472888867033,
    0.995603511651879,
    0.99573075659091,
    0.995854698638964,
    0.995975411457242,
    0.996092967425147,
    0.996207437652315,
    0.996318891990825,
    0.9964273990476,
    0.99653302619696,
    0.996635839593331,
    0.996735904184109,
    0.996833283722642,
    0.99692804078135,
    0.997020236764945,
    0.997109931923774,
    0.997197185367235,
    0.997282055077299,
    0.997364597922095,
    0.997444869669572,
    0.997522925001214,
    0.99759881752581,
    0.997672599793268,
    0.997744323308458,
    0.997814038545087,
    0.997881794959595,
    0.99794764100506,
    0.998011624145106,
    0.998073790867812,
    0.998134186699616,
    0.998192856219194,
    0.998249843071324,
    0.998305189980723,
    0.998358938765843,
    0.998411130352635,
    0.998461804788262,
    0.998511001254763,
    0.99855875808266,
    0.998605112764508,
    0.99865010196837,
    0.99869376155123,
    0.998736126572328,
    0.998777231306408,
    0.998817109256896,
    0.998855793168977,
    0.99889331504259,
    0.998929706145321,
    0.998964997025197,
    0.998999217523386,
    0.999032396786782,
    0.999064563280486,
    0.999095744800178,
    0.999125968484368,
    0.999155260826541,
    0.999183647687171,
    0.999211154305624,
    0.999237805311933,
    0.999263624738446,
    0.999288636031355,
    0.999312862062084,
    0.99933632513856,
    0.99935904701634,
    0.999381048909613,
    0.999402351502066,
    0.99942297495761,
    0.999442938930975,
    0.99946226257817,
    0.999480964566793,
    0.999499063086214,
    0.999516575857616,
    0.999533520143892,
    0.999549912759408,
    0.999565770079618,
    0.99958110805055,
    0.999595942198136,
    0.999610287637418,
    0.9996241590816,
    0.999637570850967,
    0.999650536881662,
    0.999663070734323,
    0.99967518560258,
    0.999686894321419,
    0.999698209375391,
    0.99970914290671,
    0.999719706723184,
    0.999729912306036,
    0.999739770817572,
    0.99974929310872,
    0.999758489726432,
    0.999767370920964,
    0.999775946653009,
    0.999784226600705,
    0.99979222016652,
    0.999799936483993,
    0.999807384424364,
    0.999814572603067,
    0.999821509386095,
    0.999828202896254,
    0.99983466101928,
    0.999840891409842,
    0.999846901497426,
    0.999852698492093,
    0.999858289390124,
    0.999863680979554,
    0.99986887984558,
    0.999873892375862,
    0.999878724765715,
    0.999883383023185,
    0.999887872974018,
    0.999892200266523,
    0.999896370376326,
    0.999900388611024,
    0.99990426011473,
    0.999907989872526,
    0.9999115827148,
    0.999915043321502,
    0.999918376226297,
    0.999921585820616,
    0.999924676357621,
    0.999927651956075,
    0.99993051660412,
    0.99993327416297,
    0.999935928370511,
    0.999938482844817,
    0.999940941087581,
    0.999943306487466,
    0.999945582323366,
    0.999947771767598,
    0.999949877889004,
    0.999951903655982,
    0.999953851939444,
    0.999955725515688,
    0.999957527069211,
    0.99995925919544,
    0.999960924403402,
    0.99996252511831,
    0.999964063684097,
    0.999965542365885,
    0.99996696335237,
    0.999968328758167,
    0.999969640626073,
    0.999970900929288,
    0.99997211157356,
    0.99997327439928,
    0.999974391183526,
    0.999975463642034,
    0.999976493431131,
    0.999977482149611,
    0.999978431340552,
    0.999979342493088,
    0.999980217044132,
    0.99998105638005,
    0.999981861838282,
    0.999982634708926,
    0.99998337623627,
    0.99998408762028,
    0.999984770018052,
    0.99998542454521,
    0.999986052277273,
    0.999986654250984,
    0.999987231465586,
    0.999987784884075,
    0.999988315434405,
    0.999988824010668,
    0.999989311474225,
    0.999989778654816,
    0.999990226351627,
    0.99999065533433,
    0.999991066344087,
    0.999991460094529,
    0.999991837272697,
    0.999992198539962,
    0.999992544532909,
    0.999992875864198,
    0.9999931931234,
    0.9999934968778,
    0.999993787673173,
    0.999994066034554,
    0.999994332466958,
    0.999994587456092,
    0.999994831469043,
    0.999995064954938,
    0.999995288345588,
    0.999995502056111,
    0.99999570648553,
    0.999995902017353,
    0.99999608902014,
    0.99999626784804,
    0.99999643884132,
    0.999996602326875,
    0.999996758618713,
    0.999996908018431,
    0.999997050815677,
    0.999997187288588,
    0.99999731770422,
    0.99999744231896,
    0.999997561378926,
    0.99999767512035,
    0.999997783769952,
    0.999997887545298,
    0.999997986655145,
    0.99999808129978,
    0.999998171671336,
    0.99999825795411,
    0.999998340324856,
    0.99999841895308,
    0.999998494001322,
    0.999998565625416,
    0.999998633974755,
    0.999998699192546,
    0.999998761416043,
    0.999998820776783,
    0.999998877400815,
    0.999998931408906,
    0.999998982916757,
    0.999999032035204,
    0.999999078870404,
    0.999999123524027,
    0.999999166093434,
    0.999999206671848,
    0.99999924534852,
    0.999999282208893,
    0.999999317334747,
    0.999999350804357,
    0.999999382692628,
    0.999999413071236,
    0.999999442008757,
    0.999999469570797,
    0.999999495820112,
    0.999999520816723,
    0.999999544618035,
    0.999999567278938,
    0.999999588851916,
    0.999999609387146,
    0.999999628932592,
    0.999999647534102,
    0.999999665235492,
    0.999999682078634,
    0.999999698103538,
    0.999999713348428,
    0.999999727849823,
    0.999999741642602,
    0.999999754760082,
    0.999999767234077,
    0.999999779094968,
    0.999999790371761,
    0.99999980109215,
    0.999999811282566,
    0.999999820968243,
    0.99999983017326,
    0.999999838920594,
    0.999999847232172,
    0.99999985512891,
    0.999999862630766,
    0.99999986975677,
    0.999999876525079,
    0.999999882953003,
    0.99999988905705,
    0.99999989485296,
    0.999999900355737,
    0.999999905579684,
    0.999999910538435,
    0.99999991524498,
    0.999999919711701,
    0.999999923950395,
    0.9999999279723,
    0.99999993178812,
    0.999999935408057,
    0.99999993884182,
    0.99999994209866,
    0.999999945187383,
    0.999999948116374,
    0.999999950893617,
    0.99999995352671,
    0.999999956022884,
    0.999999958389024,
    0.99999996063168,
    0.99999996275708,
    0.999999964771158,
    0.999999966679551,
    0.999999968487626,
    0.999999970200482,
    0.999999971822974,
    0.999999973359714,
    0.99999997481509,
    0.99999997619327,
    0.999999977498221,
    0.999999978733708,
    0.999999979903313,
    0.999999981010438,
    0.999999982058315,
    0.999999983050017,
    0.99999998398846,
    0.999999984876418,
    0.99999998571652,
    0.999999986511268,
    0.999999987263033,
    0.99999998797407,
    0.99999998864652,
    0.99999998928241,
    0.99999998988367,
    0.999999990452127,
    0.999999990989519,
    0.999999991497492,
    0.999999991977608,
    0.99999999243135,
    0.999999992860124,
    0.999999993265263,
    0.999999993648031,
    0.999999994009629,
    0.99999999435119,
    0.999999994673797,
    0.999999994978468,
    0.999999995266172,
    0.999999995537828,
    0.999999995794303,
    0.999999996036423,
    0.999999996264969,
    0.999999996480679,
    0.999999996684254,
    0.999999996876358,
    0.999999997057619,
    0.999999997228631,
    0.99999999738996,
    0.999999997542135,
    0.999999997685664,
    0.999999997821024,
    0.999999997948668,
    0.999999998069022,
    0.999999998182492,
    0.999999998289461,
    0.999999998390292,
    0.999999998485327,
    0.99999999857489,
    0.999999998659288,
    0.99999999873881,
    0.999999998813732,
    0.999999998884312,
    0.999999998950795,
    0.999999999013412,
    0.999999999072383,
    0.999999999127915,
    0.999999999180202,
    0.999999999229429,
    0.99999999927577,
    0.999999999319392,
    0.99999999936045,
    0.999999999399087,
    0.999999999435447,
    0.999999999469658,
    0.999999999501844,
    0.999999999532123,
    0.999999999560605,
    0.999999999587393,
    0.999999999612585,
    0.999999999636275,
    0.99999999965855,
    0.999999999679492,
    0.99999999969918,
    0.999999999717684,
    0.999999999735077,
    0.999999999751423,
    0.999999999766782,
    0.999999999781215,
    0.999999999794774,
    0.999999999807511,
    0.999999999819476,
    0.999999999830714,
    0.999999999841267,
    0.999999999851177,
    0.999999999860482,
    0.999999999869218,
    0.99999999987742,
    0.999999999885117,
    0.999999999892343,
    0.999999999899123,
    0.999999999905486,
    0.999999999911456,
    0.999999999917057,
    0.999999999922311,
    0.99999999992724,
    0.999999999931863,
    0.999999999936198,
    0.999999999940263,
    0.999999999944075,
    0.999999999947649,
    0.999999999950999,
    0.999999999954139,
    0.999999999957082,
    0.99999999995984,
    0.999999999962425,
    0.999999999964846,
    0.999999999967115,
    0.99999999996924,
    0.999999999971231,
    0.999999999973096,
    0.999999999974842,
    0.999999999976478,
    0.999999999978009,
    0.999999999979442,
    0.999999999980784,
    0.99999999998204,
    0.999999999983216,
    0.999999999984316,
    0.999999999985345,
    0.999999999986309,
    0.99999999998721,
    0.999999999988053,
    0.999999999988841,
    0.999999999989579,
    0.999999999990269,
    0.999999999990914,
    0.999999999991517,
    0.99999999999208,
    0.999999999992608,
    0.9999999999931,
    0.99999999999356,
    0.999999999993991,
    0.999999999994393,
    0.99999999999477,
    0.99999999999512,
    0.999999999995448,
    0.999999999995754,
    0.99999999999604,
    0.999999999996308,
    0.999999999996557,
    0.99999999999679,
    0.999999999997007,
    0.99999999999721,
    0.9999999999974,
    0.999999999997577,
    0.999999999997742,
    0.999999999997896,
    0.99999999999804,
    0.999999999998174,
    0.999999999998299,
    0.999999999998415,
    0.999999999998524,
    0.999999999998626,
    0.99999999999872,
    0.999999999998808,
    0.99999999999889,
    0.999999999998967,
    0.999999999999039,
    0.999999999999105,
    0.999999999999167,
    0.999999999999225,
    0.99999999999928,
    0.99999999999933,
    0.999999999999376,
    0.99999999999942,
    0.99999999999946,
    0.999999999999498,
    0.999999999999533,
    0.999999999999566,
    0.999999999999597,
    0.999999999999625,
    0.999999999999651,
    0.999999999999676,
    0.999999999999699,
    0.99999999999972,
    0.99999999999974,
    0.999999999999759,
    0.999999999999776,
    0.999999999999792,
    0.999999999999806,
    0.99999999999982,
    0.999999999999833,
    0.999999999999845,
    0.999999999999856,
    0.999999999999866,
    0.999999999999876,
    0.999999999999885,
    0.999999999999893,
    0.9999999999999,
    0.999999999999908,
    0.999999999999915,
    0.99999999999992,
    0.999999999999927,
    0.999999999999932,
    0.999999999999937,
    0.999999999999941,
    0.999999999999946,
    0.99999999999995,
    0.999999999999953,
    0.999999999999957,
    0.99999999999996,
    0.999999999999963,
    0.999999999999966,
    0.999999999999968,
    0.99999999999997,
    0.999999999999973,
    0.999999999999975,
    0.999999999999976,
    0.999999999999978,
    0.99999999999998,
    0.999999999999981,
    0.999999999999983,
    0.999999999999984,
    0.999999999999985,
    0.999999999999986,
    0.999999999999987,
    0.999999999999988,
    0.99999999999999,
    0.99999999999999,
    0.99999999999999,
    0.999999999999991,
    0.999999999999992,
    0.999999999999993,
    0.999999999999993,
    0.999999999999994,
    0.999999999999994,
    0.999999999999995,
    0.999999999999995,
    0.999999999999995,
    0.999999999999996,
    0.999999999999996,
    0.999999999999996,
    0.999999999999997,
    0.999999999999997,
    0.999999999999997,
    0.999999999999997,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
};

// Normal cumulative distribution function
float NormalCDF(float mu, float sigmaSq, float x);

// Poisson cumulative distribution function
float PoissonCDF(float lambda, int a, int b);

// Poisson cumulative distribution function
float PoissonCDF(float lambda, int a);

#endif
