//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
//
// Copyright (C) 2002 - 2016, The pgAdmin Development Team
// This software is released under the PostgreSQL Licence
//
// ddRelationshipItem.cpp - Items (fk columns) inside a relationship figure hashmap
//
//////////////////////////////////////////////////////////////////////////

#include "pgAdmin3.h"

// wxWindows headers
#include <wx/wx.h>
#include <wx/dcbuffer.h>

// App headers
#include "dd/dditems/figures/ddRelationshipItem.h"
#include "dd/dditems/figures/ddRelationshipFigure.h"
#include "hotdraw/main/hdDrawingView.h"
#include "dd/dditems/utilities/ddDataType.h"

ddRelationshipItem::ddRelationshipItem()
{
	ownerRel = NULL;
	original = NULL;
	destinationTable = NULL;
}

ddRelationshipItem::ddRelationshipItem(ddRelationshipFigure *owner, ddColumnFigure *originalColumn, ddTableFigure *destination, ddColumnOptionType type, ddColumnType colType, ddColumnFigure *existingColumn)
{
	ownerRel = owner;
	original = originalColumn;
	originalStartColName = original->getColumnName(false);
	destinationTable = destination;

	if(existingColumn == NULL)   //Fk destination column will be automatically generated
	{
		generatedName = autoGenerateNameForFk();
		fkColumn = new ddColumnFigure( generatedName, destinationTable, this);
		fkColumn->setColumnOption(type);
		fkColumn->toggleColumnKind(colType);
		fkColumn->activateGenFkName(); //By default fk name is generate by using ( alias | tableName) . ColumnName combination
		fkIsAutoGenerated = true;
	}
	else //using existing column as fk destination (Validation Required at user choices compatibility of types, precision and scale)
	{
		generatedName = wxEmptyString;
		fkColumn = existingColumn;
		fkColumn->setAsUserCreatedFk(this);
		fkColumn->deactivateGenFkName();
		fkIsAutoGenerated = false;
	}

	fkColumn->setRightIconForColumn();
}

ddRelationshipItem::~ddRelationshipItem()
{
}

void ddRelationshipItem::initRelationshipItemValues(ddRelationshipFigure *owner, ddTableFigure *destination, bool fromExistingColumn, ddColumnFigure *fkCol, ddColumnFigure *sourceCol, wxString initialColName)
{
	ownerRel = owner;
	destinationTable = destination;
	fkIsAutoGenerated = fromExistingColumn;
	original = sourceCol;
	fkColumn = fkCol;
	originalStartColName = initialColName;
	if(fkIsAutoGenerated)
		fkColumn->setFkSource(this);
	else
		fkColumn->setAsUserCreatedFk(this);

	fkColumn->setRightIconForColumn();
}


bool ddRelationshipItem::isAutomaticallyGenerated()
{
	return fkIsAutoGenerated;
}

wxString ddRelationshipItem::autoGenerateNameForFk()
{
	wxString newName;
	newName = original->getOwnerTable()->getTableName();
	newName.append(wxT("_"));
	newName.append(originalStartColName);
	return newName;
}

void ddRelationshipItem::syncAutoFkName()
{
	originalStartColName = original->getColumnName(false);  //Because original name was probably changed, now I should update it.
	if(fkColumn->isGeneratedForeignKey() && fkColumn->isFkNameGenerated() )
	{
		fkColumn->setColumnName(autoGenerateNameForFk());
		//Update all connections, but need to be notified to all views only doing it right now for first view
		ownerRel->updateConnection(0);
	}
}

bool ddRelationshipItem::relationIsIdentifying()
{
	return ownerRel->getIdentifying();
}

bool ddRelationshipItem::relationIsMandatory()
{
	return ownerRel->getMandatory();
}

wxString ddRelationshipItem::sourceTableName()
{
	return original->getOwnerTable()->getTableName();
}

wxString ddRelationshipItem::destTableName()
{
	return destinationTable->getTableName();
}

bool ddRelationshipItem::isForeignKeyFromPk()
{
	if(ownerRel)
	{
		return ownerRel->isForeignKeyFromPk();
	}
	return false;
}
