/* Copyright (c) 2015 ARM Ltd.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
       * Redistributions of source code must retain the above copyright
	 notice, this list of conditions and the following disclaimer.
       * Redistributions in binary form must reproduce the above copyright
	 notice, this list of conditions and the following disclaimer in the
	 documentation and/or other materials provided with the distribution.
       * Neither the name of the Linaro nor the
	 names of its contributors may be used to endorse or promote products
	 derived from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  */

/* The structure of the following #if #else #endif conditional chain
   must match the chain in memcpy.S.  */

#include <picolibc.h>

#include "machine/acle-compat.h"

#if (defined (__OPTIMIZE_SIZE__) || defined (PREFER_SIZE_OVER_SPEED))
#define MEMCPY_FALLBACK
#elif (__ARM_ARCH >= 7 && __ARM_ARCH_PROFILE == 'A' \
       && defined (__ARM_FEATURE_UNALIGNED))
/* Defined in memcpy-armv7a.S.  */
#elif __ARM_ARCH_ISA_THUMB == 2 && !__ARM_ARCH_ISA_ARM
/* Defined in memcpy-armv7m.S.  */
#elif defined (__ARM_ARCH_7A__)
/* Defined in aeabi_memcpy-armv7a.S */
#else
#define MEMCPY_FALLBACK
#endif

#ifdef MEMCPY_FALLBACK
# include "../../string/memcpy.c"

void *__aeabi_memcpy4 (void *__restrict dest, const void * __restrict source, size_t n)
	_ATTRIBUTE ((alias ("memcpy"), weak));

void *__aeabi_memcpy8 (void * __restrict dest, const void * __restrict source, size_t n)
	_ATTRIBUTE ((alias ("memcpy"), weak));

void *__aeabi_memcpy (void * __restrict dest, const void * __restrict source, size_t n)
	_ATTRIBUTE ((alias ("memcpy"), weak));

#endif
