//
//  PRCurves.m
//  PRICE
//
//  Created by Riccardo Mottola on 07/08/11.
//  Copyright 2011 Riccardo Mottola. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRCurves.h"


@implementation PRCurves

/*
 * Paramters order:
 *   Luminance Array
 *   Red Array
 *   Green Array
 *   Blue Array
 */
- (PRImage *)filterImage:(PRImage *)image with:(NSArray *)parameters progressPanel:(PRCProgress *)progressPanel
{
  PRImage *retImage;
  NSArray *array;
  unsigned arrayL[UCHAR_MAX + 1];
  unsigned arrayR[UCHAR_MAX + 1];
  unsigned arrayG[UCHAR_MAX + 1];
  unsigned arrayB[UCHAR_MAX + 1];
  unsigned i;
  
  if ([parameters count] != 1 && [parameters count] != 3)
    {
      NSLog(@"inconsistent number of parametetrs: %u", [parameters count]);
      return nil;
    }


  if ([parameters count] == 1)
    {
      array = [parameters objectAtIndex:0];
      if ([array count] > 0)
	{
	  if ([array count] == UCHAR_MAX+1)
	    {
	      for (i = 0; i <= UCHAR_MAX; i++)
		arrayL[i] = [(NSNumber *)[array objectAtIndex: i] unsignedIntValue];
	    }
	  else
	    {
	      NSLog(@"Incompatible size of parameter array: %d", [array count]);
	    }
	}
      retImage = [self adjustImage: image :arrayL :NULL :NULL :NULL];
    }
  else
    {
      array = [parameters objectAtIndex:0];
      if ([array count] > 0)
	{
	  if ([array count] == UCHAR_MAX+1)
	    {
	      for (i = 0; i <= UCHAR_MAX; i++)
		arrayR[i] = [(NSNumber *)[array objectAtIndex: i] unsignedIntValue];
	    }
	  else
	    {
	      NSLog(@"Incompatible size of parameter array: %d", [array count]);
	    }
	}
      array = [parameters objectAtIndex:1];
      if ([array count] > 0)
	{
	  if ([array count] == UCHAR_MAX+1)
	    {
	      for (i = 0; i <= UCHAR_MAX; i++)
		arrayG[i] = [(NSNumber *)[array objectAtIndex: i] unsignedIntValue];
	    }
	  else
	    {
	      NSLog(@"Incompatible size of parameter array: %d", [array count]);
	    }
	}
      array = [parameters objectAtIndex:2];
      if ([array count] > 0)
	{
	  if ([array count] == UCHAR_MAX+1)
	    {
	      for (i = 0; i <= UCHAR_MAX; i++)
		arrayB[i] = [(NSNumber *)[array objectAtIndex: i] unsignedIntValue];
	    }
	  else
	    {
	      NSLog(@"Incompatible size of parameter array: %d", [array count]);
	    }
	}
      retImage = [self adjustImage: image :arrayL :arrayR :arrayG :arrayB];
    }
  return retImage;
}

- (NSString *)actionName
{
  return @"Curves";
}

- (PRImage *)adjustImage :(PRImage *)srcImage :(unsigned *)arrayL :(unsigned *)arrayR :(unsigned *)arrayG :(unsigned *)arrayB
{
  NSBitmapImageRep *srcImageRep;
  PRImage *destImage;
  NSBitmapImageRep *destImageRep;
  int w, h;
  int x, y;
  unsigned char *srcData;
  unsigned char *destData;
  int pixNum;
  BOOL isColor;
  int tempValue;
  int srcSamplesPerPixel;
  int destSamplesPerPixel;
  int srcBytesPerRow;
  int destBytesPerRow;
  
  
  /* get source image representation and associated information */
  srcImageRep = [srcImage bitmapRep];
  
  w = [srcImageRep pixelsWide];
  h = [srcImageRep pixelsHigh];
  srcBytesPerRow = [srcImageRep bytesPerRow];
  srcSamplesPerPixel = [srcImageRep samplesPerPixel];
  pixNum = h * w;
  
  /* check bith depth and color/greyscale image */
  if ([srcImageRep hasAlpha])
    {
      if ([srcImageRep samplesPerPixel] == 2)
	{
	  isColor = NO;
	}
      else
	{
	  isColor = YES;
	}
    }
  else
    {
      if ([srcImageRep samplesPerPixel] == 1)
	{
	  isColor = NO;
	}
      else
	{
	  isColor = YES;
	}
    }
  
  /* allocate destination image and its representation */
  destImage = [[PRImage alloc] initWithSize:NSMakeSize(w, h)];
  if (isColor)
    {
      destSamplesPerPixel = 3;
      destImageRep = [[NSBitmapImageRep alloc]
		       initWithBitmapDataPlanes:NULL
		       pixelsWide:w
		       pixelsHigh:h
		       bitsPerSample:8
		       samplesPerPixel:destSamplesPerPixel
		       hasAlpha:NO
		       isPlanar:NO
		       colorSpaceName:NSCalibratedRGBColorSpace
		       bytesPerRow:w*destSamplesPerPixel
		       bitsPerPixel:0];
    }
  else
    {
      destSamplesPerPixel = 1;
      destImageRep = [[NSBitmapImageRep alloc]
		       initWithBitmapDataPlanes:NULL
		       pixelsWide:w
		       pixelsHigh:h
		       bitsPerSample:8
		       samplesPerPixel:destSamplesPerPixel
		       hasAlpha:NO
		       isPlanar:NO
		       colorSpaceName:NSCalibratedWhiteColorSpace
		       bytesPerRow:w*destSamplesPerPixel
		       bitsPerPixel:0];
    }
  srcData = [srcImageRep bitmapData];
  destData = [destImageRep bitmapData];
  destBytesPerRow = [destImageRep bytesPerRow];
  
  if (isColor)
    {
      for (y = 0; y < h; y++)
	for (x = 0; x < w; x++)
	  {
	    tempValue = arrayR[srcData[srcBytesPerRow*y + srcSamplesPerPixel*x]];
	    destData[destSamplesPerPixel*(y*w + x)] = tempValue;
	
	    tempValue = arrayG[srcData[srcBytesPerRow*y + srcSamplesPerPixel*x + 1]];
	    destData[destSamplesPerPixel*(y*w + x) + 1] = tempValue;
	
	    tempValue = arrayB[srcData[srcBytesPerRow*y + srcSamplesPerPixel*x + 2]];
	    destData[destSamplesPerPixel*(y*w + x) + 2] = tempValue;
	  }
    }
  else
    {
      for (y = 0; y < h; y++)
	for (x = 0; x < w; x++)
	  {
	    destData[y*w + x] = arrayL[srcData[srcBytesPerRow*y + x]];
	  }
    }
      
  [destImage addRepresentation:destImageRep];
  [destImageRep release];
  [destImage autorelease];
  return destImage;  
}

- (BOOL)displayProgress
{
  return NO;
}

@end
