# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.network import NetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-network
# USAGE
    python vpn_site_put.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.vpn_sites.begin_create_or_update(
        resource_group_name="rg1",
        vpn_site_name="vpnSite1",
        vpn_site_parameters={
            "location": "West US",
            "properties": {
                "addressSpace": {"addressPrefixes": ["10.0.0.0/16"]},
                "isSecuritySite": False,
                "o365Policy": {"breakOutCategories": {"allow": True, "default": False, "optimize": True}},
                "virtualWan": {
                    "id": "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1"
                },
                "vpnSiteLinks": [
                    {
                        "name": "vpnSiteLink1",
                        "properties": {
                            "bgpProperties": {"asn": 1234, "bgpPeeringAddress": "192.168.0.0"},
                            "fqdn": "link1.vpnsite1.contoso.com",
                            "ipAddress": "50.50.50.56",
                            "linkProperties": {"linkProviderName": "vendor1", "linkSpeedInMbps": 0},
                        },
                    }
                ],
            },
            "tags": {"key1": "value1"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/network/resource-manager/Microsoft.Network/stable/2024-01-01/examples/VpnSitePut.json
if __name__ == "__main__":
    main()
