# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import (
    CommunicationMessageKind,
    CommunicationMessagesChannel,
    MessageTemplateBindingsKind,
    MessageTemplateValueKind,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class NotificationContent(_model_base.Model):
    """Details of the message to send.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioNotificationContent, DocumentNotificationContent, ImageNotificationContent,
    MediaNotificationContent, TemplateNotificationContent, TextNotificationContent,
    VideoNotificationContent

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: The type discriminator describing a notification type. Required. Known values are:
     "text", "image", "image_v0", "document", "video", "audio", and "template".
    :vartype kind: str or ~azure.communication.messages.models.CommunicationMessageKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    channel_registration_id: str = rest_field(name="channelRegistrationId")
    """The Channel Registration ID for the Business Identifier. Required."""
    to: List[str] = rest_field()
    """The native external platform user identifiers of the recipient. Required."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a notification type. Required. Known values are: \"text\",
     \"image\", \"image_v0\", \"document\", \"video\", \"audio\", and \"template\"."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class AudioNotificationContent(NotificationContent, discriminator="audio"):
    """A request to send an audio notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is audio. Required. Audio message type.
    :vartype kind: str or ~azure.communication.messages.models.AUDIO
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.AUDIO] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is audio. Required. Audio message type."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.AUDIO, **kwargs)


class DocumentNotificationContent(NotificationContent, discriminator="document"):
    """A request to send a document notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Document message type.
    :vartype kind: str or ~azure.communication.messages.models.DOCUMENT
    :ivar caption: Optional text content.
    :vartype caption: str
    :ivar file_name: Optional name for the file.
    :vartype file_name: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.DOCUMENT] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Document message type."""
    caption: Optional[str] = rest_field()
    """Optional text content."""
    file_name: Optional[str] = rest_field(name="fileName")
    """Optional name for the file."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.DOCUMENT, **kwargs)


class ImageNotificationContent(NotificationContent, discriminator="image"):
    """A request to send an image notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Image message type.
    :vartype kind: str or ~azure.communication.messages.models.IMAGE
    :ivar content: Optional text content.
    :vartype content: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.IMAGE] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Image message type."""
    content: Optional[str] = rest_field(name="caption")
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        content: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.IMAGE, **kwargs)


class MediaNotificationContent(NotificationContent, discriminator="image_v0"):
    """@deprecated A request to send an image notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Image message type. Legacy image type
     for ``MediaNotificationContent`` which is being deprecated
    :vartype kind: str or ~azure.communication.messages.models.IMAGE_V0
    :ivar content: Optional text content.
    :vartype content: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.IMAGE_V0] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Image message type. Legacy image type for
     ``MediaNotificationContent`` which is being deprecated"""
    content: Optional[str] = rest_field()
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        content: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.IMAGE_V0, **kwargs)


class MessageReceipt(_model_base.Model):
    """Receipt of the sending one message.


    :ivar message_id: The message id. Required.
    :vartype message_id: str
    :ivar to: The native external platform user identifier of the recipient. Required.
    :vartype to: str
    """

    message_id: str = rest_field(name="messageId")
    """The message id. Required."""
    to: str = rest_field()
    """The native external platform user identifier of the recipient. Required."""

    @overload
    def __init__(
        self,
        *,
        message_id: str,
        to: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MessageTemplate(_model_base.Model):
    """The template object used to create templates.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the template. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar template_values: The template values.
    :vartype template_values: list[~azure.communication.messages.models.MessageTemplateValue]
    :ivar bindings: The binding object to link values to the template specific locations.
    :vartype bindings: ~azure.communication.messages.models.MessageTemplateBindings
    """

    name: str = rest_field()
    """Name of the template. Required."""
    language: str = rest_field()
    """The template's language, in the ISO 639 format, consist of a two-letter language code followed
     by an optional two-letter country code, e.g., 'en' or 'en_US'. Required."""
    template_values: Optional[List["_models.MessageTemplateValue"]] = rest_field(name="values")
    """The template values."""
    bindings: Optional["_models.MessageTemplateBindings"] = rest_field()
    """The binding object to link values to the template specific locations."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        language: str,
        template_values: Optional[List["_models.MessageTemplateValue"]] = None,
        bindings: Optional["_models.MessageTemplateBindings"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MessageTemplateBindings(_model_base.Model):
    """The binding object to link values to the template specific locations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WhatsAppMessageTemplateBindings

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a template bindings type. Required. "whatsApp"
    :vartype kind: str or ~azure.communication.messages.models.MessageTemplateBindingsKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template bindings type. Required. \"whatsApp\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MessageTemplateValue(_model_base.Model):
    """The class describes a parameter of a template.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MessageTemplateDocument, MessageTemplateImage, MessageTemplateLocation,
    MessageTemplateQuickAction, MessageTemplateText, MessageTemplateVideo

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: The type discriminator describing a template parameter type. Required. Known values
     are: "text", "image", "document", "video", "location", and "quickAction".
    :vartype kind: str or ~azure.communication.messages.models.MessageTemplateValueKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    name: str = rest_field()
    """Template binding reference name. Required."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template parameter type. Required. Known values are:
     \"text\", \"image\", \"document\", \"video\", \"location\", and \"quickAction\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MessageTemplateDocument(MessageTemplateValue, discriminator="document"):
    """The message template's document value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is document. Required. The document template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.DOCUMENT
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.DOCUMENT] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is document. Required. The document template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.DOCUMENT, **kwargs)


class MessageTemplateImage(MessageTemplateValue, discriminator="image"):
    """The message template's image value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is image. Required. The image template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.IMAGE
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.IMAGE] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is image. Required. The image template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.IMAGE, **kwargs)


class MessageTemplateItem(_model_base.Model):
    """The message template as returned from the service.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WhatsAppMessageTemplateItem

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The template's name. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar status: The aggregated template status. Required. Known values are: "approved",
     "rejected", "pending", and "paused".
    :vartype status: str or ~azure.communication.messages.models.MessageTemplateStatus
    :ivar kind: The type discriminator describing a template type. Required. "whatsApp"
    :vartype kind: str or ~azure.communication.messages.models.CommunicationMessagesChannel
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    name: str = rest_field(visibility=["read"])
    """The template's name. Required."""
    language: str = rest_field()
    """The template's language, in the ISO 639 format, consist of a two-letter language code followed
     by an optional two-letter country code, e.g., 'en' or 'en_US'. Required."""
    status: Union[str, "_models.MessageTemplateStatus"] = rest_field()
    """The aggregated template status. Required. Known values are: \"approved\", \"rejected\",
     \"pending\", and \"paused\"."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a template type. Required. \"whatsApp\""""

    @overload
    def __init__(
        self,
        *,
        language: str,
        status: Union[str, "_models.MessageTemplateStatus"],
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class MessageTemplateLocation(MessageTemplateValue, discriminator="location"):
    """The message template's location value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is location. Required. The location template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.LOCATION
    :ivar location_name: The [Optional] name of the location.
    :vartype location_name: str
    :ivar address: The [Optional] address of the location.
    :vartype address: str
    :ivar latitude: The latitude of the location. Required.
    :vartype latitude: float
    :ivar longitude: The longitude of the location. Required.
    :vartype longitude: float
    """

    kind: Literal[MessageTemplateValueKind.LOCATION] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is location. Required. The location template parameter type."""
    location_name: Optional[str] = rest_field(name="locationName")
    """The [Optional] name of the location."""
    address: Optional[str] = rest_field()
    """The [Optional] address of the location."""
    latitude: float = rest_field()
    """The latitude of the location. Required."""
    longitude: float = rest_field()
    """The longitude of the location. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        latitude: float,
        longitude: float,
        location_name: Optional[str] = None,
        address: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.LOCATION, **kwargs)


class MessageTemplateQuickAction(MessageTemplateValue, discriminator="quickAction"):
    """The message template's quick action value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is quick action. Required. The quick action template
     parameter type.
    :vartype kind: str or ~azure.communication.messages.models.QUICK_ACTION
    :ivar text: The [Optional] quick action text.
    :vartype text: str
    :ivar payload: The [Optional] quick action payload.
    :vartype payload: str
    """

    kind: Literal[MessageTemplateValueKind.QUICK_ACTION] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is quick action. Required. The quick action template parameter type."""
    text: Optional[str] = rest_field()
    """The [Optional] quick action text."""
    payload: Optional[str] = rest_field()
    """The [Optional] quick action payload."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text: Optional[str] = None,
        payload: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.QUICK_ACTION, **kwargs)


class MessageTemplateText(MessageTemplateValue, discriminator="text"):
    """The message template's text value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is text. Required. The text template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.TEXT
    :ivar text: The text value. Required.
    :vartype text: str
    """

    kind: Literal[MessageTemplateValueKind.TEXT] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is text. Required. The text template parameter type."""
    text: str = rest_field()
    """The text value. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.TEXT, **kwargs)


class MessageTemplateVideo(MessageTemplateValue, discriminator="video"):
    """The message template's video value information.

    All required parameters must be populated in order to send to server.

    :ivar name: Template binding reference name. Required.
    :vartype name: str
    :ivar kind: Message parameter type is video. Required. The video template parameter type.
    :vartype kind: str or ~azure.communication.messages.models.VIDEO
    :ivar url: The (public) URL of the media. Required.
    :vartype url: str
    :ivar caption: The [optional] caption of the media object.
    :vartype caption: str
    :ivar file_name: The [optional] filename of the media file.
    :vartype file_name: str
    """

    kind: Literal[MessageTemplateValueKind.VIDEO] = rest_discriminator(name="kind")  # type: ignore
    """Message parameter type is video. Required. The video template parameter type."""
    url: str = rest_field()
    """The (public) URL of the media. Required."""
    caption: Optional[str] = rest_field()
    """The [optional] caption of the media object."""
    file_name: Optional[str] = rest_field(name="fileName")
    """The [optional] filename of the media file."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        url: str,
        caption: Optional[str] = None,
        file_name: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateValueKind.VIDEO, **kwargs)


class SendMessageResult(_model_base.Model):
    """Result of the send message operation.


    :ivar receipts: Receipts of the send message operation. Required.
    :vartype receipts: list[~azure.communication.messages.models.MessageReceipt]
    """

    receipts: List["_models.MessageReceipt"] = rest_field()
    """Receipts of the send message operation. Required."""

    @overload
    def __init__(
        self,
        *,
        receipts: List["_models.MessageReceipt"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class TemplateNotificationContent(NotificationContent, discriminator="template"):
    """A request to send a template notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is template. Required. Template message type.
    :vartype kind: str or ~azure.communication.messages.models.TEMPLATE
    :ivar template: The template object used to create templates. Required.
    :vartype template: ~azure.communication.messages.models.MessageTemplate
    """

    kind: Literal[CommunicationMessageKind.TEMPLATE] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is template. Required. Template message type."""
    template: "_models.MessageTemplate" = rest_field()
    """The template object used to create templates. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        template: "_models.MessageTemplate",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.TEMPLATE, **kwargs)


class TextNotificationContent(NotificationContent, discriminator="text"):
    """A request to send a text notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is text. Required. Text message type.
    :vartype kind: str or ~azure.communication.messages.models.TEXT
    :ivar content: Message content. Required.
    :vartype content: str
    """

    kind: Literal[CommunicationMessageKind.TEXT] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is text. Required. Text message type."""
    content: str = rest_field()
    """Message content. Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        content: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.TEXT, **kwargs)


class VideoNotificationContent(NotificationContent, discriminator="video"):
    """A request to send a video notification.

    All required parameters must be populated in order to send to server.

    :ivar channel_registration_id: The Channel Registration ID for the Business Identifier.
     Required.
    :vartype channel_registration_id: str
    :ivar to: The native external platform user identifiers of the recipient. Required.
    :vartype to: list[str]
    :ivar kind: Message notification type is image. Required. Video message type.
    :vartype kind: str or ~azure.communication.messages.models.VIDEO
    :ivar caption: Optional text content.
    :vartype caption: str
    :ivar media_uri: A media url for the file. Required if the type is one of the supported media
     types, e.g. image. Required.
    :vartype media_uri: str
    """

    kind: Literal[CommunicationMessageKind.VIDEO] = rest_discriminator(name="kind")  # type: ignore
    """Message notification type is image. Required. Video message type."""
    caption: Optional[str] = rest_field()
    """Optional text content."""
    media_uri: str = rest_field(name="mediaUri")
    """A media url for the file. Required if the type is one of the supported media types, e.g. image.
     Required."""

    @overload
    def __init__(
        self,
        *,
        channel_registration_id: str,
        to: List[str],
        media_uri: str,
        caption: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessageKind.VIDEO, **kwargs)


class WhatsAppMessageTemplateBindings(MessageTemplateBindings, discriminator="whatsApp"):
    """The template bindings for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar kind: MessageTemplateBindings is whatsApp. Required. The WhatsApp template type.
    :vartype kind: str or ~azure.communication.messages.models.WHATSAPP
    :ivar header: The header template bindings.
    :vartype header:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar body: The body template bindings.
    :vartype body:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar footer: The footer template bindings.
    :vartype footer:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsComponent]
    :ivar buttons: The button template bindings.
    :vartype buttons:
     list[~azure.communication.messages.models.WhatsAppMessageTemplateBindingsButton]
    """

    kind: Literal[MessageTemplateBindingsKind.WHATSAPP] = rest_discriminator(name="kind")  # type: ignore
    """MessageTemplateBindings is whatsApp. Required. The WhatsApp template type."""
    header: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The header template bindings."""
    body: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The body template bindings."""
    footer: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = rest_field()
    """The footer template bindings."""
    buttons: Optional[List["_models.WhatsAppMessageTemplateBindingsButton"]] = rest_field()
    """The button template bindings."""

    @overload
    def __init__(
        self,
        *,
        header: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        body: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        footer: Optional[List["_models.WhatsAppMessageTemplateBindingsComponent"]] = None,
        buttons: Optional[List["_models.WhatsAppMessageTemplateBindingsButton"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=MessageTemplateBindingsKind.WHATSAPP, **kwargs)


class WhatsAppMessageTemplateBindingsButton(_model_base.Model):
    """The template bindings component button for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar sub_type: The WhatsApp button sub type. Required. Known values are: "quickReply" and
     "url".
    :vartype sub_type: str or ~azure.communication.messages.models.WhatsAppMessageButtonSubType
    :ivar ref_value: The name of the referenced item in the template values. Required.
    :vartype ref_value: str
    """

    sub_type: Union[str, "_models.WhatsAppMessageButtonSubType"] = rest_field(name="subType")
    """The WhatsApp button sub type. Required. Known values are: \"quickReply\" and \"url\"."""
    ref_value: str = rest_field(name="refValue")
    """The name of the referenced item in the template values. Required."""

    @overload
    def __init__(
        self,
        *,
        sub_type: Union[str, "_models.WhatsAppMessageButtonSubType"],
        ref_value: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WhatsAppMessageTemplateBindingsComponent(_model_base.Model):
    """The template bindings component for WhatsApp.

    All required parameters must be populated in order to send to server.

    :ivar ref_value: The name of the referenced item in the template values. Required.
    :vartype ref_value: str
    """

    ref_value: str = rest_field(name="refValue")
    """The name of the referenced item in the template values. Required."""

    @overload
    def __init__(
        self,
        *,
        ref_value: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WhatsAppMessageTemplateItem(MessageTemplateItem, discriminator="whatsApp"):
    """The WhatsApp-specific template response contract.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar name: The template's name. Required.
    :vartype name: str
    :ivar language: The template's language, in the ISO 639 format, consist of a two-letter
     language code followed by an optional two-letter country code, e.g., 'en' or 'en_US'. Required.
    :vartype language: str
    :ivar status: The aggregated template status. Required. Known values are: "approved",
     "rejected", "pending", and "paused".
    :vartype status: str or ~azure.communication.messages.models.MessageTemplateStatus
    :ivar content: WhatsApp platform's template content. This is the payload returned from WhatsApp
     API.
    :vartype content: any
    :ivar kind: Message template response type is whatsApp. Required. The WhatsApp communication
     messages channel type.
    :vartype kind: str or ~azure.communication.messages.models.WHATS_APP
    """

    content: Optional[Any] = rest_field()
    """WhatsApp platform's template content. This is the payload returned from WhatsApp API."""
    kind: Literal[CommunicationMessagesChannel.WHATSAPP] = rest_discriminator(name="kind")  # type: ignore
    """Message template response type is whatsApp. Required. The WhatsApp communication messages
     channel type."""

    @overload
    def __init__(
        self,
        *,
        language: str,
        status: Union[str, "_models.MessageTemplateStatus"],
        content: Optional[Any] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=CommunicationMessagesChannel.WHATSAPP, **kwargs)
