# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_search_get_geocoding_request(
    *,
    top: int = 5,
    query: Optional[str] = None,
    address_line: Optional[str] = None,
    country_region: Optional[str] = None,
    bbox: Optional[List[float]] = None,
    view: Optional[str] = None,
    coordinates: Optional[List[float]] = None,
    admin_district: Optional[str] = None,
    admin_district2: Optional[str] = None,
    admin_district3: Optional[str] = None,
    locality: Optional[str] = None,
    postal_code: Optional[str] = None,
    accept_language: Optional[str] = None,
    client_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01"))
    accept = _headers.pop("Accept", "application/geo+json, application/json")

    # Construct URL
    _url = "/geocode"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int", maximum=20, minimum=1)
    if query is not None:
        _params["query"] = _SERIALIZER.query("query", query, "str")
    if address_line is not None:
        _params["addressLine"] = _SERIALIZER.query("address_line", address_line, "str")
    if country_region is not None:
        _params["countryRegion"] = _SERIALIZER.query("country_region", country_region, "str")
    if bbox is not None:
        _params["bbox"] = _SERIALIZER.query("bbox", bbox, "[float]", div=",")
    if view is not None:
        _params["view"] = _SERIALIZER.query("view", view, "str")
    if coordinates is not None:
        _params["coordinates"] = _SERIALIZER.query("coordinates", coordinates, "[float]", div=",")
    if admin_district is not None:
        _params["adminDistrict"] = _SERIALIZER.query("admin_district", admin_district, "str")
    if admin_district2 is not None:
        _params["adminDistrict2"] = _SERIALIZER.query("admin_district2", admin_district2, "str")
    if admin_district3 is not None:
        _params["adminDistrict3"] = _SERIALIZER.query("admin_district3", admin_district3, "str")
    if locality is not None:
        _params["locality"] = _SERIALIZER.query("locality", locality, "str")
    if postal_code is not None:
        _params["postalCode"] = _SERIALIZER.query("postal_code", postal_code, "str")

    # Construct headers
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_get_geocoding_batch_request(
    *, client_id: Optional[str] = None, accept_language: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/geocode:batch"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_get_polygon_request(
    *,
    coordinates: List[float],
    view: Optional[str] = None,
    result_type: str = "countryRegion",
    resolution: str = "medium",
    client_id: Optional[str] = None,
    accept_language: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01"))
    accept = _headers.pop("Accept", "application/geo+json, application/json")

    # Construct URL
    _url = "/search/polygon"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["coordinates"] = _SERIALIZER.query("coordinates", coordinates, "[float]", div=",")
    if view is not None:
        _params["view"] = _SERIALIZER.query("view", view, "str")
    if result_type is not None:
        _params["resultType"] = _SERIALIZER.query("result_type", result_type, "str")
    if resolution is not None:
        _params["resolution"] = _SERIALIZER.query("resolution", resolution, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_get_reverse_geocoding_request(  # pylint: disable=name-too-long
    *,
    coordinates: List[float],
    result_types: Optional[List[str]] = None,
    view: Optional[str] = None,
    client_id: Optional[str] = None,
    accept_language: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01"))
    accept = _headers.pop("Accept", "application/geo+json, application/json")

    # Construct URL
    _url = "/reverseGeocode"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["coordinates"] = _SERIALIZER.query("coordinates", coordinates, "[float]", div=",")
    if result_types is not None:
        _params["resultTypes"] = _SERIALIZER.query("result_types", result_types, "[str]", div=",")
    if view is not None:
        _params["view"] = _SERIALIZER.query("view", view, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_search_get_reverse_geocoding_batch_request(  # pylint: disable=name-too-long
    *, client_id: Optional[str] = None, accept_language: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/reverseGeocode:batch"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class SearchOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.search.MapsSearchClient`'s
        :attr:`search` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_geocoding(
        self,
        *,
        top: int = 5,
        query: Optional[str] = None,
        address_line: Optional[str] = None,
        country_region: Optional[str] = None,
        bbox: Optional[List[float]] = None,
        view: Optional[str] = None,
        coordinates: Optional[List[float]] = None,
        admin_district: Optional[str] = None,
        admin_district2: Optional[str] = None,
        admin_district3: Optional[str] = None,
        locality: Optional[str] = None,
        postal_code: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Use to get longitude and latitude coordinates of a street address or name of a place.

        The ``Get Geocoding`` API is an HTTP ``GET`` request that returns the longitude and latitude
        coordinates of the location being searched.

        In many cases, the complete search service might be too much, for instance if you are only
        interested in traditional geocoding. Search can also be accessed for address look up
        exclusively. The geocoding is performed by hitting the geocoding endpoint with just the address
        or partial address in question. The geocoding search index will be queried for everything above
        the street level data. No Point of Interest (POIs) will be returned. Note that the geocoder is
        very tolerant of typos and incomplete addresses. It will also handle everything from exact
        street addresses or street or intersections as well as higher level geographies such as city
        centers, counties and states. The response also returns detailed address properties such as
        street, postal code, municipality, and country/region information.

        :keyword top: Maximum number of responses that will be returned. Default: 5, minimum: 1 and
         maximum: 20. Default value is 5.
        :paramtype top: int
        :keyword query: A string that contains information about a location, such as an address or
         landmark name. Default value is None.
        :paramtype query: str
        :keyword address_line: The official street line of an address relative to the area, as
         specified by the locality, or postalCode, properties. Typical use of this element would be to
         provide a street address or any official address.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype address_line: str
        :keyword country_region: Signal for the geocoding result to an `ISO 3166-1 Alpha-2
         region/country code <https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2>`_ that is specified e.g.
         FR./

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype country_region: str
        :keyword bbox: A rectangular area on the earth defined as a bounding box object. The sides of
         the rectangles are defined by longitude and latitude values. When you specify this parameter,
         the geographical area is taken into account when computing the results of a location query.

         Example: lon1,lat1,lon2,lat2. Default value is None.
        :paramtype bbox: list[float]
        :keyword view: A string that represents an `ISO 3166-1 Alpha-2 region/country code
         <https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2>`_. This will alter Geopolitical disputed
         borders and labels to align with the specified user region. By default, the View parameter is
         set to “Auto” even if you haven’t defined it in the request.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views. Default value is None.
        :paramtype view: str
        :keyword coordinates: A point on the earth specified as a longitude and latitude. When you
         specify this parameter, the user’s location is taken into account and the results returned may
         be more relevant to the user. Example: &coordinates=lon,lat. Default value is None.
        :paramtype coordinates: list[float]
        :keyword admin_district: The country subdivision portion of an address, such as WA.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype admin_district: str
        :keyword admin_district2: The county for the structured address, such as King.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype admin_district2: str
        :keyword admin_district3: The named area for the structured address.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype admin_district3: str
        :keyword locality: The locality portion of an address, such as Seattle.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype locality: str
        :keyword postal_code: The postal code portion of an address.

         **If query is given, should not use this parameter.**. Default value is None.
        :paramtype postal_code: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_search_get_geocoding_request(
            top=top,
            query=query,
            address_line=address_line,
            country_region=country_region,
            bbox=bbox,
            view=view,
            coordinates=coordinates,
            admin_district=admin_district,
            admin_district2=admin_district2,
            admin_district3=admin_district3,
            locality=locality,
            postal_code=postal_code,
            accept_language=self._config.accept_language,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def get_geocoding_batch(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in
        a single request.

        The ``Get Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to **100**
        queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *geocoding* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 2 *geocoding* queries:

        A *geocoding* batchItem object can accept any of the supported *geocoding* `URI parameters
        </rest/api/maps/search/get-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of address geocoding queries/requests to process.
         The list can contain a max of 100 queries and must contain at least 1 query. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_geocoding_batch(self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in
        a single request.

        The ``Get Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to **100**
        queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *geocoding* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 2 *geocoding* queries:

        A *geocoding* batchItem object can accept any of the supported *geocoding* `URI parameters
        </rest/api/maps/search/get-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of address geocoding queries/requests to process.
         The list can contain a max of 100 queries and must contain at least 1 query. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_geocoding_batch(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in
        a single request.

        The ``Get Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to **100**
        queries to the `Geocoding </rest/api/maps/search/get-geocoding>`_ API in a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *geocoding* queries you will use a ``POST`` request where the request body will
        contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will be set
        to ``application/json``. Here's a sample request body containing 2 *geocoding* queries:

        A *geocoding* batchItem object can accept any of the supported *geocoding* `URI parameters
        </rest/api/maps/search/get-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of address geocoding queries/requests to process.
         The list can contain a max of 100 queries and must contain at least 1 query. Is either a JSON
         type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_search_get_geocoding_batch_request(
            client_id=self._config.client_id,
            accept_language=self._config.accept_language,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_polygon(
        self,
        *,
        coordinates: List[float],
        view: Optional[str] = None,
        result_type: str = "countryRegion",
        resolution: str = "medium",
        **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Use to get polygon data of a geographical area shape such as a city or a country region.

        The ``Get Polygon`` API is an HTTP ``GET`` request that supplies polygon data of a geographical
        area outline such as a city or a country region.

        :keyword coordinates: A point on the earth specified as a longitude and latitude. Example:
         &coordinates=lon,lat. Required.
        :paramtype coordinates: list[float]
        :keyword view: A string that represents an `ISO 3166-1 Alpha-2 region/country code
         <https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2>`_. This will alter Geopolitical disputed
         borders and labels to align with the specified user region. By default, the View parameter is
         set to “Auto” even if you haven’t defined it in the request.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views. Default value is None.
        :paramtype view: str
        :keyword result_type: The geopolitical concept to return a boundary for. If not specified, the
         default is ``countryRegion`` result type. Known values are: "countryRegion", "adminDistrict",
         "adminDistrict2", "postalCode", "postalCode2", "postalCode3", "postalCode4", "neighborhood",
         and "locality". Default value is "countryRegion".
        :paramtype result_type: str
        :keyword resolution: Resolution determines the amount of points to send back. If not specified,
         the default is medium resolution. Known values are: "small", "medium", "large", and "huge".
         Default value is "medium".
        :paramtype resolution: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_search_get_polygon_request(
            coordinates=coordinates,
            view=view,
            result_type=result_type,
            resolution=resolution,
            client_id=self._config.client_id,
            accept_language=self._config.accept_language,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_reverse_geocoding(
        self,
        *,
        coordinates: List[float],
        result_types: Optional[List[str]] = None,
        view: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Use to get a street address and location info from longitude and latitude coordinates.

        The ``Get Reverse Geocoding`` API is an HTTP ``GET`` request used to translate a coordinate
        (example: 37.786505, -122.3862) into a human understandable street address. Useful in tracking
        applications where you receive a GPS feed from the device or asset and wish to know the address
        associated with the coordinates. This endpoint will return address information for a given
        coordinate.

        :keyword coordinates: The coordinates of the location that you want to reverse geocode.
         Example: &coordinates=lon,lat. Required.
        :paramtype coordinates: list[float]
        :keyword result_types: Specify entity types that you want in the response. Only the types you
         specify will be returned. If the point cannot be mapped to the entity types you specify, no
         location information is returned in the response.
         Default value is all possible entities.
         A comma separated list of entity types selected from the following options.


         * Address
         * Neighborhood
         * PopulatedPlace
         * Postcode1
         * AdminDivision1
         * AdminDivision2
         * CountryRegion

         These entity types are ordered from the most specific entity to the least specific entity.
         When entities of more than one entity type are found, only the most specific entity is
         returned. For example, if you specify Address and AdminDistrict1 as entity types and entities
         were found for both types, only the Address entity information is returned in the response.
         Default value is None.
        :paramtype result_types: list[str]
        :keyword view: A string that represents an `ISO 3166-1 Alpha-2 region/country code
         <https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2>`_. This will alter Geopolitical disputed
         borders and labels to align with the specified user region. By default, the View parameter is
         set to “Auto” even if you haven’t defined it in the request.

         Please refer to `Supported Views <https://aka.ms/AzureMapsLocalizationViews>`_ for details and
         to see the available Views. Default value is None.
        :paramtype view: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_search_get_reverse_geocoding_request(
            coordinates=coordinates,
            result_types=result_types,
            view=view,
            client_id=self._config.client_id,
            accept_language=self._config.accept_language,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    def get_reverse_geocoding_batch(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Reverse Geocoding
        </rest/api/maps/search/get-reverse-geocoding>`_ API in a single request.

        The ``Get Reverse Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to
        **100** queries to `Reverse Geocoding </rest/api/maps/search/get-reverse-geocoding>`_ API using
        a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *reverse geocoding* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 2 *reverse geocoding*
        queries:

        A *reverse geocoding* batchItem object can accept any of the supported *reverse geocoding* `URI
        parameters </rest/api/maps/search/get-reverse-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of reverse geocoding queries/requests to
         process. The list can contain a max of 100 queries and must contain at least 1 query. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_reverse_geocoding_batch(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Reverse Geocoding
        </rest/api/maps/search/get-reverse-geocoding>`_ API in a single request.

        The ``Get Reverse Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to
        **100** queries to `Reverse Geocoding </rest/api/maps/search/get-reverse-geocoding>`_ API using
        a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *reverse geocoding* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 2 *reverse geocoding*
        queries:

        A *reverse geocoding* batchItem object can accept any of the supported *reverse geocoding* `URI
        parameters </rest/api/maps/search/get-reverse-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of reverse geocoding queries/requests to
         process. The list can contain a max of 100 queries and must contain at least 1 query. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_reverse_geocoding_batch(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        # pylint: disable=line-too-long
        """Use to send a batch of queries to the `Reverse Geocoding
        </rest/api/maps/search/get-reverse-geocoding>`_ API in a single request.

        The ``Get Reverse Geocoding Batch`` API is an HTTP ``POST`` request that sends batches of up to
        **100** queries to `Reverse Geocoding </rest/api/maps/search/get-reverse-geocoding>`_ API using
        a single request.

        Submit Synchronous Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

        The Synchronous API is recommended for lightweight batch requests. When the service receives a
        request, it will respond as soon as the batch items are calculated and there will be no
        possibility to retrieve the results later. The Synchronous API will return a timeout error (a
        408 response) if the request takes longer than 60 seconds. The number of batch items is limited
        to **100** for this API.

        POST Body for Batch Request
        ^^^^^^^^^^^^^^^^^^^^^^^^^^^

        To send the *reverse geocoding* queries you will use a ``POST`` request where the request body
        will contain the ``batchItems`` array in ``json`` format and the ``Content-Type`` header will
        be set to ``application/json``. Here's a sample request body containing 2 *reverse geocoding*
        queries:

        A *reverse geocoding* batchItem object can accept any of the supported *reverse geocoding* `URI
        parameters </rest/api/maps/search/get-reverse-geocoding#uri-parameters>`__.

        The batch should contain at least **1** query.

        Batch Response Model
        ^^^^^^^^^^^^^^^^^^^^

        The batch response contains a ``summary`` component that indicates the ``totalRequests`` that
        were part of the original batch request and ``successfulRequests`` i.e. queries which were
        executed successfully. The batch response also includes a ``batchItems`` array which contains a
        response for each and every query in the batch request. The ``batchItems`` will contain the
        results in the exact same order the original queries were sent in the batch request. Each item
        is of one of the following types:

        * `GeocodingResponse <https://docs.microsoft.com/rest/api/maps/search/get-reverse-geocoding#geocodingresponse>`_ - If the query completed successfully.

        * ``Error`` - If the query failed. The response will contain a ``code`` and a ``message`` in this case.

        :param body: The list of reverse geocoding queries/requests to
         process. The list can contain a max of 100 queries and must contain at least 1 query. Is either
         a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_search_get_reverse_geocoding_batch_request(
            client_id=self._config.client_id,
            accept_language=self._config.accept_language,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore
