# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, Callable, Dict, List, Optional, Type, TypeVar, cast

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ...operations._operations import (
    build_timezone_convert_windows_timezone_to_iana_request,
    build_timezone_get_iana_timezone_ids_request,
    build_timezone_get_iana_version_request,
    build_timezone_get_timezone_by_coordinates_request,
    build_timezone_get_timezone_by_id_request,
    build_timezone_get_windows_timezone_ids_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class TimezoneOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.timezone.aio.TimezoneClient`'s
        :attr:`timezone` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_timezone_by_id(
        self,
        format: str = "json",
        *,
        timezone_id: str,
        accept_language: Optional[str] = None,
        options: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        dst_from: Optional[datetime.datetime] = None,
        dst_lasting_years: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get the current, historical, and future time zone information for the specified IANA
        time zone ID.

        The ``Get Timezone By ID`` API is an HTTP ``GET`` request that returns current, historical, and
        future time zone information for the specified IANA time zone ID.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword timezone_id: The IANA time zone ID. Required.
        :paramtype timezone_id: str
        :keyword accept_language: Specifies the language code in which the timezone names should be
         returned. If no language code is provided, the response will be in "EN". Please refer to
         `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for
         details. Default value is None.
        :paramtype accept_language: str
        :keyword options: Alternatively, use alias "o". Options available for types of information
         returned in the result. Known values are: "none", "zoneInfo", "transitions", and "all". Default
         value is None.
        :paramtype options: str
        :keyword time_stamp: Alternatively, use alias "stamp", or "s". Reference time, if omitted, the
         API will use the machine time serving the request. Default value is None.
        :paramtype time_stamp: ~datetime.datetime
        :keyword dst_from: Alternatively, use alias "tf". The start date from which
         daylight savings time (DST) transitions are requested, only applies when "options" = all or
         "options" = transitions. Default value is None.
        :paramtype dst_from: ~datetime.datetime
        :keyword dst_lasting_years: Alternatively, use alias "ty". The number of
         years from "transitionsFrom" for which DST transitions are requested, only applies when
         "options" = all or "options" = transitions. Default value is None.
        :paramtype dst_lasting_years: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ReferenceUtcTimestamp": "2020-02-20 00:00:00",
                    "TimeZones": [
                        {
                            "Aliases": [
                                "str"
                            ],
                            "Countries": [
                                {
                                    "Code": "str",
                                    "Name": "str"
                                }
                            ],
                            "Id": "str",
                            "Names": {
                                "Daylight": "str",
                                "Generic": "str",
                                "ISO6391LanguageCode": "str",
                                "Standard": "str"
                            },
                            "ReferenceTime": {
                                "DaylightSavings": "str",
                                "PosixTz": "str",
                                "PosixTzValidYear": 0,
                                "StandardOffset": "str",
                                "Sunrise": "2020-02-20 00:00:00",
                                "Sunset": "2020-02-20 00:00:00",
                                "Tag": "str",
                                "WallTime": "str"
                            },
                            "RepresentativePoint": {
                                "Latitude": 0.0,
                                "Longitude": 0.0
                            },
                            "TimeTransitions": [
                                {
                                    "DaylightSavings": "str",
                                    "StandardOffset": "str",
                                    "Tag": "str",
                                    "UtcEnd": "2020-02-20 00:00:00",
                                    "UtcStart": "2020-02-20 00:00:00"
                                }
                            ]
                        }
                    ],
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_timezone_by_id_request(
            format=format,
            timezone_id=timezone_id,
            accept_language=accept_language,
            options=options,
            time_stamp=time_stamp,
            dst_from=dst_from,
            dst_lasting_years=dst_lasting_years,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_timezone_by_coordinates(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        accept_language: Optional[str] = None,
        options: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        dst_from: Optional[datetime.datetime] = None,
        dst_lasting_years: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get the current, historical, and future time zone information for the specified
        latitude-longitude pair.

        The ``Get Timezone By Coordinates`` API is an HTTP ``GET`` request that returns current,
        historical, and future time zone information for a specified latitude-longitude pair. In
        addition, the API provides sunset and sunrise times for a given location.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: Coordinates of the point for which time zone information is requested.
         This parameter is a list of coordinates, containing a pair of coordinate(lat, long). When this
         endpoint is called directly, coordinates are passed in as a single string containing
         coordinates, separated by commas. Required.
        :paramtype coordinates: list[float]
        :keyword accept_language: Specifies the language code in which the timezone names should be
         returned. If no language code is provided, the response will be in "EN". Please refer to
         `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for
         details. Default value is None.
        :paramtype accept_language: str
        :keyword options: Alternatively, use alias "o". Options available for types of information
         returned in the result. Known values are: "none", "zoneInfo", "transitions", and "all". Default
         value is None.
        :paramtype options: str
        :keyword time_stamp: Alternatively, use alias "stamp", or "s". Reference time, if omitted, the
         API will use the machine time serving the request. Default value is None.
        :paramtype time_stamp: ~datetime.datetime
        :keyword dst_from: Alternatively, use alias "tf". The start date from which
         daylight savings time (DST) transitions are requested, only applies when "options" = all or
         "options" = transitions. Default value is None.
        :paramtype dst_from: ~datetime.datetime
        :keyword dst_lasting_years: Alternatively, use alias "ty". The number of
         years from "transitionsFrom" for which DST transitions are requested, only applies when
         "options" = all or "options" = transitions. Default value is None.
        :paramtype dst_lasting_years: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ReferenceUtcTimestamp": "2020-02-20 00:00:00",
                    "TimeZones": [
                        {
                            "Aliases": [
                                "str"
                            ],
                            "Countries": [
                                {
                                    "Code": "str",
                                    "Name": "str"
                                }
                            ],
                            "Id": "str",
                            "Names": {
                                "Daylight": "str",
                                "Generic": "str",
                                "ISO6391LanguageCode": "str",
                                "Standard": "str"
                            },
                            "ReferenceTime": {
                                "DaylightSavings": "str",
                                "PosixTz": "str",
                                "PosixTzValidYear": 0,
                                "StandardOffset": "str",
                                "Sunrise": "2020-02-20 00:00:00",
                                "Sunset": "2020-02-20 00:00:00",
                                "Tag": "str",
                                "WallTime": "str"
                            },
                            "RepresentativePoint": {
                                "Latitude": 0.0,
                                "Longitude": 0.0
                            },
                            "TimeTransitions": [
                                {
                                    "DaylightSavings": "str",
                                    "StandardOffset": "str",
                                    "Tag": "str",
                                    "UtcEnd": "2020-02-20 00:00:00",
                                    "UtcStart": "2020-02-20 00:00:00"
                                }
                            ]
                        }
                    ],
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_timezone_by_coordinates_request(
            format=format,
            coordinates=coordinates,
            accept_language=accept_language,
            options=options,
            time_stamp=time_stamp,
            dst_from=dst_from,
            dst_lasting_years=dst_lasting_years,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_windows_timezone_ids(self, format: str = "json", **kwargs: Any) -> List[JSON]:
        """Use to get the list of Windows Time Zone IDs.

        The ``Get Windows Time Zones`` API is an HTTP ``GET`` request that returns a full list of
        Windows Time Zone IDs.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "IanaIds": [
                            "str"
                        ],
                        "Territory": "str",
                        "WindowsId": "str"
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_get_windows_timezone_ids_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def get_iana_timezone_ids(self, format: str = "json", **kwargs: Any) -> List[JSON]:
        """Use to get the list of IANA time zone IDs.

        The ``Get IANA Time Zones`` API is an HTTP ``GET`` request that returns a full list of Internet
        Assigned Numbers Authority (IANA) time zone IDs. Updates to the IANA service are reflected in
        the system within one day.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "AliasOf": "str",
                        "HasZone1970Location": bool,
                        "Id": "str",
                        "IsAlias": bool
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_get_iana_timezone_ids_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace_async
    async def get_iana_version(self, format: str = "json", **kwargs: Any) -> JSON:
        """Use to get the current IANA version number.

        The ``Get Time Zone IANA Version`` API is an HTTP ``GET`` request that returns the current
        Internet Assigned Numbers Authority (IANA) version number as Metadata.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_iana_version_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def convert_windows_timezone_to_iana(
        self,
        format: str = "json",
        *,
        windows_timezone_id: str,
        windows_territory_code: Optional[str] = None,
        **kwargs: Any
    ) -> List[JSON]:
        """Use to get the IANA ID.

        The ``Get Windows to IANA Time Zone`` API is an HTTP ``GET`` request that returns a
        corresponding Internet Assigned Numbers Authority (IANA) ID, given a valid Windows Time Zone
        ID. Multiple IANA IDs may be returned for a single Windows ID. It is possible to narrow these
        results by adding an optional territory parameter.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword windows_timezone_id: The Windows time zone ID. Required.
        :paramtype windows_timezone_id: str
        :keyword windows_territory_code: Windows Time Zone territory code. Default value is None.
        :paramtype windows_territory_code: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "AliasOf": "str",
                        "HasZone1970Location": bool,
                        "Id": "str",
                        "IsAlias": bool
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = (  # pylint: disable=unsubscriptable-object
            {  # pylint: disable=unsubscriptable-object
                401: ClientAuthenticationError,
                404: ResourceNotFoundError,
                409: ResourceExistsError,
                304: ResourceNotModifiedError,
            }
        )
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_convert_windows_timezone_to_iana_request(
            format=format,
            windows_timezone_id=windows_timezone_id,
            windows_territory_code=windows_territory_code,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore
