# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementSubvolumesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_volume(self, resource_group):
        response = self.client.subvolumes.list_by_volume(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            api_version="2024-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.subvolumes.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            subvolume_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.subvolumes.begin_create(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            subvolume_name="str",
            body={
                "id": "str",
                "name": "str",
                "parentPath": "str",
                "path": "str",
                "provisioningState": "str",
                "size": 0,
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.subvolumes.begin_update(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            subvolume_name="str",
            body={"path": "str", "size": 0},
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.subvolumes.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            subvolume_name="str",
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_get_metadata(self, resource_group):
        response = self.client.subvolumes.begin_get_metadata(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            subvolume_name="str",
            api_version="2024-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
