# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnforcementState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enforcement status."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    NOT_AVAILABLE = "NotAvailable"


class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Environment name."""

    NON_PRODUCTION = "NonProduction"
    PRODUCTION = "Production"


class GroupingIdType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GroupingId type. It is a required property. More types of groupIds can be supported in future."""

    SERVICE_TREE_ID = "ServiceTreeId"
    BILLING_ID = "BillingId"


class LimitType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The limit object type."""

    LIMIT_VALUE = "LimitValue"


class QuotaLimitTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The quota or usages limit types."""

    INDEPENDENT = "Independent"
    SHARED = "Shared"


class QuotaRequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Quota request status."""

    ACCEPTED = "Accepted"
    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"


class RequestState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Request status."""

    ACCEPTED = "Accepted"
    CREATED = "Created"
    INVALID = "Invalid"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    IN_PROGRESS = "InProgress"
    CANCELED = "Canceled"


class UsagesTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The quota or usages limit types."""

    INDIVIDUAL = "Individual"
    COMBINED = "Combined"
