# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import ManagementLockClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagementLockManagementLocksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagementLockClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_at_resource_group_level(self, resource_group):
        response = self.client.management_locks.create_or_update_at_resource_group_level(
            resource_group_name=resource_group.name,
            lock_name="str",
            parameters={
                "level": "str",
                "id": "str",
                "name": "str",
                "notes": "str",
                "owners": [{"applicationId": "str"}],
                "type": "str",
            },
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_at_resource_group_level(self, resource_group):
        response = self.client.management_locks.delete_at_resource_group_level(
            resource_group_name=resource_group.name,
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_at_resource_group_level(self, resource_group):
        response = self.client.management_locks.get_at_resource_group_level(
            resource_group_name=resource_group.name,
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_by_scope(self, resource_group):
        response = self.client.management_locks.create_or_update_by_scope(
            scope="str",
            lock_name="str",
            parameters={
                "level": "str",
                "id": "str",
                "name": "str",
                "notes": "str",
                "owners": [{"applicationId": "str"}],
                "type": "str",
            },
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_by_scope(self, resource_group):
        response = self.client.management_locks.delete_by_scope(
            scope="str",
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_by_scope(self, resource_group):
        response = self.client.management_locks.get_by_scope(
            scope="str",
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_at_resource_level(self, resource_group):
        response = self.client.management_locks.create_or_update_at_resource_level(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            lock_name="str",
            parameters={
                "level": "str",
                "id": "str",
                "name": "str",
                "notes": "str",
                "owners": [{"applicationId": "str"}],
                "type": "str",
            },
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_at_resource_level(self, resource_group):
        response = self.client.management_locks.delete_at_resource_level(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_at_resource_level(self, resource_group):
        response = self.client.management_locks.get_at_resource_level(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update_at_subscription_level(self, resource_group):
        response = self.client.management_locks.create_or_update_at_subscription_level(
            lock_name="str",
            parameters={
                "level": "str",
                "id": "str",
                "name": "str",
                "notes": "str",
                "owners": [{"applicationId": "str"}],
                "type": "str",
            },
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete_at_subscription_level(self, resource_group):
        response = self.client.management_locks.delete_at_subscription_level(
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_at_subscription_level(self, resource_group):
        response = self.client.management_locks.get_at_subscription_level(
            lock_name="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_at_resource_group_level(self, resource_group):
        response = self.client.management_locks.list_at_resource_group_level(
            resource_group_name=resource_group.name,
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_at_resource_level(self, resource_group):
        response = self.client.management_locks.list_at_resource_level(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_at_subscription_level(self, resource_group):
        response = self.client.management_locks.list_at_subscription_level(
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_scope(self, resource_group):
        response = self.client.management_locks.list_by_scope(
            scope="str",
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
