# Supported elements

## Details

| Type               | Amount | Meaning                                        |
| ------------------ | ------ | ---------------------------------------------- |
| All                | 98     |                                                |
| ⛔ Not Possible     | 5      | Not possible to implement in a console context |
| ✅ Implemented      | 75     | Supported                                      |
| 📰 No Documentation | 12     | Not enough available information to implement  |
| ❌ Not Implemented  | 7      | Not implemented                                |

## Element List

| Index | Item                                                                                                     |     Supported?     |
| :---: | :------------------------------------------------------------------------------------------------------- | :----------------: |
|   1   | [abbreviation](https://docutils.sourceforge.io/docs/ref/doctree.html#abbreviation)                       | ⛔ Not Possible[^1] |
|   2   | [acronym](https://docutils.sourceforge.io/docs/ref/doctree.html#acronym)                                 |       ✅ Yes        |
|   3   | [address](https://docutils.sourceforge.io/docs/ref/doctree.html#address)                                 |       ✅ Yes        |
|   4   | [admonition](https://docutils.sourceforge.io/docs/ref/doctree.html#admonition)                           |       ✅ Yes        |
|   5   | [attention](https://docutils.sourceforge.io/docs/ref/doctree.html#attention)                             |       ✅ Yes        |
|   6   | [attribution](https://docutils.sourceforge.io/docs/ref/doctree.html#attribution)                         |       ✅ Yes        |
|   7   | [author](https://docutils.sourceforge.io/docs/ref/doctree.html#author)                                   |       ✅ Yes        |
|   8   | [authors](https://docutils.sourceforge.io/docs/ref/doctree.html#authors)                                 |       ✅ Yes        |
|   9   | [block-quote](https://docutils.sourceforge.io/docs/ref/doctree.html#block-quote)                         |       ✅ Yes        |
|  10   | [bullet-list](https://docutils.sourceforge.io/docs/ref/doctree.html#bullet-list)                         |     ✅ Yes[^2]      |
|  11   | [caption](https://docutils.sourceforge.io/docs/ref/doctree.html#caption)                                 |   ⛔ Not Possible   |
|  12   | [caution](https://docutils.sourceforge.io/docs/ref/doctree.html#caution)                                 |       ✅ Yes        |
|  13   | [citation](https://docutils.sourceforge.io/docs/ref/doctree.html#citation)                               |       ✅ Yes        |
|  14   | [citation-reference](https://docutils.sourceforge.io/docs/ref/doctree.html#citation-reference)           |       ✅ Yes        |
|  15   | [classifier](https://docutils.sourceforge.io/docs/ref/doctree.html#classifier)                           |       ✅ Yes        |
|  16   | [colspec](https://docutils.sourceforge.io/docs/ref/doctree.html#colspec)                                 | 📰 No Documentation |
|  17   | [comment](https://docutils.sourceforge.io/docs/ref/doctree.html#comment)                                 |       ✅ Yes        |
|  18   | [compound](https://docutils.sourceforge.io/docs/ref/doctree.html#compound)                               |        ❌ No        |
|  19   | [contact](https://docutils.sourceforge.io/docs/ref/doctree.html#contact)                                 |       ✅ Yes        |
|  20   | [container](https://docutils.sourceforge.io/docs/ref/doctree.html#container)                             | 📰 No Documentation |
|  21   | [copyright](https://docutils.sourceforge.io/docs/ref/doctree.html#copyright)                             |       ✅ Yes        |
|  22   | [danger](https://docutils.sourceforge.io/docs/ref/doctree.html#danger)                                   |       ✅ Yes        |
|  23   | [date](https://docutils.sourceforge.io/docs/ref/doctree.html#date)                                       |       ✅ Yes        |
|  24   | [decoration](https://docutils.sourceforge.io/docs/ref/doctree.html#decoration)                           |     ✅ Yes[^7]      |
|  25   | [definition](https://docutils.sourceforge.io/docs/ref/doctree.html#definition)                           |       ✅ Yes        |
|  26   | [definition-list](https://docutils.sourceforge.io/docs/ref/doctree.html#definition-list)                 |       ✅ Yes        |
|  27   | [definition-list-item](https://docutils.sourceforge.io/docs/ref/doctree.html#definition-list-item)       |       ✅ Yes        |
|  28   | [description](https://docutils.sourceforge.io/docs/ref/doctree.html#description)                         |       ✅ Yes        |
|  29   | [docinfo](https://docutils.sourceforge.io/docs/ref/doctree.html#docinfo)                                 |       ✅ Yes        |
|  30   | [doctest-block](https://docutils.sourceforge.io/docs/ref/doctree.html#doctest-block)                     |       ✅ Yes        |
|  31   | [document](https://docutils.sourceforge.io/docs/ref/doctree.html#document)                               |       ✅ Yes        |
|  32   | [emphasis](https://docutils.sourceforge.io/docs/ref/doctree.html#emphasis)                               |       ✅ Yes        |
|  33   | [entry](https://docutils.sourceforge.io/docs/ref/doctree.html#entry)                                     | 📰 No Documentation |
|  34   | [enumerated-list](https://docutils.sourceforge.io/docs/ref/doctree.html#enumerated-list)                 |     ✅ Yes[^3]      |
|  35   | [error](https://docutils.sourceforge.io/docs/ref/doctree.html#error)                                     |       ✅ Yes        |
|  36   | [field](https://docutils.sourceforge.io/docs/ref/doctree.html#field)                                     |       ✅ Yes        |
|  37   | [field-body](https://docutils.sourceforge.io/docs/ref/doctree.html#field-body)                           |       ✅ Yes        |
|  38   | [field-list](https://docutils.sourceforge.io/docs/ref/doctree.html#field-list)                           |       ✅ Yes        |
|  39   | [field-name](https://docutils.sourceforge.io/docs/ref/doctree.html#field-name)                           |       ✅ Yes        |
|  40   | [figure](https://docutils.sourceforge.io/docs/ref/doctree.html#figure)                                   |   ⛔ Not Possible   |
|  41   | [footer](https://docutils.sourceforge.io/docs/ref/doctree.html#footer)                                   |       ✅ Yes        |
|  42   | [footnote](https://docutils.sourceforge.io/docs/ref/doctree.html#footnote)                               |       ✅ Yes        |
|  43   | [footnote-reference](https://docutils.sourceforge.io/docs/ref/doctree.html#footnote-reference)           |       ✅ Yes        |
|  44   | [generated](https://docutils.sourceforge.io/docs/ref/doctree.html#generated)                             |       ✅ Yes        |
|  45   | [header](https://docutils.sourceforge.io/docs/ref/doctree.html#header)                                   |       ✅ Yes        |
|  46   | [hint](https://docutils.sourceforge.io/docs/ref/doctree.html#hint)                                       |       ✅ Yes        |
|  47   | [image](https://docutils.sourceforge.io/docs/ref/doctree.html#image)                                     |     ✅ Yes[^5]      |
|  48   | [important](https://docutils.sourceforge.io/docs/ref/doctree.html#important)                             |       ✅ Yes        |
|  49   | [inline](https://docutils.sourceforge.io/docs/ref/doctree.html#inline)                                   |        ❌ No        |
|  50   | [label](https://docutils.sourceforge.io/docs/ref/doctree.html#label)                                     | 📰 No Documentation |
|  51   | [legend](https://docutils.sourceforge.io/docs/ref/doctree.html#legend)                                   | 📰 No Documentation |
|  52   | [line](https://docutils.sourceforge.io/docs/ref/doctree.html#line)                                       |       ✅ Yes        |
|  53   | [line-block](https://docutils.sourceforge.io/docs/ref/doctree.html#line-block)                           |       ✅ Yes        |
|  54   | [list-item](https://docutils.sourceforge.io/docs/ref/doctree.html#list-item)                             |       ✅ Yes        |
|  55   | [literal](https://docutils.sourceforge.io/docs/ref/doctree.html#literal)                                 |       ✅ Yes        |
|  56   | [literal-block](https://docutils.sourceforge.io/docs/ref/doctree.html#literal-block)                     |       ✅ Yes        |
|  57   | [math](https://docutils.sourceforge.io/docs/ref/doctree.html#math)                                       | ⛔ Not Possible[^6] |
|  58   | [math-block](https://docutils.sourceforge.io/docs/ref/doctree.html#math-block)                           | ⛔ Not Possible[^6] |
|  59   | [meta](https://docutils.sourceforge.io/docs/ref/doctree.html#meta)                                       |       ✅ Yes        |
|  60   | [note](https://docutils.sourceforge.io/docs/ref/doctree.html#note)                                       |       ✅ Yes        |
|  61   | [option](https://docutils.sourceforge.io/docs/ref/doctree.html#option)                                   |       ✅ Yes        |
|  62   | [option-argument](https://docutils.sourceforge.io/docs/ref/doctree.html#option-argument)                 |       ✅ Yes        |
|  63   | [option-group](https://docutils.sourceforge.io/docs/ref/doctree.html#option-group)                       |       ✅ Yes        |
|  64   | [option-list](https://docutils.sourceforge.io/docs/ref/doctree.html#option-list)                         |       ✅ Yes        |
|  65   | [option-list-item](https://docutils.sourceforge.io/docs/ref/doctree.html#option-list-item)               |       ✅ Yes        |
|  66   | [option-string](https://docutils.sourceforge.io/docs/ref/doctree.html#option-string)                     |       ✅ Yes        |
|  67   | [organization](https://docutils.sourceforge.io/docs/ref/doctree.html#organization)                       |       ✅ Yes        |
|  68   | [paragraph](https://docutils.sourceforge.io/docs/ref/doctree.html#paragraph)                             |       ✅ Yes        |
|  69   | [pending](https://docutils.sourceforge.io/docs/ref/doctree.html#pending)                                 |       ✅ Yes        |
|  70   | [problematic](https://docutils.sourceforge.io/docs/ref/doctree.html#problematic)                         |       ✅ Yes        |
|  71   | [raw](https://docutils.sourceforge.io/docs/ref/doctree.html#raw)                                         | 📰 No Documentation |
|  72   | [reference](https://docutils.sourceforge.io/docs/ref/doctree.html#reference)                             | 📰 No Documentation |
|  73   | [revision](https://docutils.sourceforge.io/docs/ref/doctree.html#revision)                               |       ✅ Yes        |
|  74   | [row](https://docutils.sourceforge.io/docs/ref/doctree.html#row)                                         | 📰 No Documentation |
|  75   | [rubric](https://docutils.sourceforge.io/docs/ref/doctree.html#rubric)                                   |       ✅ Yes        |
|  76   | [section](https://docutils.sourceforge.io/docs/ref/doctree.html#section)                                 |       ✅ Yes        |
|  77   | [sidebar](https://docutils.sourceforge.io/docs/ref/doctree.html#sidebar)                                 |       ✅ Yes        |
|  78   | [status](https://docutils.sourceforge.io/docs/ref/doctree.html#status)                                   |       ✅ Yes        |
|  79   | [strong](https://docutils.sourceforge.io/docs/ref/doctree.html#strong)                                   |       ✅ Yes        |
|  80   | [subscript](https://docutils.sourceforge.io/docs/ref/doctree.html#subscript)                             |       ✅ Yes        |
|  81   | [substitution-definition](https://docutils.sourceforge.io/docs/ref/doctree.html#substitution-definition) | 📰 No Documentation |
|  82   | [substitution-reference](https://docutils.sourceforge.io/docs/ref/doctree.html#substitution-reference)   | 📰 No Documentation |
|  83   | [subtitle](https://docutils.sourceforge.io/docs/ref/doctree.html#subtitle)                               |       ✅ Yes        |
|  84   | [superscript](https://docutils.sourceforge.io/docs/ref/doctree.html#superscript)                         |       ✅ Yes        |
|  85   | [system-message](https://docutils.sourceforge.io/docs/ref/doctree.html#system-message)                   |       ✅ Yes        |
|  86   | [table](https://docutils.sourceforge.io/docs/ref/doctree.html#table)                                     |        ❌ No        |
|  87   | [target](https://docutils.sourceforge.io/docs/ref/doctree.html#target)                                   | 📰 No Documentation |
|  88   | [tbody](https://docutils.sourceforge.io/docs/ref/doctree.html#tbody)                                     |        ❌ No        |
|  89   | [term](https://docutils.sourceforge.io/docs/ref/doctree.html#term)                                       |       ✅ Yes        |
|  90   | [tgroup](https://docutils.sourceforge.io/docs/ref/doctree.html#tgroup)                                   |        ❌ No        |
|  91   | [thead](https://docutils.sourceforge.io/docs/ref/doctree.html#thead)                                     |        ❌ No        |
|  92   | [tip](https://docutils.sourceforge.io/docs/ref/doctree.html#tip)                                         |       ✅ Yes        |
|  93   | [title](https://docutils.sourceforge.io/docs/ref/doctree.html#title)                                     |       ✅ Yes        |
|  94   | [title-reference](https://docutils.sourceforge.io/docs/ref/doctree.html#title-reference)                 | 📰 No Documentation |
|  95   | [topic](https://docutils.sourceforge.io/docs/ref/doctree.html#topic)                                     |       ✅ Yes        |
|  96   | [transition](https://docutils.sourceforge.io/docs/ref/doctree.html#transition)                           |       ✅ Yes        |
|  97   | [version](https://docutils.sourceforge.io/docs/ref/doctree.html#version)                                 |       ✅ Yes        |
|  98   | [warning](https://docutils.sourceforge.io/docs/ref/doctree.html#warning)                                 |       ✅ Yes        |

[^1]: Abbreviation and acronym elements work when hovering over some text, since in a terminal we can't change the hover text (as far as I know), those are not supported
[^2]: Bullet lists are supported for up to 3 levels of nesting
[^3]: Enumerated lists are supported without nesting
[^4]: Currently the document is rendered top to bottom and I don't really know any method of adding a element at the end or at the beginning and keeping that order, any suggestions appreciated
[^5]: Images show an emoji and the alt text or title text (aka hover text) and they are clickable, if the image has a target link then it opens that target link when clicked, otherwise it opens the image url
[^6]: Math elements are usually written in latex. This makes it hard to show them properly in the terminal, A tool called [formulador](https://github.com/stylewarning/formulador) exists but it's written in [Common Lisp](https://common-lisp.net/ "Common Lisp is the modern, multi-paradigm, high-performance, compiled, ANSI-standardized, most prominent (along with Scheme) descendant of the long-running Lisp language"), And another tool called [cl4py](https://github.com/marcoheisig/cl4py) also exists that allows lisp and python interoperability but it requires some form of lisp to be installed, it will be a hassle to make people install lisp and formulador and the general public that uses sphinx probably doesn't use math much
[^7]: Due to the way decoration works, this doesn't have any purpose inside a terminal, so decoration is skipped
