/***************************************************************************
                          scripting.hpp  -  description
                             -------------------
    begin                : Mit Sep 19 13:11:41 CEST 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SCRIPTING_HPP
#define SCRIPTING_HPP

/**
	@author Harald Krippel <harald@the-develop.net>
*/

#include <QtGui>

class FolderListItem;
class splaModel;


class QcakeScriptApi : public QObject
{
  Q_OBJECT

  public:

  static QcakeScriptApi *theInstance(QObject *parent=0);

    /** construtor */
  QcakeScriptApi(QObject *parent=0);
    /** destructor */
  ~QcakeScriptApi();
  void Init (FolderListItem *item);
  void Redraw ();
//  int getRef ( int id , FolderListItem *item);

  public slots: // these functions (slots) will be available in Qt Script

  splaModel *getModel ( int i );
  float getPositionX(int hh);
  float getPositionY(int hh);
  float getPositionZ(int hh);
  float getPositionH(int hh);
  float getPositionP(int hh);
  float getPositionR(int hh);
  float getJoystick ( int js,int a );
  int getJoyButton (int js);
  int getRef ( int id );
  int getParentID ( int id );
  void addRelTorque ( int hh, float velx, float vely, float velz );
  void addRelForce ( int hh, float velx, float vely, float velz );
  int switchScene ( int hh);
  int switchCamera ( int hh);
  void setSequence ( int hh, int sequence, int mode );
  void setAngularVel ( int hh, float velx, float vely, float velz );
  void setLinVel ( int hh, float velx, float vely, float velz );
  void setRotation ( int hh, float h, float p, float r );
  void rotation ( int hh, float h, float p, float r );
  void setPosition ( int hh, float x, float y, float z, float h, float p, float r );
  void playSound ( int hh);
  void stopSound ( int hh);
  int getMouse ( int a );
  int getMouseButton (void);
  float get3DMouse ( int a );
  QString getAttribute ( int hh, char * attr);
  int setAttribute ( int hh, char * attr, char * value);
  int getKey ();
  int keyPressed(int keycode);
  int srand (unsigned int seed);
  float rand ();
  int astarFindPath (int pl,int sx,int sy,int tx,int ty);
  int astarReadPathX (int pl,int sx);
  int astarReadPathY (int pl,int sy);
  int astarReadMap (const QString &file);
  int astarReadMapValue (int x, int y);
  int astarInit (int mapWidth, int mapHeight , int tileSize, int numberPeople);
  int tmpobjInit (int hh, float x , float y, float z, float h , float p, float r, int id);
  void debug(const QString &msg);
  void print(const QString &msg);

  protected:
  FolderListItem *inititem;  // id from tree


  private:
   static QcakeScriptApi *theInstancePtr;

};

#endif
