#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : Import/Export
- Name     : Web Services
- ID       : io_webservices

Description
----------
Web Services
'''

from PySAGA.helper import Tool_Wrapper

def Geocoding(ADDRESSES=None, LOCATIONS=None, FIELD=None, ADDRESS=None, PROVIDER=None, API_KEY=None, METADATA=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_0(ADDRESSES=None, LOCATIONS=None, FIELD=None, ADDRESS=None, PROVIDER=None, API_KEY=None, METADATA=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        return Tool.Execute(Verbose)
    return False

