#include <assert.h>
#include <mpi.h>
#include <stdio.h>
#include <unistd.h>

#ifndef MPI_MAX_PROCESSOR_NAME
#define MPI_MAX_PROCESSOR_NAME 1024
#endif

int main(int argc, char** argv)
{
  int nprocs = -1;
  int rank   = -1;
  char processor_name[MPI_MAX_PROCESSOR_NAME];
  int namelen        = 128;
  int probe_received = 0;

  int const1 = 1;

  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Get_processor_name(processor_name, &namelen);
  printf("rank %d is alive on %s\n", rank, processor_name);

  if (rank == 0) {

    int g = 0;

    MPI_Iprobe(1, MPI_ANY_TAG, MPI_COMM_WORLD, &probe_received, &status);
    if (probe_received)
      MPI_Recv(&g, 1, MPI_INT, MPI_ANY_SOURCE, 0, MPI_COMM_WORLD, &status);

    MPI_Iprobe(1, MPI_ANY_TAG, MPI_COMM_WORLD, &probe_received, &status);
    if (probe_received)
      MPI_Recv(&g, 1, MPI_INT, MPI_ANY_SOURCE, 0, MPI_COMM_WORLD, &status);

    MPI_Iprobe(1, MPI_ANY_TAG, MPI_COMM_WORLD, &probe_received, &status);
    if (probe_received)
      MPI_Recv(&g, 1, MPI_INT, MPI_ANY_SOURCE, 0, MPI_COMM_WORLD, &status);

    assert(g != 0);
  }

  if (rank == 1) {

    MPI_Send(&const1, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);
    MPI_Send(&const1, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);
    MPI_Send(&const1, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);
  }

  MPI_Finalize();
  printf("rank %d Finished normally\n", rank);
  return 0;
}
