2.4 エンベロープでのデュレーション

# エンベロープでのデュレーション

前半のセクションでは、音を演奏したい時にどのように`sleep`コマンドを
使用するかを見てきました。ですが、わたしたちはまだ音のデュレーション（長さ）について
制御できていませんね。

音のデュレーションを制御するための、パワフルでシンプルな手段として、
Sonic Piには*ADSR amplitude envelope*（ADSR・アンプ・エンベロープ）という
概念があります（ADSRが何を意味するかはこのセクションの後半で紹介します）。
アンプ・エンベロープは制御のための便利な2つの側面を持っています。

* 音のデュレーション（長さ）を制御する
* 音のアンプ（音量）を制御する

## デュレーション

デュレーションは音の持続する長さのことです。長いデュレーションは、より長く音が
鳴ることを意味します。Sonic Piの全てのサウンドは、アンプ・エンベロープで制御でき、
ひとつのエンベロープ(音量や音色の時間的な変化)の長さは、音の長さでもあります。

## アンプ（音量）

ADSRエンベロープは、デュレーションの制御だけでなく、*アンプ（音量）の緻密な
制御*も可能にします。全てのサウンドは、サイレント（無音）で始まり、間に音があり、
またサイレントで終了します。エンベロープを使用すると、サウンドの音がある部分の音量を
スライドさせたり、保持したりすることができます。これは、音楽の音量を上げたり下げたり
するのを、誰かに指示するような感じです。例えば、あなたは誰かに「無音で始めて、
ゆっくりとフル・ボリュームにして、少しそのままで、そして一気に無音に戻る。」と頼むとします。
Sonic Piはエンベロープでこれをプログラムできるようにしてくれます。

前のセクションで見てきたように、アンプの`0`は無音、`1`は通常の音量です。

では、エンベロープのそれぞれの部分を順番に見ていきましょう。

## リリース・フェーズ（終わるまでの時間）

エンベロープのうちデフォルトで使われている唯一の部分はリリース・フェーズです。
通常、全てのシンセのリリース・フェーズ（終わるまでの時間）は1で、
これは終了するまでに1ビート（デフォルトBPMの60の場合には1秒）のデュレーションを持っているということです。

```
play 70
```

この音は1秒間だけ聞こえます。続いて時間を指定しよう。
上の記述は、次の明示的で長い記述を簡略化したものです。

```
play 70, release: 1
```

これも全く同じように（1秒間持続する）音が出たと思います。
しかし、`release:`のオプションを変更することでとても簡単に
持続時間を変更することができるようになりました。

```
play 60, release: 2
```

また、非常に小さなリリース・フェーズの値を使って、シンセのサウンドをとても短くすることができます。

```
play 60, release: 0.2
```

音がリリースされるまでの持続時間はリリース・フェーズと呼ばれていて、
デフォルトではリニア・トランジション（直線的な移行、つまり真っ直ぐ）です。以下の図は、この移行を表したものです。

![release envelope](:/images/tutorial/env-release.png)

図の左端の縦の線は、サウンドが`0`の音量(ゼロ・アンプ)からスタートしていることを示しています。
しかし、すぐにフル・アンプに上がります（これは私たちが後で学ぶ、アタック・フェーズというものです）。
いったんフル・アンプになり、それから`release:`で指定した値を取りながら、直線的にゼロに下がります。
*長いリリース・タイムは長いシンセ・フェード・アウト（徐々に消えること）を生成します*。

これにより、リリース・フェーズを変更して、あなたのサウンドのデュレーションを
変えることができます。自分の音楽にリリース・タイムを追加して演奏してみましょう。

## アタック・フェーズ

通常、アタック・フェーズは全てのシンセにおいて`0`です。つまり、`0`アンプから
 `1`にただちに移動することを意味します。シンセは最初から音が打たれます。
 けれども、あなたは音をフェード・イン（徐々に大きく）したいかも知れません。 これは、`attack:`のオプションで実現することができます。いくつかの音をフェード・インしてみましょう。

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```

複数のオプションを使うこともできます。例えば、短いアタック、長いリリースに、変更してみましょう。

```
play 60, attack: 0.7, release: 4
```

この、短いアタックに長いリリースのエンベロープは、以下の図のように表します。

![attack release envelope](:/images/tutorial/env-attack-release.png)

もちろん、ほかに変更することもできます。長いアタックに短いリリースを試してみましょう。


```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](:/images/tutorial/env-long-attack-short-release.png)

そして、アタックとリリース両方短くして、短いサウンドにもできます。


```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](:/images/tutorial/env-short-attack-short-release.png)

## サステイン・フェーズ（持続時間）

アタック・フェーズとリリース・フェーズの設定に付け加えて、サステイン・フェーズ（持続時間）を
指定することができます。サステイン・フェーズとは、アタックとリリースの間でフル・アンプの
音が鳴り続ける時間のことです。

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](:/images/tutorial/env-attack-sustain-release.png)

サステイン・フェーズは、オプションのリリース・フェーズに入る前に、ミックスの中で主となる
存在感を与えたい重要なサウンドにとって有効です。もちろん、`attack:`と`release:`両方のオプションを
0に設定することもとても有効ですし、サウンドに対して、完全にフェード・インなし、
フェード・アウトなしにするためにサステインを使えば良いのです。けれど、注意してください、
0 のリリースはオーディオの中にクリック音を生成します。たいていの場合、0.2のような
ごく小さい値を使う方が良いです。

## ディケイ・フェーズ（減衰時間）

そして、今あなたがさらなる制御のレベルを必要としているならば、ディケイ・タイムというものを
設定することもできます。これは、アタックとサステインの間にくるエンベロープのフェーズで、
音量が`attack_level:`から`decay_level:`(もしこれを明示的に指定しなければ、この値は `sustain_level:`と同じ値に設定されます)に落ちる時間を指定します。
通常では、`decay:`のオプションは 0 で、アタックとサステインのレベルは両方とも 1 です。ですから、ディケイ・フェーズで効果を得るには、アタック、サステインのレベルも指定しなくてはなりません。

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](:/images/tutorial/env-attack-decay-sustain-release.png)

## ディケイレベル

最後の仕掛けは、`decay_level:`オプションがデフォルトでは`sustain_level:`と同じ値に設定されていて、エンベロープを完全に制御したい場合に明示的に別な値に設定できることです。
これにより次のようなエンベロープを作ることができるでしょう。

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, decay_level: 0.3, sustain: 1, sustain_level: 0.4, release: 0.5
```

![ASR envelope](../images/tutorial/env-decay-level.png)

また`decay_level:`を`sustain_level:`より大きく設定することもできます。

```
play 60, attack: 0.1, attack_level: 0.1, decay: 0.2, decay_level: 1, sustain: 0.5, sustain_level: 0.8, release: 1.5
```

![ASR envelope](../images/tutorial/env-decay-level-2.png)

## ADSR エンベロープ

つまり要約すると、Sonic PiのADSRエンベロープには、以下のフェーズがあります。

1. *attack*（アタック）- 0 アンプから`attack_level`までの時間
2. *decay*（ディケイ）- 音量を`attack_level`から`decay_level`まで移行させる時間
3. *sustain*（サステイン）- 音量を`decay_level`から`sustain_level`まで移行させる時間
4. *release*（リリース） - 音量を`sustain_level`から 0 に移行させる時間

サウンドのデュレーションは、これらのフェーズの合計であることに注意することが大切です。
したがって、以下のサウンドは 0.5 + 1 + 2 + 0.5 = 4 で、4秒のデュレーションになります。

```
play 60, attack: 0.5, attack_level: 1, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

ではあなたのサウンドにエンベロープを追加して演奏してみましょう。
