6.1 Adding FX

# Adding FX

In this section we'll look at a couple of FX: reverb and echo. We'll
see how to use them, how to control their opts and how to chain
them.

Sonic Pi's FX system uses blocks. So if you haven't read section 5.1 you
might want to take a quick look and then head back.

## Reverb

If we want to use reverb we write `with_fx :reverb` as the special code
to our block like this:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Now play this code and you'll hear it played with reverb. It sounds
good, doesn't it! Everything sounds pretty nice with reverb.

Now let's look what happens if we have code outside the do/end block:

```
with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

Notice how the final `play 55` isn't played with reverb. This is because
it is *outside* the do/end block, so it isn't captured by the reverb FX.

Similarly, if you make sounds before the do/end block, they also won't
be captured:

```
play 55
sleep 1

with_fx :reverb do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end

sleep 1
play 55
```

## Echo

There are many FX to choose from. How about some echo?

```
with_fx :echo do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

One of the powerful aspects of Sonic Pi's FX blocks is that they may be
passed opts similar to opts we've already seen with `play`
and `sample`. For example a fun echo opt to play with is `phase:`
which represents the duration of a given echo in beats. Let's make the
echo slower:

```
with_fx :echo, phase: 0.5 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Let's also make the echo faster:

```
with_fx :echo, phase: 0.125 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Let's make the echo take longer to fade away by setting the `decay:`
time to 8 beats:

```
with_fx :echo, phase: 0.5, decay: 8 do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

## Nesting FX

One of the most powerful aspects of the FX blocks is that you can nest
them. This allows you to very easily chain FX together. For example,
what if you wanted to play some code with echo and then with reverb?
Easy, just put one inside the other:

```
with_fx :reverb do
  with_fx :echo, phase: 0.5, decay: 8 do
    play 50
    sleep 0.5
    sample :elec_blup
    sleep 0.5
    play 62
  end
end
```

Think about the audio flowing from the inside out. The sound of all
the code within the inner do/end block such as `play 50` is first sent
to the echo FX and the sound of the echo FX is in turn sent out to the
reverb FX.

We may use very deep nestings for crazy results. However, be warned, the
FX can use a lot of resources and when you nest them you're effectively
running multiple FX simultaneously. So be sparing with your use of FX
especially on low powered platforms such as the Raspberry Pi.

## Discovering FX

Sonic Pi ships with a large number of FX for you to play with. To find
out which ones are available, click on FX in the far left of this help
system and you'll see a list of available options. Here's a list of
some of my favourites:

* wobble,
* reverb,
* echo,
* distortion,
* slicer

Now go crazy and add FX everywhere for some amazing new sounds!
