---
thebe-kernel: ir
---

# Configuration

(configure:selector)=
## Change the HTML selector to mark interactive cells

By default, `sphinx-thebe` will be run on any cells with the `thebe` class.
However, you can customize the HTML selector to use other classes, elements, etc.

For example, if you wanted to convert **all code cells**, you could use the following
selector:

```python
thebe_config = {
   "selector": "div.highlight"
}
```

```{note}
`sphinx-thebe` will subsequently look for any `pre` blocks inside of elements it
finds with the `selector` configuration value. These are the blocks that will be
converted to interactive with `thebe`.
```

## Including outputs with your code

If you'd like to include outputs in the *static* version of your page, and only
overwrite them once the user has run that Thebe cell, you can configure `sphinx-thebe`
to detect and keep the outputs associated with some code. To do so, use
the `selector_output` configuration. This is a selector that is searched for *within* any
items discovered by `selector`. If an output is found, it will be placed just after the
code and Thebe will detect it.

For example, the following code:

``````{tab-set}

`````{tab-item} Myst Markdown

````{container} thebe
```{code-block} r
print("hi")
```

```{container} output
"hi"
```
````

`````

`````{tab-item} reStructuredText

```{code-block} rst
.. container:: thebe
   .. code-block:: r
      print("hi")

   .. container:: output
      "hi"
```

`````

``````

Defines a *parent container* in which we'll put both code and the output of the
code. We'll use a `code-block` for the code, and another `container` node with our
`output` class for the output. `sphinx-gallery` will detect the parent container because
it has a `thebe` class. It will detect the `pre` block inside the container as the
code, and it will detect the `<div>` block with the `output` class as the output.

The result is that initializing Thebe *retains* the output until the cell is
executed, like so:

```{thebe-button}
```

````{container} thebe
```{code-block} r
print("hi")
```

```{container} output
"hi"
```
````

## Setting the Kernel

You can set the kernel that Thebe uses on a page by adding metadata to your
page. To do so, add the following metadata to the top of your page:

```
thebe-kernel: <kernel-name>
```

For example, this page had the following metadata in it:

```
thebe-kernel: ir
```

In addition, this website is configured to use the [Binder R example repository](https://github.com/binder-examples/r)
for its environment. As a result, we can now run R code interactively with Thebe:


```{thebe-button} Launch thebe in R
```

```{code-block}
:class: thebe, thebe-init
# Load ggplot - this will be automatically-run
library(ggplot2)
```

```{code-block}
:class: thebe, thebe-init
# create factors with value labels
mtcars$gear <- factor(mtcars$gear,levels=c(3,4,5),
  	labels=c("3gears","4gears","5gears"))
mtcars$am <- factor(mtcars$am,levels=c(0,1),
  	labels=c("Automatic","Manual"))
mtcars$cyl <- factor(mtcars$cyl,levels=c(4,6,8),
   labels=c("4cyl","6cyl","8cyl"))
```

```{code-block}
:class: thebe, thebe-init
# Kernel density plots for mpg
# grouped by number of gears (indicated by color)
qplot(mpg, data=mtcars, geom="density", fill=gear, alpha=I(.5),
   main="Distribution of Gas Milage", xlab="Miles Per Gallon",
   ylab="Density")
```

```{code-block}
:class: thebe

# Scatterplot of mpg vs. hp for each combination of gears and cylinders
# in each facet, transmittion type is represented by shape and color
qplot(hp, mpg, data=mtcars, shape=am, color=am,
   facets=gear~cyl, size=I(3),
   xlab="Horsepower", ylab="Miles per Gallon")
```

## Automatically running some code

You can tag code blocks to run as soon as the kernel is ready (i.e., without any user input)
by adding the `thebe-init` class to the code blocks. For example:

`````{tab-set}

````{tab-item} MyST Markdown
```{code-block}
:class: thebe, thebe-init
print("hi")
```
````

````{tab-item} reStructuredText

```rst
.. code-block::
   :class: thebe, thebe-init
   
   print("hi")
```

````

`````

These code blocks will be run automatically once the kernel is ready, and their outputs
will be displayed below.


(add-custom-button)=
## Adding your own button to start Thebe

By default, Thebe encourages users to use the `thebe-button` directive to
insert a thebe button into their documentation. However, you can add your own
buttons wherever you wish. Simply ensure that an HTML element has this attribute:

```js
onclick="initThebe()"
```

and it will be able to initialize Thebe on that page on its own.

For example, here is the HTML for the Thebe button generated by the `thebe-button`
directive:

```html
<button title="Make live" class="thebe-button" onclick="initThebe()">
  Make live
</button>
```

## Choose a codemirror theme

You can customize `sphinx-thebe` to use the codemirror theme of your choice.
To do so, use the following configuration:

```python
thebe_config = {
   "codemirror-theme": "<cm-theme>"
}
```

See [the CodeMirror theme demo](https://codemirror.net/demo/theme.html) for a list
of themes that you can use, and what they look like.

## Load `thebe` automatically on all pages

By default, `sphinx-thebe` will lazily load the JS/CSS from `thebe` when the `sphinx-thebe` initialization button is pressed.
This means that no Javascript is loaded until a person explicitly tries to start thebe, which reduces page load times.

If you want `thebe` to be loaded on every page, in an "eager" fashion, you may do so with the following configuration:

```python
thebe_config = {
   "always_load": True
}
```

## Configuration reference

Here's a reference of all of the configuration values avialable to `sphinx-thebe`.
Many of these eventually make their was into the `thebe` configuration. You can
find a [reference for `thebe` configuration here](https://thebe.readthedocs.io/en/latest/config_reference.html).

```python
thebe_config = {
    "always_load": bool (default True)
    "repository_url": "<your-repo-url>",
    "repository_branch": "<your-repo-branch>",
    "selector": "<selector-for-code-cells>",
    "selector_input": "<selector-for-cell-input>",
    "selector_output": "<selector-for-cell-output>",
}
```
