/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITPARAM_H
#define _SC_COMMITPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "svn/CommitBaton.h"

/**
 * Parameter class for CommitCmd.
 */
class CommitParam : public ScParam
{
public:
  CommitParam( const svn::Paths& paths, bool recurse, bool keepLocks,
    svn::CommitBaton* baton )
    : _paths(paths), _recurse(recurse), _keepLocks(keepLocks), _baton(baton)
  {
  }

  const svn::Paths& getPaths() const
  {
    return _paths;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  void setRecurse( bool recurse )
  {
    _recurse = recurse;
  }

  bool getKeepLocks() const
  {
    return _keepLocks;
  }

  void setKeepLocks( bool keepLocks )
  {
    _keepLocks = keepLocks;
  }

  svn::CommitBaton* getBaton()
  {
    return _baton;
  }

  void setBaton( svn::CommitBaton* baton )
  {
    _baton = baton;
  }

  svn::CommitInfo& getInfo()
  {
    return _info;
  }
  
  ScParamAccept(CommitParam);

private:
  // in
  svn::Paths        _paths;
  bool              _recurse;
  bool              _keepLocks;
  svn::CommitBaton* _baton;

  // out
  svn::CommitInfo   _info;
};

#endif // _SC_COMMITPARAM_H
