# Sway-Contrib
[![CI](https://github.com/OctopusET/sway-contrib/actions/workflows/ci.yaml/badge.svg)](https://github.com/OctopusET/sway-contrib/actions/workflows/ci.yaml)

> This repository is a collection of user contributions for the Sway window manager.

[Sway](https://github.com/swaywm/sway/) is an i3-compatible tiling window manager for Wayland, offering a lightweight, efficient, and customizable environment. Sway-Contrib is a community-driven effort to share and showcase various user-created configurations, scripts, themes, and other resources that enhance and help the Sway experience.

## Tools
| Name | Description |
| :---: | :---: |
| autoname-workspaces.py | Adds icons to the workspace name for each open window |
| firefox-focus-monitor.py | Utility to selectively disable keypresses to specific windows |
| grimshot | A helper for screenshots within sway |
| inactive-windows-transparency.py | Makes inactive windows transparent |
| layout-per-window.py | A script keeps track of the active layout for each window |
| switch-top-level.py | A script allows you to define two new bindings |


## Contributing

We encourage everyone to contribute to Sway-Contrib! Whether you have a new script, a theme, a configuration file, or any other enhancement for Sway, your contributions are valuable to the community. To contribute, follow these steps:

1. Fork the repository to your GitHub account.
2. Create a new branch for your changes.
3. Make your changes and commit them.
4. Push the changes to your forked repository.
5. Open a pull request to the main Sway-Contrib repository.
  
## Resources
  
- [Sway Website](https://swaywm.org/): Official website for the Sway window manager.
- [Sway Wiki](https://github.com/swaywm/sway/wiki): Official wiki for Sway.

## Support and Issues

If you encounter any issues with Sway-Contrib or have questions, feel free to open an issue on the [issue tracker](https://github.com/OctopusET/sway-contrib/issues).

## See also
[Sway-Contrib Wiki](https://github.com/OctopusET/sway-contrib/wiki)

## License

The Sway-Contrib repository is licensed under the [MIT License](LICENSE). By contributing to this project, you agree that your contributions will be licensed under the same license.
