# Symbol Reference Rendering

Render rich reference documentation for programming symbols.

## Overview

Each section in a rendering node represents a piece of data potentially rendered on a documentation page.

A documentation abstract is represented by a ``AbstractSection``, a section listing the declarations on various platform for a symbol is represented by a ``DeclarationsRenderSection``, a See Also section by a ``SeeAlsoSection``, and so on.

## Topics

### Metadata

- ``RenderReferenceHierarchy``

### Main Sections

- ``AbstractSection``
- ``DeprecatedSection``
- ``DeclarationsRenderSection``
- ``DeclarationRenderSection``
- ``ParametersSection``
- ``ReturnsSection``
- ``DiscussionSection``
- ``TopicsSection``
- ``SeeAlsoSection``
- ``SampleDownloadSection``

### Relationship Sections

- ``RelationshipsRenderSection``
- ``Relationship``
- ``RelationshipsSection``
- ``RelationshipsGroup``
- ``DefaultImplementationsSection``
- ``ImplementationsGroup``
- ``ConformanceSection``

### Object Description Sections

- ``AttributesRenderSection``
- ``RenderAttribute``
- ``ParameterRenderSection``
- ``ParametersRenderSection``
- ``TitleStyle``
- ``PossibleValuesRenderSection``
- ``PropertiesRenderSection``
- ``RenderProperty``
- ``TypeDetails``

### Other Sections

- ``RESTEndpointRenderSection``
- ``CodeExample``

### Callouts

- ``SimpleTag``
- ``Parameter``
- ``Return``
- ``Throw``

### Generic Sections

- ``GroupedSection``
- ``TaskGroupRenderSection``
- ``ContentRenderSection``

### Availability

- ``AvailabilityRenderItem``
- ``DiffAvailability``

<!-- Copyright (c) 2021 Apple Inc and the Swift Project authors. All Rights Reserved. -->
