//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift open source project
//
// Copyright (c) 2023 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See http://swift.org/LICENSE.txt for license information
// See http://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

import XCTest

import TSCBasic

func readFileContents(
    in basePath: AbsolutePath,
    pathComponents: String...,
    fileSystem: FileSystem = localFileSystem
) throws -> [UInt8] {
    let path = basePath.appending(components: pathComponents)
    return try fileSystem.readFileContents(path).contents
}
