#!/usr/bin/env python

import numpy
import os
import sys
import glob
import pickle

def read_data(fn):
    try:
        f = open(fn)
        data = pickle.load(f)
        #data = f.read()
        f.close()
    except Exception, what:
        print "*** An error occured while trying to load reference file: %s" % fn
        print "*** Maybe you need to generate the reference? Returning None."
        data = None
    return data

def main(argv):
    folder, = argv

    # Data:
    files = sorted(glob.glob(os.path.join(folder, "*.ref")))
    datas = []
    print
    for fn in files:
        print "Reading ===", fn, "...",
        data = read_data(fn)
        datas.append((fn,data))
        print "Ok!"
    print
    for fn, data in datas:
        print "===", fn
        print data
    print

    # Timing:
    files = sorted(glob.glob(os.path.join(folder, "*.timing")))
    datas = []
    print
    for fn in files:
        print "Reading ===", fn, "...",
        data = read_data(fn)
        datas.append((fn,data))
        print "Ok!"
    print
    for fn, data in datas:
        print "===", fn
        print data
    print

if __name__ == "__main__":
    main(sys.argv[1:])
