/*----- PROTECTED REGION ID(TangoTestStateMachine.cpp) ENABLED START -----*/
static const char *RcsId = "$Id: TangoTestStateMachine.cpp 22520 2013-04-25 08:38:15Z taurel $";
//=============================================================================
//
// file :        TangoTestStateMachine.cpp
//
// description : State machine file for the TangoTest class
//
// project :     TANGO Device Server for testing generic clients
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author: taurel $
//
// $Revision: 22520 $
// $Date: 2013-04-25 10:38:15 +0200 (Thu, 25 Apr 2013) $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <TangoTest.h>

/*----- PROTECTED REGION END -----*/	//	TangoTest::TangoTestStateMachine.cpp

//================================================================
//  States   |  Description
//================================================================
//  FAULT    |  This state disables all commands
//  RUNNING  |  This state allows all the commands to be sent


namespace TangoTest_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ampli_allowed()
 *	Description : Execution allowed for ampli attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ampli_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ampli attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ampliStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ampliStateAllowed_WRITE

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_boolean_scalar_allowed()
 *	Description : Execution allowed for boolean_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_boolean_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for boolean_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_scalarStateAllowed_WRITE

	//	Not any excluded states for boolean_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_scalar_allowed()
 *	Description : Execution allowed for double_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for double_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::double_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_scalarStateAllowed_WRITE

	//	Not any excluded states for double_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_scalar_rww_allowed()
 *	Description : Execution allowed for double_scalar_rww attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for double_scalar_rww attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::double_scalar_rwwStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_scalar_rwwStateAllowed_WRITE

	//	Not any excluded states for double_scalar_rww attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_scalar_rwwStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_scalar_rwwStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_scalar_w_allowed()
 *	Description : Execution allowed for double_scalar_w attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for double_scalar_w attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::double_scalar_wStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_scalar_wStateAllowed_WRITE

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_float_scalar_allowed()
 *	Description : Execution allowed for float_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_float_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for float_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::float_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_scalarStateAllowed_WRITE

	//	Not any excluded states for float_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::float_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long64_scalar_allowed()
 *	Description : Execution allowed for long64_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long64_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long64_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long64_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long64_scalarStateAllowed_WRITE

	//	Not any excluded states for long64_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long64_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long64_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_scalar_allowed()
 *	Description : Execution allowed for long_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_scalarStateAllowed_WRITE

	//	Not any excluded states for long_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_scalar_rww_allowed()
 *	Description : Execution allowed for long_scalar_rww attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long_scalar_rww attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long_scalar_rwwStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_scalar_rwwStateAllowed_WRITE

	//	Not any excluded states for long_scalar_rww attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_scalar_rwwStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_scalar_rwwStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_scalar_w_allowed()
 *	Description : Execution allowed for long_scalar_w attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long_scalar_w attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long_scalar_wStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_scalar_wStateAllowed_WRITE

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_no_value_allowed()
 *	Description : Execution allowed for no_value attribute
 */
//--------------------------------------------------------
bool TangoTest::is_no_value_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for no_value attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::no_valueStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::no_valueStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_scalar_allowed()
 *	Description : Execution allowed for short_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for short_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalarStateAllowed_WRITE

	//	Not any excluded states for short_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_scalar_ro_allowed()
 *	Description : Execution allowed for short_scalar_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_scalar_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for short_scalar_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalar_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalar_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_scalar_rww_allowed()
 *	Description : Execution allowed for short_scalar_rww attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for short_scalar_rww attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalar_rwwStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalar_rwwStateAllowed_WRITE

	//	Not any excluded states for short_scalar_rww attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalar_rwwStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalar_rwwStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_scalar_w_allowed()
 *	Description : Execution allowed for short_scalar_w attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for short_scalar_w attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::short_scalar_wStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_scalar_wStateAllowed_WRITE

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_string_scalar_allowed()
 *	Description : Execution allowed for string_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_string_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for string_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::string_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_scalarStateAllowed_WRITE

	//	Not any excluded states for string_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::string_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_throw_exception_allowed()
 *	Description : Execution allowed for throw_exception attribute
 */
//--------------------------------------------------------
bool TangoTest::is_throw_exception_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for throw_exception attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::throw_exceptionStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::throw_exceptionStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_uchar_scalar_allowed()
 *	Description : Execution allowed for uchar_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_uchar_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for uchar_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_scalarStateAllowed_WRITE

	//	Not any excluded states for uchar_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong64_scalar_allowed()
 *	Description : Execution allowed for ulong64_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong64_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ulong64_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ulong64_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong64_scalarStateAllowed_WRITE

	//	Not any excluded states for ulong64_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong64_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong64_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ushort_scalar_allowed()
 *	Description : Execution allowed for ushort_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ushort_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ushort_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_scalarStateAllowed_WRITE

	//	Not any excluded states for ushort_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong_scalar_allowed()
 *	Description : Execution allowed for ulong_scalar attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ulong_scalar attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ulong_scalarStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong_scalarStateAllowed_WRITE

	//	Not any excluded states for ulong_scalar attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong_scalarStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong_scalarStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_boolean_spectrum_allowed()
 *	Description : Execution allowed for boolean_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_boolean_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for boolean_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_spectrumStateAllowed_WRITE

	//	Not any excluded states for boolean_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_boolean_spectrum_ro_allowed()
 *	Description : Execution allowed for boolean_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_boolean_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for boolean_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_spectrum_allowed()
 *	Description : Execution allowed for double_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for double_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::double_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_spectrumStateAllowed_WRITE

	//	Not any excluded states for double_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_spectrum_ro_allowed()
 *	Description : Execution allowed for double_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for double_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_float_spectrum_allowed()
 *	Description : Execution allowed for float_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_float_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for float_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::float_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_spectrumStateAllowed_WRITE

	//	Not any excluded states for float_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::float_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_float_spectrum_ro_allowed()
 *	Description : Execution allowed for float_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_float_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for float_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::float_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long64_spectrum_ro_allowed()
 *	Description : Execution allowed for long64_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long64_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for long64_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long64_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long64_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_spectrum_allowed()
 *	Description : Execution allowed for long_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_spectrumStateAllowed_WRITE

	//	Not any excluded states for long_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_spectrum_ro_allowed()
 *	Description : Execution allowed for long_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for long_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_spectrum_allowed()
 *	Description : Execution allowed for short_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for short_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::short_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_spectrumStateAllowed_WRITE

	//	Not any excluded states for short_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_spectrum_ro_allowed()
 *	Description : Execution allowed for short_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for short_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_string_spectrum_allowed()
 *	Description : Execution allowed for string_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_string_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for string_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::string_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_spectrumStateAllowed_WRITE

	//	Not any excluded states for string_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::string_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_string_spectrum_ro_allowed()
 *	Description : Execution allowed for string_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_string_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for string_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::string_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_uchar_spectrum_allowed()
 *	Description : Execution allowed for uchar_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_uchar_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for uchar_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_spectrumStateAllowed_WRITE

	//	Not any excluded states for uchar_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_uchar_spectrum_ro_allowed()
 *	Description : Execution allowed for uchar_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_uchar_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for uchar_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong64_spectrum_ro_allowed()
 *	Description : Execution allowed for ulong64_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong64_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ulong64_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong64_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong64_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong_spectrum_ro_allowed()
 *	Description : Execution allowed for ulong_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ulong_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ushort_spectrum_allowed()
 *	Description : Execution allowed for ushort_spectrum attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ushort_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ushort_spectrum attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_spectrumStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_spectrumStateAllowed_WRITE

	//	Not any excluded states for ushort_spectrum attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_spectrumStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_spectrumStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ushort_spectrum_ro_allowed()
 *	Description : Execution allowed for ushort_spectrum_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ushort_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ushort_spectrum_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_spectrum_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_spectrum_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_wave_allowed()
 *	Description : Execution allowed for wave attribute
 */
//--------------------------------------------------------
bool TangoTest::is_wave_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for wave attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::waveStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::waveStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_boolean_image_allowed()
 *	Description : Execution allowed for boolean_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_boolean_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for boolean_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_imageStateAllowed_WRITE

	//	Not any excluded states for boolean_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_boolean_image_ro_allowed()
 *	Description : Execution allowed for boolean_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_boolean_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for boolean_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::boolean_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::boolean_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_image_allowed()
 *	Description : Execution allowed for double_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for double_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::double_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_imageStateAllowed_WRITE

	//	Not any excluded states for double_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_double_image_ro_allowed()
 *	Description : Execution allowed for double_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_double_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for double_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::double_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::double_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_float_image_allowed()
 *	Description : Execution allowed for float_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_float_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for float_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::float_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_imageStateAllowed_WRITE

	//	Not any excluded states for float_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::float_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_float_image_ro_allowed()
 *	Description : Execution allowed for float_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_float_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for float_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::float_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::float_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long64_image_ro_allowed()
 *	Description : Execution allowed for long64_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long64_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for long64_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long64_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long64_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_image_allowed()
 *	Description : Execution allowed for long_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for long_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::long_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_imageStateAllowed_WRITE

	//	Not any excluded states for long_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_long_image_ro_allowed()
 *	Description : Execution allowed for long_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_long_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for long_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::long_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::long_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_image_allowed()
 *	Description : Execution allowed for short_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for short_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::short_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_imageStateAllowed_WRITE

	//	Not any excluded states for short_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_short_image_ro_allowed()
 *	Description : Execution allowed for short_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_short_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for short_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::short_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::short_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_string_image_allowed()
 *	Description : Execution allowed for string_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_string_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for string_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::string_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_imageStateAllowed_WRITE

	//	Not any excluded states for string_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::string_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_string_image_ro_allowed()
 *	Description : Execution allowed for string_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_string_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for string_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::string_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::string_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_uchar_image_allowed()
 *	Description : Execution allowed for uchar_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_uchar_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for uchar_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_imageStateAllowed_WRITE

	//	Not any excluded states for uchar_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_uchar_image_ro_allowed()
 *	Description : Execution allowed for uchar_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_uchar_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for uchar_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::uchar_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::uchar_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong64_image_ro_allowed()
 *	Description : Execution allowed for ulong64_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong64_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ulong64_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong64_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong64_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ulong_image_ro_allowed()
 *	Description : Execution allowed for ulong_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ulong_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ulong_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ulong_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ulong_image_roStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ushort_image_allowed()
 *	Description : Execution allowed for ushort_image attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ushort_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	//	Not any excluded states for ushort_image attribute in Write access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_imageStateAllowed_WRITE) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_imageStateAllowed_WRITE

	//	Not any excluded states for ushort_image attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_imageStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_imageStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_ushort_image_ro_allowed()
 *	Description : Execution allowed for ushort_image_ro attribute
 */
//--------------------------------------------------------
bool TangoTest::is_ushort_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ushort_image_ro attribute in read access.
	/*----- PROTECTED REGION ID(TangoTest::ushort_image_roStateAllowed_READ) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::ushort_image_roStateAllowed_READ
	return true;
}

//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_CrashFromDevelopperThread_allowed()
 *	Description : Execution allowed for CrashFromDevelopperThread attribute
 */
//--------------------------------------------------------
bool TangoTest::is_CrashFromDevelopperThread_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for CrashFromDevelopperThread command.
	/*----- PROTECTED REGION ID(TangoTest::CrashFromDevelopperThreadStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::CrashFromDevelopperThreadStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_CrashFromOmniThread_allowed()
 *	Description : Execution allowed for CrashFromOmniThread attribute
 */
//--------------------------------------------------------
bool TangoTest::is_CrashFromOmniThread_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for CrashFromOmniThread command.
	/*----- PROTECTED REGION ID(TangoTest::CrashFromOmniThreadStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::CrashFromOmniThreadStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevBoolean_allowed()
 *	Description : Execution allowed for DevBoolean attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevBoolean_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevBoolean command.
	/*----- PROTECTED REGION ID(TangoTest::DevBooleanStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevBooleanStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevDouble_allowed()
 *	Description : Execution allowed for DevDouble attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevDouble_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevDouble command.
	/*----- PROTECTED REGION ID(TangoTest::DevDoubleStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevDoubleStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevFloat_allowed()
 *	Description : Execution allowed for DevFloat attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevFloat_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevFloat command.
	/*----- PROTECTED REGION ID(TangoTest::DevFloatStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevFloatStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevLong_allowed()
 *	Description : Execution allowed for DevLong attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevLong_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevLong command.
	/*----- PROTECTED REGION ID(TangoTest::DevLongStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevLongStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevLong64_allowed()
 *	Description : Execution allowed for DevLong64 attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevLong64_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevLong64 command.
	/*----- PROTECTED REGION ID(TangoTest::DevLong64StateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevLong64StateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevShort_allowed()
 *	Description : Execution allowed for DevShort attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevShort_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevShort command.
	/*----- PROTECTED REGION ID(TangoTest::DevShortStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevShortStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevString_allowed()
 *	Description : Execution allowed for DevString attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevString_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevString command.
	/*----- PROTECTED REGION ID(TangoTest::DevStringStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevStringStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevULong_allowed()
 *	Description : Execution allowed for DevULong attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevULong_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevULong command.
	/*----- PROTECTED REGION ID(TangoTest::DevULongStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevULongStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevULong64_allowed()
 *	Description : Execution allowed for DevULong64 attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevULong64_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevULong64 command.
	/*----- PROTECTED REGION ID(TangoTest::DevULong64StateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevULong64StateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevUShort_allowed()
 *	Description : Execution allowed for DevUShort attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevUShort_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevUShort command.
	/*----- PROTECTED REGION ID(TangoTest::DevUShortStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevUShortStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarCharArray_allowed()
 *	Description : Execution allowed for DevVarCharArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarCharArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarCharArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarCharArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarCharArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarDoubleArray_allowed()
 *	Description : Execution allowed for DevVarDoubleArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarDoubleArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarDoubleArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarDoubleArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarDoubleArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarDoubleStringArray_allowed()
 *	Description : Execution allowed for DevVarDoubleStringArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarDoubleStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarDoubleStringArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarDoubleStringArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarDoubleStringArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarFloatArray_allowed()
 *	Description : Execution allowed for DevVarFloatArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarFloatArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarFloatArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarFloatArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarFloatArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarLong64Array_allowed()
 *	Description : Execution allowed for DevVarLong64Array attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarLong64Array_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarLong64Array command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarLong64ArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarLong64ArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarLongArray_allowed()
 *	Description : Execution allowed for DevVarLongArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarLongArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarLongArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarLongArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarLongArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarLongStringArray_allowed()
 *	Description : Execution allowed for DevVarLongStringArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarLongStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarLongStringArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarLongStringArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarLongStringArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarShortArray_allowed()
 *	Description : Execution allowed for DevVarShortArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarShortArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarShortArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarShortArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarShortArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarStringArray_allowed()
 *	Description : Execution allowed for DevVarStringArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarStringArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarStringArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarStringArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarULong64Array_allowed()
 *	Description : Execution allowed for DevVarULong64Array attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarULong64Array_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarULong64Array command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarULong64ArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarULong64ArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarULongArray_allowed()
 *	Description : Execution allowed for DevVarULongArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarULongArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarULongArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarULongArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarULongArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVarUShortArray_allowed()
 *	Description : Execution allowed for DevVarUShortArray attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVarUShortArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVarUShortArray command.
	/*----- PROTECTED REGION ID(TangoTest::DevVarUShortArrayStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVarUShortArrayStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DevVoid_allowed()
 *	Description : Execution allowed for DevVoid attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DevVoid_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DevVoid command.
	/*----- PROTECTED REGION ID(TangoTest::DevVoidStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DevVoidStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_DumpExecutionState_allowed()
 *	Description : Execution allowed for DumpExecutionState attribute
 */
//--------------------------------------------------------
bool TangoTest::is_DumpExecutionState_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DumpExecutionState command.
	/*----- PROTECTED REGION ID(TangoTest::DumpExecutionStateStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::DumpExecutionStateStateAllowed
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::is_SwitchStates_allowed()
 *	Description : Execution allowed for SwitchStates attribute
 */
//--------------------------------------------------------
bool TangoTest::is_SwitchStates_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for SwitchStates command.
	/*----- PROTECTED REGION ID(TangoTest::SwitchStatesStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	TangoTest::SwitchStatesStateAllowed
	return true;
}

}	//	End of namespace
