from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


Event = _Mock()

Lock = _Mock()

check_exclusions_exist = _Mock()

extract_version = _Mock()

glob = _Mock()

have = _Mock()

import_item = _Mock()

is_cmd_found = _Mock()

knownfailureif = _Mock()

min_zmq = _Mock()

monkeypatch_xunit = _Mock()

nose = _Mock()

os = _Mock()

path = _Mock()

pjoin = _Mock()

print_function = _Mock()

run_iptest = _Mock()

safe_str = _Mock()

sec = _Mock()

sys = _Mock()

test_for = _Mock()

test_group_names = _Mock()

test_sections = _Mock()

warnings = _Mock()



class BytesIO(_Mock):
  pass


class ExclusionPlugin(_Mock):
  pass
  can_configure = False
  enabled = False
  name = 'exclusions'
  score = 3000

class IPythonDoctest(_Mock):
  pass
  can_configure = False
  enabled = True
  name = 'ipdoctest'
  score = 100

class KnownFailure(_Mock):
  pass
  can_configure = False
  enabled = True
  score = 1000

class Plugin(_Mock):
  pass
  can_configure = False
  enabled = False
  score = 100

class SkipTest(_Mock):
  pass


class StreamCapturer(_Mock):
  pass
  _Thread__initialized = False
  daemon = True
  started = False

class SubprocessStreamCapturePlugin(_Mock):
  pass
  can_configure = False
  enabled = False
  name = 'subprocstreams'
  score = 100

class TestProgram(_Mock):
  pass
  USAGE = "Usage: %(progName)s [options] [test] [...]\n\nOptions:\n  -h, --help       Show this message\n  -v, --verbose    Verbose output\n  -q, --quiet      Minimal output\n%(failfast)s%(catchbreak)s%(buffer)s\nExamples:\n  %(progName)s                               - run default set of tests\n  %(progName)s MyTestSuite                   - run suite 'MyTestSuite'\n  %(progName)s MyTestCase.testSomething      - run MyTestCase.testSomething\n  %(progName)s MyTestCase                    - run all 'test*' test methods\n                                               in MyTestCase\n"
  verbosity = 1

class TestSection(_Mock):
  pass


class Thread(_Mock):
  pass
  _Thread__initialized = False

class Xunit(_Mock):
  pass
  can_configure = False
  enabled = False
  encoding = 'UTF-8'
  name = 'xunit'
  score = 1500

