/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.piccolo2d.PNode;
import org.piccolo2d.extras.swt.SWTGraphics2D;
import org.piccolo2d.extras.swt.SWTShapeManager;
import org.piccolo2d.util.PAffineTransform;
import org.piccolo2d.util.PAffineTransformException;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class PSWTPath
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SHAPE = "shape";
    private static final String PROPERTY_PATH = "path";
    private static final int PROPERTY_CODE_PATH = 262144;
    private static final String PROPERTY_STROKE_PAINT = "strokePaint";
    private static final int PROPERTY_CODE_STROKE_PAINT = 65536;
    private static final double BOUNDS_TOLERANCE = 0.01;
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final RoundRectangle2D.Float TEMP_ROUNDRECTANGLE = new RoundRectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    private static final float PEN_WIDTH = 1.0f;
    private static final float DEFAULT_TRANSPARENCY = 1.0f;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;
    private boolean updatingBoundsFromPath;
    private Shape origShape;
    private Shape shape;
    private PAffineTransform internalXForm;
    private AffineTransform inverseXForm;
    private double[] shapePts;
    private float transparency = 1.0f;

    public static PSWTPath createRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_RECTANGLE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createRoundRectangle(float x, float y, float width, float height, float arcWidth, float arcHeight) {
        TEMP_ROUNDRECTANGLE.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        PSWTPath result = new PSWTPath(TEMP_ROUNDRECTANGLE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        PSWTPath result = new PSWTPath(TEMP_ELLIPSE);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(Point2D[] points) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(points);
        result.setPaint(Color.white);
        return result;
    }

    public static PSWTPath createPolyline(float[] xp, float[] yp) {
        PSWTPath result = new PSWTPath();
        result.setPathToPolyline(xp, yp);
        result.setPaint(Color.white);
        return result;
    }

    public PSWTPath() {
    }

    public PSWTPath(Shape aShape) {
        this();
        this.setShape(aShape);
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokeColor(Paint strokeColor) {
        Paint old = this.strokePaint;
        this.strokePaint = strokeColor;
        this.invalidatePaint();
        this.firePropertyChange(65536, PROPERTY_STROKE_PAINT, old, this.strokePaint);
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        if (this.updatingBoundsFromPath) {
            return;
        }
        if (this.origShape == null) {
            return;
        }
        Rectangle2D pathBounds = this.origShape.getBounds2D();
        if (Math.abs(x - pathBounds.getX()) / x < 0.01 && Math.abs(y - pathBounds.getY()) / y < 0.01 && Math.abs(width - pathBounds.getWidth()) / width < 0.01 && Math.abs(height - pathBounds.getHeight()) / height < 0.01) {
            return;
        }
        if (this.internalXForm == null) {
            this.internalXForm = new PAffineTransform();
        }
        this.internalXForm.setToIdentity();
        this.internalXForm.translate(x, y);
        this.internalXForm.scale(width / pathBounds.getWidth(), height / pathBounds.getHeight());
        this.internalXForm.translate(-pathBounds.getX(), -pathBounds.getY());
        try {
            this.inverseXForm = this.internalXForm.createInverse();
        }
        catch (Exception e) {
            throw new PAffineTransformException("unable to invert transform", this.internalXForm);
        }
    }

    public boolean intersects(Rectangle2D aBounds) {
        if (super.intersects(aBounds)) {
            Rectangle2D srcBounds;
            if (this.internalXForm == null) {
                srcBounds = aBounds;
            } else {
                srcBounds = new PBounds(aBounds);
                this.internalXForm.inverseTransform(srcBounds, srcBounds);
            }
            if (this.getPaint() != null && this.shape.intersects(srcBounds)) {
                return true;
            }
            if (this.strokePaint != null) {
                return BASIC_STROKE.createStrokedShape(this.shape).intersects(srcBounds);
            }
        }
        return false;
    }

    public void updateBoundsFromPath() {
        this.updatingBoundsFromPath = true;
        if (this.origShape == null) {
            this.resetBounds();
        } else {
            Rectangle2D b = this.origShape.getBounds2D();
            super.setBounds(b.getX() - 1.0, b.getY() - 1.0, b.getWidth() + 2.0, b.getHeight() + 2.0);
        }
        this.updatingBoundsFromPath = false;
    }

    protected void paint(PPaintContext paintContext) {
        Paint p = this.getPaint();
        SWTGraphics2D g2 = (SWTGraphics2D)paintContext.getGraphics();
        g2.setTransparency(this.transparency);
        if (this.internalXForm != null) {
            g2.transform((AffineTransform)this.internalXForm);
        }
        if (p != null) {
            g2.setBackground((Color)p);
            this.fillShape(g2);
        }
        if (this.strokePaint != null) {
            g2.setColor((Color)this.strokePaint);
            this.drawShape(g2);
        }
        if (this.inverseXForm != null) {
            g2.transform(this.inverseXForm);
        }
    }

    private void drawShape(SWTGraphics2D g2) {
        double lineWidth = g2.getTransformedLineWidth();
        if (this.shape instanceof Rectangle2D) {
            g2.drawRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
        } else if (this.shape instanceof Ellipse2D) {
            g2.drawOval(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
        } else if (this.shape instanceof Arc2D) {
            g2.drawArc(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
        } else if (this.shape instanceof RoundRectangle2D) {
            g2.drawRoundRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
        } else {
            g2.draw(this.shape);
        }
    }

    private void fillShape(SWTGraphics2D g2) {
        double lineWidth = g2.getTransformedLineWidth();
        if (this.shape instanceof Rectangle2D) {
            g2.fillRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
        } else if (this.shape instanceof Ellipse2D) {
            g2.fillOval(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth);
        } else if (this.shape instanceof Arc2D) {
            g2.fillArc(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
        } else if (this.shape instanceof RoundRectangle2D) {
            g2.fillRoundRect(this.shapePts[0] + lineWidth / 2.0, this.shapePts[1] + lineWidth / 2.0, this.shapePts[2] - lineWidth, this.shapePts[3] - lineWidth, this.shapePts[4], this.shapePts[5]);
        } else {
            g2.fill(this.shape);
        }
    }

    public void setShape(Shape newShape) {
        this.origShape = this.shape = this.cloneShape(newShape);
        this.updateShapePoints(newShape);
        this.firePropertyChange(262144, PROPERTY_PATH, null, this.shape);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void updateShapePoints(Shape aShape) {
        if (aShape instanceof Rectangle2D) {
            if (this.shapePts == null || this.shapePts.length < 4) {
                this.shapePts = new double[4];
            }
            this.shapePts[0] = ((Rectangle2D)this.shape).getX();
            this.shapePts[1] = ((Rectangle2D)this.shape).getY();
            this.shapePts[2] = ((Rectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((Rectangle2D)this.shape).getHeight();
        } else if (aShape instanceof Ellipse2D) {
            if (this.shapePts == null || this.shapePts.length < 4) {
                this.shapePts = new double[4];
            }
            this.shapePts[0] = ((Ellipse2D)this.shape).getX();
            this.shapePts[1] = ((Ellipse2D)this.shape).getY();
            this.shapePts[2] = ((Ellipse2D)this.shape).getWidth();
            this.shapePts[3] = ((Ellipse2D)this.shape).getHeight();
        } else if (aShape instanceof Arc2D) {
            if (this.shapePts == null || this.shapePts.length < 6) {
                this.shapePts = new double[6];
            }
            this.shapePts[0] = ((Arc2D)this.shape).getX();
            this.shapePts[1] = ((Arc2D)this.shape).getY();
            this.shapePts[2] = ((Arc2D)this.shape).getWidth();
            this.shapePts[3] = ((Arc2D)this.shape).getHeight();
            this.shapePts[4] = ((Arc2D)this.shape).getAngleStart();
            this.shapePts[5] = ((Arc2D)this.shape).getAngleExtent();
        } else if (aShape instanceof RoundRectangle2D) {
            if (this.shapePts == null || this.shapePts.length < 6) {
                this.shapePts = new double[6];
            }
            this.shapePts[0] = ((RoundRectangle2D)this.shape).getX();
            this.shapePts[1] = ((RoundRectangle2D)this.shape).getY();
            this.shapePts[2] = ((RoundRectangle2D)this.shape).getWidth();
            this.shapePts[3] = ((RoundRectangle2D)this.shape).getHeight();
            this.shapePts[4] = ((RoundRectangle2D)this.shape).getArcWidth();
            this.shapePts[5] = ((RoundRectangle2D)this.shape).getArcHeight();
        } else {
            this.shapePts = SWTShapeManager.shapeToPolyline(this.shape);
        }
    }

    public Shape cloneShape(Shape aShape) {
        if (aShape instanceof Rectangle2D) {
            return new PBounds((Rectangle2D)aShape);
        }
        if (aShape instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)aShape;
            return new Ellipse2D.Double(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        }
        if (aShape instanceof Arc2D) {
            Arc2D a2 = (Arc2D)aShape;
            return new Arc2D.Double(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent(), a2.getArcType());
        }
        if (aShape instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)aShape;
            return new RoundRectangle2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        }
        if (aShape instanceof Line2D) {
            Line2D l2 = (Line2D)aShape;
            return new Line2D.Double(l2.getP1(), l2.getP2());
        }
        GeneralPath aPath = new GeneralPath();
        aPath.append(aShape, false);
        return aPath;
    }

    public void setPathToRectangle(float x, float y, float width, float height) {
        TEMP_RECTANGLE.setFrame(x, y, width, height);
        this.setShape(TEMP_RECTANGLE);
    }

    public void setPathToRoundRectangle(float x, float y, float width, float height, float arcWidth, float arcHeight) {
        TEMP_ROUNDRECTANGLE.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.setShape(TEMP_ROUNDRECTANGLE);
    }

    public void setPathToEllipse(float x, float y, float width, float height) {
        TEMP_ELLIPSE.setFrame(x, y, width, height);
        this.setShape(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] points) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo((float)points[0].getX(), (float)points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            path.lineTo((float)points[i].getX(), (float)points[i].getY());
        }
        this.setShape(path);
    }

    public void setPathToPolyline(float[] xp, float[] yp) {
        GeneralPath path = new GeneralPath();
        path.reset();
        path.moveTo(xp[0], yp[0]);
        for (int i = 1; i < xp.length; ++i) {
            path.lineTo(xp[i], yp[i]);
        }
        this.setShape(path);
    }

    public Point2D getCenter() {
        PBounds bounds = this.getBoundsReference();
        return new Point2D.Double(bounds.x + bounds.width / 2.0, bounds.y + bounds.height / 2.0);
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        if (transparency < 0.0f || transparency > 1.0f) {
            throw new IllegalArgumentException("transparency must be between 0.0f and 1.0f inclusive");
        }
        this.transparency = transparency;
    }
}

