\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{foils99}[1999/09/08 v1 class for foils 'eurobm' (EuroTeX 99)]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{common99}}
\ProcessOptions*\relax
\LoadClass{common99}

% Layout
\setlength{\paperwidth}{296mm}
\addtolength{\oddsidemargin}{-0.5mm}
\setlength{\evensidemargin}{\oddsidemargin}
\setlength{\paperheight}{222mm}

\RequirePackage{color,thumbpdf}
\RequirePackage{wasysym}

\RequirePackage[
  colorlinks,
  bookmarksopen,
  bookmarksopenlevel=0,
%  pdfpagemode=FullScreen, % Problems with Linux
]{hyperref}

\pdfstringdefDisableCommands{%
  \let\\\textbackslash
}

\newcounter{dummy}

%%%
%%% Colors
%%%
\newcommand*\Red{\textcolor{red}}
\newcommand*\Blue{\textcolor{blue}}
\newcommand*\Green{\textcolor{green}}
\definecolor{green}{rgb}{0,0.5,0}
\newcommand*\BlueEmph[1]{\Blue{\emph{#1}}}
%%%

\newcommand*{\Email}[1]{%
  \href{mailto:#1}{#1}%
}


\newcommand*{\Siehe}[2][]{%
  \hyperlink{#2}{%
    \begingroup
      \ifx\\#1\\%
        \footnotesize
        \ButtonBox{Siehe}%
      \else
        \setlength{\fboxsep}{0.6\fboxsep}%
        \ButtonBox{#1}%
      \fi
    \endgroup
  }%
}


%%% Navigation
\newcommand*{\ButtonBox}[1]{%
  \begingroup
    \setlength{\fboxsep}{.75\fboxsep}%
    \colorbox{yellow}{\textcolor{black}{#1}}%
  \endgroup
}

\newcommand*{\AcroButton}[2]{%
  \Acrobatmenu{#1}{%
    \begingroup
      \footnotesize
      \ButtonBox{#2}%
    \endgroup
  }%
}
\newcommand*{\NavSep}{\quad}

\newcommand*{\SetNav}[1]{\rightfooter{#1}}
\newcommand*{\Navigation}[1]{%
  \rightfooter{%
    \NavFull\NavSep
    \ifx\\#1\\%
    \else
      \@ReturnAfterFi{\@ScanNavArg#1\END}%
    \fi
    \NavPrev\NavSep\NavNext
  }%
}
\def\@ScanNavArg#1#2\END{%
  #1\NavSep
  \ifx\\#2\\\else
    \@ReturnAfterFi{%
      \@ScanNavArg#2\END
    }%
  \fi
}

\newenvironment{Nav}[1]{%
  \Navigation{#1}%
}{
  \clearpage
  \Navigation{}%
}

\MyLogo{}
\Navigation{}



%%% Text annotations

\newlength{\x@temp}
\newlength{\AnnotRand}
\setlength{\AnnotRand}{8mm}

\newcommand{\annot@width}{10cm}

\@ifundefined{pdfannotlink}{%
  \let\pdfannotlink\pdfstartlink
}{}

\newcommand{\Remark}[2][]{%
  \begingroup
    \pdfstringdef\x@title{#1}%
    \edef\r{\string\r}%
    \pdfstringdef\x@contents{#2}%
    \settoheight{\x@temp}{X}%
    \mbox{%
      \pdfannotlink
        width\annot@width
        height\x@temp
        depth 5cm
        user {%
          /Subtype /Text
          /T (\x@title)
          /Contents (\x@contents)
        }%
      \pdfendlink
    }%
  \endgroup
}


\endinput
