/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "global-manager.h"

GlobalManager *GlobalManager::m_globalManager = nullptr;

GlobalManager::GlobalManager()
{
    m_pBright = new Brightness();
    m_pSignal = new GlobalSignal();
    QDBusConnection sessionBug = QDBusConnection::sessionBus();
    if (sessionBug.registerService("org.ukui.SettingsDaemon")) {
        sessionBug.registerObject(DBUS_GC_BRIGHTNESS_PATH, m_pBright,
                                 QDBusConnection::ExportAllSlots | QDBusConnection::ExportAllSignals
                                 );

        sessionBug.registerObject("/GlobalSignal", m_pSignal,
                                 QDBusConnection::ExportAllSlots | QDBusConnection::ExportAllSignals
                                 );

    }
}

GlobalManager::~GlobalManager()
{
    if (m_pBright != nullptr) {
        delete m_pBright;
        m_pBright = nullptr;
    }

    if (m_pSignal != nullptr) {
        delete m_pSignal;
        m_pSignal = nullptr;
    }
}

GlobalManager *GlobalManager::GlobalManagerNew()
{
    if (m_globalManager == nullptr) {
        m_globalManager = new GlobalManager();
    }

    return m_globalManager;
}

void GlobalManager::start()
{

}

void GlobalManager::stop()
{

}
