// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UABDL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UABDL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uabdl2_4S[] = {
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x00007fff, 0x00000001,
  0x00000002, 0x00007ffe, 0x00007ffe, 0x00000002,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00000010,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x0000007d,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x0000007e,
  0x00007fed, 0x00007f81, 0x00007f81, 0x0000007f,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00003333,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x00005555,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x00007ffd,
  0x00004cca, 0x00002aa9, 0x00000002, 0x00007ffe,
  0x00002aa8, 0x00000001, 0x00000001, 0x00007fff,
  0x00000000, 0x00000000, 0x00000000, 0x00008000,
  0x00000001, 0x00000001, 0x00000001, 0x00008001,
  0x00000002, 0x00000002, 0x00000002, 0x0000aaaa,
  0x00000003, 0x00000003, 0x00002aab, 0x0000cccc,
  0x00000004, 0x00002aac, 0x00004ccd, 0x0000ff80,
  0x00002aad, 0x00004cce, 0x00007f81, 0x0000ff81,
  0x00004ccf, 0x00007f82, 0x00007f82, 0x0000ff82,
  0x00007f83, 0x00007f83, 0x00007f83, 0x0000ff83,
  0x00007f84, 0x00007f84, 0x00007f84, 0x0000fff0,
  0x00007f85, 0x00007f85, 0x00007ff1, 0x0000fffd,
  0x00007f86, 0x00007ff2, 0x00007ffe, 0x0000fffe,
  0x00007ff3, 0x00007fff, 0x00007fff, 0x0000ffff,
  0x00007fff, 0x00007fff, 0x0000ffff, 0x00000001,
  0x00008000, 0x00008000, 0x00000000, 0x00000000,
  0x00008001, 0x00007fff, 0x00000001, 0x00000001,
  0x00007ffe, 0x00007ffe, 0x00000002, 0x0000000f,
  0x00007ffd, 0x00007ffd, 0x00000010, 0x0000007c,
  0x00007ffc, 0x00007fef, 0x0000007d, 0x0000007d,
  0x00007fee, 0x00007f82, 0x0000007e, 0x0000007e,
  0x00007f81, 0x00007f81, 0x0000007f, 0x00003332,
  0x00007f80, 0x00007f80, 0x00003333, 0x00005554,
  0x00007f7f, 0x00004ccc, 0x00005555, 0x00007ffc,
  0x00004ccb, 0x00002aaa, 0x00007ffd, 0x00007ffd,
  0x00002aa9, 0x00000002, 0x00007ffe, 0x00007ffe,
  0x00000001, 0x00000001, 0x00007fff, 0x00007fff,
  0x00000000, 0x00000000, 0x00008000, 0x00008000,
  0x00000001, 0x00000001, 0x00008001, 0x0000aaa9,
  0x00000002, 0x00000002, 0x0000aaaa, 0x0000cccb,
  0x00000003, 0x00002aab, 0x0000cccc, 0x0000ff7f,
  0x00002aac, 0x00004ccd, 0x0000ff80, 0x0000ff80,
  0x00004cce, 0x00007f81, 0x0000ff81, 0x0000ff81,
  0x00007f82, 0x00007f82, 0x0000ff82, 0x0000ff82,
  0x00007f83, 0x00007f83, 0x0000ff83, 0x0000ffef,
  0x00007f84, 0x00007f84, 0x0000fff0, 0x0000fffc,
  0x00007f85, 0x00007ff1, 0x0000fffd, 0x0000fffd,
  0x00007ff2, 0x00007ffe, 0x0000fffe, 0x0000fffe,
  0x00007ffe, 0x0000fffe, 0x0000fffe, 0x00000002,
  0x00007fff, 0x0000ffff, 0x00000001, 0x00000001,
  0x00008000, 0x00000000, 0x00000000, 0x00000000,
  0x00007fff, 0x00000001, 0x00000001, 0x0000000e,
  0x00007ffe, 0x00000002, 0x0000000f, 0x0000007b,
  0x00007ffd, 0x00000010, 0x0000007c, 0x0000007c,
  0x00007fef, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00007f82, 0x0000007e, 0x0000007e, 0x00003331,
  0x00007f81, 0x0000007f, 0x00003332, 0x00005553,
  0x00007f80, 0x00003333, 0x00005554, 0x00007ffb,
  0x00004ccc, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00002aaa, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00000002, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00000001, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00000000, 0x00008000, 0x00008000, 0x0000aaa8,
  0x00000001, 0x00008001, 0x0000aaa9, 0x0000ccca,
  0x00000002, 0x0000aaaa, 0x0000cccb, 0x0000ff7e,
  0x00002aab, 0x0000cccc, 0x0000ff7f, 0x0000ff7f,
  0x00004ccd, 0x0000ff80, 0x0000ff80, 0x0000ff80,
  0x00007f81, 0x0000ff81, 0x0000ff81, 0x0000ff81,
  0x00007f82, 0x0000ff82, 0x0000ff82, 0x0000ffee,
  0x00007f83, 0x0000ff83, 0x0000ffef, 0x0000fffb,
  0x00007f84, 0x0000fff0, 0x0000fffc, 0x0000fffc,
  0x00007ff1, 0x0000fffd, 0x0000fffd, 0x0000fffd,
  0x0000fffd, 0x0000fffd, 0x0000fffd, 0x00000010,
  0x0000fffe, 0x0000fffe, 0x00000002, 0x0000000f,
  0x0000ffff, 0x00000001, 0x00000001, 0x0000000e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x0000000e, 0x0000006d,
  0x00000002, 0x0000000f, 0x0000007b, 0x0000006e,
  0x00000010, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00003323,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00007ff0,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x00007ff1,
  0x00007fff, 0x00007fff, 0x00007fff, 0x0000aa9a,
  0x00008000, 0x00008000, 0x0000aaa8, 0x0000ccbc,
  0x00008001, 0x0000aaa9, 0x0000ccca, 0x0000ff70,
  0x0000aaaa, 0x0000cccb, 0x0000ff7e, 0x0000ff71,
  0x0000cccc, 0x0000ff7f, 0x0000ff7f, 0x0000ff72,
  0x0000ff80, 0x0000ff80, 0x0000ff80, 0x0000ff73,
  0x0000ff81, 0x0000ff81, 0x0000ff81, 0x0000ffe0,
  0x0000ff82, 0x0000ff82, 0x0000ffee, 0x0000ffed,
  0x0000ff83, 0x0000ffef, 0x0000fffb, 0x0000ffee,
  0x0000fff0, 0x0000fffc, 0x0000fffc, 0x0000ffef,
  0x0000fffc, 0x0000fffc, 0x0000ffef, 0x0000007d,
  0x0000fffd, 0x0000fffd, 0x00000010, 0x0000007c,
  0x0000fffe, 0x00000002, 0x0000000f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000000e, 0x0000006d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x0000000e, 0x0000006d, 0x00000001,
  0x0000000f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000007c, 0x0000007c, 0x0000006f, 0x000032b6,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x00007f83,
  0x00007ffd, 0x00007ffd, 0x00007ff0, 0x00007f84,
  0x00007ffe, 0x00007ffe, 0x00007ff1, 0x0000aa2d,
  0x00007fff, 0x00007fff, 0x0000aa9a, 0x0000cc4f,
  0x00008000, 0x0000aaa8, 0x0000ccbc, 0x0000ff03,
  0x0000aaa9, 0x0000ccca, 0x0000ff70, 0x0000ff04,
  0x0000cccb, 0x0000ff7e, 0x0000ff71, 0x0000ff05,
  0x0000ff7f, 0x0000ff7f, 0x0000ff72, 0x0000ff06,
  0x0000ff80, 0x0000ff80, 0x0000ff73, 0x0000ff73,
  0x0000ff81, 0x0000ff81, 0x0000ffe0, 0x0000ff80,
  0x0000ff82, 0x0000ffee, 0x0000ffed, 0x0000ff81,
  0x0000ffef, 0x0000fffb, 0x0000ffee, 0x0000ff82,
  0x0000fffb, 0x0000ffee, 0x0000ff82, 0x0000007e,
  0x0000fffc, 0x0000ffef, 0x0000007d, 0x0000007d,
  0x0000fffd, 0x00000010, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000000f, 0x0000007b, 0x0000006e,
  0x00000001, 0x0000000e, 0x0000006d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000000e, 0x0000006d, 0x00000001, 0x00000001,
  0x0000007b, 0x0000006e, 0x00000002, 0x000032b5,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x00007f82,
  0x00007ffc, 0x00007fef, 0x00007f83, 0x00007f83,
  0x00007ffd, 0x00007ff0, 0x00007f84, 0x0000aa2c,
  0x00007ffe, 0x00007ff1, 0x0000aa2d, 0x0000cc4e,
  0x00007fff, 0x0000aa9a, 0x0000cc4f, 0x0000ff02,
  0x0000aaa8, 0x0000ccbc, 0x0000ff03, 0x0000ff03,
  0x0000ccca, 0x0000ff70, 0x0000ff04, 0x0000ff04,
  0x0000ff7e, 0x0000ff71, 0x0000ff05, 0x0000ff05,
  0x0000ff7f, 0x0000ff72, 0x0000ff06, 0x0000ff72,
  0x0000ff80, 0x0000ff73, 0x0000ff73, 0x0000ff7f,
  0x0000ff81, 0x0000ffe0, 0x0000ff80, 0x0000ff80,
  0x0000ffee, 0x0000ffed, 0x0000ff81, 0x0000ff81,
  0x0000ffed, 0x0000ff81, 0x0000ff81, 0x0000007f,
  0x0000ffee, 0x0000ff82, 0x0000007e, 0x0000007e,
  0x0000ffef, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000010, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000000f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000000e, 0x0000006d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000006d, 0x00000001, 0x00000001, 0x000032b4,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00007fed, 0x00007f81, 0x00007f81, 0x00007f81,
  0x00007fee, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00007fef, 0x00007f83, 0x00007f83, 0x0000aa2b,
  0x00007ff0, 0x00007f84, 0x0000aa2c, 0x0000cc4d,
  0x00007ff1, 0x0000aa2d, 0x0000cc4e, 0x0000ff01,
  0x0000aa9a, 0x0000cc4f, 0x0000ff02, 0x0000ff02,
  0x0000ccbc, 0x0000ff03, 0x0000ff03, 0x0000ff03,
  0x0000ff70, 0x0000ff04, 0x0000ff04, 0x0000ff04,
  0x0000ff71, 0x0000ff05, 0x0000ff05, 0x0000ff71,
  0x0000ff72, 0x0000ff06, 0x0000ff72, 0x0000ff7e,
  0x0000ff73, 0x0000ff73, 0x0000ff7f, 0x0000ff7f,
  0x0000ffe0, 0x0000ff80, 0x0000ff80, 0x0000ff80,
  0x0000ff80, 0x0000ff80, 0x0000ff80, 0x00003333,
  0x0000ff81, 0x0000ff81, 0x0000007f, 0x00003332,
  0x0000ff82, 0x0000007e, 0x0000007e, 0x00003331,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00003323,
  0x0000007c, 0x0000007c, 0x0000006f, 0x000032b6,
  0x0000007b, 0x0000006e, 0x00000002, 0x000032b5,
  0x0000006d, 0x00000001, 0x00000001, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00004ccd,
  0x00007f81, 0x00007f81, 0x00007f81, 0x00004cce,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00007777,
  0x00007f83, 0x00007f83, 0x0000aa2b, 0x00009999,
  0x00007f84, 0x0000aa2c, 0x0000cc4d, 0x0000cc4d,
  0x0000aa2d, 0x0000cc4e, 0x0000ff01, 0x0000cc4e,
  0x0000cc4f, 0x0000ff02, 0x0000ff02, 0x0000cc4f,
  0x0000ff03, 0x0000ff03, 0x0000ff03, 0x0000cc50,
  0x0000ff04, 0x0000ff04, 0x0000ff04, 0x0000ccbd,
  0x0000ff05, 0x0000ff05, 0x0000ff71, 0x0000ccca,
  0x0000ff06, 0x0000ff72, 0x0000ff7e, 0x0000cccb,
  0x0000ff73, 0x0000ff7f, 0x0000ff7f, 0x0000cccc,
  0x0000ff7f, 0x0000ff7f, 0x0000cccc, 0x00005555,
  0x0000ff80, 0x0000ff80, 0x00003333, 0x00005554,
  0x0000ff81, 0x0000007f, 0x00003332, 0x00005553,
  0x0000007e, 0x0000007e, 0x00003331, 0x00005545,
  0x0000007d, 0x0000007d, 0x00003323, 0x000054d8,
  0x0000007c, 0x0000006f, 0x000032b6, 0x000054d7,
  0x0000006e, 0x00000002, 0x000032b5, 0x000054d6,
  0x00000001, 0x00000001, 0x000032b4, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x00002aab,
  0x00007f80, 0x00007f80, 0x00004ccd, 0x00002aac,
  0x00007f81, 0x00007f81, 0x00004cce, 0x00005555,
  0x00007f82, 0x00007f82, 0x00007777, 0x00007777,
  0x00007f83, 0x0000aa2b, 0x00009999, 0x0000aa2b,
  0x0000aa2c, 0x0000cc4d, 0x0000cc4d, 0x0000aa2c,
  0x0000cc4e, 0x0000ff01, 0x0000cc4e, 0x0000aa2d,
  0x0000ff02, 0x0000ff02, 0x0000cc4f, 0x0000aa2e,
  0x0000ff03, 0x0000ff03, 0x0000cc50, 0x0000aa9b,
  0x0000ff04, 0x0000ff04, 0x0000ccbd, 0x0000aaa8,
  0x0000ff05, 0x0000ff71, 0x0000ccca, 0x0000aaa9,
  0x0000ff72, 0x0000ff7e, 0x0000cccb, 0x0000aaaa,
  0x0000ff7e, 0x0000cccb, 0x0000aaaa, 0x00007ffd,
  0x0000ff7f, 0x0000cccc, 0x00005555, 0x00007ffc,
  0x0000ff80, 0x00003333, 0x00005554, 0x00007ffb,
  0x0000007f, 0x00003332, 0x00005553, 0x00007fed,
  0x0000007e, 0x00003331, 0x00005545, 0x00007f80,
  0x0000007d, 0x00003323, 0x000054d8, 0x00007f7f,
  0x0000006f, 0x000032b6, 0x000054d7, 0x00007f7e,
  0x00000002, 0x000032b5, 0x000054d6, 0x00004cca,
  0x00000001, 0x000032b4, 0x00002222, 0x00002aa8,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x00000003,
  0x00007f7f, 0x00004ccc, 0x00002aab, 0x00000004,
  0x00007f80, 0x00004ccd, 0x00002aac, 0x00002aad,
  0x00007f81, 0x00004cce, 0x00005555, 0x00004ccf,
  0x00007f82, 0x00007777, 0x00007777, 0x00007f83,
  0x0000aa2b, 0x00009999, 0x0000aa2b, 0x00007f84,
  0x0000cc4d, 0x0000cc4d, 0x0000aa2c, 0x00007f85,
  0x0000ff01, 0x0000cc4e, 0x0000aa2d, 0x00007f86,
  0x0000ff02, 0x0000cc4f, 0x0000aa2e, 0x00007ff3,
  0x0000ff03, 0x0000cc50, 0x0000aa9b, 0x00008000,
  0x0000ff04, 0x0000ccbd, 0x0000aaa8, 0x00008001,
  0x0000ff71, 0x0000ccca, 0x0000aaa9, 0x00008002,
  0x0000ccca, 0x0000aaa9, 0x00008002, 0x00007ffe,
  0x0000cccb, 0x0000aaaa, 0x00007ffd, 0x00007ffd,
  0x0000cccc, 0x00005555, 0x00007ffc, 0x00007ffc,
  0x00003333, 0x00005554, 0x00007ffb, 0x00007fee,
  0x00003332, 0x00005553, 0x00007fed, 0x00007f81,
  0x00003331, 0x00005545, 0x00007f80, 0x00007f80,
  0x00003323, 0x000054d8, 0x00007f7f, 0x00007f7f,
  0x000032b6, 0x000054d7, 0x00007f7e, 0x00004ccb,
  0x000032b5, 0x000054d6, 0x00004cca, 0x00002aa9,
  0x000032b4, 0x00002222, 0x00002aa8, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00004cca, 0x00002aa9, 0x00000002, 0x00000002,
  0x00004ccb, 0x00002aaa, 0x00000003, 0x00000003,
  0x00004ccc, 0x00002aab, 0x00000004, 0x00002aac,
  0x00004ccd, 0x00002aac, 0x00002aad, 0x00004cce,
  0x00004cce, 0x00005555, 0x00004ccf, 0x00007f82,
  0x00007777, 0x00007777, 0x00007f83, 0x00007f83,
  0x00009999, 0x0000aa2b, 0x00007f84, 0x00007f84,
  0x0000cc4d, 0x0000aa2c, 0x00007f85, 0x00007f85,
  0x0000cc4e, 0x0000aa2d, 0x00007f86, 0x00007ff2,
  0x0000cc4f, 0x0000aa2e, 0x00007ff3, 0x00007fff,
  0x0000cc50, 0x0000aa9b, 0x00008000, 0x00008000,
  0x0000ccbd, 0x0000aaa8, 0x00008001, 0x00008001,
  0x0000aaa8, 0x00008001, 0x00008001, 0x00007fff,
  0x0000aaa9, 0x00008002, 0x00007ffe, 0x00007ffe,
  0x0000aaaa, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x00005555, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x00005554, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x00005553, 0x00007fed, 0x00007f81, 0x00007f81,
  0x00005545, 0x00007f80, 0x00007f80, 0x00007f80,
  0x000054d8, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x000054d7, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x000054d6, 0x00004cca, 0x00002aa9, 0x00000002,
  0x00002222, 0x00002aa8, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002aa8, 0x00000001, 0x00000001, 0x00000001,
  0x00002aa9, 0x00000002, 0x00000002, 0x00000002,
  0x00002aaa, 0x00000003, 0x00000003, 0x00002aab,
  0x00002aab, 0x00000004, 0x00002aac, 0x00004ccd,
  0x00002aac, 0x00002aad, 0x00004cce, 0x00007f81,
  0x00005555, 0x00004ccf, 0x00007f82, 0x00007f82,
  0x00007777, 0x00007f83, 0x00007f83, 0x00007f83,
  0x0000aa2b, 0x00007f84, 0x00007f84, 0x00007f84,
  0x0000aa2c, 0x00007f85, 0x00007f85, 0x00007ff1,
  0x0000aa2d, 0x00007f86, 0x00007ff2, 0x00007ffe,
  0x0000aa2e, 0x00007ff3, 0x00007fff, 0x00007fff,
  0x0000aa9b, 0x00008000, 0x00008000, 0x00008000,
  0x00008000, 0x00008000, 0x00008000, 0x00008000,
  0x00008001, 0x00008001, 0x00007fff, 0x00007fff,
  0x00008002, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x00007ff0,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x00007f83,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x00007f82,
  0x00007fed, 0x00007f81, 0x00007f81, 0x00007f81,
  0x00007f80, 0x00007f80, 0x00007f80, 0x00004ccd,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x00002aab,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x00000003,
  0x00004cca, 0x00002aa9, 0x00000002, 0x00000002,
  0x00002aa8, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x00000001, 0x00000001,
  0x00000002, 0x00000002, 0x00000002, 0x00002aaa,
  0x00000003, 0x00000003, 0x00002aab, 0x00004ccc,
  0x00000004, 0x00002aac, 0x00004ccd, 0x00007f80,
  0x00002aad, 0x00004cce, 0x00007f81, 0x00007f81,
  0x00004ccf, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00007f83, 0x00007f83, 0x00007f83, 0x00007f83,
  0x00007f84, 0x00007f84, 0x00007f84, 0x00007ff0,
  0x00007f85, 0x00007f85, 0x00007ff1, 0x00007ffd,
  0x00007f86, 0x00007ff2, 0x00007ffe, 0x00007ffe,
  0x00007ff3, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00007fff, 0x00007fff, 0x00007fff, 0x00008001,
  0x00008000, 0x00008000, 0x00008000, 0x00008000,
  0x00008001, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x00007ff1,
  0x00007ffd, 0x00007ffd, 0x00007ff0, 0x00007f84,
  0x00007ffc, 0x00007fef, 0x00007f83, 0x00007f83,
  0x00007fee, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00007f81, 0x00007f81, 0x00007f81, 0x00004cce,
  0x00007f80, 0x00007f80, 0x00004ccd, 0x00002aac,
  0x00007f7f, 0x00004ccc, 0x00002aab, 0x00000004,
  0x00004ccb, 0x00002aaa, 0x00000003, 0x00000003,
  0x00002aa9, 0x00000002, 0x00000002, 0x00000002,
  0x00000001, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x00000001, 0x00002aa9,
  0x00000002, 0x00000002, 0x00002aaa, 0x00004ccb,
  0x00000003, 0x00002aab, 0x00004ccc, 0x00007f7f,
  0x00002aac, 0x00004ccd, 0x00007f80, 0x00007f80,
  0x00004cce, 0x00007f81, 0x00007f81, 0x00007f81,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00007f83, 0x00007f83, 0x00007f83, 0x00007fef,
  0x00007f84, 0x00007f84, 0x00007ff0, 0x00007ffc,
  0x00007f85, 0x00007ff1, 0x00007ffd, 0x00007ffd,
  0x00007ff2, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x0000aaaa,
  0x00007fff, 0x00007fff, 0x00008001, 0x0000aaa9,
  0x00008000, 0x00008000, 0x00008000, 0x0000aaa8,
  0x00007fff, 0x00007fff, 0x00007fff, 0x0000aa9a,
  0x00007ffe, 0x00007ffe, 0x00007ff1, 0x0000aa2d,
  0x00007ffd, 0x00007ff0, 0x00007f84, 0x0000aa2c,
  0x00007fef, 0x00007f83, 0x00007f83, 0x0000aa2b,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00007777,
  0x00007f81, 0x00007f81, 0x00004cce, 0x00005555,
  0x00007f80, 0x00004ccd, 0x00002aac, 0x00002aad,
  0x00004ccc, 0x00002aab, 0x00000004, 0x00002aac,
  0x00002aaa, 0x00000003, 0x00000003, 0x00002aab,
  0x00000002, 0x00000002, 0x00000002, 0x00002aaa,
  0x00000001, 0x00000001, 0x00000001, 0x00002aa9,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x00002aa9, 0x00002222,
  0x00000002, 0x00002aaa, 0x00004ccb, 0x000054d6,
  0x00002aab, 0x00004ccc, 0x00007f7f, 0x000054d7,
  0x00004ccd, 0x00007f80, 0x00007f80, 0x000054d8,
  0x00007f81, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00005546,
  0x00007f83, 0x00007f83, 0x00007fef, 0x00005553,
  0x00007f84, 0x00007ff0, 0x00007ffc, 0x00005554,
  0x00007ff1, 0x00007ffd, 0x00007ffd, 0x00005555,
  0x00007ffd, 0x00007ffd, 0x00005555, 0x0000cccc,
  0x00007ffe, 0x00007ffe, 0x0000aaaa, 0x0000cccb,
  0x00007fff, 0x00008001, 0x0000aaa9, 0x0000ccca,
  0x00008000, 0x00008000, 0x0000aaa8, 0x0000ccbc,
  0x00007fff, 0x00007fff, 0x0000aa9a, 0x0000cc4f,
  0x00007ffe, 0x00007ff1, 0x0000aa2d, 0x0000cc4e,
  0x00007ff0, 0x00007f84, 0x0000aa2c, 0x0000cc4d,
  0x00007f83, 0x00007f83, 0x0000aa2b, 0x00009999,
  0x00007f82, 0x00007f82, 0x00007777, 0x00007777,
  0x00007f81, 0x00004cce, 0x00005555, 0x00004ccf,
  0x00004ccd, 0x00002aac, 0x00002aad, 0x00004cce,
  0x00002aab, 0x00000004, 0x00002aac, 0x00004ccd,
  0x00000003, 0x00000003, 0x00002aab, 0x00004ccc,
  0x00000002, 0x00000002, 0x00002aaa, 0x00004ccb,
  0x00000001, 0x00000001, 0x00002aa9, 0x00002222,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00002aa9, 0x00002222, 0x000032b4,
  0x00002aaa, 0x00004ccb, 0x000054d6, 0x000032b5,
  0x00004ccc, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f81, 0x00007f81, 0x000054d9, 0x00003324,
  0x00007f82, 0x00007f82, 0x00005546, 0x00003331,
  0x00007f83, 0x00007fef, 0x00005553, 0x00003332,
  0x00007ff0, 0x00007ffc, 0x00005554, 0x00003333,
  0x00007ffc, 0x00005554, 0x00003333, 0x0000ff80,
  0x00007ffd, 0x00005555, 0x0000cccc, 0x0000ff7f,
  0x00007ffe, 0x0000aaaa, 0x0000cccb, 0x0000ff7e,
  0x00008001, 0x0000aaa9, 0x0000ccca, 0x0000ff70,
  0x00008000, 0x0000aaa8, 0x0000ccbc, 0x0000ff03,
  0x00007fff, 0x0000aa9a, 0x0000cc4f, 0x0000ff02,
  0x00007ff1, 0x0000aa2d, 0x0000cc4e, 0x0000ff01,
  0x00007f84, 0x0000aa2c, 0x0000cc4d, 0x0000cc4d,
  0x00007f83, 0x0000aa2b, 0x00009999, 0x0000aa2b,
  0x00007f82, 0x00007777, 0x00007777, 0x00007f83,
  0x00004cce, 0x00005555, 0x00004ccf, 0x00007f82,
  0x00002aac, 0x00002aad, 0x00004cce, 0x00007f81,
  0x00000004, 0x00002aac, 0x00004ccd, 0x00007f80,
  0x00000003, 0x00002aab, 0x00004ccc, 0x00007f7f,
  0x00000002, 0x00002aaa, 0x00004ccb, 0x000054d6,
  0x00000001, 0x00002aa9, 0x00002222, 0x000032b4,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002aa9, 0x00002222, 0x000032b4, 0x00000001,
  0x00004ccb, 0x000054d6, 0x000032b5, 0x00000002,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x00007f80, 0x000054d8, 0x000032b7, 0x00000070,
  0x00007f81, 0x000054d9, 0x00003324, 0x0000007d,
  0x00007f82, 0x00005546, 0x00003331, 0x0000007e,
  0x00007fef, 0x00005553, 0x00003332, 0x0000007f,
  0x00005553, 0x00003332, 0x0000007f, 0x0000ff81,
  0x00005554, 0x00003333, 0x0000ff80, 0x0000ff80,
  0x00005555, 0x0000cccc, 0x0000ff7f, 0x0000ff7f,
  0x0000aaaa, 0x0000cccb, 0x0000ff7e, 0x0000ff71,
  0x0000aaa9, 0x0000ccca, 0x0000ff70, 0x0000ff04,
  0x0000aaa8, 0x0000ccbc, 0x0000ff03, 0x0000ff03,
  0x0000aa9a, 0x0000cc4f, 0x0000ff02, 0x0000ff02,
  0x0000aa2d, 0x0000cc4e, 0x0000ff01, 0x0000cc4e,
  0x0000aa2c, 0x0000cc4d, 0x0000cc4d, 0x0000aa2c,
  0x0000aa2b, 0x00009999, 0x0000aa2b, 0x00007f84,
  0x00007777, 0x00007777, 0x00007f83, 0x00007f83,
  0x00005555, 0x00004ccf, 0x00007f82, 0x00007f82,
  0x00002aad, 0x00004cce, 0x00007f81, 0x00007f81,
  0x00002aac, 0x00004ccd, 0x00007f80, 0x00007f80,
  0x00002aab, 0x00004ccc, 0x00007f7f, 0x000054d7,
  0x00002aaa, 0x00004ccb, 0x000054d6, 0x000032b5,
  0x00002aa9, 0x00002222, 0x000032b4, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00002222, 0x000032b4, 0x00000001, 0x00000001,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000054d7, 0x000032b6, 0x00000003, 0x0000006f,
  0x000054d8, 0x000032b7, 0x00000070, 0x0000007c,
  0x000054d9, 0x00003324, 0x0000007d, 0x0000007d,
  0x00005546, 0x00003331, 0x0000007e, 0x0000007e,
  0x00003331, 0x0000007e, 0x0000007e, 0x0000ff82,
  0x00003332, 0x0000007f, 0x0000ff81, 0x0000ff81,
  0x00003333, 0x0000ff80, 0x0000ff80, 0x0000ff80,
  0x0000cccc, 0x0000ff7f, 0x0000ff7f, 0x0000ff72,
  0x0000cccb, 0x0000ff7e, 0x0000ff71, 0x0000ff05,
  0x0000ccca, 0x0000ff70, 0x0000ff04, 0x0000ff04,
  0x0000ccbc, 0x0000ff03, 0x0000ff03, 0x0000ff03,
  0x0000cc4f, 0x0000ff02, 0x0000ff02, 0x0000cc4f,
  0x0000cc4e, 0x0000ff01, 0x0000cc4e, 0x0000aa2d,
  0x0000cc4d, 0x0000cc4d, 0x0000aa2c, 0x00007f85,
  0x00009999, 0x0000aa2b, 0x00007f84, 0x00007f84,
  0x00007777, 0x00007f83, 0x00007f83, 0x00007f83,
  0x00004ccf, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00004cce, 0x00007f81, 0x00007f81, 0x00007f81,
  0x00004ccd, 0x00007f80, 0x00007f80, 0x000054d8,
  0x00004ccc, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00004ccb, 0x000054d6, 0x000032b5, 0x00000002,
  0x00002222, 0x000032b4, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x000032b5, 0x00000002, 0x00000002, 0x0000006e,
  0x000032b6, 0x00000003, 0x0000006f, 0x0000007b,
  0x000032b7, 0x00000070, 0x0000007c, 0x0000007c,
  0x00003324, 0x0000007d, 0x0000007d, 0x0000007d,
  0x0000007d, 0x0000007d, 0x0000007d, 0x0000ff83,
  0x0000007e, 0x0000007e, 0x0000ff82, 0x0000ff82,
  0x0000007f, 0x0000ff81, 0x0000ff81, 0x0000ff81,
  0x0000ff80, 0x0000ff80, 0x0000ff80, 0x0000ff73,
  0x0000ff7f, 0x0000ff7f, 0x0000ff72, 0x0000ff06,
  0x0000ff7e, 0x0000ff71, 0x0000ff05, 0x0000ff05,
  0x0000ff70, 0x0000ff04, 0x0000ff04, 0x0000ff04,
  0x0000ff03, 0x0000ff03, 0x0000ff03, 0x0000cc50,
  0x0000ff02, 0x0000ff02, 0x0000cc4f, 0x0000aa2e,
  0x0000ff01, 0x0000cc4e, 0x0000aa2d, 0x00007f86,
  0x0000cc4d, 0x0000aa2c, 0x00007f85, 0x00007f85,
  0x0000aa2b, 0x00007f84, 0x00007f84, 0x00007f84,
  0x00007f83, 0x00007f83, 0x00007f83, 0x00007f83,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00007f82,
  0x00007f81, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x00000001, 0x0000006d,
  0x00000002, 0x00000002, 0x0000006e, 0x0000007a,
  0x00000003, 0x0000006f, 0x0000007b, 0x0000007b,
  0x00000070, 0x0000007c, 0x0000007c, 0x0000007c,
  0x0000007c, 0x0000007c, 0x0000007c, 0x0000fff0,
  0x0000007d, 0x0000007d, 0x0000ff83, 0x0000ffef,
  0x0000007e, 0x0000ff82, 0x0000ff82, 0x0000ffee,
  0x0000ff81, 0x0000ff81, 0x0000ff81, 0x0000ffe0,
  0x0000ff80, 0x0000ff80, 0x0000ff73, 0x0000ff73,
  0x0000ff7f, 0x0000ff72, 0x0000ff06, 0x0000ff72,
  0x0000ff71, 0x0000ff05, 0x0000ff05, 0x0000ff71,
  0x0000ff04, 0x0000ff04, 0x0000ff04, 0x0000ccbd,
  0x0000ff03, 0x0000ff03, 0x0000cc50, 0x0000aa9b,
  0x0000ff02, 0x0000cc4f, 0x0000aa2e, 0x00007ff3,
  0x0000cc4e, 0x0000aa2d, 0x00007f86, 0x00007ff2,
  0x0000aa2c, 0x00007f85, 0x00007f85, 0x00007ff1,
  0x00007f84, 0x00007f84, 0x00007f84, 0x00007ff0,
  0x00007f83, 0x00007f83, 0x00007f83, 0x00007fef,
  0x00007f82, 0x00007f82, 0x00007f82, 0x00005546,
  0x00007f81, 0x00007f81, 0x000054d9, 0x00003324,
  0x00007f80, 0x000054d8, 0x000032b7, 0x00000070,
  0x000054d7, 0x000032b6, 0x00000003, 0x0000006f,
  0x000032b5, 0x00000002, 0x00000002, 0x0000006e,
  0x00000001, 0x00000001, 0x00000001, 0x0000006d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x00000001, 0x0000006d, 0x0000000d,
  0x00000002, 0x0000006e, 0x0000007a, 0x0000000e,
  0x0000006f, 0x0000007b, 0x0000007b, 0x0000000f,
  0x0000007b, 0x0000007b, 0x0000000f, 0x0000fffd,
  0x0000007c, 0x0000007c, 0x0000fff0, 0x0000fffc,
  0x0000007d, 0x0000ff83, 0x0000ffef, 0x0000fffb,
  0x0000ff82, 0x0000ff82, 0x0000ffee, 0x0000ffed,
  0x0000ff81, 0x0000ff81, 0x0000ffe0, 0x0000ff80,
  0x0000ff80, 0x0000ff73, 0x0000ff73, 0x0000ff7f,
  0x0000ff72, 0x0000ff06, 0x0000ff72, 0x0000ff7e,
  0x0000ff05, 0x0000ff05, 0x0000ff71, 0x0000ccca,
  0x0000ff04, 0x0000ff04, 0x0000ccbd, 0x0000aaa8,
  0x0000ff03, 0x0000cc50, 0x0000aa9b, 0x00008000,
  0x0000cc4f, 0x0000aa2e, 0x00007ff3, 0x00007fff,
  0x0000aa2d, 0x00007f86, 0x00007ff2, 0x00007ffe,
  0x00007f85, 0x00007f85, 0x00007ff1, 0x00007ffd,
  0x00007f84, 0x00007f84, 0x00007ff0, 0x00007ffc,
  0x00007f83, 0x00007f83, 0x00007fef, 0x00005553,
  0x00007f82, 0x00007f82, 0x00005546, 0x00003331,
  0x00007f81, 0x000054d9, 0x00003324, 0x0000007d,
  0x000054d8, 0x000032b7, 0x00000070, 0x0000007c,
  0x000032b6, 0x00000003, 0x0000006f, 0x0000007b,
  0x00000002, 0x00000002, 0x0000006e, 0x0000007a,
  0x00000001, 0x00000001, 0x0000006d, 0x0000000d,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000001, 0x0000006d, 0x0000000d, 0x00000001,
  0x0000006e, 0x0000007a, 0x0000000e, 0x00000002,
  0x0000007a, 0x0000000e, 0x00000002, 0x0000fffe,
  0x0000007b, 0x0000000f, 0x0000fffd, 0x0000fffd,
  0x0000007c, 0x0000fff0, 0x0000fffc, 0x0000fffc,
  0x0000ff83, 0x0000ffef, 0x0000fffb, 0x0000ffee,
  0x0000ff82, 0x0000ffee, 0x0000ffed, 0x0000ff81,
  0x0000ff81, 0x0000ffe0, 0x0000ff80, 0x0000ff80,
  0x0000ff73, 0x0000ff73, 0x0000ff7f, 0x0000ff7f,
  0x0000ff06, 0x0000ff72, 0x0000ff7e, 0x0000cccb,
  0x0000ff05, 0x0000ff71, 0x0000ccca, 0x0000aaa9,
  0x0000ff04, 0x0000ccbd, 0x0000aaa8, 0x00008001,
  0x0000cc50, 0x0000aa9b, 0x00008000, 0x00008000,
  0x0000aa2e, 0x00007ff3, 0x00007fff, 0x00007fff,
  0x00007f86, 0x00007ff2, 0x00007ffe, 0x00007ffe,
  0x00007f85, 0x00007ff1, 0x00007ffd, 0x00007ffd,
  0x00007f84, 0x00007ff0, 0x00007ffc, 0x00005554,
  0x00007f83, 0x00007fef, 0x00005553, 0x00003332,
  0x00007f82, 0x00005546, 0x00003331, 0x0000007e,
  0x000054d9, 0x00003324, 0x0000007d, 0x0000007d,
  0x000032b7, 0x00000070, 0x0000007c, 0x0000007c,
  0x00000003, 0x0000006f, 0x0000007b, 0x0000007b,
  0x00000002, 0x0000006e, 0x0000007a, 0x0000000e,
  0x00000001, 0x0000006d, 0x0000000d, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x0000006d, 0x0000000d, 0x00000001, 0x00000001,
  0x0000000d, 0x00000001, 0x00000001, 0x0000ffff,
  0x0000000e, 0x00000002, 0x0000fffe, 0x0000fffe,
  0x0000000f, 0x0000fffd, 0x0000fffd, 0x0000fffd,
  0x0000fff0, 0x0000fffc, 0x0000fffc, 0x0000ffef,
  0x0000ffef, 0x0000fffb, 0x0000ffee, 0x0000ff82,
  0x0000ffee, 0x0000ffed, 0x0000ff81, 0x0000ff81,
  0x0000ffe0, 0x0000ff80, 0x0000ff80, 0x0000ff80,
  0x0000ff73, 0x0000ff7f, 0x0000ff7f, 0x0000cccc,
  0x0000ff72, 0x0000ff7e, 0x0000cccb, 0x0000aaaa,
  0x0000ff71, 0x0000ccca, 0x0000aaa9, 0x00008002,
  0x0000ccbd, 0x0000aaa8, 0x00008001, 0x00008001,
  0x0000aa9b, 0x00008000, 0x00008000, 0x00008000,
  0x00007ff3, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00007ff2, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00007ff1, 0x00007ffd, 0x00007ffd, 0x00005555,
  0x00007ff0, 0x00007ffc, 0x00005554, 0x00003333,
  0x00007fef, 0x00005553, 0x00003332, 0x0000007f,
  0x00005546, 0x00003331, 0x0000007e, 0x0000007e,
  0x00003324, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000070, 0x0000007c, 0x0000007c, 0x0000007c,
  0x0000006f, 0x0000007b, 0x0000007b, 0x0000000f,
  0x0000006e, 0x0000007a, 0x0000000e, 0x00000002,
  0x0000006d, 0x0000000d, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_uabdl2_4S = 576;

#endif  // VIXL_SIM_UABDL2_4S_TRACE_AARCH64_H_
