/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Button;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import vncviewer.CConn;
import vncviewer.Dialog;

class ClipboardDialog
extends Dialog {
    static Clipboard systemClipboard;
    CConn cc;
    String current;
    TextArea textArea;
    Button clearButton;
    Button sendButton;
    Button cancelButton;

    static {
        try {
            systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ClipboardDialog(CConn cc_) {
        super(false);
        this.cc = cc_;
        this.setTitle("VNC clipboard");
        this.textArea = new TextArea(5, 50);
        this.add("Center", this.textArea);
        Panel pb = new Panel();
        this.clearButton = new Button("Clear");
        pb.add(this.clearButton);
        this.sendButton = new Button("Send to VNC server");
        pb.add(this.sendButton);
        this.cancelButton = new Button("Cancel");
        pb.add(this.cancelButton);
        this.add("South", pb);
        this.pack();
    }

    public void initDialog() {
        this.textArea.setText(this.current);
        this.textArea.selectAll();
    }

    public void setContents(String str) {
        this.current = str;
        this.textArea.setText(str);
        this.textArea.selectAll();
    }

    public void serverCutText(String str) {
        this.setContents(str);
        if (systemClipboard != null) {
            StringSelection ss = new StringSelection(str);
            systemClipboard.setContents(ss, ss);
        }
    }

    public void setSendingEnabled(boolean b) {
        this.sendButton.setEnabled(b);
    }

    public boolean action(Event event, Object arg) {
        if (event.target == this.clearButton) {
            this.current = "";
            this.textArea.setText(this.current);
        } else if (event.target == this.sendButton) {
            this.ok = true;
            this.current = this.textArea.getText();
            this.cc.writeClientCutText(this.current);
            this.endDialog();
        } else if (event.target == this.cancelButton) {
            this.ok = false;
            this.endDialog();
        }
        return true;
    }
}

