# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for OpenSSH-LPK
(see http://code.google.com/p/openssh-lpk/)
"""

import re


from w2lapp.schema.syntaxes import DirectoryString,syntax_registry

class SshPublicKey(DirectoryString):
  oid = 'SshPublicKey-oid'
  desc = 'SSH public key of a user'
  reObj = re.compile('^ssh-(rsa|dss) .+$')

  def sanitizeInput(self,inputValue):
    return inputValue.strip().replace('\r','').replace('\n','')

syntax_registry.registerAttrType(
  SshPublicKey.oid,[
    '1.3.6.1.4.1.24552.500.1.1.1.13', # sshPublicKey
    '2.16.840.1.113730.3.8.11.31', # ipaSshPubKey
  ]
)


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
