/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ImageObject;
import rene.zirkel.objects.PointObject;

public class ImageConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        PointObject pointObject = zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY());
        if (pointObject != null) {
            this.P[this.NPoints++] = pointObject;
            pointObject.setSelected(true);
            zirkelCanvas.repaint();
        }
        this.showStatus(zirkelCanvas);
        if (this.NPoints == 3) {
            String string = zirkelCanvas.loadImage();
            if (string.equals("")) {
                this.reset(zirkelCanvas);
                return;
            }
            ImageObject imageObject = new ImageObject(zirkelCanvas.getConstruction(), this.P, string);
            zirkelCanvas.addObject(imageObject);
            zirkelCanvas.clearSelected();
            this.reset(zirkelCanvas);
            zirkelCanvas.repaint();
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.NPoints <= 1) {
            zirkelCanvas.showStatus(ConstructionObject.text1(Zirkel.name("message.image"), "" + (this.NPoints + 1)));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.image.last"));
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P = new PointObject[3];
            this.NPoints = 0;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.image"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Image")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        for (int i = 0; i < 3; ++i) {
            if (xmlTag.hasParam("point" + (i + 1))) continue;
            throw new ConstructionException("Image points missing!");
        }
        if (!xmlTag.hasParam("filename")) {
            throw new ConstructionException("Image filename missing!");
        }
        try {
            PointObject[] pointObjectArray = new PointObject[3];
            for (int i = 0; i < 3; ++i) {
                pointObjectArray[i] = (PointObject)construction.find(xmlTag.getValue("point" + (i + 1)));
            }
            String string = xmlTag.getValue("filename");
            ImageObject imageObject = new ImageObject(construction, pointObjectArray, string);
            this.setName(xmlTag, imageObject);
            this.set(xmlTree, imageObject);
            construction.add(imageObject);
            this.setConditionals(xmlTree, construction, imageObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Image points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.image");
    }

    public String getTag() {
        return "Image";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
    }
}

