#!/bin/sh -e
# Copyright (c) 2002-2024 Martin A. Godisch <martin@godisch.de>

test -e wmweather.c
umask 022
autoheader -Wall
autoconf -Wall
./configure --without-xmessage
make distclean
rm -rf autom4te.cache
rm -f autoscan.log configure.scan *~ *.log
cd ..
chmod -R go=u-w .
version="`pwd`"
version="${version##*-}"
fakeroot debian/rules clean
cd ..
tar cvzf wmweather-$version.tar.gz --exclude .git --exclude .gitignore --exclude debian --exclude .pc wmweather-$version
ln -sf wmweather-$version.tar.gz wmweather_$version.orig.tar.gz
